/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.crashhandling;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.files.UncivFiles;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.images.IconTextButton;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.ToastPopup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.utils.Log;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\tH\u0002J\b\u0010\u0013\u001a\u00020\tH\u0002J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u0019H\u0002J\b\u0010\u001d\u001a\u00020\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lcom/unciv/ui/crashhandling/CrashScreen;", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "exception", "", "<init>", "(Ljava/lang/Throwable;)V", "getException", "()Ljava/lang/Throwable;", "lastScreenType", "", "text", "getText", "()Ljava/lang/String;", "value", "", "copied", "getCopied", "()Z", "tryGetSaveGame", "tryGetSaveMods", "formatReport", "message", "makeLayoutTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "makeTitleLabel", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "makeErrorScroll", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "makeInstructionLabel", "makeActionButtonsTable", "Companion", "core"})
public final class CrashScreen
extends BaseScreen {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Throwable exception;
    @NotNull
    private final String lastScreenType;
    @NotNull
    private final String text;
    private boolean copied;

    /*
     * WARNING - void declaration
     */
    public CrashScreen(@NotNull Throwable exception2) {
        String string;
        CrashScreen crashScreen;
        Intrinsics.checkNotNullParameter(exception2, "exception");
        this.exception = exception2;
        CrashScreen crashScreen2 = this;
        try {
            crashScreen = crashScreen2;
            BaseScreen baseScreen = UncivGame.Companion.getCurrent().getScreen();
            Intrinsics.checkNotNull(baseScreen);
            string = String.valueOf(Reflection.getOrCreateKotlinClass(baseScreen.getClass()).getQualifiedName());
        }
        catch (Throwable throwable) {
            void e;
            crashScreen = crashScreen2;
            string = "Could not get screen type: " + e;
        }
        crashScreen.lastScreenType = string;
        this.text = this.formatReport(Companion.stringify(this.exception));
        System.gc();
        this.getStage().addActor(this.makeLayoutTable());
    }

    @NotNull
    public final Throwable getException() {
        return this.exception;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final boolean getCopied() {
        return this.copied;
    }

    /*
     * WARNING - void declaration
     */
    private final String tryGetSaveGame() {
        String string;
        StringBuilder stringBuilder;
        GameInfo gameInfo = UncivGame.Companion.getGameInfoOrNull();
        if (gameInfo == null) {
            return "";
        }
        GameInfo gameInfo2 = gameInfo;
        StringBuilder stringBuilder2 = new StringBuilder().append("\n**Save Data:**\n<details><summary>Show Saved Game</summary>\n\n```\n");
        try {
            stringBuilder = stringBuilder2;
            string = UncivFiles.Companion.gameInfoToString$default(UncivFiles.Companion, gameInfo2, true, false, 4, null);
        }
        catch (Throwable throwable) {
            void e;
            stringBuilder = stringBuilder2;
            string = "No save data: " + e;
        }
        return stringBuilder.append(string).append("\n```\n</details>\n").toString();
    }

    private final String tryGetSaveMods() {
        HashSet<String> visualMods;
        StringBuilder sb = new StringBuilder(160);
        GameInfo gameInfo = UncivGame.Companion.getGameInfoOrNull();
        if (gameInfo != null) {
            sb.append("\n**Save Mods:**\n```\n");
            try {
                sb.append(gameInfo.getGameParameters().getModsAndBaseRuleset().toString());
            }
            catch (Throwable e) {
                sb.append("No mod data: " + e);
            }
            sb.append("\n```\n");
        }
        if ((visualMods = UncivGame.Companion.getCurrent().getSettings().getVisualMods()).isEmpty()) {
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            return string;
        }
        sb.append("**Permanent audiovisual Mods**:\n```\n");
        sb.append(visualMods.toString());
        sb.append("\n```\n");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private final String formatReport(String message) {
        String indent = StringsKt.repeat(" ", 4);
        String baseIndent = StringsKt.repeat(indent, 3);
        String subIndent = baseIndent + indent;
        return StringsKt.trimIndent("\n            **Platform:** " + CrashScreen.formatReport$prependIndentToOnlyNewLines(Gdx.app.getType().toString(), subIndent) + "\n            **Version:** " + CrashScreen.formatReport$prependIndentToOnlyNewLines(UncivGame.Companion.getVERSION().toNiceString(), subIndent) + "\n            **Rulesets:** " + CrashScreen.formatReport$prependIndentToOnlyNewLines(RulesetCache.INSTANCE.keySet().toString(), subIndent) + "\n            **Last Screen:** `" + this.lastScreenType + "`\n\n            --------------------------------\n\n            " + CrashScreen.formatReport$prependIndentToOnlyNewLines(Log.INSTANCE.getSystemInfo(), baseIndent) + "\n\n            --------------------------------\n\n\n            **Message:**\n            ```\n            " + CrashScreen.formatReport$prependIndentToOnlyNewLines(message, baseIndent) + "\n            ```\n            ") + this.tryGetSaveMods() + this.tryGetSaveGame();
    }

    private final Table makeLayoutTable() {
        Table table2;
        Table it = table2 = new Table();
        boolean bl = false;
        it.setWidth(this.getStage().getWidth());
        it.setHeight(this.getStage().getHeight());
        Table layoutTable = table2;
        layoutTable.add((Actor)this.makeTitleLabel()).padBottom(15.0f).width(this.getStage().getWidth()).row();
        layoutTable.add(this.makeErrorScroll()).maxWidth(this.getStage().getWidth() * 0.7f).maxHeight(this.getStage().getHeight() * 0.5f).minHeight(this.getStage().getHeight() * 0.2f).row();
        layoutTable.add((Actor)this.makeInstructionLabel()).padTop(15.0f).width(this.getStage().getWidth()).row();
        layoutTable.add((Actor)this.makeActionButtonsTable()).padTop(10.0f);
        return layoutTable;
    }

    private final Label makeTitleLabel() {
        Label label;
        Label $this$makeTitleLabel_u24lambda_u240 = label = Scene2dExtensionsKt.toLabel$default("An unrecoverable error has occurred in Unciv:", null, 24, 0, false, 13, null);
        boolean bl = false;
        $this$makeTitleLabel_u24lambda_u240.setWrap(true);
        $this$makeTitleLabel_u24lambda_u240.setAlignment(1);
        return label;
    }

    private final Actor makeErrorScroll() {
        Label label;
        Label $this$makeErrorScroll_u24lambda_u240 = label = new Label((CharSequence)this.text, BaseScreen.Companion.getSkin());
        boolean bl = false;
        Scene2dExtensionsKt.setFontSize($this$makeErrorScroll_u24lambda_u240, 15);
        Label errorLabel = label;
        Table errorTable = new Table();
        errorTable.add((Actor)errorLabel).pad(10.0f);
        Actor actor = new AutoScrollPane((Actor)errorTable, null, 2, null);
        Color color = Color.DARK_GRAY;
        Intrinsics.checkNotNullExpressionValue(color, "DARK_GRAY");
        return Scene2dExtensionsKt.addBorder$default(actor, 4.0f, color, false, 4, null);
    }

    private final Label makeInstructionLabel() {
        Label label;
        Label $this$makeInstructionLabel_u24lambda_u240 = label = Scene2dExtensionsKt.toLabel("{If this keeps happening, you can try disabling mods.}\n{You can also report this on the issue tracker.}");
        boolean bl = false;
        $this$makeInstructionLabel_u24lambda_u240.setWrap(true);
        $this$makeInstructionLabel_u24lambda_u240.setAlignment(1);
        return label;
    }

    private final Table makeActionButtonsTable() {
        Cell<Actor> cell;
        Actor copyButton = ActivationExtensionsKt.onClick(new IconTextButton("Copy", null, 24, null, 10, null), () -> CrashScreen.makeActionButtonsTable$lambda$0(this));
        Actor reportButton = ActivationExtensionsKt.onClick(new IconTextButton("Open Issue Tracker", (Actor)ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Link", null, 2, null), 24, null, 8, null), () -> CrashScreen.makeActionButtonsTable$lambda$1(this));
        Actor closeButton = ActivationExtensionsKt.onClick(new IconTextButton("Close Unciv", null, 24, null, 10, null), CrashScreen::makeActionButtonsTable$lambda$2);
        Table buttonsTable = new Table();
        buttonsTable.add(copyButton).pad(10.0f);
        Cell<Actor> it = cell = buttonsTable.add(reportButton).pad(10.0f);
        boolean bl = false;
        if (this.isCrampedPortrait()) {
            it.row();
            buttonsTable.add();
        }
        buttonsTable.add(closeButton).pad(10.0f);
        return buttonsTable;
    }

    private static final String formatReport$prependIndentToOnlyNewLines(String $this$formatReport_u24prependIndentToOnlyNewLines, String indent) {
        return StringsKt.removePrefix(StringsKt.prependIndent($this$formatReport_u24prependIndentToOnlyNewLines, indent), (CharSequence)indent);
    }

    private static final Unit makeActionButtonsTable$lambda$0(CrashScreen this$0) {
        try {
            Gdx.app.getClipboard().setContents(this$0.text);
            this$0.copied = true;
            new ToastPopup("Error report copied.", this$0, 0L, 4, null);
        }
        catch (Exception ex) {
            Log.INSTANCE.debug("Could not copy to clipboard", ex);
            new ToastPopup("Could not copy to clipboard!", this$0, 0L, 4, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit makeActionButtonsTable$lambda$1(CrashScreen this$0) {
        Object object = this$0.copied ? Boolean.valueOf(Gdx.net.openURI("https://github.com/yairm210/Unciv/issues")) : new ToastPopup("Please copy the error report first.", this$0, 0L, 4, null);
        return Unit.INSTANCE;
    }

    private static final Unit makeActionButtonsTable$lambda$2() {
        Gdx.app.exit();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0010\u0003\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/unciv/ui/crashhandling/CrashScreen$Companion;", "", "<init>", "()V", "stringify", "", "", "core"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String stringify(@NotNull Throwable $this$stringify) {
            Intrinsics.checkNotNullParameter($this$stringify, "<this>");
            StringWriter out = new StringWriter();
            $this$stringify.printStackTrace(new PrintWriter(out));
            String string = out.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

