/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.images;

import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.unciv.logic.civilization.Civilization;
import com.unciv.ui.components.tilegroups.TileSetStrings;
import com.unciv.ui.images.ImageGetter;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0019\u0010\u0011\u001a\u0015\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0012\u00a2\u0006\u0002\b\u0013J-\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u001f\u0010\u0015\u001a\u001b\u0012\u0017\u0012\u0015\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0012\u00a2\u0006\u0002\b\u00130\u0016J.\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u0004\u0018\u00010\nJ\b\u0010\u001f\u001a\u0004\u0018\u00010\nJ\u0006\u0010 \u001a\u00020!R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Lcom/unciv/ui/images/ImageAttempter;", "T", "", "scope", "<init>", "(Ljava/lang/Object;)V", "getScope", "()Ljava/lang/Object;", "Ljava/lang/Object;", "lastTriedFileName", "", "value", "", "imageFound", "getImageFound", "()Z", "tryImage", "fileName", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "tryImages", "fileNames", "Lkotlin/sequences/Sequence;", "tryEraImage", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "locationToCheck", "style", "tileSetStrings", "Lcom/unciv/ui/components/tilegroups/TileSetStrings;", "getPath", "getPathOrNull", "getImage", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "core"})
public final class ImageAttempter<T> {
    @NotNull
    private final T scope;
    @Nullable
    private String lastTriedFileName;
    private boolean imageFound;

    public ImageAttempter(@NotNull T scope2) {
        Intrinsics.checkNotNullParameter(scope2, "scope");
        this.scope = scope2;
    }

    @NotNull
    public final T getScope() {
        return this.scope;
    }

    public final boolean getImageFound() {
        return this.imageFound;
    }

    @NotNull
    public final ImageAttempter<T> tryImage(@NotNull Function1<? super T, String> fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        if (!this.imageFound) {
            String imagePath = fileName.invoke(this.scope);
            String string = imagePath;
            if (string == null) {
                string = this.lastTriedFileName = this.lastTriedFileName;
            }
            if (imagePath != null && ImageGetter.INSTANCE.imageExists(imagePath)) {
                this.imageFound = true;
            }
        }
        return this;
    }

    @NotNull
    public final ImageAttempter<T> tryImages(@NotNull Sequence<? extends Function1<? super T, String>> fileNames) {
        Intrinsics.checkNotNullParameter(fileNames, "fileNames");
        Iterator<Function1<T, String>> iterator2 = fileNames.iterator();
        while (iterator2.hasNext()) {
            Function1<? super T, String> fileName = iterator2.next();
            this.tryImage(fileName);
        }
        return this;
    }

    @NotNull
    public final ImageAttempter<T> tryEraImage(@NotNull Civilization civInfo, @NotNull String locationToCheck, @Nullable String style, @NotNull TileSetStrings tileSetStrings) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        Intrinsics.checkNotNullParameter(locationToCheck, "locationToCheck");
        Intrinsics.checkNotNullParameter(tileSetStrings, "tileSetStrings");
        return this.tryImages(SequencesKt.map(CollectionsKt.asSequence(RangesKt.downTo(civInfo.getEraNumber(), 0)), arg_0 -> ImageAttempter.tryEraImage$lambda$0(civInfo, style, tileSetStrings, locationToCheck, arg_0)));
    }

    @Nullable
    public final String getPath() {
        return this.lastTriedFileName;
    }

    @Nullable
    public final String getPathOrNull() {
        return this.imageFound ? this.lastTriedFileName : null;
    }

    @NotNull
    public final Image getImage() {
        return ImageGetter.getImage$default(ImageGetter.INSTANCE, this.lastTriedFileName, null, 2, null);
    }

    private static final String tryEraImage$lambda$0$0(Civilization $civInfo, int $it, String $style, TileSetStrings $tileSetStrings, String $locationToCheck, Object $this$map) {
        String string;
        Intrinsics.checkNotNullParameter($this$map, "$this$map");
        Set<String> set = $civInfo.getGameInfo().getRuleset().getEras().keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        Object t = CollectionsKt.elementAt((Iterable)set, $it);
        Intrinsics.checkNotNullExpressionValue(t, "elementAt(...)");
        String era = (String)t;
        if ($style != null) {
            String[] stringArray = new String[]{$locationToCheck, $tileSetStrings.getTag(), $style, $tileSetStrings.getTag(), era};
            string = $tileSetStrings.getString(stringArray);
        } else {
            String[] stringArray = new String[]{$locationToCheck, $tileSetStrings.getTag(), era};
            string = $tileSetStrings.getString(stringArray);
        }
        return string;
    }

    private static final Function1 tryEraImage$lambda$0(Civilization $civInfo, String $style, TileSetStrings $tileSetStrings, String $locationToCheck, int it) {
        return arg_0 -> ImageAttempter.tryEraImage$lambda$0$0($civInfo, it, $style, $tileSetStrings, $locationToCheck, arg_0);
    }
}

