/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.basescreen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.viewport.ExtendViewport;
import com.unciv.UncivGame;
import com.unciv.models.TutorialTrigger;
import com.unciv.models.metadata.BaseRuleset;
import com.unciv.models.metadata.GameSettings;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.skins.SkinStrings;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.fonts.Fonts;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyShortcutDispatcher;
import com.unciv.ui.components.input.KeyShortcutDispatcherVeto;
import com.unciv.ui.crashhandling.CrashScreen;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.popups.PopupKt;
import com.unciv.ui.popups.options.OptionsPopup;
import com.unciv.ui.screens.GameStartScreen;
import com.unciv.ui.screens.basescreen.RecreateOnResize;
import com.unciv.ui.screens.basescreen.SceneDebugMode;
import com.unciv.ui.screens.basescreen.TutorialController;
import com.unciv.ui.screens.basescreen.UncivStage;
import com.unciv.ui.screens.civilopediascreen.CivilopediaScreen;
import com.unciv.ui.screens.mainmenuscreen.MainMenuScreen;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u0000 ?2\u00020\u0001:\u0001?B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0016\u001a'\u0012\u0015\u0012\u0013\u0018\u00010\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u0017j\u0004\u0018\u0001`\u001dH\u0016J-\u0010\u001e\u001a'\u0012\u0015\u0012\u0013\u0018\u00010\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u0017j\u0004\u0018\u0001`\u001dH\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0016J\b\u0010(\u001a\u00020 H\u0016J\b\u0010)\u001a\u00020 H\u0016J\b\u0010*\u001a\u00020 H\u0016J\b\u0010+\u001a\u00020 H\u0016J \u0010,\u001a\u00020 2\u0006\u0010-\u001a\u00020.2\u0010\b\u0002\u0010/\u001a\n\u0012\u0004\u0012\u000201\u0018\u000100J\u0006\u00102\u001a\u000201J\u0006\u00103\u001a\u000201J\u0006\u00104\u001a\u000201J,\u00105\u001a\u00020 2\b\b\u0002\u00106\u001a\u00020&2\b\b\u0002\u00107\u001a\u0002012\u000e\b\u0002\u00108\u001a\b\u0012\u0004\u0012\u00020 00H\u0016J\b\u00109\u001a\u00020:H\u0016J\u0012\u0010;\u001a\u00020 2\b\b\u0002\u0010<\u001a\u00020=H\u0016J\u0018\u0010;\u001a\u00020 2\u0006\u0010>\u001a\u00020:2\b\b\u0002\u0010<\u001a\u00020=R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006@"}, d2={"Lcom/unciv/ui/screens/basescreen/BaseScreen;", "Lcom/badlogic/gdx/Screen;", "<init>", "()V", "game", "Lcom/unciv/UncivGame;", "getGame", "()Lcom/unciv/UncivGame;", "stage", "Lcom/badlogic/gdx/scenes/scene2d/Stage;", "getStage", "()Lcom/badlogic/gdx/scenes/scene2d/Stage;", "tutorialController", "Lcom/unciv/ui/screens/basescreen/TutorialController;", "getTutorialController", "()Lcom/unciv/ui/screens/basescreen/TutorialController;", "tutorialController$delegate", "Lkotlin/Lazy;", "globalShortcuts", "Lcom/unciv/ui/components/input/KeyShortcutDispatcher;", "getGlobalShortcuts", "()Lcom/unciv/ui/components/input/KeyShortcutDispatcher;", "getShortcutDispatcherVetoer", "Lkotlin/Function1;", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "Lkotlin/ParameterName;", "name", "associatedActor", "Lcom/unciv/ui/components/input/KeyShortcutDispatcherVeto$DispatcherVetoResult;", "Lcom/unciv/ui/components/input/DispatcherVetoer;", "createDispatcherVetoer", "show", "", "render", "delta", "", "resize", "width", "", "height", "pause", "resume", "hide", "dispose", "displayTutorial", "tutorial", "Lcom/unciv/models/TutorialTrigger;", "test", "Lkotlin/Function0;", "", "isPortrait", "isCrampedPortrait", "isNarrowerThan4to3", "openOptionsPopup", "startingPage", "withDebug", "onClose", "getCivilopediaRuleset", "Lcom/unciv/models/ruleset/Ruleset;", "openCivilopedia", "link", "", "ruleset", "Companion", "core"})
public abstract class BaseScreen
implements Screen {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UncivGame game = UncivGame.Companion.getCurrent();
    @NotNull
    private final Stage stage;
    @NotNull
    private final Lazy tutorialController$delegate = LazyKt.lazy(() -> BaseScreen.tutorialController_delegate$lambda$0(this));
    @NotNull
    private final KeyShortcutDispatcher globalShortcuts = new KeyShortcutDispatcher();
    @NotNull
    private static SceneDebugMode enableSceneDebug = SceneDebugMode.None;
    @NotNull
    private static Color clearColor = new Color(0.0f, 0.0f, 0.2f, 1.0f);
    public static Skin skin;
    public static SkinStrings skinStrings;

    public BaseScreen() {
        GameSettings.ScreenSize screenSize = this.game.getSettings().getScreenSize();
        float height = screenSize.getVirtualHeight();
        this.stage = new UncivStage(new ExtendViewport(height, height));
        if (enableSceneDebug.getActive() && !(this instanceof CrashScreen) && !(this instanceof GameStartScreen)) {
            ((UncivStage)this.stage).setSceneDebugMode();
        }
        ActivationExtensionsKt.installShortcutDispatcher(this.stage, this.globalShortcuts, (Function0<? extends Function1<? super Actor, ? extends KeyShortcutDispatcherVeto.DispatcherVetoResult>>)new Function0<Function1<? super Actor, ? extends KeyShortcutDispatcherVeto.DispatcherVetoResult>>((Object)this){

            @Override
            public final Function1<Actor, KeyShortcutDispatcherVeto.DispatcherVetoResult> invoke() {
                return ((BaseScreen)this.receiver).createDispatcherVetoer();
            }
        });
    }

    @NotNull
    public final UncivGame getGame() {
        return this.game;
    }

    @NotNull
    public final Stage getStage() {
        return this.stage;
    }

    @NotNull
    protected final TutorialController getTutorialController() {
        Lazy lazy = this.tutorialController$delegate;
        return (TutorialController)lazy.getValue();
    }

    @NotNull
    public final KeyShortcutDispatcher getGlobalShortcuts() {
        return this.globalShortcuts;
    }

    @Nullable
    public Function1<Actor, KeyShortcutDispatcherVeto.DispatcherVetoResult> getShortcutDispatcherVetoer() {
        return null;
    }

    private final Function1<Actor, KeyShortcutDispatcherVeto.DispatcherVetoResult> createDispatcherVetoer() {
        Popup popup2 = PopupKt.getActivePopup(this);
        if (popup2 == null) {
            return this.getShortcutDispatcherVetoer();
        }
        Popup activePopup = popup2;
        return KeyShortcutDispatcherVeto.INSTANCE.createPopupBasedDispatcherVetoer(activePopup);
    }

    @Override
    public void show() {
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(BaseScreen.clearColor.r, BaseScreen.clearColor.g, BaseScreen.clearColor.b, BaseScreen.clearColor.a);
        Gdx.gl.glClear(16384);
        this.stage.act();
        this.stage.draw();
    }

    @Override
    public void resize(int width, int height) {
        if (!(this instanceof RecreateOnResize)) {
            this.stage.getViewport().update(width, height, true);
        } else if (this.stage.getViewport().getScreenWidth() != width || this.stage.getViewport().getScreenHeight() != height) {
            this.game.replaceCurrentScreen(((RecreateOnResize)((Object)this)).recreate());
        }
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
        this.stage.dispose();
    }

    public final void displayTutorial(@NotNull TutorialTrigger tutorial, @Nullable Function0<Boolean> test) {
        Intrinsics.checkNotNullParameter((Object)tutorial, "tutorial");
        if (!this.game.getSettings().getShowTutorials()) {
            return;
        }
        if (this.game.getSettings().getTutorialsShown().contains(tutorial.name())) {
            return;
        }
        if (this instanceof WorldScreen && ((WorldScreen)this).getAutoPlay().isAutoPlaying()) {
            return;
        }
        if (test != null && !test.invoke().booleanValue()) {
            return;
        }
        this.getTutorialController().showTutorial(tutorial);
    }

    public static /* synthetic */ void displayTutorial$default(BaseScreen baseScreen, TutorialTrigger tutorialTrigger, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: displayTutorial");
        }
        if ((n & 2) != 0) {
            function0 = null;
        }
        baseScreen.displayTutorial(tutorialTrigger, function0);
    }

    public final boolean isPortrait() {
        return this.stage.getViewport().getScreenHeight() > this.stage.getViewport().getScreenWidth();
    }

    public final boolean isCrampedPortrait() {
        return this.isPortrait() && this.game.getSettings().getScreenSize().getVirtualHeight() <= 700.0f;
    }

    public final boolean isNarrowerThan4to3() {
        return Scene2dExtensionsKt.isNarrowerThan4to3(this.stage);
    }

    public void openOptionsPopup(int startingPage, boolean withDebug, @NotNull Function0<Unit> onClose) {
        Intrinsics.checkNotNullParameter(onClose, "onClose");
        new OptionsPopup(this, startingPage, withDebug, onClose).open(true);
    }

    public static /* synthetic */ void openOptionsPopup$default(BaseScreen baseScreen, int n, boolean bl, Function0 function0, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: openOptionsPopup");
        }
        if ((n2 & 1) != 0) {
            n = 2;
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            function0 = BaseScreen::openOptionsPopup$lambda$0;
        }
        baseScreen.openOptionsPopup(n, bl, function0);
    }

    @NotNull
    public Ruleset getCivilopediaRuleset() {
        if (this.game.getWorldScreen() != null) {
            WorldScreen worldScreen = this.game.getWorldScreen();
            Intrinsics.checkNotNull(worldScreen);
            return worldScreen.getGameInfo().getRuleset();
        }
        BaseScreen mainMenuScreen = SequencesKt.firstOrNull(this.game.getScreensOfType(Reflection.getOrCreateKotlinClass(MainMenuScreen.class)));
        if (mainMenuScreen != null) {
            return mainMenuScreen.getCivilopediaRuleset();
        }
        Object object = RulesetCache.INSTANCE.get((Object)BaseRuleset.Civ_V_GnK.getFullName());
        Intrinsics.checkNotNull(object);
        return (Ruleset)object;
    }

    public void openCivilopedia(@NotNull String link) {
        Intrinsics.checkNotNullParameter(link, "link");
        this.openCivilopedia(this.getCivilopediaRuleset(), link);
    }

    public static /* synthetic */ void openCivilopedia$default(BaseScreen baseScreen, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: openCivilopedia");
        }
        if ((n & 1) != 0) {
            string = "";
        }
        baseScreen.openCivilopedia(string);
    }

    public final void openCivilopedia(@NotNull Ruleset ruleset, @NotNull String link) {
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        Intrinsics.checkNotNullParameter(link, "link");
        this.game.pushScreen(new CivilopediaScreen(ruleset, null, link, 2, null));
    }

    public static /* synthetic */ void openCivilopedia$default(BaseScreen baseScreen, Ruleset ruleset, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: openCivilopedia");
        }
        if ((n & 2) != 0) {
            string = "";
        }
        baseScreen.openCivilopedia(ruleset, string);
    }

    private static final TutorialController tutorialController_delegate$lambda$0(BaseScreen this$0) {
        return new TutorialController(this$0);
    }

    private static final Unit openOptionsPopup$lambda$0() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0014\u001a\u00020\u001cR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lcom/unciv/ui/screens/basescreen/BaseScreen$Companion;", "", "<init>", "()V", "enableSceneDebug", "Lcom/unciv/ui/screens/basescreen/SceneDebugMode;", "getEnableSceneDebug", "()Lcom/unciv/ui/screens/basescreen/SceneDebugMode;", "setEnableSceneDebug", "(Lcom/unciv/ui/screens/basescreen/SceneDebugMode;)V", "clearColor", "Lcom/badlogic/gdx/graphics/Color;", "getClearColor", "()Lcom/badlogic/gdx/graphics/Color;", "setClearColor", "(Lcom/badlogic/gdx/graphics/Color;)V", "skin", "Lcom/badlogic/gdx/scenes/scene2d/ui/Skin;", "getSkin", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Skin;", "setSkin", "(Lcom/badlogic/gdx/scenes/scene2d/ui/Skin;)V", "skinStrings", "Lcom/unciv/models/skins/SkinStrings;", "getSkinStrings", "()Lcom/unciv/models/skins/SkinStrings;", "setSkinStrings", "(Lcom/unciv/models/skins/SkinStrings;)V", "", "core"})
    @SourceDebugExtension(value={"SMAP\nBaseScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseScreen.kt\ncom/unciv/ui/screens/basescreen/BaseScreen$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,215:1\n1#2:216\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SceneDebugMode getEnableSceneDebug() {
            return enableSceneDebug;
        }

        public final void setEnableSceneDebug(@NotNull SceneDebugMode sceneDebugMode) {
            Intrinsics.checkNotNullParameter((Object)sceneDebugMode, "<set-?>");
            enableSceneDebug = sceneDebugMode;
        }

        @NotNull
        public final Color getClearColor() {
            return clearColor;
        }

        public final void setClearColor(@NotNull Color color) {
            Intrinsics.checkNotNullParameter(color, "<set-?>");
            clearColor = color;
        }

        @NotNull
        public final Skin getSkin() {
            Skin skin = BaseScreen.skin;
            if (skin != null) {
                return skin;
            }
            Intrinsics.throwUninitializedPropertyAccessException("skin");
            return null;
        }

        public final void setSkin(@NotNull Skin skin) {
            Intrinsics.checkNotNullParameter(skin, "<set-?>");
            BaseScreen.skin = skin;
        }

        @NotNull
        public final SkinStrings getSkinStrings() {
            SkinStrings skinStrings = BaseScreen.skinStrings;
            if (skinStrings != null) {
                return skinStrings;
            }
            Intrinsics.throwUninitializedPropertyAccessException("skinStrings");
            return null;
        }

        public final void setSkinStrings(@NotNull SkinStrings skinStrings) {
            Intrinsics.checkNotNullParameter(skinStrings, "<set-?>");
            BaseScreen.skinStrings = skinStrings;
        }

        /*
         * WARNING - void declaration
         */
        public final void setSkin() {
            void $this$setSkin_u24lambda_u240_u241;
            TextureRegionDrawable $this$setSkin_u24lambda_u240_u240;
            TextureRegionDrawable textureRegionDrawable;
            void $this$setSkin_u24lambda_u240;
            Fonts.INSTANCE.resetFont();
            this.setSkinStrings(new SkinStrings(null, 1, null));
            Object object = new Skin();
            Skin skin = object;
            Companion companion = this;
            boolean bl = false;
            $this$setSkin_u24lambda_u240.add("default-clear", Companion.getClearColor(), Color.class);
            $this$setSkin_u24lambda_u240.add("Nativefont", Fonts.INSTANCE.getFont(), BitmapFont.class);
            $this$setSkin_u24lambda_u240.add("RoundedEdgeRectangle", SkinStrings.getUiBackground$default(Companion.getSkinStrings(), "", Companion.getSkinStrings().getRoundedEdgeRectangleShape(), null, 4, null), Drawable.class);
            $this$setSkin_u24lambda_u240.add("Rectangle", ImageGetter.INSTANCE.getDrawable(""), Drawable.class);
            TextureRegionDrawable textureRegionDrawable2 = textureRegionDrawable = ImageGetter.INSTANCE.getCircleDrawable();
            String string = "Circle";
            void var7_8 = $this$setSkin_u24lambda_u240;
            boolean bl2 = false;
            $this$setSkin_u24lambda_u240_u240.setMinSize(20.0f, 20.0f);
            Unit unit = Unit.INSTANCE;
            var7_8.add(string, textureRegionDrawable, Drawable.class);
            $this$setSkin_u24lambda_u240_u240 = textureRegionDrawable = ImageGetter.INSTANCE.getDrawable("");
            string = "Scrollbar";
            var7_8 = $this$setSkin_u24lambda_u240;
            boolean bl3 = false;
            $this$setSkin_u24lambda_u240_u241.setMinSize(10.0f, 10.0f);
            unit = Unit.INSTANCE;
            var7_8.add(string, textureRegionDrawable, Drawable.class);
            $this$setSkin_u24lambda_u240.add("RectangleWithOutline", SkinStrings.getUiBackground$default(Companion.getSkinStrings(), "", Companion.getSkinStrings().getRectangleWithOutlineShape(), null, 4, null), Drawable.class);
            $this$setSkin_u24lambda_u240.add("Select-box", SkinStrings.getUiBackground$default(Companion.getSkinStrings(), "", Companion.getSkinStrings().getSelectBoxShape(), null, 4, null), Drawable.class);
            $this$setSkin_u24lambda_u240.add("Select-box-pressed", SkinStrings.getUiBackground$default(Companion.getSkinStrings(), "", Companion.getSkinStrings().getSelectBoxPressedShape(), null, 4, null), Drawable.class);
            $this$setSkin_u24lambda_u240.add("Checkbox", SkinStrings.getUiBackground$default(Companion.getSkinStrings(), "", Companion.getSkinStrings().getCheckboxShape(), null, 4, null), Drawable.class);
            $this$setSkin_u24lambda_u240.add("Checkbox-pressed", SkinStrings.getUiBackground$default(Companion.getSkinStrings(), "", Companion.getSkinStrings().getCheckboxPressedShape(), null, 4, null), Drawable.class);
            $this$setSkin_u24lambda_u240.load(Gdx.files.internal("Skin.json"));
            companion.setSkin((Skin)object);
            this.getSkin().get(TextButton.TextButtonStyle.class).font = Fonts.INSTANCE.getFont();
            object = this.getSkin().get(CheckBox.CheckBoxStyle.class);
            CheckBox.CheckBoxStyle $this$setSkin_u24lambda_u241 = (CheckBox.CheckBoxStyle)object;
            boolean bl4 = false;
            $this$setSkin_u24lambda_u241.font = Fonts.INSTANCE.getFont();
            $this$setSkin_u24lambda_u241.fontColor = Color.WHITE;
            object = this.getSkin().get(Label.LabelStyle.class);
            Label.LabelStyle $this$setSkin_u24lambda_u242 = (Label.LabelStyle)object;
            boolean bl5 = false;
            $this$setSkin_u24lambda_u242.font = Fonts.INSTANCE.getFont();
            $this$setSkin_u24lambda_u242.fontColor = Color.WHITE;
            this.getSkin().get(TextField.TextFieldStyle.class).font = Fonts.INSTANCE.getFont();
            object = this.getSkin().get(SelectBox.SelectBoxStyle.class);
            SelectBox.SelectBoxStyle $this$setSkin_u24lambda_u243 = (SelectBox.SelectBoxStyle)object;
            boolean bl6 = false;
            $this$setSkin_u24lambda_u243.font = Fonts.INSTANCE.getFont();
            $this$setSkin_u24lambda_u243.listStyle.font = Fonts.INSTANCE.getFont();
            this.setClearColor(this.getSkinStrings().getSkinConfig().getClearColor());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

