/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.basescreen;

import com.unciv.UncivGame;
import com.unciv.models.TutorialTrigger;
import com.unciv.models.metadata.GameSettings;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.Tutorial;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.basescreen.TutorialForRender;
import com.unciv.ui.screens.basescreen.TutorialRender;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\bJ\u0010\u0010!\u001a\u00020\r2\u0006\u0010 \u001a\u00020\bH\u0002J\b\u0010\"\u001a\u00020\rH\u0002J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00160$2\u0006\u0010 \u001a\u00020\bH\u0003R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R=\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015j\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0017`\u00188BX\u0082\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001c*\u0004\b\u0019\u0010\u001a\u00a8\u0006%"}, d2={"Lcom/unciv/ui/screens/basescreen/TutorialController;", "", "screen", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "<init>", "(Lcom/unciv/ui/screens/basescreen/BaseScreen;)V", "tutorialQueue", "", "Lcom/unciv/models/TutorialTrigger;", "isTutorialShowing", "", "allTutorialsShowedCallback", "Lkotlin/Function0;", "", "getAllTutorialsShowedCallback", "()Lkotlin/jvm/functions/Function0;", "setAllTutorialsShowedCallback", "(Lkotlin/jvm/functions/Function0;)V", "tutorialRender", "Lcom/unciv/ui/screens/basescreen/TutorialRender;", "tutorials", "Ljava/util/LinkedHashMap;", "", "Lcom/unciv/models/ruleset/Tutorial;", "Lkotlin/collections/LinkedHashMap;", "getTutorials$delegate", "(Lcom/unciv/ui/screens/basescreen/TutorialController;)Ljava/lang/Object;", "getTutorials", "()Ljava/util/LinkedHashMap;", "tutorials$receiver", "Lcom/unciv/models/ruleset/Ruleset;", "showTutorial", "tutorial", "removeTutorial", "showTutorialIfNeeded", "getTutorial", "", "core"})
public final class TutorialController {
    @NotNull
    private final Set<TutorialTrigger> tutorialQueue;
    private boolean isTutorialShowing;
    @Nullable
    private Function0<Unit> allTutorialsShowedCallback;
    @NotNull
    private final TutorialRender tutorialRender;
    @NotNull
    private final Ruleset tutorials$receiver;

    public TutorialController(@NotNull BaseScreen screen) {
        Intrinsics.checkNotNullParameter(screen, "screen");
        this.tutorialQueue = new LinkedHashSet();
        this.tutorialRender = new TutorialRender(screen);
        this.tutorials$receiver = screen.getCivilopediaRuleset();
    }

    @Nullable
    public final Function0<Unit> getAllTutorialsShowedCallback() {
        return this.allTutorialsShowedCallback;
    }

    public final void setAllTutorialsShowedCallback(@Nullable Function0<Unit> function0) {
        this.allTutorialsShowedCallback = function0;
    }

    private final LinkedHashMap<String, Tutorial> getTutorials() {
        return this.tutorials$receiver.getTutorials();
    }

    private static Object getTutorials$delegate(TutorialController tutorialController) {
        return Reflection.property0(new PropertyReference0Impl((Object)tutorialController.tutorials$receiver, Ruleset.class, "tutorials", "getTutorials()Ljava/util/LinkedHashMap;", 0));
    }

    public final void showTutorial(@NotNull TutorialTrigger tutorial) {
        Intrinsics.checkNotNullParameter((Object)tutorial, "tutorial");
        this.tutorialQueue.add(tutorial);
        this.showTutorialIfNeeded();
    }

    private final void removeTutorial(TutorialTrigger tutorial) {
        this.isTutorialShowing = false;
        this.tutorialQueue.remove((Object)tutorial);
        GameSettings $this$removeTutorial_u24lambda_u240 = UncivGame.Companion.getCurrent().getSettings();
        boolean bl = false;
        if (!$this$removeTutorial_u24lambda_u240.getTutorialsShown().contains(tutorial.name())) {
            $this$removeTutorial_u24lambda_u240.getTutorialsShown().add(tutorial.name());
            $this$removeTutorial_u24lambda_u240.save();
        }
        this.showTutorialIfNeeded();
    }

    private final void showTutorialIfNeeded() {
        if (!UncivGame.Companion.getCurrent().getSettings().getShowTutorials()) {
            return;
        }
        TutorialTrigger tutorial = (TutorialTrigger)((Object)CollectionsKt.firstOrNull((Iterable)this.tutorialQueue));
        if (tutorial == null) {
            Function0<Unit> function0 = this.allTutorialsShowedCallback;
            if (function0 != null) {
                function0.invoke();
            }
        } else if (!this.isTutorialShowing) {
            this.isTutorialShowing = true;
            List<String> texts = this.getTutorial(tutorial);
            this.tutorialRender.showTutorial(new TutorialForRender(tutorial, texts), () -> TutorialController.showTutorialIfNeeded$lambda$0(this, tutorial));
        }
    }

    @Readonly
    private final List<String> getTutorial(TutorialTrigger tutorial) {
        String name = ((Object)StringsKt.trimStart((CharSequence)StringsKt.replace$default(tutorial.getValue(), '_', ' ', false, 4, null))).toString();
        Object object = this.getTutorials().get(name);
        return object != null && (object = ((Tutorial)object).getSteps()) != null ? (List)object : CollectionsKt.emptyList();
    }

    private static final Unit showTutorialIfNeeded$lambda$0(TutorialController this$0, TutorialTrigger $tutorial) {
        this$0.removeTutorial($tutorial);
        return Unit.INSTANCE;
    }
}

