/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.basescreen;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.basescreen.TutorialForRender;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bJ,\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/unciv/ui/screens/basescreen/TutorialRender;", "", "screen", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "<init>", "(Lcom/unciv/ui/screens/basescreen/BaseScreen;)V", "showTutorial", "", "tutorial", "Lcom/unciv/ui/screens/basescreen/TutorialForRender;", "closeAction", "Lkotlin/Function0;", "showDialog", "tutorialName", "", "texts", "", "core"})
public final class TutorialRender {
    @NotNull
    private final BaseScreen screen;

    public TutorialRender(@NotNull BaseScreen screen) {
        Intrinsics.checkNotNullParameter(screen, "screen");
        this.screen = screen;
    }

    public final void showTutorial(@NotNull TutorialForRender tutorial, @NotNull Function0<Unit> closeAction) {
        Intrinsics.checkNotNullParameter(tutorial, "tutorial");
        Intrinsics.checkNotNullParameter(closeAction, "closeAction");
        this.showDialog(tutorial.getTutorial().name(), tutorial.getTexts(), closeAction);
    }

    private final void showDialog(String tutorialName, List<String> texts, Function0<Unit> closeAction) {
        if (texts.isEmpty()) {
            closeAction.invoke();
            return;
        }
        Popup tutorialPopup = new Popup(this.screen, null, 0.0f, 6, null);
        tutorialPopup.setName("Tutorial: " + tutorialName);
        FileHandle externalImage = ImageGetter.INSTANCE.findExternalImage(tutorialName);
        if (externalImage != null) {
            tutorialPopup.add((Actor)ImageGetter.INSTANCE.getExternalImage(externalImage)).row();
        }
        Popup.addGoodSizedLabel$default(tutorialPopup, texts.get(0), 0, false, null, 14, null).row();
        Popup.addCloseButton$default(tutorialPopup, null, KeyCharAndCode.Companion.getSPACE(), null, () -> TutorialRender.showDialog$lambda$0(tutorialPopup, this, tutorialName, texts, closeAction), 5, null);
        Popup.open$default(tutorialPopup, false, 1, null);
    }

    private static final Unit showDialog$lambda$0(Popup $tutorialPopup, TutorialRender this$0, String $tutorialName, List $texts, Function0 $closeAction) {
        $tutorialPopup.remove();
        this$0.showDialog($tutorialName, $texts.subList(1, $texts.size()), $closeAction);
        return Unit.INSTANCE;
    }
}

