/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.cityscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.models.UncivSound;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.IConstruction;
import com.unciv.models.ruleset.IRulesetObject;
import com.unciv.models.ruleset.PerpetualConstruction;
import com.unciv.models.ruleset.PerpetualStatConversion;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.popups.PopupKt;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.cityscreen.BuyButtonFactory;
import com.unciv.ui.screens.cityscreen.CityScreen;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/unciv/ui/screens/cityscreen/ConstructionInfoTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "cityScreen", "Lcom/unciv/ui/screens/cityscreen/CityScreen;", "<init>", "(Lcom/unciv/ui/screens/cityscreen/CityScreen;)V", "getCityScreen", "()Lcom/unciv/ui/screens/cityscreen/CityScreen;", "selectedConstructionTable", "buyButtonFactory", "Lcom/unciv/ui/screens/cityscreen/BuyButtonFactory;", "update", "", "selectedConstruction", "Lcom/unciv/models/ruleset/IConstruction;", "updateSelectedConstructionTable", "construction", "showSellButton", "sellBuildingClicked", "Lcom/unciv/models/ruleset/Building;", "sellText", "", "sellBuildingConfirmed", "core"})
public final class ConstructionInfoTable
extends Table {
    @NotNull
    private final CityScreen cityScreen;
    @NotNull
    private final Table selectedConstructionTable;
    @NotNull
    private final BuyButtonFactory buyButtonFactory;

    public ConstructionInfoTable(@NotNull CityScreen cityScreen) {
        Intrinsics.checkNotNullParameter(cityScreen, "cityScreen");
        this.cityScreen = cityScreen;
        this.selectedConstructionTable = new Table();
        this.buyButtonFactory = new BuyButtonFactory(this.cityScreen);
        this.selectedConstructionTable.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "CityScreen/ConstructionInfoTable/SelectedConstructionTable", null, Scene2dExtensionsKt.darken(BaseScreen.Companion.getSkinStrings().getSkinConfig().getBaseColor(), 0.5f), 2, null));
        this.add((Actor)this.selectedConstructionTable).pad(2.0f).fill();
        this.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "CityScreen/ConstructionInfoTable/Background", null, Color.WHITE, 2, null));
    }

    @NotNull
    public final CityScreen getCityScreen() {
        return this.cityScreen;
    }

    public final void update(@Nullable IConstruction selectedConstruction) {
        this.selectedConstructionTable.clear();
        if (selectedConstruction == null) {
            this.setVisible(false);
            return;
        }
        this.setVisible(true);
        this.updateSelectedConstructionTable(selectedConstruction);
        this.pack();
    }

    /*
     * WARNING - void declaration
     */
    private final void updateSelectedConstructionTable(IConstruction construction) {
        Object link;
        Group group;
        City city = this.cityScreen.getCity$core();
        CityConstructions cityConstructions = city.getCityConstructions();
        Table $this$updateSelectedConstructionTable_u24lambda_u240 = this.selectedConstructionTable;
        boolean bl = false;
        $this$updateSelectedConstructionTable_u24lambda_u240.pad(10.0f);
        Group group2 = group = ImageGetter.INSTANCE.getConstructionPortrait(construction.getName(), 50.0f);
        Table table2 = $this$updateSelectedConstructionTable_u24lambda_u240;
        boolean bl2 = false;
        Object object = construction instanceof IRulesetObject ? (IRulesetObject)((Object)construction) : null;
        if (object != null && (object = object.makeLink()) != null && !(((CharSequence)(link = object)).length() == 0)) {
            void $this$updateSelectedConstructionTable_u24lambda_u240_u240;
            $this$updateSelectedConstructionTable_u24lambda_u240_u240.setTouchable(Touchable.enabled);
            ActivationExtensionsKt.onClick((Actor)$this$updateSelectedConstructionTable_u24lambda_u240_u240, () -> ConstructionInfoTable.updateSelectedConstructionTable$lambda$0$0$0(this, (String)link));
        }
        table2.add((Actor)group).pad(5.0f);
        String buildingText = TranslationsKt.tr$default(construction.getName(), true, false, 2, null);
        PerpetualConstruction specialConstruction = PerpetualConstruction.Companion.getPerpetualConstructionsMap().get(construction.getName());
        StringBuilder stringBuilder = new StringBuilder().append(buildingText);
        Object object2 = specialConstruction;
        if (object2 == null || (object2 = PerpetualConstruction.getProductionTooltip$default((PerpetualConstruction)object2, city, false, 2, null)) == null) {
            object2 = CityConstructions.getTurnsToConstructionString$core$default(cityConstructions, construction, false, 2, null);
        }
        buildingText = stringBuilder.append((String)object2).toString();
        $this$updateSelectedConstructionTable_u24lambda_u240.add((Actor)new Label((CharSequence)buildingText, BaseScreen.Companion.getSkin())).expandX().row();
        link = construction;
        String description = link instanceof BaseUnit ? ((BaseUnit)construction).getDescription(city) : (link instanceof Building ? ((Building)construction).getDescription(city, true) : (link instanceof PerpetualStatConversion ? TranslationsKt.tr$default(StringsKt.replace$default(((PerpetualStatConversion)construction).getDescription(), "[rate]", "" + '[' + ((PerpetualStatConversion)construction).getConversionRate(city) + ']', false, 4, null), false, false, 3, null) : (link instanceof PerpetualConstruction ? TranslationsKt.tr$default(((PerpetualConstruction)construction).getDescription(), false, false, 3, null) : "")));
        Label descriptionLabel = new Label((CharSequence)description, BaseScreen.Companion.getSkin());
        descriptionLabel.setWrap(true);
        $this$updateSelectedConstructionTable_u24lambda_u240.add((Actor)descriptionLabel).colspan(2).width($this$updateSelectedConstructionTable_u24lambda_u240.getStage().getWidth() / (float)(this.cityScreen.isCrampedPortrait() ? 3 : 4));
        if (cityConstructions.isBuilt(construction.getName())) {
            this.showSellButton(construction);
        } else if (this.buyButtonFactory.hasBuyButtons(construction)) {
            $this$updateSelectedConstructionTable_u24lambda_u240.row();
            for (TextButton button : this.buyButtonFactory.getBuyButtons(construction)) {
                this.selectedConstructionTable.add((Actor)button).padTop(5.0f).colspan(2).center().row();
            }
        }
        if (construction instanceof BaseUnit) {
            String baseUnit = ((BaseUnit)construction).getName();
            Boolean buildUnitWithPromotions = city.getUnitShouldUseSavedPromotion().get(baseUnit);
            if (buildUnitWithPromotions != null) {
                $this$updateSelectedConstructionTable_u24lambda_u240.row();
                $this$updateSelectedConstructionTable_u24lambda_u240.add((Actor)Scene2dExtensionsKt.toCheckBox("Use default promotions", buildUnitWithPromotions, arg_0 -> ConstructionInfoTable.updateSelectedConstructionTable$lambda$0$1(city, baseUnit, arg_0))).colspan(2).center();
            }
        }
    }

    private final void showSellButton(IConstruction construction) {
        if (construction instanceof Building && ((Building)construction).isSellable()) {
            Table $this$showSellButton_u24lambda_u240 = this.selectedConstructionTable;
            boolean bl = false;
            int sellAmount = this.cityScreen.getCity$core().getGoldForSellingBuilding(((Building)construction).getName());
            String sellText = "{Sell} " + sellAmount + " \u00a4";
            TextButton sellBuildingButton = Scene2dExtensionsKt.toTextButton$default(sellText, null, false, 3, null);
            $this$showSellButton_u24lambda_u240.row();
            $this$showSellButton_u24lambda_u240.add((Actor)sellBuildingButton).padTop(5.0f).colspan(2).center();
            boolean isFree = this.cityScreen.hasFreeBuilding$core((Building)construction);
            boolean enableSell = !isFree && !this.cityScreen.getCity$core().isPuppet() && this.cityScreen.getCanChangeState() && (!this.cityScreen.getCity$core().getHasSoldBuildingThisTurn() || this.cityScreen.getCity$core().getCiv().getGameInfo().getGameParameters().getGodMode());
            Scene2dExtensionsKt.setEnabled(sellBuildingButton, enableSell);
            if (enableSell) {
                ActivationExtensionsKt.onClick(sellBuildingButton, UncivSound.Companion.getCoin(), () -> ConstructionInfoTable.showSellButton$lambda$0$0(sellBuildingButton, this, construction, sellText));
            }
            if (this.cityScreen.getCity$core().getHasSoldBuildingThisTurn() && !this.cityScreen.getCity$core().getCiv().getGameInfo().getGameParameters().getGodMode() || this.cityScreen.getCity$core().isPuppet() || !this.cityScreen.getCanChangeState()) {
                Scene2dExtensionsKt.disable(sellBuildingButton);
            }
        }
    }

    private final void sellBuildingClicked(Building construction, String sellText) {
        PopupKt.closeAllPopups(this.cityScreen);
        Popup.open$default(new ConfirmPopup(this.cityScreen, "Are you sure you want to sell this [" + construction.getName() + "]?", sellText, false, () -> ConstructionInfoTable.sellBuildingClicked$lambda$0(this), () -> ConstructionInfoTable.sellBuildingClicked$lambda$1(this, construction), 8, null), false, 1, null);
    }

    private final void sellBuildingConfirmed(Building construction) {
        this.cityScreen.getCity$core().sellBuilding(construction);
        this.cityScreen.clearSelection();
        this.cityScreen.update$core();
    }

    private static final Unit updateSelectedConstructionTable$lambda$0$0$0(ConstructionInfoTable this$0, String $link) {
        this$0.cityScreen.openCivilopedia($link);
        return Unit.INSTANCE;
    }

    private static final Unit updateSelectedConstructionTable$lambda$0$1(City $city, String $baseUnit, boolean it) {
        ((Map)$city.getUnitShouldUseSavedPromotion()).put($baseUnit, it);
        return Unit.INSTANCE;
    }

    private static final Unit showSellButton$lambda$0$0(TextButton $sellBuildingButton, ConstructionInfoTable this$0, IConstruction $construction, String $sellText) {
        Scene2dExtensionsKt.disable($sellBuildingButton);
        this$0.sellBuildingClicked((Building)$construction, $sellText);
        return Unit.INSTANCE;
    }

    private static final Unit sellBuildingClicked$lambda$0(ConstructionInfoTable this$0) {
        this$0.cityScreen.update$core();
        return Unit.INSTANCE;
    }

    private static final Unit sellBuildingClicked$lambda$1(ConstructionInfoTable this$0, Building $construction) {
        this$0.sellBuildingConfirmed($construction);
        return Unit.INSTANCE;
    }
}

