/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.devconsole;

import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.files.Autosaves;
import com.unciv.models.ruleset.nation.Difficulty;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.screens.devconsole.CliInput;
import com.unciv.ui.screens.devconsole.ConsoleAction;
import com.unciv.ui.screens.devconsole.ConsoleCommand;
import com.unciv.ui.screens.devconsole.ConsoleCommandNode;
import com.unciv.ui.screens.devconsole.ConsoleErrorException;
import com.unciv.ui.screens.devconsole.DevConsolePopup;
import com.unciv.ui.screens.devconsole.DevConsoleResponse;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.utils.Concurrency;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fH\u0002R0\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/unciv/ui/screens/devconsole/ConsoleGameCommands;", "Lcom/unciv/ui/screens/devconsole/ConsoleCommandNode;", "<init>", "()V", "subcommands", "Ljava/util/HashMap;", "", "Lcom/unciv/ui/screens/devconsole/ConsoleCommand;", "Lkotlin/collections/HashMap;", "getSubcommands", "()Ljava/util/HashMap;", "getSpectatorOrNull", "Lcom/unciv/logic/civilization/Civilization;", "Lcom/unciv/logic/GameInfo;", "doRemoveSpectator", "", "console", "Lcom/unciv/ui/screens/devconsole/DevConsolePopup;", "existingSpectator", "core"})
@SourceDebugExtension(value={"SMAP\nConsoleGameCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsoleGameCommands.kt\ncom/unciv/ui/screens/devconsole/ConsoleGameCommands\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n296#2,2:67\n*S KotlinDebug\n*F\n+ 1 ConsoleGameCommands.kt\ncom/unciv/ui/screens/devconsole/ConsoleGameCommands\n*L\n46#1:67,2\n*E\n"})
public final class ConsoleGameCommands
implements ConsoleCommandNode {
    @NotNull
    private final HashMap<String, ConsoleCommand> subcommands;

    public ConsoleGameCommands() {
        Pair[] pairArray = new Pair[]{TuplesKt.to("setdifficulty", new ConsoleAction("game setdifficulty <difficulty>", ConsoleGameCommands::subcommands$lambda$0)), TuplesKt.to("setturn", new ConsoleAction("game setturn <nonNegativeAmount>", ConsoleGameCommands::subcommands$lambda$1)), TuplesKt.to("add-spectator", new ConsoleAction("game add-spectator", (arg_0, arg_1) -> ConsoleGameCommands.subcommands$lambda$2(this, arg_0, arg_1))), TuplesKt.to("remove-spectator", new ConsoleAction("game remove-spectator", (arg_0, arg_1) -> ConsoleGameCommands.subcommands$lambda$3(this, arg_0, arg_1)))};
        this.subcommands = MapsKt.hashMapOf(pairArray);
    }

    @Override
    @NotNull
    public HashMap<String, ConsoleCommand> getSubcommands() {
        return this.subcommands;
    }

    private final Civilization getSpectatorOrNull(GameInfo $this$getSpectatorOrNull) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = $this$getSpectatorOrNull.getCivilizations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Civilization it = (Civilization)element$iv;
                boolean bl = false;
                if (!it.getNation().isSpectator()) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final void doRemoveSpectator(DevConsolePopup console, Civilization existingSpectator) {
        GameInfo game = console.getGameInfo$core();
        if (Intrinsics.areEqual(game.getCurrentPlayerCiv(), existingSpectator)) {
            game.setCurrentPlayer("");
        }
        game.getCivilizations().remove(existingSpectator);
        Iterator<Civilization> iterator2 = game.getCivilizations().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Civilization> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Civilization civ;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            civ.getDiplomacy().remove("Spectator");
        }
        Autosaves.autoSave$default(UncivGame.Companion.getCurrent().getFiles().getAutosaves(), console.getGameInfo$core(), false, 2, null);
        console.getScreen().setShouldUpdate(false);
        UncivGame.Companion.getCurrent().removeScreensOfType(Reflection.getOrCreateKotlinClass(WorldScreen.class));
        GameInfo newGame = UncivGame.Companion.getCurrent().getFiles().getAutosaves().loadLatestAutosave();
        Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(newGame, null){
            int label;
            final /* synthetic */ GameInfo $newGame;
            {
                this.$newGame = $newGame;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        this.label = 1;
                        Object object2 = UncivGame.loadGame$default(UncivGame.Companion.getCurrent(), this.$newGame, null, true, this, 2, null);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
    }

    private static final Unit subcommands$lambda$3$0(ConsoleGameCommands this$0, DevConsolePopup $console, Civilization $existingSpectator) {
        this$0.doRemoveSpectator($console, $existingSpectator);
        return Unit.INSTANCE;
    }

    private static final DevConsoleResponse subcommands$lambda$0(DevConsolePopup console, List params) {
        Intrinsics.checkNotNullParameter(console, "console");
        Intrinsics.checkNotNullParameter(params, "params");
        CliInput cliInput = (CliInput)params.get(0);
        Collection<Difficulty> collection = console.getGameInfo$core().getRuleset().getDifficulties().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Difficulty difficulty = (Difficulty)cliInput.findOrNull((Iterable)collection);
        if (difficulty == null) {
            throw new ConsoleErrorException("Unrecognized difficulty");
        }
        Difficulty difficulty2 = difficulty;
        console.getGameInfo$core().setDifficulty(difficulty2.getName());
        console.getGameInfo$core().setTransients();
        return DevConsoleResponse.Companion.getOK();
    }

    private static final DevConsoleResponse subcommands$lambda$1(DevConsolePopup console, List params) {
        Intrinsics.checkNotNullParameter(console, "console");
        Intrinsics.checkNotNullParameter(params, "params");
        int turn = ((CliInput)params.get(0)).toInt();
        console.getGameInfo$core().setTurns(turn);
        console.getGameInfo$core().setTransients();
        return DevConsoleResponse.Companion.getOK();
    }

    private static final DevConsoleResponse subcommands$lambda$2(ConsoleGameCommands this$0, DevConsolePopup console, List list2) {
        Intrinsics.checkNotNullParameter(console, "console");
        Intrinsics.checkNotNullParameter(list2, "<unused var>");
        Civilization existingSpectator = this$0.getSpectatorOrNull(console.getGameInfo$core());
        if (existingSpectator != null) {
            throw new ConsoleErrorException("Spectator already exists");
        }
        console.getGameInfo$core().getSpectator("");
        return DevConsoleResponse.Companion.getOK();
    }

    private static final DevConsoleResponse subcommands$lambda$3(ConsoleGameCommands this$0, DevConsolePopup console, List list2) {
        Intrinsics.checkNotNullParameter(console, "console");
        Intrinsics.checkNotNullParameter(list2, "<unused var>");
        Civilization civilization = this$0.getSpectatorOrNull(console.getGameInfo$core());
        if (civilization == null) {
            throw new ConsoleErrorException("No Spectator in this game");
        }
        Civilization existingSpectator = civilization;
        new ConfirmPopup(console.getScreen(), "Warning: This needs to save and reload an autosave", "Do it anyway", false, null, () -> ConsoleGameCommands.subcommands$lambda$3$0(this$0, console, existingSpectator), 24, null).open(true);
        return DevConsoleResponse.Companion.getOK();
    }
}

