/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.mapeditorscreen.tabs;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.map.BFS;
import com.unciv.logic.map.mapgenerator.MapGenerationRandomness;
import com.unciv.logic.map.mapgenerator.MapGenerator;
import com.unciv.logic.map.mapgenerator.RiverGenerator;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.map.tile.TileNormalizer;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.ActorKeyShortcutDispatcher;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.components.widgets.TabbedPager;
import com.unciv.ui.components.widgets.UncivSlider;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.ToastPopup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import com.unciv.ui.screens.mapeditorscreen.MapEditorScreen;
import com.unciv.ui.screens.mapeditorscreen.tabs.IMapEditorEditSubTabs;
import com.unciv.ui.screens.mapeditorscreen.tabs.MapEditorEditFeaturesTab;
import com.unciv.ui.screens.mapeditorscreen.tabs.MapEditorEditImprovementsTab;
import com.unciv.ui.screens.mapeditorscreen.tabs.MapEditorEditResourcesTab;
import com.unciv.ui.screens.mapeditorscreen.tabs.MapEditorEditRiversTab;
import com.unciv.ui.screens.mapeditorscreen.tabs.MapEditorEditStartsTab;
import com.unciv.ui.screens.mapeditorscreen.tabs.MapEditorEditTerrainTab;
import com.unciv.ui.screens.mapeditorscreen.tabs.MapEditorEditWondersTab;
import com.unciv.ui.screens.mapeditorscreen.tabs.MapEditorOptionsTab;
import com.unciv.utils.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u001a\u0018\u0000 I2\u00020\u00012\u00020\u0002:\u0003GHIB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020 H\u0002J\u0018\u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u00122\u0006\u0010/\u001a\u000200H\u0002JH\u00101\u001a\u00020\u001e2\u0006\u00102\u001a\u0002002\u0006\u00103\u001a\u0002002\b\b\u0002\u00104\u001a\u00020\u001a2\b\b\u0002\u00105\u001a\u0002002\b\b\u0002\u00106\u001a\u00020+2\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001cJ:\u00101\u001a\u00020\u001e2\u0006\u00104\u001a\u00020\u001a2\u0006\u00102\u001a\u0002002\u0006\u00103\u001a\u00020\u00122\u0006\u00105\u001a\u0002002\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001cJ \u00108\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020 2\u0006\u00109\u001a\u0002002\u0006\u0010:\u001a\u00020\nH\u0016J \u0010;\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020 2\u0006\u00109\u001a\u0002002\u0006\u0010:\u001a\u00020\nH\u0016J\u0010\u0010<\u001a\u00020\u001e2\u0006\u0010=\u001a\u00020\u001dH\u0002J\u0010\u0010>\u001a\u00020\u001e2\u0006\u0010=\u001a\u00020\u001dH\u0002J\b\u0010?\u001a\u00020\u001eH\u0002J\u0015\u0010@\u001a\u00020\u001e2\u0006\u0010=\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\bAJ\u0010\u0010B\u001a\u00020\u001e2\u0006\u0010=\u001a\u00020\u001dH\u0002J\u0010\u0010C\u001a\u00020+2\u0006\u0010=\u001a\u00020\u001dH\u0002J\u0014\u0010D\u001a\u00020+*\u00020\u001d2\u0006\u0010E\u001a\u00020\u001dH\u0002J\u0014\u0010F\u001a\u00020\u001e*\u00020\u001d2\u0006\u0010E\u001a\u00020\u001dH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010!\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 @@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditTab;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "Lcom/unciv/ui/components/widgets/TabbedPager$IPageExtensions;", "editorScreen", "Lcom/unciv/ui/screens/mapeditorscreen/MapEditorScreen;", "headerHeight", "", "<init>", "(Lcom/unciv/ui/screens/mapeditorscreen/MapEditorScreen;F)V", "subTabs", "Lcom/unciv/ui/components/widgets/TabbedPager;", "brushTable", "brushSlider", "Lcom/unciv/ui/components/widgets/UncivSlider;", "brushLabel", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "brushCell", "Lcom/badlogic/gdx/scenes/scene2d/ui/Cell;", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "randomness", "Lcom/unciv/logic/map/mapgenerator/MapGenerationRandomness;", "getRandomness$core", "()Lcom/unciv/logic/map/mapgenerator/MapGenerationRandomness;", "brushHandlerType", "Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditTab$BrushHandlerType;", "brushAction", "Lkotlin/Function1;", "Lcom/unciv/logic/map/tile/Tile;", "", "value", "", "brushSize", "getBrushSize$core", "()I", "setBrushSize$core", "(I)V", "tileMatchFuzziness", "Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorOptionsTab$TileMatchFuzziness;", "riverStartTile", "riverEndTile", "selectPage", "", "index", "linkCivilopedia", "brushActor", "link", "", "setBrush", "name", "icon", "handlerType", "pediaLink", "isRemove", "applyAction", "activated", "caption", "pager", "deactivated", "tileClickHandler", "tile", "selectRiverFromOrTo", "paintRiverFromTo", "paintTilesWithBrush", "paintTilesWithBrush$core", "directPaintTile", "paintTile", "isSimilarEnough", "other", "applyFrom", "BrushHandlerType", "AllEditSubTabs", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nMapEditorEditTab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapEditorEditTab.kt\ncom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditTab\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,346:1\n1404#2:347\n1496#2,5:348\n*S KotlinDebug\n*F\n+ 1 MapEditorEditTab.kt\ncom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditTab\n*L\n267#1:347\n267#1:348,5\n*E\n"})
public final class MapEditorEditTab
extends Table
implements TabbedPager.IPageExtensions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MapEditorScreen editorScreen;
    @NotNull
    private final TabbedPager subTabs;
    @NotNull
    private final Table brushTable;
    @NotNull
    private final UncivSlider brushSlider;
    @NotNull
    private final Label brushLabel;
    @NotNull
    private final Cell<Actor> brushCell;
    @NotNull
    private Ruleset ruleset;
    @NotNull
    private final MapGenerationRandomness randomness;
    @NotNull
    private BrushHandlerType brushHandlerType;
    @NotNull
    private Function1<? super Tile, Unit> brushAction;
    private int brushSize;
    @NotNull
    private MapEditorOptionsTab.TileMatchFuzziness tileMatchFuzziness;
    @Nullable
    private Tile riverStartTile;
    @Nullable
    private Tile riverEndTile;

    public MapEditorEditTab(@NotNull MapEditorScreen editorScreen, float headerHeight) {
        Table table2;
        Intrinsics.checkNotNullParameter(editorScreen, "editorScreen");
        super(BaseScreen.Companion.getSkin());
        this.editorScreen = editorScreen;
        this.brushTable = new Table(this.getSkin());
        this.brushLabel = Scene2dExtensionsKt.toLabel("Brush ([1]):");
        this.ruleset = this.editorScreen.getRuleset();
        this.randomness = new MapGenerationRandomness();
        this.brushHandlerType = BrushHandlerType.None;
        this.brushAction = MapEditorEditTab::brushAction$lambda$0;
        this.brushSize = 1;
        this.tileMatchFuzziness = MapEditorOptionsTab.TileMatchFuzziness.CompleteMatch;
        this.top();
        Table $this$_init__u24lambda_u240 = table2 = this.brushTable;
        boolean bl = false;
        $this$_init__u24lambda_u240.pad(5.0f);
        $this$_init__u24lambda_u240.defaults().pad(10.0f).left();
        $this$_init__u24lambda_u240.add((Actor)this.brushLabel);
        Cell cell = $this$_init__u24lambda_u240.add().padLeft(0.0f);
        Intrinsics.checkNotNullExpressionValue(cell, "padLeft(...)");
        this.brushCell = cell;
        UncivSlider.TipType tipType = UncivSlider.TipType.Auto;
        this.brushSlider = new UncivSlider(1.0f, 6.0f, 1.0f, false, false, 1.0f, null, tipType, MapEditorEditTab::lambda$0$0, arg_0 -> MapEditorEditTab.lambda$0$1(this, arg_0), 88, null);
        $this$_init__u24lambda_u240.add((Actor)this.brushSlider).padLeft(0.0f);
        float subTabsHeight = this.editorScreen.getStage().getHeight() - (float)2 * headerHeight - this.brushTable.getPrefHeight() - 2.0f + 10.0f;
        float subTabsWidth = this.editorScreen.getToolsWidth();
        int n = AllEditSubTabs.getEntries().size();
        this.subTabs = new TabbedPager(subTabsWidth, subTabsWidth, subTabsHeight, subTabsHeight, 0, null, null, null, 5.0f, null, null, n, 1776, null);
        for (AllEditSubTabs page : AllEditSubTabs.getEntries()) {
            TabbedPager tabbedPager = this.subTabs;
            String string = page.getCaption();
            Group group = new Group();
            Image image = ImageGetter.getImage$default(ImageGetter.INSTANCE, page.getIcon(), null, 2, null);
            KeyCharAndCode keyCharAndCode = new KeyCharAndCode(page.getKey());
            TabbedPager.addPage$default(tabbedPager, string, group, image, 20.0f, 0, false, true, keyCharAndCode, 0, false, 816, null);
        }
        TabbedPager.selectPage$default(this.subTabs, 0, false, 2, null);
        this.add((Actor)this.brushTable).fillX().row();
        Table table3 = this;
        Color color = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color, "GRAY");
        Scene2dExtensionsKt.addSeparator$default(table3, color, 0, 0.0f, 6, null);
        this.add((Actor)this.subTabs).left().fillX().row();
        ActivationExtensionsKt.getKeyShortcuts(this).add(Character.valueOf('t'), () -> MapEditorEditTab._init_$lambda$1(this));
        ActivationExtensionsKt.getKeyShortcuts(this).add(Character.valueOf('f'), () -> MapEditorEditTab._init_$lambda$2(this));
        ActivationExtensionsKt.getKeyShortcuts(this).add(Character.valueOf('w'), () -> MapEditorEditTab._init_$lambda$3(this));
        ActivationExtensionsKt.getKeyShortcuts(this).add(Character.valueOf('r'), () -> MapEditorEditTab._init_$lambda$4(this));
        ActivationExtensionsKt.getKeyShortcuts(this).add(Character.valueOf('i'), () -> MapEditorEditTab._init_$lambda$5(this));
        ActivationExtensionsKt.getKeyShortcuts(this).add(Character.valueOf('v'), () -> MapEditorEditTab._init_$lambda$6(this));
        ActivationExtensionsKt.getKeyShortcuts(this).add(Character.valueOf('s'), () -> MapEditorEditTab._init_$lambda$7(this));
        ActivationExtensionsKt.getKeyShortcuts(this).add(Character.valueOf('u'), () -> MapEditorEditTab._init_$lambda$8(this));
        ActivationExtensionsKt.getKeyShortcuts(this).add(Character.valueOf('1'), () -> MapEditorEditTab._init_$lambda$9(this));
        ActivationExtensionsKt.getKeyShortcuts(this).add(Character.valueOf('2'), () -> MapEditorEditTab._init_$lambda$10(this));
        ActivationExtensionsKt.getKeyShortcuts(this).add(Character.valueOf('3'), () -> MapEditorEditTab._init_$lambda$11(this));
        ActivationExtensionsKt.getKeyShortcuts(this).add(Character.valueOf('4'), () -> MapEditorEditTab._init_$lambda$12(this));
        ActivationExtensionsKt.getKeyShortcuts(this).add(Character.valueOf('5'), () -> MapEditorEditTab._init_$lambda$13(this));
        ActivationExtensionsKt.getKeyShortcuts(this).add(KeyCharAndCode.Companion.ctrl('f'), () -> MapEditorEditTab._init_$lambda$14(this));
    }

    @NotNull
    public final MapGenerationRandomness getRandomness$core() {
        return this.randomness;
    }

    public final int getBrushSize$core() {
        return this.brushSize;
    }

    public final void setBrushSize$core(int value) {
        this.brushSize = value;
        this.brushSlider.setValue(value < 0 ? 6.0f : (float)value);
    }

    private final boolean selectPage(int index) {
        return TabbedPager.selectPage$default(this.subTabs, index, false, 2, null);
    }

    private final void linkCivilopedia(Actor brushActor, String link) {
        if (((CharSequence)link).length() == 0) {
            return;
        }
        brushActor.setTouchable(Touchable.enabled);
        ActivationExtensionsKt.onActivation(brushActor, () -> MapEditorEditTab.linkCivilopedia$lambda$0(this, link));
        ActorKeyShortcutDispatcher.add$default(ActivationExtensionsKt.getKeyShortcuts(brushActor), KeyboardBinding.Civilopedia, 0, 2, null);
    }

    public final void setBrush(@NotNull String name, @NotNull String icon, @NotNull BrushHandlerType handlerType, @NotNull String pediaLink, boolean isRemove, @NotNull Function1<? super Tile, Unit> applyAction) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(icon, "icon");
        Intrinsics.checkNotNullParameter((Object)handlerType, "handlerType");
        Intrinsics.checkNotNullParameter(pediaLink, "pediaLink");
        Intrinsics.checkNotNullParameter(applyAction, "applyAction");
        this.brushHandlerType = handlerType;
        Actor brushActor = FormattedLine.render$default(new FormattedLine(name, null, icon, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, isRemove, 8186, null), 0.0f, null, 2, null);
        this.linkCivilopedia(brushActor, pediaLink);
        this.brushCell.setActor(brushActor);
        this.brushAction = applyAction;
    }

    public static /* synthetic */ void setBrush$default(MapEditorEditTab mapEditorEditTab, String string, String string2, BrushHandlerType brushHandlerType, String string3, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            brushHandlerType = BrushHandlerType.Tile;
        }
        if ((n & 8) != 0) {
            string3 = string2;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        mapEditorEditTab.setBrush(string, string2, brushHandlerType, string3, bl, function1);
    }

    public final void setBrush(@NotNull BrushHandlerType handlerType, @NotNull String name, @NotNull Actor icon, @NotNull String pediaLink, @NotNull Function1<? super Tile, Unit> applyAction) {
        Table table2;
        Intrinsics.checkNotNullParameter((Object)handlerType, "handlerType");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(icon, "icon");
        Intrinsics.checkNotNullParameter(pediaLink, "pediaLink");
        Intrinsics.checkNotNullParameter(applyAction, "applyAction");
        this.brushHandlerType = handlerType;
        Table $this$setBrush_u24lambda_u240 = table2 = new Table();
        boolean bl = false;
        $this$setBrush_u24lambda_u240.add(icon).padRight(10.0f);
        $this$setBrush_u24lambda_u240.add((Actor)Scene2dExtensionsKt.toLabel(name));
        Table brushActor = table2;
        this.linkCivilopedia(brushActor, pediaLink);
        this.brushCell.setActor((Actor)brushActor);
        this.brushAction = applyAction;
    }

    @Override
    public void activated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        Intrinsics.checkNotNullParameter(caption, "caption");
        Intrinsics.checkNotNullParameter(pager, "pager");
        if (this.editorScreen.getEditTabsNeedRefresh()) {
            this.ruleset = this.editorScreen.getRuleset();
            ImageGetter.setNewRuleset$default(ImageGetter.INSTANCE, this.ruleset, false, 2, null);
            for (AllEditSubTabs page : AllEditSubTabs.getEntries()) {
                Table tab = page.getInstantiate().invoke(this, this.ruleset);
                this.subTabs.replacePage(page.getCaption(), (Actor)tab);
                String string = page.getCaption();
                Intrinsics.checkNotNull(tab, "null cannot be cast to non-null type com.unciv.ui.screens.mapeditorscreen.tabs.IMapEditorEditSubTabs");
                this.subTabs.setPageDisabled(string, ((IMapEditorEditSubTabs)((Object)tab)).isDisabled());
            }
            this.brushHandlerType = BrushHandlerType.None;
            this.editorScreen.setEditTabsNeedRefresh(false);
        }
        this.editorScreen.setTileClickHandler((Function1<? super Tile, Unit>)new Function1<Tile, Unit>((Object)this){

            public final void invoke(Tile p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                MapEditorEditTab.access$tileClickHandler((MapEditorEditTab)this.receiver, p0);
            }
        });
        pager.setScrollDisabled(true);
        this.tileMatchFuzziness = this.editorScreen.getTileMatchFuzziness();
    }

    @Override
    public void deactivated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        Intrinsics.checkNotNullParameter(caption, "caption");
        Intrinsics.checkNotNullParameter(pager, "pager");
        pager.setScrollDisabled(true);
        this.editorScreen.setTileClickHandler(null);
    }

    private final void tileClickHandler(Tile tile) {
        if (this.brushSize < -1 || this.brushSize > 5 || this.brushHandlerType == BrushHandlerType.None) {
            return;
        }
        if (this.editorScreen.getMapHolder().isPanning() || this.editorScreen.getMapHolder().isZooming()) {
            return;
        }
        this.editorScreen.hideSelection();
        switch (WhenMappings.$EnumSwitchMapping$0[this.brushHandlerType.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                this.selectRiverFromOrTo(tile);
                break;
            }
            default: {
                this.paintTilesWithBrush$core(tile);
            }
        }
    }

    private final void selectRiverFromOrTo(Tile tile) {
        Tile[] tileArray = new Tile[]{tile};
        Set<Tile> tilesToHighlight = SetsKt.mutableSetOf(tileArray);
        if (tile.isLand()) {
            this.riverStartTile = tile;
            if (this.riverEndTile != null) {
                this.paintRiverFromTo();
                return;
            }
            RiverGenerator riverGenerator = new RiverGenerator(this.editorScreen.getTileMap(), this.randomness, this.ruleset);
            this.riverEndTile = riverGenerator.getClosestWaterTile(tile);
            if (this.riverEndTile != null) {
                Collection collection = tilesToHighlight;
                Tile tile2 = this.riverEndTile;
                Intrinsics.checkNotNull(tile2);
                collection.add(tile2);
            }
        } else {
            this.riverEndTile = tile;
            if (this.riverStartTile != null) {
                this.paintRiverFromTo();
                return;
            }
        }
        for (Object e : tilesToHighlight) {
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            Tile tileToHighlight = (Tile)e;
            Color color = Color.BLUE;
            Intrinsics.checkNotNullExpressionValue(color, "BLUE");
            this.editorScreen.highlightTile(tileToHighlight, color);
        }
    }

    private final void paintRiverFromTo() {
        Set resultingTiles = new LinkedHashSet();
        this.randomness.seedRNG(this.editorScreen.getNewMapParameters().getSeed());
        try {
            RiverGenerator riverGenerator = new RiverGenerator(this.editorScreen.getTileMap(), this.randomness, this.ruleset);
            Tile tile = this.riverStartTile;
            Intrinsics.checkNotNull(tile);
            Tile tile2 = this.riverEndTile;
            Intrinsics.checkNotNull(tile2);
            riverGenerator.spawnRiver(tile, tile2, resultingTiles);
            new MapGenerator(this.ruleset, null, 2, null).convertTerrains(resultingTiles);
        }
        catch (Exception ex) {
            Log.INSTANCE.error("Exception while generating rivers", ex);
            new ToastPopup("River generation failed!", this.editorScreen, 0L, 4, null);
        }
        this.riverStartTile = null;
        this.riverEndTile = null;
        this.editorScreen.setDirty(true);
        for (Object e : resultingTiles) {
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            Tile tile = (Tile)e;
            Color color = Color.SKY;
            Intrinsics.checkNotNullExpressionValue(color, "SKY");
            this.editorScreen.updateAndHighlight(tile, color);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void paintTilesWithBrush$core(@NotNull Tile tile) {
        void $this$flatMapTo$iv$iv;
        Set<Tile> set;
        Intrinsics.checkNotNullParameter(tile, "tile");
        if (this.brushSize == -1) {
            BFS bfs = new BFS(tile, arg_0 -> MapEditorEditTab.paintTilesWithBrush$lambda$0(this, tile, arg_0));
            bfs.stepToEnd();
            set = CollectionsKt.toSet((Iterable)bfs.getReachedTiles());
        } else {
            set = SequencesKt.toSet(tile.getTilesInDistance(this.brushSize - 1));
        }
        Set<Tile> tiles = set;
        for (Tile tileToPaint : tiles) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.brushHandlerType.ordinal()]) {
                case 3: {
                    this.directPaintTile(tileToPaint);
                    break;
                }
                case 4: {
                    this.directPaintTile(tileToPaint);
                    break;
                }
                case 5: {
                    this.paintTile(tileToPaint);
                    break;
                }
                case 6: {
                    this.paintTile(tileToPaint);
                }
            }
        }
        Iterable $this$flatMap$iv = tiles;
        boolean $i$f$flatMapSequence = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapSequenceTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Tile it = (Tile)element$iv$iv;
            boolean bl = false;
            Sequence<Tile> list$iv$iv = SequencesKt.plus(it.getNeighbors(), it);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Set<Tile> tilesToUpdate = CollectionsKt.toSet((List)destination$iv$iv);
        for (Tile tileToUpdate : tilesToUpdate) {
            this.editorScreen.updateTile(tileToUpdate);
        }
    }

    private final void directPaintTile(Tile tile) {
        this.brushAction.invoke(tile);
        this.editorScreen.setDirty(true);
        MapEditorScreen.highlightTile$default(this.editorScreen, tile, null, 2, null);
    }

    private final boolean paintTile(Tile tile) {
        Tile savedTile = Tile.clone$default(tile, false, 1, null);
        Tile paintedTile = Tile.clone$default(tile, false, 1, null);
        this.brushAction.invoke(paintedTile);
        paintedTile.setRuleset(this.ruleset);
        try {
            paintedTile.setTerrainTransients();
        }
        catch (Exception ex) {
            String string = ex.getMessage();
            if (string == null) {
                throw ex;
            }
            String message = string;
            if (!StringsKt.endsWith$default(message, "not exist in this ruleset!", false, 2, null)) {
                throw ex;
            }
            new ToastPopup(message, this.editorScreen, 0L, 4, null);
        }
        this.brushAction.invoke(tile);
        tile.setTerrainTransients();
        TileNormalizer.INSTANCE.normalizeToRuleset(tile, this.ruleset);
        if (!this.isSimilarEnough(paintedTile, tile)) {
            this.applyFrom(tile, savedTile);
            return false;
        }
        if (!Intrinsics.areEqual(tile.getNaturalWonder(), savedTile.getNaturalWonder())) {
            this.editorScreen.setNaturalWondersNeedRefresh(true);
        }
        this.editorScreen.setDirty(true);
        MapEditorScreen.highlightTile$default(this.editorScreen, tile, null, 2, null);
        return true;
    }

    private final boolean isSimilarEnough(Tile $this$isSimilarEnough, Tile other) {
        return this.tileMatchFuzziness.compareTo((Enum)MapEditorOptionsTab.TileMatchFuzziness.CompleteMatch) <= 0 && !Intrinsics.areEqual($this$isSimilarEnough.getImprovement(), other.getImprovement()) || $this$isSimilarEnough.getRoadStatus() != other.getRoadStatus() ? false : (this.tileMatchFuzziness.compareTo((Enum)MapEditorOptionsTab.TileMatchFuzziness.NoImprovement) <= 0 && !Intrinsics.areEqual($this$isSimilarEnough.getResource(), other.getResource()) ? false : (this.tileMatchFuzziness.compareTo((Enum)MapEditorOptionsTab.TileMatchFuzziness.BaseAndFeatures) <= 0 && !Intrinsics.areEqual(CollectionsKt.toSet((Iterable)$this$isSimilarEnough.getTerrainFeatures()), CollectionsKt.toSet((Iterable)other.getTerrainFeatures())) ? false : (this.tileMatchFuzziness.compareTo((Enum)MapEditorOptionsTab.TileMatchFuzziness.BaseTerrain) <= 0 && !Intrinsics.areEqual($this$isSimilarEnough.getBaseTerrain(), other.getBaseTerrain()) ? false : (this.tileMatchFuzziness.compareTo((Enum)MapEditorOptionsTab.TileMatchFuzziness.LandOrWater) <= 0 && $this$isSimilarEnough.isLand() != other.isLand() ? false : Intrinsics.areEqual($this$isSimilarEnough.getNaturalWonder(), other.getNaturalWonder())))));
    }

    private final void applyFrom(Tile $this$applyFrom, Tile other) {
        $this$applyFrom.setBaseTerrain(other.getBaseTerrain());
        $this$applyFrom.setTerrainFeatures(other.getTerrainFeatures());
        $this$applyFrom.setTileResource(other.getTileResource());
        $this$applyFrom.setImprovement(other.getImprovement());
        $this$applyFrom.setNaturalWonder(other.getNaturalWonder());
        $this$applyFrom.setRoadStatus(other.getRoadStatus());
        $this$applyFrom.setHasBottomLeftRiver(other.getHasBottomLeftRiver());
        $this$applyFrom.setHasBottomRightRiver(other.getHasBottomRightRiver());
        $this$applyFrom.setHasBottomRiver(other.getHasBottomRiver());
        $this$applyFrom.setTerrainTransients();
    }

    private static final Unit brushAction$lambda$0(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Unit.INSTANCE;
    }

    private static final String lambda$0$0(float it) {
        return TranslationsKt.tr$default(com.unciv.ui.screens.mapeditorscreen.tabs.MapEditorEditTab$Companion.getBrushTip$default(Companion, it, false, 2, null), false, false, 3, null);
    }

    private static final Unit lambda$0$1(MapEditorEditTab this$0, float it) {
        this$0.setBrushSize$core(it > 5.0f ? -1 : (int)it);
        this$0.brushLabel.setText(TranslationsKt.tr$default("Brush ([" + MapEditorEditTab.Companion.getBrushTip(it, true) + "]):", false, false, 3, null));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(MapEditorEditTab this$0) {
        this$0.selectPage(0);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(MapEditorEditTab this$0) {
        this$0.selectPage(1);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(MapEditorEditTab this$0) {
        this$0.selectPage(2);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(MapEditorEditTab this$0) {
        this$0.selectPage(3);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$5(MapEditorEditTab this$0) {
        this$0.selectPage(4);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$6(MapEditorEditTab this$0) {
        this$0.selectPage(5);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$7(MapEditorEditTab this$0) {
        this$0.selectPage(6);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$8(MapEditorEditTab this$0) {
        this$0.selectPage(7);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$9(MapEditorEditTab this$0) {
        this$0.setBrushSize$core(1);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$10(MapEditorEditTab this$0) {
        this$0.setBrushSize$core(2);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$11(MapEditorEditTab this$0) {
        this$0.setBrushSize$core(3);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$12(MapEditorEditTab this$0) {
        this$0.setBrushSize$core(4);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$13(MapEditorEditTab this$0) {
        this$0.setBrushSize$core(5);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$14(MapEditorEditTab this$0) {
        this$0.setBrushSize$core(-1);
        return Unit.INSTANCE;
    }

    private static final Unit linkCivilopedia$lambda$0(MapEditorEditTab this$0, String $link) {
        this$0.editorScreen.openCivilopedia($link);
        return Unit.INSTANCE;
    }

    private static final boolean paintTilesWithBrush$lambda$0(MapEditorEditTab this$0, Tile $tile, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.isSimilarEnough(it, $tile);
    }

    public static final /* synthetic */ void access$tileClickHandler(MapEditorEditTab $this, Tile tile) {
        $this.tileClickHandler(tile);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B;\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\b\u00a2\u0006\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR#\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001b\u00a8\u0006\u001c"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditTab$AllEditSubTabs;", "", "caption", "", "key", "", "icon", "instantiate", "Lkotlin/Function2;", "Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditTab;", "Lcom/unciv/models/ruleset/Ruleset;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "<init>", "(Ljava/lang/String;ILjava/lang/String;CLjava/lang/String;Lkotlin/jvm/functions/Function2;)V", "getCaption", "()Ljava/lang/String;", "getKey", "()C", "getIcon", "getInstantiate", "()Lkotlin/jvm/functions/Function2;", "Terrain", "TerrainFeatures", "NaturalWonders", "Resources", "Improvements", "Rivers", "StartingLocations", "core"})
    private static final class AllEditSubTabs
    extends Enum<AllEditSubTabs> {
        @NotNull
        private final String caption;
        private final char key;
        @NotNull
        private final String icon;
        @NotNull
        private final Function2<MapEditorEditTab, Ruleset, Table> instantiate;
        public static final /* enum */ AllEditSubTabs Terrain = new AllEditSubTabs("Terrain", 't', "OtherIcons/Terrains", AllEditSubTabs::_init_$lambda$0);
        public static final /* enum */ AllEditSubTabs TerrainFeatures = new AllEditSubTabs("Features", 'f', "OtherIcons/Star", AllEditSubTabs::_init_$lambda$1);
        public static final /* enum */ AllEditSubTabs NaturalWonders = new AllEditSubTabs("Wonders", 'w', "OtherIcons/Star", AllEditSubTabs::_init_$lambda$2);
        public static final /* enum */ AllEditSubTabs Resources = new AllEditSubTabs("Resources", 'r', "OtherIcons/Resources", AllEditSubTabs::_init_$lambda$3);
        public static final /* enum */ AllEditSubTabs Improvements = new AllEditSubTabs("Improvements", 'i', "OtherIcons/Improvements", AllEditSubTabs::_init_$lambda$4);
        public static final /* enum */ AllEditSubTabs Rivers = new AllEditSubTabs("Rivers", 'v', "OtherIcons/Star", AllEditSubTabs::_init_$lambda$5);
        public static final /* enum */ AllEditSubTabs StartingLocations = new AllEditSubTabs("Starting locations", 's', "OtherIcons/Nations", AllEditSubTabs::_init_$lambda$6);
        private static final /* synthetic */ AllEditSubTabs[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private AllEditSubTabs(String caption, char key, String icon, Function2<? super MapEditorEditTab, ? super Ruleset, ? extends Table> instantiate) {
            this.caption = caption;
            this.key = key;
            this.icon = icon;
            this.instantiate = instantiate;
        }

        @NotNull
        public final String getCaption() {
            return this.caption;
        }

        public final char getKey() {
            return this.key;
        }

        @NotNull
        public final String getIcon() {
            return this.icon;
        }

        @NotNull
        public final Function2<MapEditorEditTab, Ruleset, Table> getInstantiate() {
            return this.instantiate;
        }

        public static AllEditSubTabs[] values() {
            return (AllEditSubTabs[])$VALUES.clone();
        }

        public static AllEditSubTabs valueOf(String value) {
            return Enum.valueOf(AllEditSubTabs.class, value);
        }

        @NotNull
        public static EnumEntries<AllEditSubTabs> getEntries() {
            return $ENTRIES;
        }

        private static final Table _init_$lambda$0(MapEditorEditTab parent, Ruleset ruleset) {
            Intrinsics.checkNotNullParameter(parent, "parent");
            Intrinsics.checkNotNullParameter(ruleset, "ruleset");
            return new MapEditorEditTerrainTab(parent, ruleset);
        }

        private static final Table _init_$lambda$1(MapEditorEditTab parent, Ruleset ruleset) {
            Intrinsics.checkNotNullParameter(parent, "parent");
            Intrinsics.checkNotNullParameter(ruleset, "ruleset");
            return new MapEditorEditFeaturesTab(parent, ruleset);
        }

        private static final Table _init_$lambda$2(MapEditorEditTab parent, Ruleset ruleset) {
            Intrinsics.checkNotNullParameter(parent, "parent");
            Intrinsics.checkNotNullParameter(ruleset, "ruleset");
            return new MapEditorEditWondersTab(parent, ruleset);
        }

        private static final Table _init_$lambda$3(MapEditorEditTab parent, Ruleset ruleset) {
            Intrinsics.checkNotNullParameter(parent, "parent");
            Intrinsics.checkNotNullParameter(ruleset, "ruleset");
            return new MapEditorEditResourcesTab(parent, ruleset);
        }

        private static final Table _init_$lambda$4(MapEditorEditTab parent, Ruleset ruleset) {
            Intrinsics.checkNotNullParameter(parent, "parent");
            Intrinsics.checkNotNullParameter(ruleset, "ruleset");
            return new MapEditorEditImprovementsTab(parent, ruleset);
        }

        private static final Table _init_$lambda$5(MapEditorEditTab parent, Ruleset ruleset) {
            Intrinsics.checkNotNullParameter(parent, "parent");
            Intrinsics.checkNotNullParameter(ruleset, "ruleset");
            return new MapEditorEditRiversTab(parent, ruleset);
        }

        private static final Table _init_$lambda$6(MapEditorEditTab parent, Ruleset ruleset) {
            Intrinsics.checkNotNullParameter(parent, "parent");
            Intrinsics.checkNotNullParameter(ruleset, "ruleset");
            return new MapEditorEditStartsTab(parent, ruleset);
        }

        static {
            $VALUES = allEditSubTabsArray = new AllEditSubTabs[]{AllEditSubTabs.Terrain, AllEditSubTabs.TerrainFeatures, AllEditSubTabs.NaturalWonders, AllEditSubTabs.Resources, AllEditSubTabs.Improvements, AllEditSubTabs.Rivers, AllEditSubTabs.StartingLocations};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditTab$BrushHandlerType;", "", "<init>", "(Ljava/lang/String;I)V", "None", "Direct", "Tile", "Road", "River", "RiverFromTo", "core"})
    public static final class BrushHandlerType
    extends Enum<BrushHandlerType> {
        public static final /* enum */ BrushHandlerType None = new BrushHandlerType();
        public static final /* enum */ BrushHandlerType Direct = new BrushHandlerType();
        public static final /* enum */ BrushHandlerType Tile = new BrushHandlerType();
        public static final /* enum */ BrushHandlerType Road = new BrushHandlerType();
        public static final /* enum */ BrushHandlerType River = new BrushHandlerType();
        public static final /* enum */ BrushHandlerType RiverFromTo = new BrushHandlerType();
        private static final /* synthetic */ BrushHandlerType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static BrushHandlerType[] values() {
            return (BrushHandlerType[])$VALUES.clone();
        }

        public static BrushHandlerType valueOf(String value) {
            return Enum.valueOf(BrushHandlerType.class, value);
        }

        @NotNull
        public static EnumEntries<BrushHandlerType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = brushHandlerTypeArray = new BrushHandlerType[]{BrushHandlerType.None, BrushHandlerType.Direct, BrushHandlerType.Tile, BrushHandlerType.Road, BrushHandlerType.River, BrushHandlerType.RiverFromTo};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditTab$Companion;", "", "<init>", "()V", "getBrushTip", "", "value", "", "abbreviate", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final String getBrushTip(float value, boolean abbreviate) {
            return value <= 5.0f ? TranslationsKt.tr((int)value) : (abbreviate ? "Floodfill_Abbreviation" : "Floodfill");
        }

        static /* synthetic */ String getBrushTip$default(Companion companion, float f, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.getBrushTip(f, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BrushHandlerType.values().length];
            try {
                nArray[BrushHandlerType.None.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BrushHandlerType.RiverFromTo.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BrushHandlerType.Direct.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BrushHandlerType.River.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BrushHandlerType.Tile.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BrushHandlerType.Road.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

