/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.multiplayerscreens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.logic.IdChecker;
import com.unciv.logic.multiplayer.FriendList;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.UncivTextField;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.popups.ToastPopup;
import com.unciv.ui.screens.multiplayerscreens.EditFriendScreenKt;
import com.unciv.ui.screens.pickerscreens.PickerScreen;
import com.unciv.utils.StringExtensionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/unciv/ui/screens/multiplayerscreens/EditFriendScreen;", "Lcom/unciv/ui/screens/pickerscreens/PickerScreen;", "selectedFriend", "Lcom/unciv/logic/multiplayer/FriendList$Friend;", "<init>", "(Lcom/unciv/logic/multiplayer/FriendList$Friend;)V", "core"})
@SourceDebugExtension(value={"SMAP\nEditFriendScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditFriendScreen.kt\ncom/unciv/ui/screens/multiplayerscreens/EditFriendScreen\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
public final class EditFriendScreen
extends PickerScreen {
    public EditFriendScreen(@NotNull FriendList.Friend selectedFriend) {
        Actor actor;
        Intrinsics.checkNotNullParameter(selectedFriend, "selectedFriend");
        super(false, 1, null);
        UncivTextField friendNameTextField = new UncivTextField("Please input a name for your friend!", selectedFriend.getName(), null, 4, null);
        TextButton pastePlayerIDButton = Scene2dExtensionsKt.toTextButton$default("Player ID from clipboard", null, false, 3, null);
        UncivTextField playerIDTextField = new UncivTextField("Please input a player ID for your friend!", selectedFriend.getPlayerID(), null, 4, null);
        TextButton deleteFriendButton = Scene2dExtensionsKt.toTextButton$default("Delete", null, false, 3, null);
        FriendList friendlist = new FriendList();
        this.getTopTable().add((Actor)Scene2dExtensionsKt.toLabel("Friend name")).row();
        this.getTopTable().add((Actor)friendNameTextField).pad(10.0f).padBottom(30.0f).width(this.getStage().getWidth() / (float)2).row();
        ActivationExtensionsKt.onClick(pastePlayerIDButton, () -> EditFriendScreen._init_$lambda$0(playerIDTextField));
        this.getTopTable().add((Actor)Scene2dExtensionsKt.toLabel("Player ID")).row();
        Table gameIDTable = new Table();
        gameIDTable.add((Actor)playerIDTextField).pad(10.0f).width((float)2 * this.getStage().getWidth() / (float)3 - pastePlayerIDButton.getWidth());
        gameIDTable.add((Actor)pastePlayerIDButton);
        this.getTopTable().add((Actor)gameIDTable).padBottom(30.0f).row();
        Actor $this$_init__u24lambda_u242 = actor = ActivationExtensionsKt.onClick(deleteFriendButton, () -> EditFriendScreen._init_$lambda$1(this, friendlist, selectedFriend));
        boolean bl = false;
        $this$_init__u24lambda_u242.setColor(Color.RED);
        this.getTopTable().add((Actor)deleteFriendButton);
        this.getCloseButton().setText(TranslationsKt.tr$default("Back", false, false, 3, null));
        ActivationExtensionsKt.onClick(this.getCloseButton(), EditFriendScreen::_init_$lambda$3);
        this.getRightSideButton().setText(TranslationsKt.tr$default("Save", false, false, 3, null));
        Scene2dExtensionsKt.enable(this.getRightSideButton());
        ActivationExtensionsKt.onClick(this.getRightSideButton(), () -> EditFriendScreen._init_$lambda$4(selectedFriend, friendNameTextField, playerIDTextField, friendlist, this));
    }

    private static final Unit lambda$1$0(FriendList $friendlist, FriendList.Friend $selectedFriend) {
        $friendlist.delete($selectedFriend);
        EditFriendScreenKt.goBack();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$0(UncivTextField $playerIDTextField) {
        $playerIDTextField.setText(Gdx.app.getClipboard().getContents());
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(EditFriendScreen this$0, FriendList $friendlist, FriendList.Friend $selectedFriend) {
        ConfirmPopup askPopup = new ConfirmPopup(this$0, "Are you sure you want to delete this friend?", "Delete", false, null, () -> EditFriendScreen.lambda$1$0($friendlist, $selectedFriend), 24, null);
        Popup.open$default(askPopup, false, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3() {
        EditFriendScreenKt.goBack();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(FriendList.Friend $selectedFriend, UncivTextField $friendNameTextField, UncivTextField $playerIDTextField, FriendList $friendlist, EditFriendScreen this$0) {
        if (Intrinsics.areEqual($selectedFriend.getName(), $friendNameTextField.getText()) && Intrinsics.areEqual($selectedFriend.getPlayerID(), $playerIDTextField.getText())) {
            EditFriendScreenKt.goBack();
        }
        String string = $friendNameTextField.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        if ($friendlist.isFriendNameInFriendList(string) == FriendList.ErrorType.ALREADYINLIST) {
            String string2 = $playerIDTextField.getText();
            Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
            if ($friendlist.isFriendIDInFriendList(string2) == FriendList.ErrorType.ALREADYINLIST) {
                new ToastPopup("Player name already used!", this$0, 0L, 4, null);
                return Unit.INSTANCE;
            }
        }
        String string3 = $playerIDTextField.getText();
        Intrinsics.checkNotNullExpressionValue(string3, "getText(...)");
        if ($friendlist.isFriendIDInFriendList(string3) == FriendList.ErrorType.ALREADYINLIST) {
            String string4 = $friendNameTextField.getText();
            Intrinsics.checkNotNullExpressionValue(string4, "getText(...)");
            if ($friendlist.isFriendNameInFriendList(string4) == FriendList.ErrorType.ALREADYINLIST) {
                new ToastPopup("Player ID already used!", this$0, 0L, 4, null);
                return Unit.INSTANCE;
            }
        }
        String string5 = $playerIDTextField.getText();
        Intrinsics.checkNotNullExpressionValue(string5, "getText(...)");
        String string6 = IdChecker.INSTANCE.checkAndReturnPlayerUuid(string5);
        if (!(string6 != null ? StringExtensionsKt.isUUID(string6) : false)) {
            new ToastPopup("Player ID is incorrect", this$0, 0L, 4, null);
            return Unit.INSTANCE;
        }
        String string7 = $friendNameTextField.getText();
        Intrinsics.checkNotNullExpressionValue(string7, "getText(...)");
        String string8 = $playerIDTextField.getText();
        Intrinsics.checkNotNullExpressionValue(string8, "getText(...)");
        $friendlist.edit($selectedFriend, string7, string8);
        EditFriendScreenKt.goBack();
        return Unit.INSTANCE;
    }
}

