/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.DelayedRemovalArray;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.PopupAlert;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticStatus;
import com.unciv.logic.civilization.transients.CapitalConnectionsFinder;
import com.unciv.logic.event.EventBus;
import com.unciv.logic.map.HexCoord;
import com.unciv.logic.map.MapVisualization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.multiplayer.MultiplayerGameUpdated;
import com.unciv.logic.trade.TradeEvaluation;
import com.unciv.logic.trade.TradeRequest;
import com.unciv.models.TutorialTrigger;
import com.unciv.models.metadata.GameSetupInfo;
import com.unciv.models.ruleset.Event;
import com.unciv.models.ruleset.EventChoice;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tile.ResourceSupplyList;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.skins.SkinStrings;
import com.unciv.ui.audio.MusicController;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyShortcutDispatcher;
import com.unciv.ui.components.input.KeyShortcutDispatcherVeto;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.components.input.KeyboardPanningListener;
import com.unciv.ui.components.widgets.ZoomableScrollPane;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.popups.PopupKt;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.cityscreen.CityScreen;
import com.unciv.ui.screens.devconsole.DevConsolePopup;
import com.unciv.ui.screens.mainmenuscreen.MainMenuScreen;
import com.unciv.ui.screens.newgamescreen.NewGameScreen;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewCategories;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewScreen;
import com.unciv.ui.screens.pickerscreens.DiplomaticVoteResultScreen;
import com.unciv.ui.screens.pickerscreens.GreatPersonPickerScreen;
import com.unciv.ui.screens.savescreens.LoadGameScreen;
import com.unciv.ui.screens.savescreens.LoadOrSaveScreen;
import com.unciv.ui.screens.savescreens.QuickSave;
import com.unciv.ui.screens.savescreens.SaveGameScreen;
import com.unciv.ui.screens.victoryscreen.VictoryScreen;
import com.unciv.ui.screens.worldscreen.AlertPopup;
import com.unciv.ui.screens.worldscreen.NotificationsScroll;
import com.unciv.ui.screens.worldscreen.RenderEvent;
import com.unciv.ui.screens.worldscreen.TechPolicyDiplomacyButtons;
import com.unciv.ui.screens.worldscreen.TradePopup;
import com.unciv.ui.screens.worldscreen.UndoHandler;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.WorldScreenKt;
import com.unciv.ui.screens.worldscreen.ZoomButtonPair;
import com.unciv.ui.screens.worldscreen.bottombar.BattleTable;
import com.unciv.ui.screens.worldscreen.bottombar.TileInfoTable;
import com.unciv.ui.screens.worldscreen.chat.ChatButton;
import com.unciv.ui.screens.worldscreen.mainmenu.WorldScreenMusicPopup;
import com.unciv.ui.screens.worldscreen.minimap.MinimapHolder;
import com.unciv.ui.screens.worldscreen.status.AutoPlayStatusButton;
import com.unciv.ui.screens.worldscreen.status.MultiplayerStatusButton;
import com.unciv.ui.screens.worldscreen.status.NextTurnButton;
import com.unciv.ui.screens.worldscreen.status.NextTurnProgress;
import com.unciv.ui.screens.worldscreen.status.SmallUnitButton;
import com.unciv.ui.screens.worldscreen.status.StatusButtons;
import com.unciv.ui.screens.worldscreen.topbar.WorldScreenTopBar;
import com.unciv.ui.screens.worldscreen.unit.AutoPlay;
import com.unciv.ui.screens.worldscreen.unit.UnitTable;
import com.unciv.ui.screens.worldscreen.unit.actions.UnitActionsTable;
import com.unciv.ui.screens.worldscreen.worldmap.WorldMapHolder;
import com.unciv.ui.screens.worldscreen.worldmap.WorldMapTileUpdater;
import com.unciv.utils.Concurrency;
import com.unciv.utils.ConcurrencyKt;
import com.unciv.utils.LogKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.TimersKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0092\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002\u009d\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010d\u001a\u00020eH\u0016J\b\u0010f\u001a\u00020gH\u0016J&\u0010h\u001a\u00020e2\u0006\u0010i\u001a\u00020Z2\u0006\u0010j\u001a\u00020\u00132\f\u0010k\u001a\b\u0012\u0004\u0012\u00020e0lH\u0016J\u001c\u0010m\u001a\u00020e2\n\b\u0002\u0010n\u001a\u0004\u0018\u00010o2\b\b\u0002\u0010p\u001a\u00020qJ\u0006\u0010r\u001a\u00020eJ\u0006\u0010s\u001a\u00020eJ\b\u0010t\u001a\u00020eH\u0002J\b\u0010u\u001a\u00020eH\u0007J\b\u0010v\u001a\u00020eH\u0002J\b\u0010w\u001a\u00020eH\u0002J)\u0010x\u001a#\u0012\u0015\u0012\u0013\u0018\u00010z\u00a2\u0006\f\b{\u0012\b\b|\u0012\u0004\b\b(}\u0012\u0004\u0012\u00020~0yj\u0002`\u007fH\u0016J\u0010\u0010\u0080\u0001\u001a\u00020eH\u0082@\u00a2\u0006\u0003\u0010\u0081\u0001J\t\u0010\u0082\u0001\u001a\u00020eH\u0002J\f\u0010\u0083\u0001\u001a\u0005\u0018\u00010\u0084\u0001H\u0002J\t\u0010\u0085\u0001\u001a\u00020eH\u0002J\t\u0010\u0086\u0001\u001a\u00020eH\u0002J\t\u0010\u0087\u0001\u001a\u00020eH\u0002J\t\u0010\u0088\u0001\u001a\u00020\tH\u0007J\u0011\u0010\u0089\u0001\u001a\u00020e2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0007\u0010\u008a\u0001\u001a\u00020eJ\u0012\u0010\u008b\u0001\u001a\u00020e2\t\b\u0002\u0010\u008c\u0001\u001a\u00020\u0013J\u000f\u0010\u008d\u0001\u001a\u00020\u0013H\u0001\u00a2\u0006\u0003\b\u008e\u0001J\t\u0010\u008f\u0001\u001a\u00020eH\u0002J\t\u0010\u0090\u0001\u001a\u00020eH\u0002J\t\u0010\u0091\u0001\u001a\u00020eH\u0002J\u001b\u0010\u0094\u0001\u001a\u00020e2\u0007\u0010\u0095\u0001\u001a\u00020Z2\u0007\u0010\u0096\u0001\u001a\u00020ZH\u0016J\u0013\u0010\u0097\u0001\u001a\u00020e2\b\u0010\u0098\u0001\u001a\u00030\u0099\u0001H\u0016J\t\u0010\u009a\u0001\u001a\u00020eH\u0002J\t\u0010\u009b\u0001\u001a\u00020eH\u0002J\u0007\u0010\u009c\u0001\u001a\u00020eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R$\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0013@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u001a\u0010\u001b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0011\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0015\"\u0004\b!\u0010\u0017R\u0011\u0010\"\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0015R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020\u0013X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0015\"\u0004\b*\u0010\u0017R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\u00020.X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0014\u00101\u001a\u000202X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0014\u00105\u001a\u000206X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u000e\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010;\u001a\u00020<X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u000e\u0010?\u001a\u00020@X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020BX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010C\u001a\u00020DX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010FR\u000e\u0010G\u001a\u00020HX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010I\u001a\u00020JX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010LR\u0014\u0010M\u001a\u00020NX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010PR\u000e\u0010Q\u001a\u00020RX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010S\u001a\u00020TX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010VR\u000e\u0010W\u001a\u00020XX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010Y\u001a\u00020ZX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010[\u001a\u0004\u0018\u00010\\X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010]\u001a\u00020^X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010_\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010`\u001a\u00020aX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bb\u0010cR\u0012\u0010\u0092\u0001\u001a\u0005\u0018\u00010\u0093\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u009e\u0001"}, d2={"Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "gameInfo", "Lcom/unciv/logic/GameInfo;", "autoPlay", "Lcom/unciv/ui/screens/worldscreen/unit/AutoPlay;", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "restoreState", "Lcom/unciv/ui/screens/worldscreen/WorldScreen$RestoreState;", "<init>", "(Lcom/unciv/logic/GameInfo;Lcom/unciv/ui/screens/worldscreen/unit/AutoPlay;Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/ui/screens/worldscreen/WorldScreen$RestoreState;)V", "getGameInfo", "()Lcom/unciv/logic/GameInfo;", "getAutoPlay", "()Lcom/unciv/ui/screens/worldscreen/unit/AutoPlay;", "getViewingCiv", "()Lcom/unciv/logic/civilization/Civilization;", "shouldUpdate", "", "getShouldUpdate", "()Z", "setShouldUpdate", "(Z)V", "value", "isPlayersTurn", "setPlayersTurn$core", "selectedCiv", "getSelectedCiv", "setSelectedCiv", "(Lcom/unciv/logic/civilization/Civilization;)V", "fogOfWar", "getFogOfWar", "setFogOfWar", "canChangeState", "getCanChangeState", "mapHolder", "Lcom/unciv/ui/screens/worldscreen/worldmap/WorldMapHolder;", "getMapHolder", "()Lcom/unciv/ui/screens/worldscreen/worldmap/WorldMapHolder;", "waitingForAutosave", "getWaitingForAutosave$core", "setWaitingForAutosave$core", "mapVisualization", "Lcom/unciv/logic/map/MapVisualization;", "topBar", "Lcom/unciv/ui/screens/worldscreen/topbar/WorldScreenTopBar;", "getTopBar$core", "()Lcom/unciv/ui/screens/worldscreen/topbar/WorldScreenTopBar;", "techPolicyAndDiplomacy", "Lcom/unciv/ui/screens/worldscreen/TechPolicyDiplomacyButtons;", "getTechPolicyAndDiplomacy$core", "()Lcom/unciv/ui/screens/worldscreen/TechPolicyDiplomacyButtons;", "chatButton", "Lcom/unciv/ui/screens/worldscreen/chat/ChatButton;", "getChatButton$core", "()Lcom/unciv/ui/screens/worldscreen/chat/ChatButton;", "unitActionsTable", "Lcom/unciv/ui/screens/worldscreen/unit/actions/UnitActionsTable;", "bottomUnitTable", "Lcom/unciv/ui/screens/worldscreen/unit/UnitTable;", "getBottomUnitTable$core", "()Lcom/unciv/ui/screens/worldscreen/unit/UnitTable;", "battleTable", "Lcom/unciv/ui/screens/worldscreen/bottombar/BattleTable;", "zoomController", "Lcom/unciv/ui/screens/worldscreen/ZoomButtonPair;", "minimapWrapper", "Lcom/unciv/ui/screens/worldscreen/minimap/MinimapHolder;", "getMinimapWrapper$core", "()Lcom/unciv/ui/screens/worldscreen/minimap/MinimapHolder;", "bottomTileInfoTable", "Lcom/unciv/ui/screens/worldscreen/bottombar/TileInfoTable;", "notificationsScroll", "Lcom/unciv/ui/screens/worldscreen/NotificationsScroll;", "getNotificationsScroll$core", "()Lcom/unciv/ui/screens/worldscreen/NotificationsScroll;", "nextTurnButton", "Lcom/unciv/ui/screens/worldscreen/status/NextTurnButton;", "getNextTurnButton$core", "()Lcom/unciv/ui/screens/worldscreen/status/NextTurnButton;", "statusButtons", "Lcom/unciv/ui/screens/worldscreen/status/StatusButtons;", "smallUnitButton", "Lcom/unciv/ui/screens/worldscreen/status/SmallUnitButton;", "getSmallUnitButton$core", "()Lcom/unciv/ui/screens/worldscreen/status/SmallUnitButton;", "tutorialTaskTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "tutorialTaskTableHash", "", "nextTurnUpdateJob", "Lkotlinx/coroutines/Job;", "events", "Lcom/unciv/logic/event/EventBus$EventReceiver;", "uiEnabled", "undoHandler", "Lcom/unciv/ui/screens/worldscreen/UndoHandler;", "getUndoHandler$core", "()Lcom/unciv/ui/screens/worldscreen/UndoHandler;", "dispose", "", "getCivilopediaRuleset", "Lcom/unciv/models/ruleset/Ruleset;", "openOptionsPopup", "startingPage", "withDebug", "onClose", "Lkotlin/Function0;", "openEmpireOverview", "category", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewCategories;", "selection", "", "openNewGameScreen", "openSaveGameScreen", "addKeyboardPresses", "openDeveloperConsole", "toggleUI", "addKeyboardListener", "getShortcutDispatcherVetoer", "Lkotlin/Function1;", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "Lkotlin/ParameterName;", "name", "associatedActor", "Lcom/unciv/ui/components/input/KeyShortcutDispatcherVeto$DispatcherVetoResult;", "Lcom/unciv/ui/components/input/DispatcherVetoer;", "loadLatestMultiplayerState", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "update", "getCurrentTutorialTask", "Lcom/unciv/models/ruleset/Event;", "displayTutorialsOnUpdate", "displayTutorialTaskOnUpdate", "updateSelectedCiv", "getRestoreState", "restore", "nextTurn", "switchToNextUnit", "resetDue", "isNextTurnUpdateRunning", "isNextTurnUpdateRunning$core", "updateGameplayButtons", "updateAutoPlayStatusButton", "updateMultiplayerStatusButton", "resizeDeferTimer", "Ljava/util/Timer;", "resize", "width", "height", "render", "delta", "", "showTutorialsOnNextTurn", "backButtonAndESCHandler", "autoSave", "RestoreState", "core"})
@SourceDebugExtension(value={"SMAP\nWorldScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldScreen.kt\ncom/unciv/ui/screens/worldscreen/WorldScreen\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,854:1\n812#2,12:855\n1834#2,4:867\n296#2,2:874\n1807#2,3:879\n1807#2,3:886\n1807#2,2:889\n1809#2:893\n1807#2,3:900\n193#3,3:871\n1#4:876\n1276#5,2:877\n1276#5,2:882\n1276#5,2:884\n1276#5,2:891\n1276#5,2:894\n1276#5,2:896\n1276#5,2:898\n*S KotlinDebug\n*F\n+ 1 WorldScreen.kt\ncom/unciv/ui/screens/worldscreen/WorldScreen\n*L\n229#1:855,12\n302#1:867,4\n472#1:874,2\n494#1:879,3\n771#1:886,3\n772#1:889,2\n772#1:893\n788#1:900,3\n468#1:871,3\n492#1:877,2\n496#1:882,2\n499#1:884,2\n772#1:891,2\n780#1:894,2\n781#1:896,2\n784#1:898,2\n*E\n"})
public final class WorldScreen
extends BaseScreen {
    @NotNull
    private final GameInfo gameInfo;
    @NotNull
    private final AutoPlay autoPlay;
    @NotNull
    private final Civilization viewingCiv;
    private boolean shouldUpdate;
    private boolean isPlayersTurn;
    @NotNull
    private Civilization selectedCiv;
    private boolean fogOfWar;
    @NotNull
    private final WorldMapHolder mapHolder;
    private boolean waitingForAutosave;
    @NotNull
    private final MapVisualization mapVisualization;
    @NotNull
    private final WorldScreenTopBar topBar;
    @NotNull
    private final TechPolicyDiplomacyButtons techPolicyAndDiplomacy;
    @NotNull
    private final ChatButton chatButton;
    @NotNull
    private final UnitActionsTable unitActionsTable;
    @NotNull
    private final UnitTable bottomUnitTable;
    @NotNull
    private final BattleTable battleTable;
    @NotNull
    private final ZoomButtonPair zoomController;
    @NotNull
    private final MinimapHolder minimapWrapper;
    @NotNull
    private final TileInfoTable bottomTileInfoTable;
    @NotNull
    private final NotificationsScroll notificationsScroll;
    @NotNull
    private final NextTurnButton nextTurnButton;
    @NotNull
    private final StatusButtons statusButtons;
    @NotNull
    private final SmallUnitButton smallUnitButton;
    @NotNull
    private final Table tutorialTaskTable;
    private int tutorialTaskTableHash;
    @Nullable
    private Job nextTurnUpdateJob;
    @NotNull
    private final EventBus.EventReceiver events;
    private boolean uiEnabled;
    @NotNull
    private final UndoHandler undoHandler;
    @Nullable
    private Timer resizeDeferTimer;

    /*
     * WARNING - void declaration
     */
    public WorldScreen(@NotNull GameInfo gameInfo, @NotNull AutoPlay autoPlay, @NotNull Civilization viewingCiv, @Nullable RestoreState restoreState) {
        HexCoord hexCoord;
        void $this$tutorialTaskTable_u24lambda_u240;
        Table table2;
        Intrinsics.checkNotNullParameter(gameInfo, "gameInfo");
        Intrinsics.checkNotNullParameter(autoPlay, "autoPlay");
        Intrinsics.checkNotNullParameter(viewingCiv, "viewingCiv");
        this.gameInfo = gameInfo;
        this.autoPlay = autoPlay;
        this.viewingCiv = viewingCiv;
        this.isPlayersTurn = this.viewingCiv.isCurrentPlayer();
        this.selectedCiv = this.viewingCiv;
        this.fogOfWar = true;
        this.mapHolder = new WorldMapHolder(this, this.gameInfo.getTileMap());
        this.mapVisualization = new MapVisualization(this.gameInfo, this.viewingCiv);
        this.topBar = new WorldScreenTopBar(this);
        this.techPolicyAndDiplomacy = new TechPolicyDiplomacyButtons(this);
        this.chatButton = new ChatButton(this);
        this.unitActionsTable = new UnitActionsTable(this);
        this.bottomUnitTable = new UnitTable(this);
        this.battleTable = new BattleTable(this);
        this.zoomController = new ZoomButtonPair(this.mapHolder);
        this.minimapWrapper = new MinimapHolder(this.mapHolder);
        this.bottomTileInfoTable = new TileInfoTable(this);
        this.notificationsScroll = new NotificationsScroll(this);
        this.nextTurnButton = new NextTurnButton(this);
        this.statusButtons = new StatusButtons(this.nextTurnButton);
        this.smallUnitButton = new SmallUnitButton(this, this.statusButtons);
        Table table3 = table2 = new Table();
        WorldScreen worldScreen = this;
        boolean bl = false;
        $this$tutorialTaskTable_u24lambda_u240.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "WorldScreen/TutorialTaskTable", null, Scene2dExtensionsKt.darken(BaseScreen.Companion.getSkinStrings().getSkinConfig().getBaseColor(), 0.5f), 2, null));
        worldScreen.tutorialTaskTable = table2;
        this.events = new EventBus.EventReceiver();
        this.uiEnabled = true;
        this.undoHandler = new UndoHandler(this);
        this.notificationsScroll.setWidth(this.getStage().getWidth() / (float)2);
        this.minimapWrapper.setX(this.getStage().getWidth() - this.minimapWrapper.getWidth());
        this.mapHolder.addTiles$core();
        this.mapHolder.reloadMaxZoom();
        MusicController.resume$default(UncivGame.Companion.getCurrent().getMusicController(), 0.0f, 1, null);
        this.getStage().addActor(this.mapHolder);
        this.getStage().setScrollFocus(this.mapHolder);
        this.getStage().addActor(this.notificationsScroll);
        this.getStage().addActor(this.tutorialTaskTable);
        this.getStage().addActor(this.topBar);
        this.getStage().addActor(this.statusButtons);
        this.getStage().addActor(this.techPolicyAndDiplomacy);
        this.getStage().addActor(this.chatButton);
        this.getStage().addActor(this.zoomController);
        this.zoomController.setVisible(UncivGame.Companion.getCurrent().getSettings().getShowZoomButtons());
        this.getStage().addActor(this.bottomUnitTable);
        this.getStage().addActor(this.unitActionsTable);
        this.getStage().addActor(this.bottomTileInfoTable);
        this.getStage().addActor(this.minimapWrapper);
        this.battleTable.setWidth(this.getStage().getWidth() / (float)3);
        this.battleTable.setX(this.getStage().getWidth() / (float)3);
        this.getStage().addActor(this.battleTable);
        if (Civilization.getCapital$default(this.viewingCiv, false, 1, null) != null) {
            City city = Civilization.getCapital$default(this.viewingCiv, false, 1, null);
            Intrinsics.checkNotNull(city);
            hexCoord = city.getLocation().toHexCoord();
        } else {
            hexCoord = SequencesKt.any(this.viewingCiv.getUnits().getCivUnits()) ? SequencesKt.first(this.viewingCiv.getUnits().getCivUnits()).getTile().getPosition() : HexCoord.Companion.getZero();
        }
        HexCoord tileToCenterOn = hexCoord;
        this.mapHolder.setAutoScrollEnabled(Gdx.app.getType() == Application.ApplicationType.Desktop && this.getGame().getSettings().getMapAutoScroll());
        this.mapHolder.setMapPanningSpeed(this.getGame().getSettings().getMapPanningSpeed());
        WorldMapHolder.setCenterPosition$default(this.mapHolder, tileToCenterOn, true, !this.viewingCiv.isSpectator(), null, 8, null);
        this.getTutorialController().setAllTutorialsShowedCallback(() -> WorldScreen._init_$lambda$0(this));
        this.addKeyboardListener();
        this.addKeyboardPresses();
        if (this.gameInfo.getGameParameters().isOnlineMultiplayer() && !this.gameInfo.isUpToDate()) {
            this.isPlayersTurn = false;
        }
        if (this.gameInfo.getGameParameters().isOnlineMultiplayer()) {
            String gameId = this.gameInfo.getGameId();
            this.events.receive(Reflection.getOrCreateKotlinClass(MultiplayerGameUpdated.class), arg_0 -> WorldScreen._init_$lambda$1(gameId, arg_0), arg_0 -> WorldScreen._init_$lambda$2(this, arg_0));
        }
        if (restoreState != null) {
            this.restore(restoreState);
        }
        this.shouldUpdate = true;
    }

    public /* synthetic */ WorldScreen(GameInfo gameInfo, AutoPlay autoPlay, Civilization civilization, RestoreState restoreState, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            restoreState = null;
        }
        this(gameInfo, autoPlay, civilization, restoreState);
    }

    @NotNull
    public final GameInfo getGameInfo() {
        return this.gameInfo;
    }

    @NotNull
    public final AutoPlay getAutoPlay() {
        return this.autoPlay;
    }

    @NotNull
    public final Civilization getViewingCiv() {
        return this.viewingCiv;
    }

    public final boolean getShouldUpdate() {
        return this.shouldUpdate;
    }

    public final void setShouldUpdate(boolean bl) {
        this.shouldUpdate = bl;
    }

    public final boolean isPlayersTurn() {
        return this.isPlayersTurn;
    }

    public final void setPlayersTurn$core(boolean bl) {
        this.isPlayersTurn = bl;
    }

    @NotNull
    public final Civilization getSelectedCiv() {
        return this.selectedCiv;
    }

    public final void setSelectedCiv(@NotNull Civilization civilization) {
        Intrinsics.checkNotNullParameter(civilization, "<set-?>");
        this.selectedCiv = civilization;
    }

    public final boolean getFogOfWar() {
        return this.fogOfWar;
    }

    public final void setFogOfWar(boolean bl) {
        this.fogOfWar = bl;
    }

    public final boolean getCanChangeState() {
        return this.isPlayersTurn && !this.viewingCiv.isSpectator();
    }

    @NotNull
    public final WorldMapHolder getMapHolder() {
        return this.mapHolder;
    }

    public final boolean getWaitingForAutosave$core() {
        return this.waitingForAutosave;
    }

    public final void setWaitingForAutosave$core(boolean bl) {
        this.waitingForAutosave = bl;
    }

    @NotNull
    public final WorldScreenTopBar getTopBar$core() {
        return this.topBar;
    }

    @NotNull
    public final TechPolicyDiplomacyButtons getTechPolicyAndDiplomacy$core() {
        return this.techPolicyAndDiplomacy;
    }

    @NotNull
    public final ChatButton getChatButton$core() {
        return this.chatButton;
    }

    @NotNull
    public final UnitTable getBottomUnitTable$core() {
        return this.bottomUnitTable;
    }

    @NotNull
    public final MinimapHolder getMinimapWrapper$core() {
        return this.minimapWrapper;
    }

    @NotNull
    public final NotificationsScroll getNotificationsScroll$core() {
        return this.notificationsScroll;
    }

    @NotNull
    public final NextTurnButton getNextTurnButton$core() {
        return this.nextTurnButton;
    }

    @NotNull
    public final SmallUnitButton getSmallUnitButton$core() {
        return this.smallUnitButton;
    }

    @NotNull
    public final UndoHandler getUndoHandler$core() {
        return this.undoHandler;
    }

    @Override
    public void dispose() {
        Timer timer2 = this.resizeDeferTimer;
        if (timer2 != null) {
            timer2.cancel();
        }
        this.events.stopReceiving();
        this.statusButtons.dispose();
        super.dispose();
    }

    @Override
    @NotNull
    public Ruleset getCivilopediaRuleset() {
        return this.gameInfo.getRuleset();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void openOptionsPopup(int startingPage, boolean withDebug, @NotNull Function0<Unit> onClose) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter(onClose, "onClose");
        DelayedRemovalArray<EventListener> delayedRemovalArray = this.getStage().getRoot().getListeners();
        Intrinsics.checkNotNullExpressionValue(delayedRemovalArray, "getListeners(...)");
        Iterable $this$filterIsInstance$iv = delayedRemovalArray;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KeyboardPanningListener)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        KeyboardPanningListener oldListener = (KeyboardPanningListener)CollectionsKt.firstOrNull((List)destination$iv$iv);
        if (oldListener != null) {
            this.getStage().removeListener(oldListener);
            oldListener.dispose();
        }
        super.openOptionsPopup(startingPage, withDebug, () -> WorldScreen.openOptionsPopup$lambda$0(this, onClose));
    }

    public final void openEmpireOverview(@Nullable EmpireOverviewCategories category, @NotNull String selection) {
        Intrinsics.checkNotNullParameter(selection, "selection");
        this.getGame().pushScreen(new EmpireOverviewScreen(this.selectedCiv, category, selection));
    }

    public static /* synthetic */ void openEmpireOverview$default(WorldScreen worldScreen, EmpireOverviewCategories empireOverviewCategories, String string, int n, Object object) {
        if ((n & 1) != 0) {
            empireOverviewCategories = null;
        }
        if ((n & 2) != 0) {
            string = "";
        }
        worldScreen.openEmpireOverview(empireOverviewCategories, string);
    }

    public final void openNewGameScreen() {
        GameSetupInfo newGameSetupInfo = new GameSetupInfo(this.gameInfo);
        newGameSetupInfo.getMapParameters().reseed();
        NewGameScreen newGameScreen = new NewGameScreen(newGameSetupInfo);
        this.getGame().pushScreen(newGameScreen);
    }

    public final void openSaveGameScreen() {
        if (this.gameInfo.getGameParameters().isOnlineMultiplayer()) {
            return;
        }
        this.getGame().pushScreen(new SaveGameScreen(this.gameInfo));
    }

    private final void addKeyboardPresses() {
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.DeselectOrQuit, 0, () -> WorldScreen.addKeyboardPresses$lambda$0(this), 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.Civilopedia, 0, () -> WorldScreen.addKeyboardPresses$lambda$1(this), 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.EmpireOverviewTrades, 0, () -> WorldScreen.addKeyboardPresses$lambda$2(this), 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.EmpireOverviewUnits, 0, () -> WorldScreen.addKeyboardPresses$lambda$3(this), 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.EmpireOverviewPolitics, 0, () -> WorldScreen.addKeyboardPresses$lambda$4(this), 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.EmpireOverviewNotifications, 0, () -> WorldScreen.addKeyboardPresses$lambda$5(this), 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.VictoryScreen, 0, () -> WorldScreen.addKeyboardPresses$lambda$6(this), 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.EmpireOverviewStats, 0, () -> WorldScreen.addKeyboardPresses$lambda$7(this), 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.EmpireOverviewResources, 0, () -> WorldScreen.addKeyboardPresses$lambda$8(this), 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.QuickSave, 0, () -> WorldScreen.addKeyboardPresses$lambda$9(this), 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.QuickLoad, 0, () -> WorldScreen.addKeyboardPresses$lambda$10(this), 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.ViewCapitalCity, 0, () -> WorldScreen.addKeyboardPresses$lambda$11(this), 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.Options, 0, () -> WorldScreen.addKeyboardPresses$lambda$12(this), 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.SaveGame, 0, () -> WorldScreen.addKeyboardPresses$lambda$13(this), 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.LoadGame, 0, () -> WorldScreen.addKeyboardPresses$lambda$14(this), 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.QuitGame, 0, () -> WorldScreen.addKeyboardPresses$lambda$15(this), 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.NewGame, 0, () -> WorldScreen.addKeyboardPresses$lambda$16(this), 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.MusicPlayer, 0, () -> WorldScreen.addKeyboardPresses$lambda$17(this), 2, null);
        this.getGlobalShortcuts().add(157, () -> WorldScreen.addKeyboardPresses$lambda$18(this));
        this.getGlobalShortcuts().add(156, () -> WorldScreen.addKeyboardPresses$lambda$19(this));
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.ToggleUI, 0, () -> WorldScreen.addKeyboardPresses$lambda$20(this), 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.ToggleYieldDisplay, 0, () -> WorldScreen.addKeyboardPresses$lambda$21(this), 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.ToggleWorkedTilesDisplay, 0, () -> WorldScreen.addKeyboardPresses$lambda$22(this), 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.ToggleMovementDisplay, 0, () -> WorldScreen.addKeyboardPresses$lambda$23(this), 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.ToggleResourceDisplay, 0, () -> WorldScreen.addKeyboardPresses$lambda$24(this), 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.ToggleImprovementDisplay, 0, () -> WorldScreen.addKeyboardPresses$lambda$25(this), 2, null);
        KeyShortcutDispatcher.add$default(this.getGlobalShortcuts(), KeyboardBinding.DeveloperConsole, 0, new Function0<Unit>((Object)this){

            public final void invoke() {
                ((WorldScreen)this.receiver).openDeveloperConsole();
            }
        }, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    public final void openDeveloperConsole() {
        boolean bl;
        Iterable $this$count$iv = this.gameInfo.getCivilizations();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            bl = false;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Civilization it = (Civilization)element$iv;
                boolean bl2 = false;
                if (!(it.isHuman() && !it.isSpectator()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            bl = var3_3;
        }
        if (bl > true) {
            return;
        }
        new DevConsolePopup(this);
    }

    private final void toggleUI() {
        this.uiEnabled = !this.uiEnabled;
        this.topBar.setVisible(this.uiEnabled);
        this.statusButtons.setVisible(this.uiEnabled);
        this.techPolicyAndDiplomacy.setVisible(this.uiEnabled);
        this.tutorialTaskTable.setVisible(this.uiEnabled);
        this.bottomTileInfoTable.setVisible(this.uiEnabled);
        this.unitActionsTable.setVisible(this.uiEnabled);
        this.notificationsScroll.setVisible(this.uiEnabled);
        this.minimapWrapper.setVisible(this.uiEnabled);
        this.bottomUnitTable.setVisible(this.uiEnabled);
        if (this.uiEnabled) {
            this.battleTable.update();
        } else {
            this.battleTable.setVisible(false);
        }
    }

    private final void addKeyboardListener() {
        this.getStage().addListener(new KeyboardPanningListener(this.mapHolder, true));
    }

    @Override
    @NotNull
    public Function1<Actor, KeyShortcutDispatcherVeto.DispatcherVetoResult> getShortcutDispatcherVetoer() {
        return KeyShortcutDispatcherVeto.INSTANCE.createTileGroupMapDispatcherVetoer();
    }

    private final Object loadLatestMultiplayerState(Continuation<? super Unit> $completion) {
        Object object = CoroutineScopeKt.coroutineScope((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var6_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        if (!Intrinsics.areEqual(this.this$0.getGame().getScreen(), this.this$0)) {
                            return Unit.INSTANCE;
                        }
                        loadingGamePopup = new Popup(this.this$0, null, 0.0f, 6, null);
                        ConcurrencyKt.launchOnGLThread$default((CoroutineScope)$this$coroutineScope, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(loadingGamePopup, null){
                            int label;
                            final /* synthetic */ Popup $loadingGamePopup;
                            {
                                this.$loadingGamePopup = $loadingGamePopup;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure($result);
                                        Popup.addGoodSizedLabel$default(this.$loadingGamePopup, "Loading latest game state...", 0, false, null, 14, null);
                                        Popup.open$default(this.$loadingGamePopup, false, 1, null);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, 1, null);
                        var4_5 = new Object[]{this.this$0.getGameInfo().getGameId(), Boxing.boxInt(this.this$0.getGameInfo().getTurns()), this.this$0.getGameInfo().getCurrentPlayer()};
                        LogKt.debug("loadLatestMultiplayerState current game: gameId: %s, turn: %s, curCiv: %s", var4_5);
                        this.L$0 = $this$coroutineScope;
                        this.L$1 = loadingGamePopup;
                        this.label = 1;
                        v0 = this.this$0.getGame().getOnlineMultiplayer().getMultiplayerServer().downloadGame(this.this$0.getGameInfo().getGameId(), this);
                        ** if (v0 != var6_3) goto lbl21
lbl20:
                        // 1 sources

                        return var6_3;
lbl21:
                        // 1 sources

                        ** GOTO lbl28
                    }
                    case 1: {
                        loadingGamePopup = (Popup)this.L$1;
                        try {
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
lbl28:
                            // 2 sources

                            latestGame = (GameInfo)v0;
                            var5_6 = new Object[]{latestGame.getGameId(), Boxing.boxInt(latestGame.getTurns()), latestGame.getCurrentPlayer()};
                            LogKt.debug("loadLatestMultiplayerState downloaded game: gameId: %s, turn: %s, curCiv: %s", var5_6);
                            if (Intrinsics.areEqual(this.this$0.getViewingCiv().getCivID(), latestGame.getCurrentPlayer()) || Intrinsics.areEqual(this.this$0.getViewingCiv().getCivID(), "Spectator")) {
                                this.this$0.getGame().notifyTurnStarted();
                            }
                            ConcurrencyKt.launchOnGLThread$default((CoroutineScope)$this$coroutineScope, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(loadingGamePopup, null){
                                int label;
                                final /* synthetic */ Popup $loadingGamePopup;
                                {
                                    this.$loadingGamePopup = $loadingGamePopup;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure($result);
                                            this.$loadingGamePopup.close();
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                            WorldScreenKt.startNewScreenJob$default(latestGame, this.this$0.getAutoPlay(), false, 4, null);
                        }
                        catch (Throwable ex) {
                            ConcurrencyKt.launchOnGLThread$default((CoroutineScope)$this$coroutineScope, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(ex, loadingGamePopup, this.this$0, null){
                                int label;
                                private /* synthetic */ Object L$0;
                                final /* synthetic */ Throwable $ex;
                                final /* synthetic */ Popup $loadingGamePopup;
                                final /* synthetic */ WorldScreen this$0;
                                {
                                    this.$ex = $ex;
                                    this.$loadingGamePopup = $loadingGamePopup;
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            void $this$launchOnGLThread;
                                            ResultKt.throwOnFailure($result);
                                            String message = (String)LoadOrSaveScreen.Helpers.getLoadExceptionMessage$default(LoadGameScreen.Companion, this.$ex, "Couldn't download the latest game state!", null, 4, null).component1();
                                            this.$loadingGamePopup.clear();
                                            Popup.addGoodSizedLabel$default(this.$loadingGamePopup, message, 0, false, null, 14, null).colspan(2).row();
                                            Popup.addButton$default(this.$loadingGamePopup, "Retry", null, null, () -> loadLatestMultiplayerState.3.invokeSuspend$lambda$0((CoroutineScope)$this$launchOnGLThread, this.this$0), 6, null).right();
                                            Popup.addButton$default(this.$loadingGamePopup, "Main menu", null, null, () -> loadLatestMultiplayerState.3.invokeSuspend$lambda$1(this.this$0), 6, null).left();
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                    function2.L$0 = value;
                                    return (Continuation)((Object)function2);
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }

                                private static final Unit invokeSuspend$lambda$0(CoroutineScope $$this$launchOnGLThread, WorldScreen this$0) {
                                    ConcurrencyKt.launchOnThreadPool($$this$launchOnGLThread, "Load latest multiplayer state after error", (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
                                        int label;
                                        final /* synthetic */ WorldScreen this$0;
                                        {
                                            this.this$0 = $receiver;
                                            super(2, $completion);
                                        }

                                        /*
                                         * Enabled force condition propagation
                                         * Lifted jumps to return sites
                                         */
                                        public final Object invokeSuspend(Object $result) {
                                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure($result);
                                                    this.label = 1;
                                                    Object object2 = WorldScreen.access$loadLatestMultiplayerState(this.this$0, this);
                                                    if (object2 != object) return Unit.INSTANCE;
                                                    return object;
                                                }
                                                case 1: {
                                                    ResultKt.throwOnFailure($result);
                                                    Object object2 = $result;
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                            return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                        }

                                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    });
                                    return Unit.INSTANCE;
                                }

                                private static final Unit invokeSuspend$lambda$1(WorldScreen this$0) {
                                    this$0.getGame().pushScreen(new MainMenuScreen());
                                    return Unit.INSTANCE;
                                }
                            }, 1, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void update() {
        if (this.uiEnabled) {
            this.displayTutorialsOnUpdate();
            this.bottomUnitTable.update();
            this.updateSelectedCiv();
            if (this.fogOfWar) {
                this.minimapWrapper.update(this.selectedCiv);
            } else {
                this.minimapWrapper.update(this.viewingCiv);
            }
            if (this.fogOfWar) {
                this.bottomTileInfoTable.setSelectedCiv(this.selectedCiv);
            } else {
                this.bottomTileInfoTable.setSelectedCiv(this.viewingCiv);
            }
            this.bottomTileInfoTable.updateTileTable$core(this.mapHolder.getSelectedTile$core());
            this.bottomTileInfoTable.setX(this.getStage().getWidth() - this.bottomTileInfoTable.getWidth());
            this.bottomTileInfoTable.setY(this.getGame().getSettings().getShowMinimap() ? this.minimapWrapper.getHeight() + 5.0f : 0.0f);
            this.battleTable.update();
            this.displayTutorialTaskOnUpdate();
        }
        this.mapHolder.resetArrows();
        if (UncivGame.Companion.getCurrent().getSettings().getShowUnitMovements()) {
            Sequence allUnits = SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)this.gameInfo.getCivilizations()), WorldScreen::update$lambda$0);
            Sequence allAttacks = SequencesKt.plus(SequencesKt.flatten(SequencesKt.map(allUnits, WorldScreen::update$lambda$1)), SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)this.gameInfo.getCivilizations()), WorldScreen::update$lambda$2));
            this.mapHolder.updateMovementOverlay$core(SequencesKt.filter(allUnits, (Function1)new Function1<MapUnit, Boolean>((Object)this.mapVisualization){

                public final Boolean invoke(MapUnit p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return ((MapVisualization)this.receiver).isUnitPastVisible(p0);
                }
            }), SequencesKt.filter(allUnits, (Function1)new Function1<MapUnit, Boolean>((Object)this.mapVisualization){

                public final Boolean invoke(MapUnit p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return ((MapVisualization)this.receiver).isUnitFutureVisible(p0);
                }
            }), SequencesKt.map(SequencesKt.filter(allAttacks, arg_0 -> WorldScreen.update$lambda$3(this, arg_0)), WorldScreen::update$lambda$4));
        }
        this.zoomController.setVisible(UncivGame.Companion.getCurrent().getSettings().getShowZoomButtons());
        if (this.fogOfWar) {
            WorldMapTileUpdater.INSTANCE.updateTiles(this.mapHolder, this.selectedCiv);
        } else {
            WorldMapTileUpdater.INSTANCE.updateTiles(this.mapHolder, this.viewingCiv);
        }
        this.topBar.update$core(this.selectedCiv);
        if (this.tutorialTaskTable.isVisible()) {
            this.tutorialTaskTable.setY(this.topBar.getYForTutorialTask$core() - this.tutorialTaskTable.getHeight());
        }
        if (this.techPolicyAndDiplomacy.update()) {
            BaseScreen.displayTutorial$default(this, TutorialTrigger.OtherCivEncountered, null, 2, null);
        }
        if (this.uiEnabled) {
            this.unitActionsTable.setY(this.bottomUnitTable.getHeight());
            this.unitActionsTable.update(this.bottomUnitTable.getSelectedUnit());
        }
        if (this.autoPlay.isAutoPlaying() && !this.gameInfo.getOneMoreTurnMode() && (this.viewingCiv.isDefeated() || this.gameInfo.checkForVictory())) {
            this.autoPlay.stopAutoPlay();
        }
        if (!PopupKt.hasOpenPopups(this) && !this.autoPlay.isAutoPlaying() && this.isPlayersTurn) {
            if (this.viewingCiv.shouldShowDiplomaticVotingResults()) {
                UncivGame.Companion.getCurrent().pushScreen(new DiplomaticVoteResultScreen(this.gameInfo.getDiplomaticVictoryVotesCast(), this.viewingCiv));
            } else if (!this.gameInfo.getOneMoreTurnMode() && (this.viewingCiv.isDefeated() || this.gameInfo.checkForVictory())) {
                this.getGame().pushScreen(new VictoryScreen(this, 0, 2, null));
            } else if (this.viewingCiv.getGreatPeople().getFreeGreatPeople() > 0) {
                this.getGame().pushScreen(new GreatPersonPickerScreen(this, this.viewingCiv));
            } else if (CollectionsKt.any((Iterable)this.viewingCiv.getPopupAlerts())) {
                new AlertPopup(this, (PopupAlert)CollectionsKt.first((List)this.viewingCiv.getPopupAlerts()));
            } else if (!((Collection)this.viewingCiv.getTradeRequests()).isEmpty()) {
                for (TradeRequest tradeRequest : CollectionsKt.toList((Iterable)this.viewingCiv.getTradeRequests())) {
                    if (new TradeEvaluation().isTradeValid(tradeRequest.getTrade(), this.viewingCiv, this.gameInfo.getCivilization(tradeRequest.getRequestingCiv()))) continue;
                    this.viewingCiv.getTradeRequests().remove(tradeRequest);
                }
                if (!((Collection)this.viewingCiv.getTradeRequests()).isEmpty()) {
                    Popup.open$default(new TradePopup(this), false, 1, null);
                }
            }
        }
        this.updateGameplayButtons();
        float coveredNotificationsTop = this.getStage().getHeight() - this.statusButtons.getY();
        float coveredNotificationsBottom = this.bottomTileInfoTable.getHeight() + this.bottomTileInfoTable.getY();
        this.notificationsScroll.update$core((List<Notification>)this.viewingCiv.getNotifications(), coveredNotificationsTop, coveredNotificationsBottom);
        float posZoomFromRight = this.getGame().getSettings().getShowMinimap() ? this.minimapWrapper.getWidth() : this.bottomTileInfoTable.getWidth();
        this.zoomController.setPosition(this.getStage().getWidth() - posZoomFromRight - 10.0f, 10.0f, 20);
    }

    private final Event getCurrentTutorialTask() {
        Object v2;
        block7: {
            if (!this.getGame().getSettings().getTutorialTasksCompleted().contains("Create a trade route")) {
                boolean bl;
                block6: {
                    Map<City, EnumSet<CapitalConnectionsFinder.CapitalConnectionMedium>> $this$any$iv = this.viewingCiv.getCache().getCitiesConnectedToCapitalToMediums();
                    boolean $i$f$any = false;
                    if ($this$any$iv.isEmpty()) {
                        bl = false;
                    } else {
                        Iterator<Map.Entry<City, EnumSet<CapitalConnectionsFinder.CapitalConnectionMedium>>> iterator2 = $this$any$iv.entrySet().iterator();
                        while (iterator2.hasNext()) {
                            Map.Entry<City, EnumSet<CapitalConnectionsFinder.CapitalConnectionMedium>> element$iv;
                            Map.Entry<City, EnumSet<CapitalConnectionsFinder.CapitalConnectionMedium>> it = element$iv = iterator2.next();
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual(it.getKey().getCiv(), this.viewingCiv)) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    this.getGame().getSettings().addCompletedTutorialTask("Create a trade route");
                }
            }
            GameContext stateForConditionals = this.viewingCiv.getState();
            Collection<Event> collection = this.gameInfo.getRuleset().getEvents().values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Event it = (Event)element$iv;
                boolean bl = false;
                if (!(it.getPresentation() == Event.Presentation.Floating && it.isAvailable(stateForConditionals))) continue;
                v2 = element$iv;
                break block7;
            }
            v2 = null;
        }
        return v2;
    }

    private final void displayTutorialsOnUpdate() {
        BaseScreen.displayTutorial$default(this, TutorialTrigger.Introduction, null, 2, null);
        this.displayTutorial(TutorialTrigger.EnemyCityNeedsConqueringWithMeleeUnit, () -> WorldScreen.displayTutorialsOnUpdate$lambda$0(this));
        this.displayTutorial(TutorialTrigger.AfterConquering, () -> WorldScreen.displayTutorialsOnUpdate$lambda$1(this));
        this.displayTutorial(TutorialTrigger.InjuredUnits, () -> WorldScreen.displayTutorialsOnUpdate$lambda$2(this));
        this.displayTutorial(TutorialTrigger.Workers, () -> WorldScreen.displayTutorialsOnUpdate$lambda$3(this));
    }

    /*
     * WARNING - void declaration
     */
    private final void displayTutorialTaskOnUpdate() {
        if (!this.getGame().getSettings().getShowTutorials() || this.viewingCiv.isDefeated()) {
            WorldScreen.displayTutorialTaskOnUpdate$setInvisible(this);
            return;
        }
        Event event = this.getCurrentTutorialTask();
        if (event == null) {
            WorldScreen.displayTutorialTaskOnUpdate$setInvisible(this);
            return;
        }
        Event tutorialTask = event;
        if (!UncivGame.Companion.getCurrent().isTutorialTaskCollapsed()) {
            int hash = tutorialTask.hashCode();
            if (hash != this.tutorialTaskTableHash) {
                RenderEvent renderEvent = new RenderEvent(tutorialTask, this, null, arg_0 -> WorldScreen.displayTutorialTaskOnUpdate$lambda$0(this, arg_0), 4, null);
                if (!renderEvent.isValid()) {
                    WorldScreen.displayTutorialTaskOnUpdate$setInvisible(this);
                    return;
                }
                this.tutorialTaskTable.clear();
                this.tutorialTaskTable.add((Actor)renderEvent).pad(10.0f);
                this.tutorialTaskTableHash = hash;
            }
        } else {
            void $this$displayTutorialTaskOnUpdate_u24lambda_u241;
            Image image;
            this.tutorialTaskTable.clear();
            Image renderEvent = image = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/HiddenTutorialTask", null, 2, null);
            Table table2 = this.tutorialTaskTable;
            boolean bl = false;
            $this$displayTutorialTaskOnUpdate_u24lambda_u241.setSize(30.0f, 30.0f);
            table2.add((Actor)image).pad(5.0f);
            this.tutorialTaskTableHash = 0;
        }
        this.tutorialTaskTable.pack();
        Scene2dExtensionsKt.centerX((Actor)this.tutorialTaskTable, this.getStage());
        this.tutorialTaskTable.setY(this.topBar.getYForTutorialTask$core() - this.tutorialTaskTable.getHeight());
        ActivationExtensionsKt.onClick(this.tutorialTaskTable, () -> WorldScreen.displayTutorialTaskOnUpdate$lambda$2(this));
        this.tutorialTaskTable.setVisible(true);
    }

    private final void updateSelectedCiv() {
        Civilization civilization;
        if (this.bottomUnitTable.getSelectedUnit() != null) {
            MapUnit mapUnit = this.bottomUnitTable.getSelectedUnit();
            Intrinsics.checkNotNull(mapUnit);
            civilization = mapUnit.getCiv();
        } else if (this.bottomUnitTable.getSelectedCity() != null) {
            City city = this.bottomUnitTable.getSelectedCity();
            Intrinsics.checkNotNull(city);
            civilization = city.getCiv();
        } else {
            civilization = this.viewingCiv;
        }
        this.selectedCiv = civilization;
    }

    @Readonly
    @NotNull
    public final RestoreState getRestoreState() {
        return new RestoreState(this.mapHolder, this.selectedCiv.getCivID(), this.viewingCiv.getCivID(), this.fogOfWar);
    }

    private final void restore(RestoreState restoreState) {
        if (Intrinsics.areEqual(this.viewingCiv.getCivID(), restoreState.getViewingCivName())) {
            this.mapHolder.zoom(restoreState.getZoom());
            this.mapHolder.setScrollX(restoreState.getScrollX());
            this.mapHolder.setScrollY(restoreState.getScrollY());
            this.mapHolder.updateVisualScroll();
        }
        this.selectedCiv = this.gameInfo.getCivilization(restoreState.getSelectedCivName());
        this.fogOfWar = restoreState.getFogOfWar();
    }

    public final void nextTurn() {
        this.isPlayersTurn = false;
        this.shouldUpdate = true;
        NextTurnProgress progressBar = new NextTurnProgress(this.nextTurnButton);
        progressBar.start(this);
        this.nextTurnUpdateJob = Concurrency.INSTANCE.runOnNonDaemonThreadPool("NextTurn", (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, progressBar, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            long J$0;
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ WorldScreen this$0;
            final /* synthetic */ NextTurnProgress $progressBar;
            {
                this.this$0 = $receiver;
                this.$progressBar = $progressBar;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            public final Object invokeSuspend(Object $result) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 12[DOLOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.bytecode.analysis.types.MethodPrototype.dumpAppropriatelyCastedArgumentString(MethodPrototype.java:562)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.MemberFunctionInvokation.dumpInner(MemberFunctionInvokation.java:63)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.dump(StructuredAssignment.java:69)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public final void switchToNextUnit(boolean resetDue) {
        MapUnit nextDueUnit;
        if (this.bottomUnitTable.getSelectedUnit() != null && resetDue) {
            MapUnit mapUnit = this.bottomUnitTable.getSelectedUnit();
            Intrinsics.checkNotNull(mapUnit);
            mapUnit.setDue(false);
        }
        if ((nextDueUnit = this.viewingCiv.getUnits().cycleThroughDueUnits(this.bottomUnitTable.getSelectedUnit())) != null) {
            WorldMapHolder.setCenterPosition$default(this.mapHolder, nextDueUnit.getCurrentTile().getPosition(), false, false, null, 8, null);
            UnitTable.selectUnit$default(this.bottomUnitTable, nextDueUnit, false, 2, null);
        } else {
            this.mapHolder.removeAction(this.mapHolder.getBlinkAction());
            this.mapHolder.setSelectedTile$core(null);
            UnitTable.selectUnit$default(this.bottomUnitTable, null, false, 3, null);
        }
        this.shouldUpdate = true;
    }

    public static /* synthetic */ void switchToNextUnit$default(WorldScreen worldScreen, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        worldScreen.switchToNextUnit(bl);
    }

    @Readonly
    public final boolean isNextTurnUpdateRunning$core() {
        Job job2 = this.nextTurnUpdateJob;
        return job2 != null && job2.isActive();
    }

    private final void updateGameplayButtons() {
        this.nextTurnButton.update();
        this.updateAutoPlayStatusButton();
        this.updateMultiplayerStatusButton();
        this.statusButtons.update(false);
        float maxWidth = this.getStage().getWidth() - this.techPolicyAndDiplomacy.getWidth() - 25.0f;
        if (this.statusButtons.getWidth() > maxWidth) {
            this.statusButtons.update(true);
        }
        this.statusButtons.setPosition(this.getStage().getWidth() - this.statusButtons.getWidth() - 10.0f, this.topBar.getY() - this.statusButtons.getHeight() - 10.0f);
        this.chatButton.updatePosition();
    }

    private final void updateAutoPlayStatusButton() {
        if (this.statusButtons.getAutoPlayStatusButton() == null) {
            if (this.getGame().getSettings().getAutoPlay().getShowAutoPlayButton()) {
                this.statusButtons.setAutoPlayStatusButton(new AutoPlayStatusButton(this, this.nextTurnButton));
            }
        } else if (!this.getGame().getSettings().getAutoPlay().getShowAutoPlayButton()) {
            this.statusButtons.setAutoPlayStatusButton(null);
            this.autoPlay.stopAutoPlay();
        }
    }

    private final void updateMultiplayerStatusButton() {
        if (this.gameInfo.getGameParameters().isOnlineMultiplayer() || this.getGame().getSettings().getMultiplayer().getStatusButtonInSinglePlayer()) {
            if (this.statusButtons.getMultiplayerStatusButton() != null) {
                return;
            }
            this.statusButtons.setMultiplayerStatusButton(new MultiplayerStatusButton(this, this.getGame().getOnlineMultiplayer().getMultiplayerFiles().getGameByGameId(this.gameInfo.getGameId())));
        } else {
            if (this.statusButtons.getMultiplayerStatusButton() == null) {
                return;
            }
            this.statusButtons.setMultiplayerStatusButton(null);
        }
    }

    @Override
    public void resize(int width, int height) {
        Timer timer2;
        Timer timer3 = this.resizeDeferTimer;
        if (timer3 != null) {
            timer3.cancel();
        }
        if (this.resizeDeferTimer == null && this.getStage().getViewport().getScreenWidth() == width && this.getStage().getViewport().getScreenHeight() == height) {
            return;
        }
        String string = "Resize";
        boolean bl = true;
        long l = 500L;
        long l2 = Long.MAX_VALUE;
        Timer timer4 = timer2 = TimersKt.timer(string, bl);
        timer4.schedule(new TimerTask(this){
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = worldScreen;
            }

            public void run() {
                TimerTask $this$resize_u24lambda_u240 = this;
                boolean bl = false;
                Timer timer2 = WorldScreen.access$getResizeDeferTimer$p(this.this$0);
                if (timer2 != null) {
                    timer2.cancel();
                }
                WorldScreen.access$setResizeDeferTimer$p(this.this$0, null);
                WorldScreenKt.access$startNewScreenJob(this.this$0.getGameInfo(), this.this$0.getAutoPlay(), true);
            }
        }, l, l2);
        this.resizeDeferTimer = timer2;
    }

    @Override
    public void render(float delta) {
        if (this.shouldUpdate && this.resizeDeferTimer == null) {
            this.shouldUpdate = false;
            Gdx.input.setInputProcessor(null);
            this.update();
            this.showTutorialsOnNextTurn();
            if (Gdx.input.getInputProcessor() == null) {
                Gdx.input.setInputProcessor(this.getStage());
            }
        }
        super.render(delta);
    }

    private final void showTutorialsOnNextTurn() {
        if (!this.getGame().getSettings().getShowTutorials() || this.autoPlay.isAutoPlaying()) {
            return;
        }
        BaseScreen.displayTutorial$default(this, TutorialTrigger.SlowStart, null, 2, null);
        this.displayTutorial(TutorialTrigger.CityExpansion, () -> WorldScreen.showTutorialsOnNextTurn$lambda$0(this));
        this.displayTutorial(TutorialTrigger.BarbarianEncountered, () -> WorldScreen.showTutorialsOnNextTurn$lambda$1(this));
        this.displayTutorial(TutorialTrigger.RoadsAndRailroads, () -> WorldScreen.showTutorialsOnNextTurn$lambda$2(this));
        this.displayTutorial(TutorialTrigger.Happiness, () -> WorldScreen.showTutorialsOnNextTurn$lambda$3(this));
        this.displayTutorial(TutorialTrigger.Unhappiness, () -> WorldScreen.showTutorialsOnNextTurn$lambda$4(this));
        this.displayTutorial(TutorialTrigger.GoldenAge, () -> WorldScreen.showTutorialsOnNextTurn$lambda$5(this));
        this.displayTutorial(TutorialTrigger.IdleUnits, () -> WorldScreen.showTutorialsOnNextTurn$lambda$6(this));
        this.displayTutorial(TutorialTrigger.ContactMe, () -> WorldScreen.showTutorialsOnNextTurn$lambda$7(this));
        Sequence<ResourceSupplyList.ResourceSupply> resources = SequencesKt.filter(CollectionsKt.asSequence(this.viewingCiv.getDetailedCivResources()), WorldScreen::showTutorialsOnNextTurn$lambda$8);
        this.displayTutorial(TutorialTrigger.LuxuryResource, () -> WorldScreen.showTutorialsOnNextTurn$lambda$9(resources));
        this.displayTutorial(TutorialTrigger.StrategicResource, () -> WorldScreen.showTutorialsOnNextTurn$lambda$10(resources));
        this.displayTutorial(TutorialTrigger.EnemyCity, () -> WorldScreen.showTutorialsOnNextTurn$lambda$11(this));
        this.displayTutorial(TutorialTrigger.Embarking, () -> WorldScreen.showTutorialsOnNextTurn$lambda$12(this));
        this.displayTutorial(TutorialTrigger.NaturalWonders, () -> WorldScreen.showTutorialsOnNextTurn$lambda$13(this));
        this.displayTutorial(TutorialTrigger.WeLoveTheKingDay, () -> WorldScreen.showTutorialsOnNextTurn$lambda$14(this));
    }

    private final void backButtonAndESCHandler() {
        if (this.bottomUnitTable.getSelectedUnit() != null) {
            UnitTable.selectUnit$default(this.bottomUnitTable, null, false, 3, null);
            this.shouldUpdate = true;
            return;
        }
        if (this.bottomUnitTable.getSelectedCity() != null) {
            UnitTable.selectUnit$default(this.bottomUnitTable, null, false, 3, null);
            this.shouldUpdate = true;
            return;
        }
        if (this.bottomUnitTable.getSelectedSpy() != null) {
            this.bottomUnitTable.selectSpy(null);
            this.shouldUpdate = true;
            return;
        }
        UncivGame.popScreen$default(this.getGame(), false, 1, null);
    }

    public final void autoSave() {
        this.waitingForAutosave = true;
        this.shouldUpdate = true;
        UncivGame.Companion.getCurrent().getFiles().getAutosaves().requestAutoSave(this.gameInfo, true).invokeOnCompletion(arg_0 -> WorldScreen.autoSave$lambda$0(this, arg_0));
    }

    private static final Unit _init_$lambda$0(WorldScreen this$0) {
        this$0.shouldUpdate = true;
        return Unit.INSTANCE;
    }

    private static final boolean _init_$lambda$1(String $gameId, MultiplayerGameUpdated it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getPreview().getGameId(), $gameId);
    }

    private static final Unit _init_$lambda$2(WorldScreen this$0, MultiplayerGameUpdated it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (this$0.isNextTurnUpdateRunning$core() || this$0.getGame().getOnlineMultiplayer().hasLatestGameState(this$0.gameInfo, it.getPreview())) {
            return Unit.INSTANCE;
        }
        Concurrency.run$default(Concurrency.INSTANCE, "Load latest multiplayer state", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            final /* synthetic */ WorldScreen this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        this.label = 1;
                        Object object2 = WorldScreen.access$loadLatestMultiplayerState(this.this$0, this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit openOptionsPopup$lambda$0(WorldScreen this$0, Function0 $onClose) {
        this$0.addKeyboardListener();
        $onClose.invoke();
        return Unit.INSTANCE;
    }

    private static final Unit addKeyboardPresses$lambda$12$0(WorldScreen this$0) {
        this$0.nextTurnButton.update();
        return Unit.INSTANCE;
    }

    private static final Unit addKeyboardPresses$lambda$0(WorldScreen this$0) {
        this$0.backButtonAndESCHandler();
        return Unit.INSTANCE;
    }

    private static final Unit addKeyboardPresses$lambda$1(WorldScreen this$0) {
        BaseScreen.openCivilopedia$default(this$0, null, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit addKeyboardPresses$lambda$2(WorldScreen this$0) {
        WorldScreen.openEmpireOverview$default(this$0, EmpireOverviewCategories.Trades, null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit addKeyboardPresses$lambda$3(WorldScreen this$0) {
        WorldScreen.openEmpireOverview$default(this$0, EmpireOverviewCategories.Units, null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit addKeyboardPresses$lambda$4(WorldScreen this$0) {
        WorldScreen.openEmpireOverview$default(this$0, EmpireOverviewCategories.Politics, null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit addKeyboardPresses$lambda$5(WorldScreen this$0) {
        WorldScreen.openEmpireOverview$default(this$0, EmpireOverviewCategories.Notifications, null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit addKeyboardPresses$lambda$6(WorldScreen this$0) {
        this$0.getGame().pushScreen(new VictoryScreen(this$0, 0, 2, null));
        return Unit.INSTANCE;
    }

    private static final Unit addKeyboardPresses$lambda$7(WorldScreen this$0) {
        WorldScreen.openEmpireOverview$default(this$0, EmpireOverviewCategories.Stats, null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit addKeyboardPresses$lambda$8(WorldScreen this$0) {
        WorldScreen.openEmpireOverview$default(this$0, EmpireOverviewCategories.Resources, null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit addKeyboardPresses$lambda$9(WorldScreen this$0) {
        QuickSave.INSTANCE.save(this$0.gameInfo, this$0);
        return Unit.INSTANCE;
    }

    private static final Unit addKeyboardPresses$lambda$10(WorldScreen this$0) {
        QuickSave.INSTANCE.load(this$0);
        return Unit.INSTANCE;
    }

    private static final Unit addKeyboardPresses$lambda$11(WorldScreen this$0) {
        City capital = Civilization.getCapital$default(this$0.gameInfo.getCurrentPlayerCivilization(), false, 1, null);
        if (capital != null && !WorldMapHolder.setCenterPosition$default(this$0.mapHolder, capital.getLocation().toHexCoord(), false, false, null, 14, null)) {
            this$0.getGame().pushScreen(new CityScreen(capital, null, null, null, 14, null));
        }
        return Unit.INSTANCE;
    }

    private static final Unit addKeyboardPresses$lambda$12(WorldScreen this$0) {
        BaseScreen.openOptionsPopup$default(this$0, 0, false, () -> WorldScreen.addKeyboardPresses$lambda$12$0(this$0), 3, null);
        return Unit.INSTANCE;
    }

    private static final Unit addKeyboardPresses$lambda$13(WorldScreen this$0) {
        this$0.openSaveGameScreen();
        return Unit.INSTANCE;
    }

    private static final Unit addKeyboardPresses$lambda$14(WorldScreen this$0) {
        this$0.getGame().pushScreen(new LoadGameScreen());
        return Unit.INSTANCE;
    }

    private static final Unit addKeyboardPresses$lambda$15(WorldScreen this$0) {
        UncivGame.popScreen$default(this$0.getGame(), false, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit addKeyboardPresses$lambda$16(WorldScreen this$0) {
        this$0.openNewGameScreen();
        return Unit.INSTANCE;
    }

    private static final Unit addKeyboardPresses$lambda$17(WorldScreen this$0) {
        new WorldScreenMusicPopup(this$0).open(true);
        return Unit.INSTANCE;
    }

    private static final Unit addKeyboardPresses$lambda$18(WorldScreen this$0) {
        ZoomableScrollPane.zoomIn$default(this$0.mapHolder, false, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit addKeyboardPresses$lambda$19(WorldScreen this$0) {
        ZoomableScrollPane.zoomOut$default(this$0.mapHolder, false, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit addKeyboardPresses$lambda$20(WorldScreen this$0) {
        this$0.toggleUI();
        return Unit.INSTANCE;
    }

    private static final Unit addKeyboardPresses$lambda$21(WorldScreen this$0) {
        this$0.minimapWrapper.getYieldImageButton().toggle();
        return Unit.INSTANCE;
    }

    private static final Unit addKeyboardPresses$lambda$22(WorldScreen this$0) {
        this$0.minimapWrapper.getPopulationImageButton().toggle();
        return Unit.INSTANCE;
    }

    private static final Unit addKeyboardPresses$lambda$23(WorldScreen this$0) {
        this$0.minimapWrapper.getMovementsImageButton().toggle();
        return Unit.INSTANCE;
    }

    private static final Unit addKeyboardPresses$lambda$24(WorldScreen this$0) {
        this$0.minimapWrapper.getResourceImageButton().toggle();
        return Unit.INSTANCE;
    }

    private static final Unit addKeyboardPresses$lambda$25(WorldScreen this$0) {
        this$0.minimapWrapper.getImprovementsImageButton().toggle();
        return Unit.INSTANCE;
    }

    private static final Triple update$lambda$1$0(MapUnit $unit, HexCoord attacked) {
        Intrinsics.checkNotNullParameter(attacked, "attacked");
        return new Triple<Civilization, HexCoord, HexCoord>($unit.getCiv(), $unit.getTile().getPosition(), attacked.toHexCoord());
    }

    private static final Triple update$lambda$2$0(Civilization $civInfo, Civilization.HistoricalAttackMemory it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new Triple<Civilization, HexCoord, HexCoord>($civInfo, it.getSource(), it.getTarget());
    }

    private static final Sequence update$lambda$0(Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getUnits().getCivUnits();
    }

    private static final Sequence update$lambda$1(MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        return SequencesKt.map(CollectionsKt.asSequence((Iterable)unit.getAttacksSinceTurnStart()), arg_0 -> WorldScreen.update$lambda$1$0(unit, arg_0));
    }

    private static final Sequence update$lambda$2(Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        return SequencesKt.map(CollectionsKt.asSequence((Iterable)civInfo.getAttacksSinceTurnStart()), arg_0 -> WorldScreen.update$lambda$2$0(civInfo, arg_0));
    }

    private static final boolean update$lambda$3(WorldScreen this$0, Triple triple) {
        Intrinsics.checkNotNullParameter(triple, "<destruct>");
        Civilization attacker = (Civilization)triple.component1();
        HexCoord source = (HexCoord)triple.component2();
        HexCoord target = (HexCoord)triple.component3();
        return this$0.mapVisualization.isAttackVisible(attacker, source, target);
    }

    private static final Pair update$lambda$4(Triple triple) {
        Intrinsics.checkNotNullParameter(triple, "<destruct>");
        HexCoord source = (HexCoord)triple.component2();
        HexCoord target = (HexCoord)triple.component3();
        return TuplesKt.to(source, target);
    }

    private static final boolean displayTutorialsOnUpdate$lambda$0$0(DiplomacyManager it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getDiplomaticStatus() == DiplomaticStatus.War;
    }

    private static final Civilization displayTutorialsOnUpdate$lambda$0$1(DiplomacyManager it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getOtherCiv();
    }

    private static final Sequence displayTutorialsOnUpdate$lambda$0$2(Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return CollectionsKt.asSequence((Iterable)it.getCities());
    }

    private static final boolean displayTutorialsOnUpdate$lambda$0$3(City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getHealth() == 1;
    }

    private static final Sequence displayTutorialsOnUpdate$lambda$0$4(City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getCenterTile().getTilesInDistance(2);
    }

    private static final boolean displayTutorialsOnUpdate$lambda$0(WorldScreen this$0) {
        boolean bl;
        block3: {
            Collection<DiplomacyManager> collection = this$0.viewingCiv.getDiplomacy().values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Sequence $this$any$iv = SequencesKt.flatMap(SequencesKt.filter(SequencesKt.flatMap(SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), WorldScreen::displayTutorialsOnUpdate$lambda$0$0), WorldScreen::displayTutorialsOnUpdate$lambda$0$1), WorldScreen::displayTutorialsOnUpdate$lambda$0$2), WorldScreen::displayTutorialsOnUpdate$lambda$0$3), WorldScreen::displayTutorialsOnUpdate$lambda$0$4);
            boolean $i$f$any = false;
            Iterator iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                boolean bl2;
                block2: {
                    Object element$iv = iterator2.next();
                    Tile it = (Tile)element$iv;
                    boolean bl3 = false;
                    Sequence<MapUnit> $this$any$iv2 = it.getUnits();
                    boolean $i$f$any2 = false;
                    Iterator<MapUnit> iterator3 = $this$any$iv2.iterator();
                    while (iterator3.hasNext()) {
                        MapUnit element$iv2;
                        MapUnit unit = element$iv2 = iterator3.next();
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual(unit.getCiv(), this$0.viewingCiv)) continue;
                        bl2 = true;
                        break block2;
                    }
                    bl2 = false;
                }
                if (!bl2) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean displayTutorialsOnUpdate$lambda$1(WorldScreen this$0) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this$0.viewingCiv.getCities();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    City it = (City)element$iv;
                    boolean bl2 = false;
                    if (!it.getHasJustBeenConquered()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean displayTutorialsOnUpdate$lambda$2(WorldScreen this$0) {
        boolean bl;
        block1: {
            Sequence<MapUnit> $this$any$iv = this$0.gameInfo.getCurrentPlayerCivilization().getUnits().getCivUnits();
            boolean $i$f$any = false;
            Iterator<MapUnit> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                MapUnit element$iv;
                MapUnit it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!(it.getHealth() < 100)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean displayTutorialsOnUpdate$lambda$3(WorldScreen this$0) {
        boolean bl;
        block1: {
            Sequence<MapUnit> $this$any$iv = this$0.gameInfo.getCurrentPlayerCivilization().getUnits().getCivUnits();
            boolean $i$f$any = false;
            Iterator<MapUnit> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                MapUnit element$iv;
                MapUnit it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!(it.getCache().getHasUniqueToBuildImprovements() && it.isCivilian() && !it.isGreatPerson())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final void displayTutorialTaskOnUpdate$setInvisible(WorldScreen this$0) {
        this$0.tutorialTaskTable.setVisible(false);
        this$0.tutorialTaskTable.clear();
        this$0.tutorialTaskTableHash = 0;
    }

    private static final Unit displayTutorialTaskOnUpdate$lambda$0(WorldScreen this$0, EventChoice it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.shouldUpdate = true;
        return Unit.INSTANCE;
    }

    private static final Unit displayTutorialTaskOnUpdate$lambda$2(WorldScreen this$0) {
        UncivGame.Companion.getCurrent().setTutorialTaskCollapsed(!UncivGame.Companion.getCurrent().isTutorialTaskCollapsed());
        this$0.displayTutorialTaskOnUpdate();
        return Unit.INSTANCE;
    }

    private static final boolean showTutorialsOnNextTurn$lambda$11$0(WorldScreen this$0, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.viewingCiv.isAtWarWith(it);
    }

    private static final Sequence showTutorialsOnNextTurn$lambda$11$1(Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return CollectionsKt.asSequence((Iterable)it.getCities());
    }

    private static final boolean showTutorialsOnNextTurn$lambda$0(WorldScreen this$0) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this$0.viewingCiv.getCities();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    City it = (City)element$iv;
                    boolean bl2 = false;
                    if (!(it.getExpansion().tilesClaimed() > 0)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean showTutorialsOnNextTurn$lambda$1(WorldScreen this$0) {
        boolean bl;
        block5: {
            Iterable $this$any$iv = this$0.viewingCiv.getViewableTiles();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block4: {
                        Tile it = (Tile)element$iv;
                        boolean bl3 = false;
                        Sequence<MapUnit> $this$any$iv2 = it.getUnits();
                        boolean $i$f$any2 = false;
                        Iterator<MapUnit> iterator2 = $this$any$iv2.iterator();
                        while (iterator2.hasNext()) {
                            MapUnit element$iv2;
                            MapUnit unit = element$iv2 = iterator2.next();
                            boolean bl4 = false;
                            if (!unit.getCiv().isBarbarian()) continue;
                            bl2 = true;
                            break block4;
                        }
                        bl2 = false;
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean showTutorialsOnNextTurn$lambda$2(WorldScreen this$0) {
        return this$0.viewingCiv.getCities().size() > 2;
    }

    private static final boolean showTutorialsOnNextTurn$lambda$3(WorldScreen this$0) {
        return this$0.viewingCiv.getHappiness() < 5;
    }

    private static final boolean showTutorialsOnNextTurn$lambda$4(WorldScreen this$0) {
        return this$0.viewingCiv.getHappiness() < 0;
    }

    private static final boolean showTutorialsOnNextTurn$lambda$5(WorldScreen this$0) {
        return this$0.viewingCiv.getGoldenAges().isGoldenAge();
    }

    private static final boolean showTutorialsOnNextTurn$lambda$6(WorldScreen this$0) {
        return this$0.gameInfo.getTurns() >= 50 && this$0.getGame().getSettings().getCheckForDueUnits();
    }

    private static final boolean showTutorialsOnNextTurn$lambda$7(WorldScreen this$0) {
        return this$0.gameInfo.getTurns() >= 100;
    }

    private static final boolean showTutorialsOnNextTurn$lambda$8(ResourceSupplyList.ResourceSupply it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getOrigin(), "All");
    }

    private static final boolean showTutorialsOnNextTurn$lambda$9(Sequence $resources) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = $resources;
            boolean $i$f$any = false;
            Iterator iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                ResourceSupplyList.ResourceSupply it = (ResourceSupplyList.ResourceSupply)element$iv;
                boolean bl2 = false;
                if (!(it.getResource().getResourceType() == ResourceType.Luxury)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean showTutorialsOnNextTurn$lambda$10(Sequence $resources) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = $resources;
            boolean $i$f$any = false;
            Iterator iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                ResourceSupplyList.ResourceSupply it = (ResourceSupplyList.ResourceSupply)element$iv;
                boolean bl2 = false;
                if (!(it.getResource().getResourceType() == ResourceType.Strategic)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean showTutorialsOnNextTurn$lambda$11(WorldScreen this$0) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = SequencesKt.flatMap(SequencesKt.filter(this$0.viewingCiv.getKnownCivs(), arg_0 -> WorldScreen.showTutorialsOnNextTurn$lambda$11$0(this$0, arg_0)), WorldScreen::showTutorialsOnNextTurn$lambda$11$1);
            boolean $i$f$any = false;
            Iterator iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                City it = (City)element$iv;
                boolean bl2 = false;
                if (!this$0.viewingCiv.hasExplored(it.getCenterTile())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean showTutorialsOnNextTurn$lambda$12(WorldScreen this$0) {
        return Civilization.hasUnique$default(this$0.viewingCiv, UniqueType.LandUnitEmbarkation, null, 2, null);
    }

    private static final boolean showTutorialsOnNextTurn$lambda$13(WorldScreen this$0) {
        return this$0.viewingCiv.getNaturalWonders().size() > 0;
    }

    private static final boolean showTutorialsOnNextTurn$lambda$14(WorldScreen this$0) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this$0.viewingCiv.getCities();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    City it = (City)element$iv;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual(it.getDemandedResource(), ""))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final Unit autoSave$lambda$0(WorldScreen this$0, Throwable it) {
        this$0.waitingForAutosave = false;
        this$0.shouldUpdate = true;
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$loadLatestMultiplayerState(WorldScreen $this, Continuation $completion) {
        return $this.loadLatestMultiplayerState($completion);
    }

    public static final /* synthetic */ Timer access$getResizeDeferTimer$p(WorldScreen $this) {
        return $this.resizeDeferTimer;
    }

    public static final /* synthetic */ void access$setResizeDeferTimer$p(WorldScreen $this, Timer timer2) {
        $this.resizeDeferTimer = timer2;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lcom/unciv/ui/screens/worldscreen/WorldScreen$RestoreState;", "", "mapHolder", "Lcom/unciv/ui/screens/worldscreen/worldmap/WorldMapHolder;", "selectedCivName", "", "viewingCivName", "fogOfWar", "", "<init>", "(Lcom/unciv/ui/screens/worldscreen/worldmap/WorldMapHolder;Ljava/lang/String;Ljava/lang/String;Z)V", "getSelectedCivName", "()Ljava/lang/String;", "getViewingCivName", "getFogOfWar", "()Z", "zoom", "", "getZoom", "()F", "scrollX", "getScrollX", "scrollY", "getScrollY", "core"})
    public static final class RestoreState {
        @NotNull
        private final String selectedCivName;
        @NotNull
        private final String viewingCivName;
        private final boolean fogOfWar;
        private final float zoom;
        private final float scrollX;
        private final float scrollY;

        public RestoreState(@NotNull WorldMapHolder mapHolder, @NotNull String selectedCivName, @NotNull String viewingCivName, boolean fogOfWar) {
            Intrinsics.checkNotNullParameter(mapHolder, "mapHolder");
            Intrinsics.checkNotNullParameter(selectedCivName, "selectedCivName");
            Intrinsics.checkNotNullParameter(viewingCivName, "viewingCivName");
            this.selectedCivName = selectedCivName;
            this.viewingCivName = viewingCivName;
            this.fogOfWar = fogOfWar;
            this.zoom = mapHolder.getScaleX();
            this.scrollX = mapHolder.getScrollX();
            this.scrollY = mapHolder.getScrollY();
        }

        @NotNull
        public final String getSelectedCivName() {
            return this.selectedCivName;
        }

        @NotNull
        public final String getViewingCivName() {
            return this.viewingCivName;
        }

        public final boolean getFogOfWar() {
            return this.fogOfWar;
        }

        public final float getZoom() {
            return this.zoom;
        }

        public final float getScrollX() {
            return this.scrollX;
        }

        public final float getScrollY() {
            return this.scrollY;
        }
    }
}

