/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.status;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.GUI;
import com.unciv.logic.GameInfo;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.metadata.GameParameters;
import com.unciv.models.skins.SkinStrings;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.status.NextTurnAction;
import com.unciv.ui.screens.worldscreen.status.NextTurnButton;
import com.unciv.ui.screens.worldscreen.unit.AutoPlay;
import com.unciv.utils.Concurrency;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u000fJ\b\u0010\u0013\u001a\u00020\u000fH\u0002J\b\u0010\u0014\u001a\u00020\u000fH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/unciv/ui/screens/worldscreen/status/NextTurnProgress;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "nextTurnButton", "Lcom/unciv/ui/screens/worldscreen/status/NextTurnButton;", "<init>", "(Lcom/unciv/ui/screens/worldscreen/status/NextTurnButton;)V", "progress", "", "progressMax", "isDirty", "", "barWidth", "", "worldScreenHash", "start", "", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "increment", "startUpdateProgress", "updateProgress", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nNextTurnProgress.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextTurnProgress.kt\ncom/unciv/ui/screens/worldscreen/status/NextTurnProgress\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n1834#2,4:124\n*S KotlinDebug\n*F\n+ 1 NextTurnProgress.kt\ncom/unciv/ui/screens/worldscreen/status/NextTurnProgress\n*L\n70#1:124,4\n*E\n"})
public final class NextTurnProgress
extends Table {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private NextTurnButton nextTurnButton;
    private int progress;
    private int progressMax;
    private boolean isDirty;
    private float barWidth;
    private int worldScreenHash;
    @NotNull
    private static final Color defaultRightColor = new Color(0x600000FF);
    private static final float defaultBarHeight = 4.0f;
    private static final float barYPos = 1.0f;
    private static final float removeHorizontalPad = 25.0f;
    private static final float fadeInDuration = 1.0f;

    public NextTurnProgress(@Nullable NextTurnButton nextTurnButton) {
        this.nextTurnButton = nextTurnButton;
        this.progress = -1;
        this.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "WorldScreen/NextTurn/ProgressBar", null, defaultRightColor, 2, null));
        Color leftColor = BaseScreen.Companion.getSkinStrings().getUIColor("WorldScreen/NextTurn/ProgressColor", Color.FOREST);
        this.add((Actor)ImageGetter.INSTANCE.getDot(leftColor));
        this.add();
    }

    /*
     * WARNING - void declaration
     */
    public final void start(@NotNull WorldScreen worldScreen) {
        int n;
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        this.progress = 0;
        GameInfo game = worldScreen.getGameInfo();
        this.worldScreenHash = worldScreen.hashCode();
        NextTurnProgress nextTurnProgress = this;
        int n2 = 3;
        if (game.getTurns() > 0) {
            n = SequencesKt.count(game.getCities()) * 2;
        } else if (NextTurnProgress.start$isRandomNumberOfCivs(game.getGameParameters())) {
            n = NextTurnProgress.start$minNumberOfCivs(game.getGameParameters());
        } else {
            int n3;
            void $this$count$iv;
            Iterable iterable = game.getCivilizations();
            int n4 = n2;
            NextTurnProgress nextTurnProgress2 = nextTurnProgress;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n3 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Civilization it = (Civilization)element$iv;
                    boolean bl = false;
                    if (!(it.isMajorCiv() && it.isAI() || it.isCityState()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n3 = count$iv;
            }
            int n5 = n3;
            nextTurnProgress = nextTurnProgress2;
            n2 = n4;
            n = n5;
        }
        nextTurnProgress.progressMax = n2 + n;
        this.startUpdateProgress();
    }

    public final void increment() {
        int n = this.progress;
        this.progress = n + 1;
        this.startUpdateProgress();
    }

    private final void startUpdateProgress() {
        this.isDirty = true;
        Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ NextTurnProgress this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        NextTurnProgress.access$updateProgress(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
    }

    private final void updateProgress() {
        int currentWorldScreenHash;
        if (!this.isDirty) {
            return;
        }
        this.isDirty = false;
        WorldScreen worldScreen = GUI.INSTANCE.getWorldScreenIfActive();
        int n = currentWorldScreenHash = worldScreen != null ? worldScreen.hashCode() : -1;
        if (this.progressMax == 0 || currentWorldScreenHash != this.worldScreenHash) {
            this.remove();
            return;
        }
        if (this.progress == 0) {
            NextTurnButton nextTurnButton = this.nextTurnButton;
            if (nextTurnButton != null) {
                NextTurnButton nextTurnButton2;
                NextTurnButton $this$updateProgress_u24lambda_u240 = nextTurnButton2 = nextTurnButton;
                boolean bl = false;
                Scene2dExtensionsKt.disable($this$updateProgress_u24lambda_u240);
                Object object = GUI.INSTANCE.getWorldScreenIfActive();
                boolean bl2 = object != null && (object = ((WorldScreen)object).getAutoPlay()) != null ? ((AutoPlay)object).isAutoPlaying() : false;
                if (bl2) {
                    $this$updateProgress_u24lambda_u240.updateButton$core(NextTurnAction.AutoPlay);
                } else {
                    $this$updateProgress_u24lambda_u240.updateButton$core(NextTurnAction.Working);
                }
                this.barWidth = $this$updateProgress_u24lambda_u240.getWidth() - 25.0f - ($this$updateProgress_u24lambda_u240.getBackground().getLeftWidth() + $this$updateProgress_u24lambda_u240.getBackground().getRightWidth());
                this.setPosition(($this$updateProgress_u24lambda_u240.getWidth() - this.barWidth) / (float)2, 1.0f);
            }
        }
        float cellWidth = this.barWidth * (float)RangesKt.coerceAtMost(this.progress, this.progressMax) / (float)this.progressMax;
        float cellHeight = RangesKt.coerceAtLeast(this.getBackground().getMinHeight(), 4.0f);
        ((Actor)this.getCells().get(0).getActor()).setSize(cellWidth, cellHeight);
        this.getCells().get(1).width(this.barWidth - cellWidth);
        this.setSize(this.barWidth, 4.0f);
        if (this.getParent() == null) {
            this.getColor().a = 0.0f;
            NextTurnButton nextTurnButton = this.nextTurnButton;
            if (nextTurnButton != null) {
                nextTurnButton.addActor(this);
            }
            this.addAction(Actions.fadeIn(1.0f));
            this.nextTurnButton = null;
        }
    }

    @Readonly
    private static final boolean start$isRandomNumberOfCivs(GameParameters $this$start_u24isRandomNumberOfCivs) {
        return $this$start_u24isRandomNumberOfCivs.getRandomNumberOfPlayers() || $this$start_u24isRandomNumberOfCivs.getRandomNumberOfCityStates();
    }

    @Readonly
    private static final int start$minNumberOfCivs(GameParameters $this$start_u24minNumberOfCivs) {
        return ($this$start_u24minNumberOfCivs.getRandomNumberOfPlayers() ? $this$start_u24minNumberOfCivs.getMinNumberOfPlayers() : $this$start_u24minNumberOfCivs.getPlayers().size()) + ($this$start_u24minNumberOfCivs.getRandomNumberOfCityStates() ? $this$start_u24minNumberOfCivs.getMinNumberOfCityStates() : $this$start_u24minNumberOfCivs.getNumberOfCityStates());
    }

    public static final /* synthetic */ void access$updateProgress(NextTurnProgress $this) {
        $this.updateProgress();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/unciv/ui/screens/worldscreen/status/NextTurnProgress$Companion;", "", "<init>", "()V", "defaultRightColor", "Lcom/badlogic/gdx/graphics/Color;", "defaultBarHeight", "", "barYPos", "removeHorizontalPad", "fadeInDuration", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

