/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.unit;

import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.models.Spy;
import com.unciv.models.SpyAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.RandomKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R!\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\r\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/unciv/logic/automation/unit/EspionageAutomation;", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "<init>", "(Lcom/unciv/logic/civilization/Civilization;)V", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "civsToStealFrom", "", "getCivsToStealFrom", "()Ljava/util/List;", "civsToStealFrom$delegate", "Lkotlin/Lazy;", "getCivsToStealFromSorted", "cityStatesToRig", "getCityStatesToRig", "cityStatesToRig$delegate", "automateSpies", "", "automateSpyStealTech", "", "spy", "Lcom/unciv/models/Spy;", "automateSpyRigElection", "automateSpyCounterInteligence", "checkIfShouldStageCoup", "core"})
@SourceDebugExtension(value={"SMAP\nEspionageAutomation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EspionageAutomation.kt\ncom/unciv/logic/automation/unit/EspionageAutomation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,107:1\n1056#2:108\n774#2:109\n865#2,2:110\n2746#2,3:112\n1869#2,2:129\n774#2:131\n865#2,2:132\n1999#2,14:134\n1374#2:148\n1460#2,5:149\n774#2:154\n865#2,2:155\n1999#2,14:157\n774#2:171\n865#2,2:172\n1999#2,14:174\n1761#2,3:188\n1463#3,14:115\n*S KotlinDebug\n*F\n+ 1 EspionageAutomation.kt\ncom/unciv/logic/automation/unit/EspionageAutomation\n*L\n17#1:108\n27#1:109\n27#1:110,2\n36#1:112,3\n54#1:129,2\n64#1:131\n64#1:132,2\n65#1:134,14\n74#1:148\n74#1:149,5\n75#1:154\n75#1:155,2\n77#1:157,14\n88#1:171\n88#1:172,2\n89#1:174,14\n12#1:188,3\n51#1:115,14\n*E\n"})
public final class EspionageAutomation {
    @NotNull
    private final Civilization civInfo;
    @NotNull
    private final Lazy civsToStealFrom$delegate;
    @NotNull
    private final List<Civilization> getCivsToStealFromSorted;
    @NotNull
    private final Lazy cityStatesToRig$delegate;

    public EspionageAutomation(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        this.civInfo = civInfo;
        this.civsToStealFrom$delegate = LazyKt.lazy(() -> EspionageAutomation.civsToStealFrom_delegate$lambda$0(this));
        Iterable $this$sortedBy$iv = this.getCivsToStealFrom();
        boolean $i$f$sortedBy = false;
        this.getCivsToStealFromSorted = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(this){
            final /* synthetic */ EspionageAutomation this$0;
            {
                this.this$0 = espionageAutomation;
            }

            /*
             * Unable to fully structure code
             */
            public final int compare(T a, T b) {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                otherCiv = (Civilization)a;
                                $i$a$-sortedBy-EspionageAutomation$getCivsToStealFromSorted$1 = false;
                                var5_5 = this.this$0.getCivInfo().getEspionageManager().getSpyList();
                                $i$f$count = false;
                                if (!($this$count$iv instanceof Collection) || !((Collection)$this$count$iv).isEmpty()) break block6;
                                v0 = 0;
                                break block7;
                            }
                            count$iv = 0;
                            for (T element$iv : $this$count$iv) {
                                it = (Spy)element$iv;
                                $i$a$-count-EspionageAutomation$getCivsToStealFromSorted$1$1 = false;
                                if (!it.isDoingWork()) ** GOTO lbl-1000
                                v1 = it.getCityOrNull();
                                if (Intrinsics.areEqual(v1 != null ? v1.getCiv() : null, otherCiv)) {
                                    v2 = true;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v2 = false;
                                }
                                if (!v2 || ++count$iv >= 0) continue;
                                CollectionsKt.throwCountOverflow();
                            }
                            v0 = count$iv;
                        }
                        otherCiv = (Civilization)b;
                        var12_12 = Integer.valueOf(v0);
                        $i$a$-sortedBy-EspionageAutomation$getCivsToStealFromSorted$1 = false;
                        $this$count$iv = this.this$0.getCivInfo().getEspionageManager().getSpyList();
                        $i$f$count = false;
                        if (!($this$count$iv instanceof Collection) || !((Collection)$this$count$iv).isEmpty()) break block8;
                        v3 = 0;
                        break block9;
                    }
                    count$iv = 0;
                    for (T element$iv : $this$count$iv) {
                        it = (Spy)element$iv;
                        $i$a$-count-EspionageAutomation$getCivsToStealFromSorted$1$1 = false;
                        if (!it.isDoingWork()) ** GOTO lbl-1000
                        v4 = it.getCityOrNull();
                        if (Intrinsics.areEqual(v4 != null ? v4.getCiv() : null, otherCiv)) {
                            v5 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v5 = false;
                        }
                        if (!v5 || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    v3 = count$iv;
                }
                return ComparisonsKt.compareValues(var12_12, v3);
            }
        });
        this.cityStatesToRig$delegate = LazyKt.lazy(() -> EspionageAutomation.cityStatesToRig_delegate$lambda$0(this));
    }

    @NotNull
    public final Civilization getCivInfo() {
        return this.civInfo;
    }

    private final List<Civilization> getCivsToStealFrom() {
        Lazy lazy = this.civsToStealFrom$delegate;
        return (List)lazy.getValue();
    }

    private final List<Civilization> getCityStatesToRig() {
        Lazy lazy = this.cityStatesToRig$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void automateSpies() {
        void $this$filterTo$iv$iv;
        ArrayList<Spy> spies = this.civInfo.getEspionageManager().getSpyList();
        Iterable $this$filter$iv = spies;
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Spy it = (Spy)element$iv$iv;
            boolean bl = false;
            if (!(it.isAlive() && !it.isDoingWork())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List spiesToMove = (List)destination$iv$iv;
        for (Spy spy : spiesToMove) {
            Object v1;
            void $this$maxByOrNull$iv;
            int randomSeed = spies.size() + spies.indexOf(spy) + this.civInfo.getGameInfo().getTurns();
            int randomAction = RandomKt.Random(randomSeed).nextInt(10);
            City capital = Civilization.getCapital$default(this.civInfo, false, 1, null);
            if (capital != null) {
                boolean bl;
                block13: {
                    Iterable $this$none$iv = spies;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            Spy it = (Spy)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual(it.getCityOrNull(), capital)) continue;
                            bl = false;
                            break block13;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    spy.moveTo(capital);
                    continue;
                }
            }
            if (randomAction <= 7 && this.automateSpyStealTech(spy) || randomAction <= 9 && this.automateSpyRigElection(spy) || this.automateSpyCounterInteligence(spy) || spy.isDoingWork() || this.automateSpyStealTech(spy) || this.automateSpyRigElection(spy)) continue;
            Sequence<City> $i$f$none = SequencesKt.filter(this.civInfo.getGameInfo().getCities(), arg_0 -> EspionageAutomation.automateSpies$lambda$2(spy, arg_0));
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = maxElem$iv;
                } else {
                    City it = (City)maxElem$iv;
                    boolean bl = false;
                    float maxValue$iv = it.getCityStats().getCurrentCityStats().getScience();
                    do {
                        Object e$iv = iterator$iv.next();
                        City it2 = (City)e$iv;
                        $i$a$-maxByOrNull-EspionageAutomation$automateSpies$chosenCity$2 = false;
                        float v$iv = it2.getCityStats().getCurrentCityStats().getScience();
                        if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = maxElem$iv;
                }
            }
            City chosenCity = v1;
            spy.moveTo(chosenCity);
        }
        Iterable $this$forEach$iv = spies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Spy it = (Spy)element$iv;
            boolean bl = false;
            this.checkIfShouldStageCoup(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean automateSpyStealTech(Spy spy) {
        Object v0;
        void $this$filterTo$iv$iv;
        if (this.getCivsToStealFrom().isEmpty()) {
            return false;
        }
        Iterable $this$filter$iv = CollectionsKt.first(this.getCivsToStealFromSorted).getCities();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            City it = (City)element$iv$iv;
            boolean bl = false;
            if (!spy.canMoveTo(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$maxByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                City it = (City)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.getPopulation().getPopulation();
                do {
                    Object e$iv = iterator$iv.next();
                    City it2 = (City)e$iv;
                    $i$a$-maxByOrNull-EspionageAutomation$automateSpyStealTech$cityToMoveTo$2 = false;
                    int v$iv = it2.getPopulation().getPopulation();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        City cityToMoveTo = v0;
        spy.moveTo(cityToMoveTo);
        return cityToMoveTo != null;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean automateSpyRigElection(Spy spy) {
        $this$flatMap$iv = this.getCityStatesToRig();
        $i$f$flatMap = false;
        var5_4 = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Civilization)element$iv$iv;
            $i$a$-flatMap-EspionageAutomation$automateSpyRigElection$cityToMoveTo$1 = false;
            list$iv$iv = it.getCities();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (City)element$iv$iv;
            $i$a$-filter-EspionageAutomation$automateSpyRigElection$cityToMoveTo$2 = false;
            if (it.isBeingRazed() || !spy.canMoveTo((City)it)) ** GOTO lbl-1000
            v0 = it.getCiv().getDiplomacyManager(this.civInfo);
            Intrinsics.checkNotNull(v0);
            if (v0.getInfluence() < 150.0f || !Intrinsics.areEqual(it.getCiv().getAllyCiv(), this.civInfo)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$maxByOrNull$iv = (List)destination$iv$iv;
        $i$f$maxByOrNull = false;
        iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v2 = maxElem$iv;
            } else {
                it = (City)maxElem$iv;
                $i$a$-maxByOrNull-EspionageAutomation$automateSpyRigElection$cityToMoveTo$3 = false;
                v3 = it.getCiv().getDiplomacyManager(this.civInfo);
                Intrinsics.checkNotNull(v3);
                maxValue$iv = v3.getInfluence();
                do {
                    e$iv = iterator$iv.next();
                    it = (City)e$iv;
                    $i$a$-maxByOrNull-EspionageAutomation$automateSpyRigElection$cityToMoveTo$3 = false;
                    v4 = it.getCiv().getDiplomacyManager(this.civInfo);
                    Intrinsics.checkNotNull(v4);
                    v$iv = v4.getInfluence();
                    if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v2 = maxElem$iv;
            }
        }
        cityToMoveTo = v2;
        spy.moveTo(cityToMoveTo);
        return cityToMoveTo != null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean automateSpyCounterInteligence(Spy spy) {
        Object v0;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.civInfo.getCities();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            City it = (City)element$iv$iv;
            boolean bl = false;
            if (!spy.canMoveTo(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$maxByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                City it = (City)maxElem$iv;
                boolean bl = false;
                float maxValue$iv = it.getCityStats().getCurrentCityStats().getScience();
                do {
                    Object e$iv = iterator$iv.next();
                    City it2 = (City)e$iv;
                    $i$a$-maxByOrNull-EspionageAutomation$automateSpyCounterInteligence$cityToMoveTo$2 = false;
                    float v$iv = it2.getCityStats().getCurrentCityStats().getScience();
                    if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        City cityToMoveTo = v0;
        if (cityToMoveTo == null) {
            return false;
        }
        spy.moveTo(cityToMoveTo);
        return true;
    }

    private final void checkIfShouldStageCoup(Spy spy) {
        ArrayList<Spy> spies;
        int randomSeed;
        int randomAction;
        if (!spy.canDoCoup()) {
            return;
        }
        if ((double)spy.getCoupChanceOfSuccess(false) < 0.7) {
            return;
        }
        Civilization allyCiv = spy.getCity().getCiv().getAllyCiv();
        if (allyCiv != null) {
            DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(allyCiv);
            boolean bl = diplomacyManager != null ? diplomacyManager.isRelationshipLevelGE(RelationshipLevel.Friend) : false;
            if (bl) {
                return;
            }
        }
        if ((randomAction = RandomKt.Random(randomSeed = (spies = this.civInfo.getEspionageManager().getSpyList()).size() + spies.indexOf(spy) + this.civInfo.getGameInfo().getTurns()).nextInt(100)) < 20) {
            spy.setAction(SpyAction.Coup, 1);
        }
    }

    private static final List civsToStealFrom_delegate$lambda$0(EspionageAutomation this$0) {
        return SequencesKt.toList(SequencesKt.filter(this$0.civInfo.getKnownCivs(), arg_0 -> EspionageAutomation.civsToStealFrom_delegate$lambda$0$0(this$0, arg_0)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean civsToStealFrom_delegate$lambda$0$0(EspionageAutomation this$0, Civilization otherCiv) {
        City it;
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        if (!otherCiv.isMajorCiv()) return false;
        Iterable $this$any$iv = otherCiv.getCities();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (City)element$iv;
            boolean bl = false;
        } while (!(it.getCenterTile().isExplored(this$0.civInfo) && this$0.civInfo.getEspionageManager().getSpyAssignedToCity(it) == null));
        boolean bl = true;
        if (!bl) return false;
        if (((Collection)this$0.civInfo.getEspionageManager().getTechsToSteal(otherCiv)).isEmpty()) return false;
        return true;
    }

    private static final List cityStatesToRig_delegate$lambda$0(EspionageAutomation this$0) {
        return SequencesKt.toList(SequencesKt.filter(this$0.civInfo.getKnownCivs(), arg_0 -> EspionageAutomation.cityStatesToRig_delegate$lambda$0$0(this$0, arg_0)));
    }

    private static final boolean cityStatesToRig_delegate$lambda$0$0(EspionageAutomation this$0, Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        return otherCiv.isMinorCiv() && otherCiv.knows(this$0.civInfo) && !this$0.civInfo.isAtWarWith(otherCiv);
    }

    private static final boolean automateSpies$lambda$2(Spy $spy, City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $spy.canMoveTo(it);
    }
}

