/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map;

import com.unciv.logic.map.tile.Tile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.InternalState;
import yairm210.purity.annotations.Readonly;

@InternalState
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0003J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u001c2\u0006\u0010\u0019\u001a\u00020\u0003H\u0007J\u0006\u0010\u001d\u001a\u00020\u0006J\u000e\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0003J\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030!J\u0006\u0010\"\u001a\u00020\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0014j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/unciv/logic/map/BFS;", "", "startingPoint", "Lcom/unciv/logic/map/tile/Tile;", "predicate", "Lkotlin/Function1;", "", "<init>", "(Lcom/unciv/logic/map/tile/Tile;Lkotlin/jvm/functions/Function1;)V", "getStartingPoint", "()Lcom/unciv/logic/map/tile/Tile;", "maxSize", "", "getMaxSize", "()I", "setMaxSize", "(I)V", "tilesToCheck", "Lkotlin/collections/ArrayDeque;", "tilesReached", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "stepToEnd", "", "stepUntilDestination", "destination", "nextStep", "getPathTo", "Lkotlin/sequences/Sequence;", "hasEnded", "hasReachedTile", "tile", "getReachedTiles", "", "size", "core"})
public final class BFS {
    @NotNull
    private final Tile startingPoint;
    @NotNull
    private final Function1<Tile, Boolean> predicate;
    private int maxSize;
    @NotNull
    private final ArrayDeque<Tile> tilesToCheck;
    @NotNull
    private final HashMap<Tile, Tile> tilesReached;

    public BFS(@NotNull Tile startingPoint, @NotNull Function1<? super Tile, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(startingPoint, "startingPoint");
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        this.startingPoint = startingPoint;
        this.predicate = predicate;
        this.maxSize = Integer.MAX_VALUE;
        this.tilesToCheck = new ArrayDeque(37);
        this.tilesReached = new HashMap();
        this.tilesToCheck.add(this.startingPoint);
        ((Map)this.tilesReached).put(this.startingPoint, this.startingPoint);
    }

    @NotNull
    public final Tile getStartingPoint() {
        return this.startingPoint;
    }

    public final int getMaxSize() {
        return this.maxSize;
    }

    public final void setMaxSize(int n) {
        this.maxSize = n;
    }

    public final void stepToEnd() {
        while (!this.hasEnded()) {
            this.nextStep();
        }
    }

    @NotNull
    public final BFS stepUntilDestination(@NotNull Tile destination) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        while (!this.tilesReached.containsKey(destination) && !this.hasEnded()) {
            this.nextStep();
        }
        return this;
    }

    @Nullable
    public final Tile nextStep() {
        if (this.tilesReached.size() >= this.maxSize) {
            this.tilesToCheck.clear();
            return null;
        }
        Tile tile = this.tilesToCheck.removeFirstOrNull();
        if (tile == null) {
            return null;
        }
        Tile current = tile;
        Iterator<Tile> iterator2 = current.getNeighbors().iterator();
        while (iterator2.hasNext()) {
            Tile neighbor = iterator2.next();
            if (((Map)this.tilesReached).containsKey(neighbor) || !this.predicate.invoke(neighbor).booleanValue()) continue;
            ((Map)this.tilesReached).put(neighbor, current);
            this.tilesToCheck.add(neighbor);
        }
        return current;
    }

    @Readonly
    @NotNull
    public final Sequence<Tile> getPathTo(@NotNull Tile destination) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super Tile>, Continuation<? super Unit>, Object>(destination, this, null){
            Object L$1;
            Object L$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Tile $destination;
            final /* synthetic */ BFS this$0;
            {
                this.$destination = $destination;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (SequenceScope)this.L$0;
                var5_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        currentNode = this.$destination;
lbl8:
                        // 2 sources

                        while ((Tile)BFS.access$getTilesReached$p(this.this$0).get(currentNode) != null) {
                            this.L$0 = $this$sequence;
                            this.L$1 = currentNode;
                            this.L$2 = parent;
                            this.label = 1;
                            v0 = $this$sequence.yield(currentNode, this);
                            if (v0 == var5_3) {
                                return var5_3;
                            }
                            ** GOTO lbl23
                        }
                        ** GOTO lbl26
                    }
                    case 1: {
                        parent = (Tile)this.L$2;
                        currentNode = (Tile)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl23:
                        // 2 sources

                        if (Intrinsics.areEqual(currentNode, this.this$0.getStartingPoint())) ** GOTO lbl26
                        currentNode = parent;
                        ** GOTO lbl8
lbl26:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super Tile>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super Tile> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public final boolean hasEnded() {
        return this.tilesToCheck.isEmpty();
    }

    public final boolean hasReachedTile(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        return this.tilesReached.containsKey(tile);
    }

    @NotNull
    public final Set<Tile> getReachedTiles() {
        Set<Tile> set = this.tilesReached.keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        return set;
    }

    public final int size() {
        return this.tilesReached.size();
    }

    public static final /* synthetic */ HashMap access$getTilesReached$p(BFS $this) {
        return $this.tilesReached;
    }
}

