/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset;

import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.models.ruleset.PerpetualConstruction;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.Stat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/unciv/models/ruleset/PerpetualStatConversion;", "Lcom/unciv/models/ruleset/PerpetualConstruction;", "stat", "Lcom/unciv/models/stats/Stat;", "<init>", "(Lcom/unciv/models/stats/Stat;)V", "getStat", "()Lcom/unciv/models/stats/Stat;", "getProductionTooltip", "", "city", "Lcom/unciv/logic/city/City;", "withIcon", "", "getConversionRate", "", "isBuildable", "cityConstructions", "Lcom/unciv/logic/city/CityConstructions;", "core"})
@SourceDebugExtension(value={"SMAP\nIConstruction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IConstruction.kt\ncom/unciv/models/ruleset/PerpetualStatConversion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,339:1\n1255#2,2:340\n*S KotlinDebug\n*F\n+ 1 IConstruction.kt\ncom/unciv/models/ruleset/PerpetualStatConversion\n*L\n336#1:340,2\n*E\n"})
public class PerpetualStatConversion
extends PerpetualConstruction {
    @NotNull
    private final Stat stat;

    public PerpetualStatConversion(@NotNull Stat stat) {
        Intrinsics.checkNotNullParameter(stat, "stat");
        super(stat.name(), "Convert production to [" + stat.name() + "] at a rate of [rate] to 1");
        this.stat = stat;
    }

    @NotNull
    public final Stat getStat() {
        return this.stat;
    }

    @Override
    @NotNull
    public String getProductionTooltip(@NotNull City city, boolean withIcon) {
        Intrinsics.checkNotNullParameter(city, "city");
        return "\r\n" + MathKt.roundToInt(city.getCityStats().getCurrentCityStats().getProduction() / (float)this.getConversionRate(city)) + (withIcon ? Character.valueOf(this.stat.getCharacter()) : "") + "/\u23f3";
    }

    @Readonly
    public final int getConversionRate(@NotNull City city) {
        Intrinsics.checkNotNullParameter(city, "city");
        return MathKt.roundToInt(1.0f / city.getCityStats().getStatConversionRate(this.stat));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isBuildable(@NotNull CityConstructions cityConstructions) {
        boolean bl;
        block2: {
            void $this$any$iv;
            Intrinsics.checkNotNullParameter(cityConstructions, "cityConstructions");
            City city = cityConstructions.getCity();
            if (this.stat == Stat.Faith && !city.getCiv().getGameInfo().isReligionEnabled()) {
                return false;
            }
            GameContext stateForConditionals = city.getState();
            Sequence<Unique> sequence = city.getCiv().getMatchingUniques(UniqueType.EnablesCivWideStatProduction, stateForConditionals);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Unique it = (Unique)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual(it.getParams().get(0), this.stat.name())) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }
}

