/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.popups.options;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.PixmapIO;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.unciv.GUI;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.map.HexCoord;
import com.unciv.models.metadata.GameSettings;
import com.unciv.models.metadata.ModCategories;
import com.unciv.models.translations.TranslationFileWriter;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.UncivTooltip;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.fonts.FontFamilyData;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.UncivTextField;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.popups.options.AdvancedTab;
import com.unciv.ui.popups.options.OptionsPopup;
import com.unciv.ui.popups.options.OptionsPopupHelpers;
import com.unciv.ui.popups.options.OptionsPopupTab;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.worldmap.WorldMapHolder;
import com.unciv.utils.CollectionExtensionsKt;
import com.unciv.utils.Concurrency;
import com.unciv.utils.ConcurrencyKt;
import com.unciv.utils.Display;
import com.unciv.utils.StringExtensionsKt;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.path.FileVisitorBuilder;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0002J\b\u0010\t\u001a\u00020\u0007H\u0002J\b\u0010\n\u001a\u00020\u0007H\u0002J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0011\u001a\u00020\u0007H\u0002J\b\u0010\u0012\u001a\u00020\u0007H\u0002J\b\u0010\u0013\u001a\u00020\u0007H\u0002J\b\u0010\u0014\u001a\u00020\u0007H\u0002J\b\u0010\u0015\u001a\u00020\u0007H\u0002J\b\u0010\u0016\u001a\u00020\u0007H\u0002J,\u0010\u0017\u001a\u00020\u0007*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u001d0\u001cj\b\u0012\u0004\u0012\u00020\u001d`\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u0007H\u0002\u00a8\u0006!"}, d2={"Lcom/unciv/ui/popups/options/AdvancedTab;", "Lcom/unciv/ui/popups/options/OptionsPopupTab;", "optionsPopup", "Lcom/unciv/ui/popups/options/OptionsPopup;", "<init>", "(Lcom/unciv/ui/popups/options/OptionsPopup;)V", "lateInitialize", "", "addCutoutCheckbox", "addHideSystemUiCheckbox", "addAutosaveField", "setAutosaveButtonState", "button", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "text", "", "autosaveFieldEnterClicked", "addFontFamilySelect", "addFontSizeMultiplier", "addMaxZoomSlider", "addTranslationGeneration", "addUpdateModCategories", "addScreenhotGeneration", "generateScreenshots", "Lkotlinx/coroutines/CoroutineScope;", "settings", "Lcom/unciv/models/metadata/GameSettings;", "configs", "Ljava/util/ArrayList;", "Lcom/unciv/ui/popups/options/AdvancedTab$ScreenshotConfig;", "Lkotlin/collections/ArrayList;", "addSetUserId", "ScreenshotConfig", "core"})
public final class AdvancedTab
extends OptionsPopupTab {
    public AdvancedTab(@NotNull OptionsPopup optionsPopup) {
        Intrinsics.checkNotNullParameter(optionsPopup, "optionsPopup");
        super(optionsPopup);
    }

    @Override
    public void lateInitialize() {
        this.addAutosaveField();
        Integer[] integerArray = new Integer[]{1, 2, 5, 10, 20, 50, 100, 1000};
        OptionsPopupHelpers.addSelectBox$default(this, this, "Turns between autosaves", new MutablePropertyReference0Impl(this.getSettings()){

            public Object get() {
                return ((GameSettings)this.receiver).getTurnsBetweenAutosaves();
            }

            public void set(Object value) {
                ((GameSettings)this.receiver).setTurnsBetweenAutosaves(((Number)value).intValue());
            }
        }, CollectionsKt.listOf(integerArray), null, 8, null);
        Scene2dExtensionsKt.addSeparator$default(this, null, 0, 0.0f, 7, null);
        if (Display.INSTANCE.hasCutout()) {
            this.addCutoutCheckbox();
        }
        if (Display.INSTANCE.hasSystemUiVisibility()) {
            this.addHideSystemUiCheckbox();
        }
        this.addFontFamilySelect();
        this.addFontSizeMultiplier();
        Scene2dExtensionsKt.addSeparator$default(this, null, 0, 0.0f, 7, null);
        this.addMaxZoomSlider();
        OptionsPopupHelpers.addCheckbox$default(this, this, "Enable Easter Eggs", new MutablePropertyReference0Impl(this.getSettings()){

            public Object get() {
                return ((GameSettings)this.receiver).getEnableEasterEggs();
            }

            public void set(Object value) {
                ((GameSettings)this.receiver).setEnableEasterEggs((Boolean)value);
            }
        }, false, null, 12, null);
        OptionsPopupHelpers.addCheckbox$default(this, this, "Enlarge selected notifications", new MutablePropertyReference0Impl(this.getSettings()){

            public Object get() {
                return ((GameSettings)this.receiver).getEnlargeSelectedNotification();
            }

            public void set(Object value) {
                ((GameSettings)this.receiver).setEnlargeSelectedNotification((Boolean)value);
            }
        }, false, null, 12, null);
        Scene2dExtensionsKt.addSeparator$default(this, null, 0, 0.0f, 7, null);
        this.addSetUserId();
        this.addTranslationGeneration();
        this.addUpdateModCategories();
        this.addScreenhotGeneration();
        super.lateInitialize();
    }

    private final void addCutoutCheckbox() {
        OptionsPopupHelpers.addCheckbox$default(this, this, "Enable using display cutout areas", new MutablePropertyReference0Impl(this.getSettings()){

            public Object get() {
                return ((GameSettings)this.receiver).getAndroidCutout();
            }

            public void set(Object value) {
                ((GameSettings)this.receiver).setAndroidCutout((Boolean)value);
            }
        }, false, arg_0 -> AdvancedTab.addCutoutCheckbox$lambda$0(this, arg_0), 4, null);
    }

    private final void addHideSystemUiCheckbox() {
        OptionsPopupHelpers.addCheckbox$default(this, this, "Hide system status and navigation bars", new MutablePropertyReference0Impl(this.getSettings()){

            public Object get() {
                return ((GameSettings)this.receiver).getAndroidHideSystemUi();
            }

            public void set(Object value) {
                ((GameSettings)this.receiver).setAndroidHideSystemUi((Boolean)value);
            }
        }, false, arg_0 -> AdvancedTab.addHideSystemUiCheckbox$lambda$0(this, arg_0), 4, null);
    }

    private final void addAutosaveField() {
        this.add((Actor)Scene2dExtensionsKt.toLabel("Number of autosave files stored")).left().fillX();
        UncivTextField autoSaveTurnsTextField = new UncivTextField("", String.valueOf(this.getSettings().getMaxAutosavesStored()), null, 4, null);
        autoSaveTurnsTextField.setMaxLength(8);
        autoSaveTurnsTextField.setTextFieldFilter(AdvancedTab::addAutosaveField$lambda$0);
        TextButton autoSaveTurnsTextFieldButton = Scene2dExtensionsKt.toTextButton$default("Enter", null, false, 3, null);
        Scene2dExtensionsKt.setEnabled(autoSaveTurnsTextFieldButton, false);
        ActivationExtensionsKt.onClick(autoSaveTurnsTextFieldButton, () -> AdvancedTab.addAutosaveField$lambda$1(this, autoSaveTurnsTextField, autoSaveTurnsTextFieldButton));
        ActivationExtensionsKt.onChange(autoSaveTurnsTextField, arg_0 -> AdvancedTab.addAutosaveField$lambda$2(this, autoSaveTurnsTextFieldButton, autoSaveTurnsTextField, arg_0));
        Cell<Table> cell = this.addWrapped(this, false, arg_0 -> AdvancedTab.addAutosaveField$lambda$3(autoSaveTurnsTextField, autoSaveTurnsTextFieldButton, arg_0));
        cell.minWidth(this.getRightWidgetMinWidth()).right().row();
    }

    private final void setAutosaveButtonState(TextButton button, String text2) {
        Integer n = StringsKt.toIntOrNull(text2);
        int n2 = this.getSettings().getMaxAutosavesStored();
        Scene2dExtensionsKt.setEnabled(button, n == null || n != n2);
    }

    private final void autosaveFieldEnterClicked(String text2) {
        if (((CharSequence)text2).length() == 0) {
            return;
        }
        int numberAutosaveTurns = Integer.parseInt(text2);
        if (numberAutosaveTurns <= 0) {
            Stage stage = this.getStage();
            Intrinsics.checkNotNullExpressionValue(stage, "getStage(...)");
            Popup popup2 = new Popup(stage, null, 0.0f, 6, null);
            Color color = Color.RED;
            Intrinsics.checkNotNullExpressionValue(color, "RED");
            Popup.addGoodSizedLabel$default(popup2, "Autosave turns must be larger than 0!", 0, false, color, 6, null);
            Popup.addCloseButton$default(popup2, null, null, null, null, 15, null);
            popup2.open(true);
            return;
        }
        this.getSettings().setMaxAutosavesStored(numberAutosaveTurns);
        if (numberAutosaveTurns < 200) {
            return;
        }
        Stage stage = this.getStage();
        Intrinsics.checkNotNullExpressionValue(stage, "getStage(...)");
        Popup popup3 = new Popup(stage, null, 0.0f, 6, null);
        Color color = Color.ORANGE;
        Intrinsics.checkNotNullExpressionValue(color, "ORANGE");
        Popup.addGoodSizedLabel$default(popup3, "Autosave turns over 200 may take a lot of space on your device.", 0, false, color, 6, null);
        Popup.addCloseButton$default(popup3, null, null, null, null, 15, null);
        popup3.open(true);
    }

    private final void addFontFamilySelect() {
        OptionsPopupHelpers.addAsyncSelectBox$default(this, this, "Font family", new MutablePropertyReference0Impl(this.getSettings()){

            public Object get() {
                return ((GameSettings)this.receiver).getFontFamilyData();
            }

            public void set(Object value) {
                ((GameSettings)this.receiver).setFontFamilyData((FontFamilyData)value);
            }
        }, addFontFamilySelect.2.INSTANCE, null, arg_0 -> AdvancedTab.addFontFamilySelect$lambda$1(this, arg_0), 8, null);
    }

    private final void addFontSizeMultiplier() {
        OptionsPopupHelpers.addSlider$default((OptionsPopupHelpers)this, (Table)this, "Font size multiplier", new MutablePropertyReference0Impl(this.getSettings()){

            public Object get() {
                return Float.valueOf(((GameSettings)this.receiver).getFontSizeMultiplier());
            }

            public void set(Object value) {
                ((GameSettings)this.receiver).setFontSizeMultiplier(((Number)value).floatValue());
            }
        }, 0.7f, 1.5f, 0.05f, null, arg_0 -> AdvancedTab.addFontSizeMultiplier$lambda$0(this, arg_0), 32, null);
    }

    private final void addMaxZoomSlider() {
        OptionsPopupHelpers.addSlider$default((OptionsPopupHelpers)this, (Table)this, "Max zoom out", new MutablePropertyReference0Impl(this.getSettings()){

            public Object get() {
                return Float.valueOf(((GameSettings)this.receiver).getMaxWorldZoomOut());
            }

            public void set(Object value) {
                ((GameSettings)this.receiver).setMaxWorldZoomOut(((Number)value).floatValue());
            }
        }, 2.0f, 6.0f, 1.0f, null, AdvancedTab::addMaxZoomSlider$lambda$0, 32, null);
    }

    private final void addTranslationGeneration() {
        if (Gdx.app.getType() != Application.ApplicationType.Desktop) {
            return;
        }
        TextButton generateTranslationsButton = Scene2dExtensionsKt.toTextButton$default("Generate translation files", null, false, 3, null);
        ActivationExtensionsKt.onActivation(generateTranslationsButton, () -> AdvancedTab.addTranslationGeneration$lambda$0(generateTranslationsButton));
        ActivationExtensionsKt.getKeyShortcuts(generateTranslationsButton).add(142);
        UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, generateTranslationsButton, "F12", 18.0f, false, 0, 0, false, null, 124, null);
        this.add((Actor)generateTranslationsButton).colspan(2).row();
    }

    private final void addUpdateModCategories() {
        TextButton updateModCategoriesButton = Scene2dExtensionsKt.toTextButton$default("Update Mod categories", null, false, 3, null);
        ActivationExtensionsKt.onActivation(updateModCategoriesButton, () -> AdvancedTab.addUpdateModCategories$lambda$0(updateModCategoriesButton));
        this.add((Actor)updateModCategoriesButton).colspan(2).row();
    }

    private final void addScreenhotGeneration() {
        if (!UncivGame.Companion.getCurrent().getFiles().getSave("ScreenshotGenerationGame").exists()) {
            return;
        }
        TextButton generateScreenshotsButton = Scene2dExtensionsKt.toTextButton$default("Generate screenshots", null, false, 3, null);
        ActivationExtensionsKt.onActivation(generateScreenshotsButton, () -> AdvancedTab.addScreenhotGeneration$lambda$0(generateScreenshotsButton, this));
        this.add((Actor)generateScreenshotsButton).colspan(2).row();
    }

    private final void generateScreenshots(CoroutineScope $this$generateScreenshots, GameSettings settings, ArrayList<ScreenshotConfig> configs) {
        ScreenshotConfig currentConfig = (ScreenshotConfig)CollectionsKt.first((List)configs);
        ConcurrencyKt.launchOnGLThread$default($this$generateScreenshots, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(settings, currentConfig, configs, this, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ GameSettings $settings;
            final /* synthetic */ ScreenshotConfig $currentConfig;
            final /* synthetic */ ArrayList<ScreenshotConfig> $configs;
            final /* synthetic */ AdvancedTab this$0;
            {
                this.$settings = $settings;
                this.$currentConfig = $currentConfig;
                this.$configs = $configs;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        screenshotGame = UncivGame.Companion.getCurrent().getFiles().loadGameByName("ScreenshotGenerationGame");
                        this.$settings.setScreenSize(this.$currentConfig.getScreenSize());
                        this.L$0 = SpillingKt.nullOutSpilledVariable(screenshotGame);
                        this.label = 1;
                        v0 = UncivGame.loadGame$default(UncivGame.Companion.getCurrent(), screenshotGame, null, false, this, 6, null);
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl17
                    }
                    case 1: {
                        screenshotGame = (GameInfo)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        newScreen = (WorldScreen)v0;
                        newScreen.getStage().getViewport().update(this.$currentConfig.getWidth(), this.$currentConfig.getHeight(), true);
                        newScreen.getMapHolder().setSize(newScreen.getStage().getWidth(), newScreen.getStage().getHeight());
                        newScreen.getMapHolder().layout();
                        newScreen.getMinimapWrapper$core().setX(newScreen.getStage().getWidth() - newScreen.getMinimapWrapper$core().getWidth());
                        WorldMapHolder.setCenterPosition$default(newScreen.getMapHolder(), this.$currentConfig.getCenterTile(), true, true, null, 8, null);
                        newScreen.getMapHolder().onTileClicked(newScreen.getMapHolder().getTileMap$core().get(-2, 3));
                        if (this.$currentConfig.getAttackCity()) {
                            newScreen.getMapHolder().onTileClicked(newScreen.getMapHolder().getTileMap$core().get(-2, 2));
                        }
                        newScreen.getMapHolder().zoomIn(true);
                        this.L$0 = SpillingKt.nullOutSpilledVariable(screenshotGame);
                        this.L$1 = SpillingKt.nullOutSpilledVariable(newScreen);
                        this.label = 2;
                        v1 = BuildersKt.withContext(Dispatchers.getIO(), (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$currentConfig, this.$configs, this.this$0, this.$settings, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ ScreenshotConfig $currentConfig;
                            final /* synthetic */ ArrayList<ScreenshotConfig> $configs;
                            final /* synthetic */ AdvancedTab this$0;
                            final /* synthetic */ GameSettings $settings;
                            {
                                this.$currentConfig = $currentConfig;
                                this.$configs = $configs;
                                this.this$0 = $receiver;
                                this.$settings = $settings;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void $this$withContext;
                                        ResultKt.throwOnFailure($result);
                                        Thread.sleep(300L);
                                        ConcurrencyKt.launchOnGLThread$default((CoroutineScope)$this$withContext, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$currentConfig, this.$configs, this.this$0, this.$settings, null){
                                            int label;
                                            private /* synthetic */ Object L$0;
                                            final /* synthetic */ ScreenshotConfig $currentConfig;
                                            final /* synthetic */ ArrayList<ScreenshotConfig> $configs;
                                            final /* synthetic */ AdvancedTab this$0;
                                            final /* synthetic */ GameSettings $settings;
                                            {
                                                this.$currentConfig = $currentConfig;
                                                this.$configs = $configs;
                                                this.this$0 = $receiver;
                                                this.$settings = $settings;
                                                super(2, $completion);
                                            }

                                            /*
                                             * WARNING - void declaration
                                             */
                                            public final Object invokeSuspend(Object $result) {
                                                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure($result);
                                                        Pixmap pixmap = Pixmap.createFromFrameBuffer(0, 0, this.$currentConfig.getWidth(), this.$currentConfig.getHeight());
                                                        PixmapIO.writePNG(new FileHandle(this.$currentConfig.getFileLocation()), pixmap, -1, true);
                                                        pixmap.dispose();
                                                        ArrayList<ScreenshotConfig> newConfigs = CollectionExtensionsKt.withoutItem((List)this.$configs, this.$currentConfig);
                                                        if (!((Collection)newConfigs).isEmpty()) {
                                                            void $this$launchOnGLThread;
                                                            AdvancedTab.access$generateScreenshots(this.this$0, (CoroutineScope)$this$launchOnGLThread, this.$settings, newConfigs);
                                                        }
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                                function2.L$0 = value;
                                                return (Continuation)((Object)function2);
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }, 1, null);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                function2.L$0 = value;
                                return (Continuation)((Object)function2);
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, this);
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl40
                    }
                    case 2: {
                        newScreen = (WorldScreen)this.L$1;
                        screenshotGame = (GameInfo)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl40:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
    }

    private final void addSetUserId() {
        Label idSetLabel = Scene2dExtensionsKt.toLabel("");
        Actor takeUserIdFromClipboardButton = ActivationExtensionsKt.onClick(Scene2dExtensionsKt.toTextButton$default("Take user ID from clipboard", null, false, 3, null), () -> AdvancedTab.addSetUserId$lambda$0(this, idSetLabel));
        this.add(takeUserIdFromClipboardButton).pad(5.0f).colspan(2).row();
        this.add((Actor)idSetLabel).colspan(2).row();
    }

    private static final Unit addCutoutCheckbox$lambda$0(AdvancedTab this$0, boolean it) {
        Display.INSTANCE.setCutout(it);
        OptionsPopupHelpers.reopenOptions$default(this$0, false, 1, null);
        GUI.INSTANCE.setUpdateWorldOnNextRender();
        return Unit.INSTANCE;
    }

    private static final Unit addHideSystemUiCheckbox$lambda$0(AdvancedTab this$0, boolean it) {
        Display.INSTANCE.setSystemUiVisibility(it);
        OptionsPopupHelpers.reopenOptions$default(this$0, false, 1, null);
        return Unit.INSTANCE;
    }

    private static final boolean addAutosaveField$lambda$0(TextField textField, char c) {
        return StringsKt.contains$default((CharSequence)"1234567890", c, false, 2, null);
    }

    private static final Unit addAutosaveField$lambda$1(AdvancedTab this$0, UncivTextField $autoSaveTurnsTextField, TextButton $autoSaveTurnsTextFieldButton) {
        String string = $autoSaveTurnsTextField.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        this$0.autosaveFieldEnterClicked(string);
        String string2 = $autoSaveTurnsTextField.getText();
        Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
        this$0.setAutosaveButtonState($autoSaveTurnsTextFieldButton, string2);
        return Unit.INSTANCE;
    }

    private static final Unit addAutosaveField$lambda$2(AdvancedTab this$0, TextButton $autoSaveTurnsTextFieldButton, UncivTextField $autoSaveTurnsTextField, ChangeListener.ChangeEvent it) {
        String string = $autoSaveTurnsTextField.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        this$0.setAutosaveButtonState($autoSaveTurnsTextFieldButton, string);
        return Unit.INSTANCE;
    }

    private static final Unit addAutosaveField$lambda$3(UncivTextField $autoSaveTurnsTextField, TextButton $autoSaveTurnsTextFieldButton, Table $this$addWrapped) {
        Intrinsics.checkNotNullParameter($this$addWrapped, "$this$addWrapped");
        $this$addWrapped.add((Actor)$autoSaveTurnsTextField);
        $this$addWrapped.add((Actor)$autoSaveTurnsTextFieldButton).padLeft(5.0f);
        return Unit.INSTANCE;
    }

    private static final Flow<FontFamilyData> addFontFamilySelect$loadModFonts(Path mod) {
        return FlowKt.flow((Function2)new Function2<FlowCollector<? super FontFamilyData>, Continuation<? super Unit>, Object>(mod, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            Object L$6;
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Path $mod;
            {
                this.$mod = $mod;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            public final Object invokeSuspend(Object $result) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[WHILELOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.dump(StructuredReturn.java:60)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<FlowCollector<? super FontFamilyData>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(FlowCollector<? super FontFamilyData> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(FileVisitorBuilder $this$fileVisitor) {
                return Unit.INSTANCE;
            }
        });
    }

    private static final Flow<FontFamilyData> addFontFamilySelect$loadFonts() {
        return FlowKt.flow((Function2)new Function2<FlowCollector<? super FontFamilyData>, Continuation<? super Unit>, Object>(null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            Object L$6;
            int I$0;
            int label;
            private /* synthetic */ Object L$0;

            /*
             * Exception decompiling
             */
            public final Object invokeSuspend(Object $result) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 11[WHILELOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.dump(StructuredReturn.java:60)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<FlowCollector<? super FontFamilyData>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(FlowCollector<? super FontFamilyData> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private static final Unit addFontFamilySelect$lambda$1(AdvancedTab this$0, FontFamilyData it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.reloadWorldAndOptions();
        return Unit.INSTANCE;
    }

    private static final Unit addFontSizeMultiplier$lambda$0(AdvancedTab this$0, float it) {
        this$0.reloadWorldAndOptions();
        return Unit.INSTANCE;
    }

    private static final Unit addMaxZoomSlider$lambda$0(float it) {
        if (GUI.INSTANCE.isWorldLoaded()) {
            GUI.INSTANCE.getMap().reloadMaxZoom();
        }
        return Unit.INSTANCE;
    }

    private static final Unit addTranslationGeneration$lambda$0(TextButton $generateTranslationsButton) {
        $generateTranslationsButton.setText(TranslationsKt.tr$default("Working...", false, false, 3, null));
        Concurrency.run$default(Concurrency.INSTANCE, "WriteTranslations", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>($generateTranslationsButton, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ TextButton $generateTranslationsButton;
            {
                this.$generateTranslationsButton = $generateTranslationsButton;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$run;
                        ResultKt.throwOnFailure($result);
                        String result2 = TranslationFileWriter.INSTANCE.writeNewTranslationFiles();
                        ConcurrencyKt.launchOnGLThread$default((CoroutineScope)$this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$generateTranslationsButton, result2, null){
                            int label;
                            final /* synthetic */ TextButton $generateTranslationsButton;
                            final /* synthetic */ String $result;
                            {
                                this.$generateTranslationsButton = $generateTranslationsButton;
                                this.$result = $result;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure($result);
                                        this.$generateTranslationsButton.setText(TranslationsKt.tr$default(this.$result, false, false, 3, null));
                                        Scene2dExtensionsKt.disable(this.$generateTranslationsButton);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, 1, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit addUpdateModCategories$lambda$0(TextButton $updateModCategoriesButton) {
        $updateModCategoriesButton.setText(TranslationsKt.tr$default("Working...", false, false, 3, null));
        Concurrency.run$default(Concurrency.INSTANCE, "GithubTopicQuery", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>($updateModCategoriesButton, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ TextButton $updateModCategoriesButton;
            {
                this.$updateModCategoriesButton = $updateModCategoriesButton;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var4_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        this.L$0 = $this$run;
                        this.label = 1;
                        v0 = ModCategories.Companion.mergeOnline(this);
                        if (v0 == var4_3) {
                            return var4_3;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        result = (String)v0;
                        ConcurrencyKt.launchOnGLThread$default((CoroutineScope)$this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$updateModCategoriesButton, result, null){
                            int label;
                            final /* synthetic */ TextButton $updateModCategoriesButton;
                            final /* synthetic */ String $result;
                            {
                                this.$updateModCategoriesButton = $updateModCategoriesButton;
                                this.$result = $result;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure($result);
                                        this.$updateModCategoriesButton.setText(this.$result);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, 1, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit addScreenhotGeneration$lambda$0(TextButton $generateScreenshotsButton, AdvancedTab this$0) {
        $generateScreenshotsButton.setText(TranslationsKt.tr$default("Working...", false, false, 3, null));
        Concurrency.run$default(Concurrency.INSTANCE, "GenerateScreenshot", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ AdvancedTab this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$run;
                        ResultKt.throwOnFailure($result);
                        String extraImagesLocation = "../../extraImages";
                        ScreenshotConfig[] screenshotConfigArray = new ScreenshotConfig[]{new ScreenshotConfig(630, 500, GameSettings.ScreenSize.Medium, extraImagesLocation + "/itch.io image.png", new HexCoord(-2, 2), false), new ScreenshotConfig(1280, 640, GameSettings.ScreenSize.Medium, extraImagesLocation + "/GithubPreviewImage.png", new HexCoord(-2, 4), false, 32, null), new ScreenshotConfig(1024, 500, GameSettings.ScreenSize.Medium, extraImagesLocation + "/Feature graphic - Google Play.png", new HexCoord(-2, 6), false, 32, null), new ScreenshotConfig(1024, 500, GameSettings.ScreenSize.Medium, "../../fastlane/metadata/android/en-US/images/featureGraphic.png", new HexCoord(-2, 8), false, 32, null)};
                        AdvancedTab.access$generateScreenshots(this.this$0, (CoroutineScope)$this$run, this.this$0.getSettings(), CollectionsKt.arrayListOf(screenshotConfigArray));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit addSetUserId$lambda$0(AdvancedTab this$0, Label $idSetLabel) {
        String string = Gdx.app.getClipboard().getContents();
        Intrinsics.checkNotNullExpressionValue(string, "getContents(...)");
        String clipboardContents = ((Object)StringsKt.trim((CharSequence)string)).toString();
        if (StringExtensionsKt.isUUID(clipboardContents)) {
            Stage stage = this$0.getStage();
            Intrinsics.checkNotNullExpressionValue(stage, "getStage(...)");
            new ConfirmPopup(stage, "Doing this will reset your current user ID to the clipboard contents - are you sure?", "Take user ID from clipboard", false, null, () -> AdvancedTab.addSetUserId$lambda$0$0(this$0, clipboardContents, $idSetLabel), 24, null).open(true);
            $idSetLabel.setVisible(true);
        } else {
            $idSetLabel.setVisible(true);
            Color color = Color.RED;
            Intrinsics.checkNotNullExpressionValue(color, "RED");
            Scene2dExtensionsKt.setFontColor($idSetLabel, color).setText(TranslationsKt.tr$default("Invalid ID!", false, false, 3, null));
        }
        return Unit.INSTANCE;
    }

    private static final Unit addSetUserId$lambda$0$0(AdvancedTab this$0, String $clipboardContents, Label $idSetLabel) {
        this$0.getSettings().getMultiplayer().setUserId($clipboardContents);
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue(color, "WHITE");
        Scene2dExtensionsKt.setFontColor($idSetLabel, color).setText(TranslationsKt.tr$default("ID successfully set!", false, false, 3, null));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$addFontFamilySelect$loadFonts$0(Continuation $completion) {
        return AdvancedTab.addFontFamilySelect$loadFonts();
    }

    public static final /* synthetic */ void access$generateScreenshots(AdvancedTab $this, CoroutineScope $receiver, GameSettings settings, ArrayList configs) {
        $this.generateScreenshots($receiver, settings, configs);
    }

    public static final /* synthetic */ Flow access$addFontFamilySelect$loadModFonts(Path mod) {
        return AdvancedTab.addFontFamilySelect$loadModFonts(mod);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u001f\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0006H\u00c6\u0003J\t\u0010#\u001a\u00020\bH\u00c6\u0003J\t\u0010$\u001a\u00020\nH\u00c6\u0003J\t\u0010%\u001a\u00020\fH\u00c6\u0003JE\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010'\u001a\u00020\f2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010)\u001a\u00020\u0003H\u00d6\u0001J\t\u0010*\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006+"}, d2={"Lcom/unciv/ui/popups/options/AdvancedTab$ScreenshotConfig;", "", "width", "", "height", "screenSize", "Lcom/unciv/models/metadata/GameSettings$ScreenSize;", "fileLocation", "", "centerTile", "Lcom/unciv/logic/map/HexCoord;", "attackCity", "", "<init>", "(IILcom/unciv/models/metadata/GameSettings$ScreenSize;Ljava/lang/String;Lcom/unciv/logic/map/HexCoord;Z)V", "getWidth", "()I", "getHeight", "getScreenSize", "()Lcom/unciv/models/metadata/GameSettings$ScreenSize;", "getFileLocation", "()Ljava/lang/String;", "setFileLocation", "(Ljava/lang/String;)V", "getCenterTile", "()Lcom/unciv/logic/map/HexCoord;", "setCenterTile", "(Lcom/unciv/logic/map/HexCoord;)V", "getAttackCity", "()Z", "setAttackCity", "(Z)V", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "toString", "core"})
    public static final class ScreenshotConfig {
        private final int width;
        private final int height;
        @NotNull
        private final GameSettings.ScreenSize screenSize;
        @NotNull
        private String fileLocation;
        @NotNull
        private HexCoord centerTile;
        private boolean attackCity;

        public ScreenshotConfig(int width, int height, @NotNull GameSettings.ScreenSize screenSize, @NotNull String fileLocation, @NotNull HexCoord centerTile, boolean attackCity) {
            Intrinsics.checkNotNullParameter((Object)screenSize, "screenSize");
            Intrinsics.checkNotNullParameter(fileLocation, "fileLocation");
            Intrinsics.checkNotNullParameter(centerTile, "centerTile");
            this.width = width;
            this.height = height;
            this.screenSize = screenSize;
            this.fileLocation = fileLocation;
            this.centerTile = centerTile;
            this.attackCity = attackCity;
        }

        public /* synthetic */ ScreenshotConfig(int n, int n2, GameSettings.ScreenSize screenSize, String string, HexCoord hexCoord, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 0x20) != 0) {
                bl = true;
            }
            this(n, n2, screenSize, string, hexCoord, bl);
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        @NotNull
        public final GameSettings.ScreenSize getScreenSize() {
            return this.screenSize;
        }

        @NotNull
        public final String getFileLocation() {
            return this.fileLocation;
        }

        public final void setFileLocation(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.fileLocation = string;
        }

        @NotNull
        public final HexCoord getCenterTile() {
            return this.centerTile;
        }

        public final void setCenterTile(@NotNull HexCoord hexCoord) {
            Intrinsics.checkNotNullParameter(hexCoord, "<set-?>");
            this.centerTile = hexCoord;
        }

        public final boolean getAttackCity() {
            return this.attackCity;
        }

        public final void setAttackCity(boolean bl) {
            this.attackCity = bl;
        }

        public final int component1() {
            return this.width;
        }

        public final int component2() {
            return this.height;
        }

        @NotNull
        public final GameSettings.ScreenSize component3() {
            return this.screenSize;
        }

        @NotNull
        public final String component4() {
            return this.fileLocation;
        }

        @NotNull
        public final HexCoord component5() {
            return this.centerTile;
        }

        public final boolean component6() {
            return this.attackCity;
        }

        @NotNull
        public final ScreenshotConfig copy(int width, int height, @NotNull GameSettings.ScreenSize screenSize, @NotNull String fileLocation, @NotNull HexCoord centerTile, boolean attackCity) {
            Intrinsics.checkNotNullParameter((Object)screenSize, "screenSize");
            Intrinsics.checkNotNullParameter(fileLocation, "fileLocation");
            Intrinsics.checkNotNullParameter(centerTile, "centerTile");
            return new ScreenshotConfig(width, height, screenSize, fileLocation, centerTile, attackCity);
        }

        public static /* synthetic */ ScreenshotConfig copy$default(ScreenshotConfig screenshotConfig, int n, int n2, GameSettings.ScreenSize screenSize, String string, HexCoord hexCoord, boolean bl, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = screenshotConfig.width;
            }
            if ((n3 & 2) != 0) {
                n2 = screenshotConfig.height;
            }
            if ((n3 & 4) != 0) {
                screenSize = screenshotConfig.screenSize;
            }
            if ((n3 & 8) != 0) {
                string = screenshotConfig.fileLocation;
            }
            if ((n3 & 0x10) != 0) {
                hexCoord = screenshotConfig.centerTile;
            }
            if ((n3 & 0x20) != 0) {
                bl = screenshotConfig.attackCity;
            }
            return screenshotConfig.copy(n, n2, screenSize, string, hexCoord, bl);
        }

        @NotNull
        public String toString() {
            return "ScreenshotConfig(width=" + this.width + ", height=" + this.height + ", screenSize=" + (Object)((Object)this.screenSize) + ", fileLocation=" + this.fileLocation + ", centerTile=" + this.centerTile + ", attackCity=" + this.attackCity + ')';
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.width);
            result2 = result2 * 31 + Integer.hashCode(this.height);
            result2 = result2 * 31 + this.screenSize.hashCode();
            result2 = result2 * 31 + this.fileLocation.hashCode();
            result2 = result2 * 31 + this.centerTile.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.attackCity);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ScreenshotConfig)) {
                return false;
            }
            ScreenshotConfig screenshotConfig = (ScreenshotConfig)other;
            if (this.width != screenshotConfig.width) {
                return false;
            }
            if (this.height != screenshotConfig.height) {
                return false;
            }
            if (this.screenSize != screenshotConfig.screenSize) {
                return false;
            }
            if (!Intrinsics.areEqual(this.fileLocation, screenshotConfig.fileLocation)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.centerTile, screenshotConfig.centerTile)) {
                return false;
            }
            return this.attackCity == screenshotConfig.attackCity;
        }
    }
}

