/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.cityscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityFocus;
import com.unciv.models.skins.SkinStrings;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.components.widgets.ExpanderTab;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.cityscreen.CityScreen;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/unciv/ui/screens/cityscreen/CitizenManagementTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "cityScreen", "Lcom/unciv/ui/screens/cityscreen/CityScreen;", "<init>", "(Lcom/unciv/ui/screens/cityscreen/CityScreen;)V", "getCityScreen", "()Lcom/unciv/ui/screens/cityscreen/CityScreen;", "city", "Lcom/unciv/logic/city/City;", "getCity", "()Lcom/unciv/logic/city/City;", "numCol", "", "update", "", "asExpander", "Lcom/unciv/ui/components/widgets/ExpanderTab;", "onChange", "Lkotlin/Function0;", "core"})
public final class CitizenManagementTable
extends Table {
    @NotNull
    private final CityScreen cityScreen;
    @NotNull
    private final City city;
    private final int numCol;

    public CitizenManagementTable(@NotNull CityScreen cityScreen) {
        Intrinsics.checkNotNullParameter(cityScreen, "cityScreen");
        super(BaseScreen.Companion.getSkin());
        this.cityScreen = cityScreen;
        this.city = this.cityScreen.getCity$core();
        this.numCol = 4;
    }

    @NotNull
    public final CityScreen getCityScreen() {
        return this.cityScreen;
    }

    @NotNull
    public final City getCity() {
        return this.city;
    }

    public final void update() {
        this.clear();
        Color colorSelected = BaseScreen.Companion.getSkin().getColor("selection");
        Color colorButton = BaseScreen.Companion.getSkin().getColor("color");
        Table topTable = new Table();
        Label resetLabel = Scene2dExtensionsKt.toLabel("Reset Citizens");
        Table resetCell = new Table();
        resetCell.add((Actor)resetLabel).pad(5.0f);
        if (this.cityScreen.canCityBeChanged()) {
            resetCell.setTouchable(Touchable.enabled);
            ActivationExtensionsKt.onActivation$default(resetCell, null, KeyboardBinding.ResetCitizens, () -> CitizenManagementTable.update$lambda$0(this), 1, null);
        }
        resetCell.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "CityScreen/CitizenManagementTable/ResetCell", null, colorButton, 2, null));
        topTable.add((Actor)resetCell).pad(3.0f);
        Label avoidLabel = Scene2dExtensionsKt.toLabel("Avoid Growth");
        Table avoidCell = new Table();
        avoidCell.add((Actor)avoidLabel).pad(5.0f);
        if (this.cityScreen.canCityBeChanged()) {
            avoidCell.setTouchable(Touchable.enabled);
            ActivationExtensionsKt.onActivation$default(avoidCell, null, KeyboardBinding.AvoidGrowth, () -> CitizenManagementTable.update$lambda$1(this), 1, null);
        }
        avoidCell.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "CityScreen/CitizenManagementTable/AvoidCell", null, this.city.getAvoidGrowth() ? colorSelected : colorButton, 2, null));
        topTable.add((Actor)avoidCell).pad(3.0f);
        this.add((Actor)topTable).colspan(this.numCol).growX();
        this.row();
        Label focusLabel = Scene2dExtensionsKt.toLabel("Citizen Focus");
        Table focusCell = new Table();
        focusCell.add((Actor)focusLabel).pad(5.0f);
        this.add((Actor)focusCell).colspan(this.numCol).growX().pad(3.0f);
        this.row();
        int currCol = this.numCol;
        Table defaultTable = new Table();
        for (CityFocus focus : CityFocus.getEntries()) {
            Object object;
            if (!focus.getTableEnabled() || focus == CityFocus.FaithFocus && !this.city.getCiv().getGameInfo().isReligionEnabled()) continue;
            Label label = Scene2dExtensionsKt.toLabel(focus.getLabel());
            Table cell = new Table();
            cell.add((Actor)label).pad(5.0f);
            if (this.cityScreen.canCityBeChanged()) {
                cell.setTouchable(Touchable.enabled);
                KeyboardBinding binding = this.city.getCityFocus() == focus ? focus.getBinding() : KeyboardBinding.None;
                ActivationExtensionsKt.onActivation$default(cell, null, binding, () -> CitizenManagementTable.update$lambda$2(this, focus), 1, null);
            }
            cell.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "CityScreen/CitizenManagementTable/FocusCell", null, this.city.getCityFocus() == focus ? colorSelected : colorButton, 2, null));
            if (focus == CityFocus.NoFocus) {
                object = defaultTable.add((Actor)cell).growX().pad(3.0f);
                continue;
            }
            if (focus == CityFocus.Manual) {
                defaultTable.add((Actor)cell).growX().pad(3.0f);
                this.add((Actor)defaultTable).colspan(this.numCol).growX();
                object = this.row();
                continue;
            }
            cell.padTop(5.0f);
            this.add((Actor)cell).growX().pad(3.0f);
            if (--currCol == 0) {
                this.row();
                currCol = this.numCol;
            }
            object = Unit.INSTANCE;
        }
        this.pack();
    }

    @NotNull
    public final ExpanderTab asExpander(@Nullable Function0<Unit> onChange) {
        KeyboardBinding keyboardBinding = KeyboardBinding.CitizenManagement;
        return new ExpanderTab("{Citizen Management}", 18, null, false, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, "CityStatsTable.CitizenManagement", keyboardBinding, onChange, arg_0 -> CitizenManagementTable.asExpander$lambda$0(this, arg_0), 500, null);
    }

    private static final Unit update$lambda$0(CitizenManagementTable this$0) {
        this$0.city.reassignPopulation(true);
        this$0.cityScreen.update$core();
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$1(CitizenManagementTable this$0) {
        this$0.city.setAvoidGrowth(!this$0.city.getAvoidGrowth());
        City.reassignPopulation$default(this$0.city, false, 1, null);
        this$0.cityScreen.update$core();
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$2(CitizenManagementTable this$0, CityFocus $focus) {
        this$0.city.setCityFocus($focus);
        City.reassignPopulation$default(this$0.city, false, 1, null);
        this$0.cityScreen.update$core();
        return Unit.INSTANCE;
    }

    private static final Unit asExpander$lambda$0(CitizenManagementTable this$0, Table it) {
        Intrinsics.checkNotNullParameter(it, "it");
        it.add((Actor)this$0);
        this$0.update();
        return Unit.INSTANCE;
    }
}

