/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization.diplomacy;

import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.automation.civilization.NextTurnAutomation;
import com.unciv.logic.battle.CityCombatant;
import com.unciv.logic.battle.ICombatant;
import com.unciv.logic.city.City;
import com.unciv.logic.city.managers.SpyFleeReason;
import com.unciv.logic.civilization.AlertType;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.DiplomacyAction;
import com.unciv.logic.civilization.LocationAction;
import com.unciv.logic.civilization.MapUnitAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.NotificationAction;
import com.unciv.logic.civilization.PlayerType;
import com.unciv.logic.civilization.PopupAlert;
import com.unciv.logic.civilization.Proximity;
import com.unciv.logic.civilization.diplomacy.CityStatePersonality;
import com.unciv.logic.civilization.diplomacy.DeclareWarReason;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticModifiers;
import com.unciv.logic.civilization.diplomacy.DiplomaticStatus;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.logic.civilization.diplomacy.WarType;
import com.unciv.logic.civilization.managers.TechManager;
import com.unciv.logic.civilization.managers.UnitManager;
import com.unciv.logic.civilization.transients.CivInfoTransientCache;
import com.unciv.logic.map.HexCoord;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Spy;
import com.unciv.models.SpyAction;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.Speed;
import com.unciv.models.ruleset.nation.CityStateType;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.tech.Technology;
import com.unciv.models.ruleset.tile.ResourceSupplyList;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueMap;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.ruleset.unit.UnitType;
import com.unciv.models.stats.Stat;
import com.unciv.ui.screens.victoryscreen.RankingType;
import com.unciv.utils.CollectionExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 L2\u00020\u0001:\u0001LB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0007J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0003J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0003J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0014H\u0007J\u0016\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0014J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u001dH\u0007J\u000e\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0003J\u0018\u0010 \u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u00032\b\b\u0002\u0010!\u001a\u00020\tJ\u0010\u0010\"\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u0003H\u0007J\u0010\u0010#\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u0003H\u0007J\u0006\u0010$\u001a\u00020\u0012J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u000fH\u0007J\b\u0010'\u001a\u00020\u0014H\u0007J\u0010\u0010(\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u0003H\u0007J\u000e\u0010)\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0003J\u001a\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\u00032\b\b\u0002\u0010,\u001a\u00020\tH\u0007J@\u0010-\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00140.j\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0014`/2\u0006\u0010+\u001a\u00020\u00032\b\b\u0002\u0010,\u001a\u00020\t2\b\b\u0002\u00100\u001a\u00020\tH\u0007J\b\u00101\u001a\u00020\u0014H\u0007J\u000e\u00102\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u0003J\u000e\u00103\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u0003J\u0010\u00104\u001a\u00020\t2\u0006\u00105\u001a\u000206H\u0007J\u0006\u00107\u001a\u00020\u0012J\u0006\u00108\u001a\u00020\u0012J\b\u00109\u001a\u00020\u0014H\u0007J\u000e\u0010:\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0003J\u0010\u0010;\u001a\u00020\u00122\u0006\u0010<\u001a\u00020\u0003H\u0002J\u000e\u0010=\u001a\u00020\u00122\u0006\u0010>\u001a\u00020\u0003J\u0010\u0010?\u001a\u00020\u00122\u0006\u0010>\u001a\u00020\u0003H\u0002J\u0010\u0010@\u001a\u00020\u00122\u0006\u0010>\u001a\u00020\u0003H\u0002J\u0010\u0010A\u001a\u00020\u00122\u0006\u0010>\u001a\u00020\u0003H\u0002J\u000e\u0010B\u001a\u00020\u00122\u0006\u0010>\u001a\u00020\u0003J\u000e\u0010C\u001a\u00020\u00122\u0006\u0010>\u001a\u00020\u0003J\b\u0010D\u001a\u00020EH\u0007J\u001e\u0010F\u001a\b\u0012\u0004\u0012\u00020G0\u000f2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020KH\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006M"}, d2={"Lcom/unciv/logic/civilization/diplomacy/CityStateFunctions;", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "<init>", "(Lcom/unciv/logic/civilization/Civilization;)V", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "initCityState", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "startingEra", "", "usedMajorCivs", "Lkotlin/sequences/Sequence;", "Lcom/unciv/models/ruleset/nation/Nation;", "holdElections", "", "turnsForGreatPersonFromCityState", "", "giveGreatPersonToPatron", "receivingCiv", "giveMilitaryUnitToPatron", "influenceGainedByGift", "donorCiv", "giftAmount", "receiveGoldGift", "getProtectorCivs", "", "addProtectorCiv", "otherCiv", "removeProtectorCiv", "forced", "otherCivCanPledgeProtection", "otherCivCanWithdrawProtection", "updateAllyCivForCityState", "getNotificationActions", "Lcom/unciv/logic/civilization/NotificationAction;", "getDiplomaticMarriageCost", "canBeMarriedBy", "diplomaticMarriage", "getTributeWillingness", "demandingCiv", "demandingWorker", "getTributeModifiers", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "requireWholeList", "goldGainedByTribute", "tributeGold", "tributeWorker", "canProvideStat", "statType", "Lcom/unciv/models/stats/Stat;", "updateDiplomaticRelationshipForCityState", "getFreeTechForCityState", "getNumThreateningBarbarians", "threateningBarbarianKilledBy", "cityStateBullied", "bully", "cityStateAttacked", "attacker", "makeOtherCityStatesWaryOfAttacker", "triggerProtectorCivs", "triggerAllyCivs", "cityStateDestroyed", "askForUnitGifts", "getCityStateResourcesForAlly", "Lcom/unciv/models/ruleset/tile/ResourceSupplyList;", "getUniquesProvidedByCityStates", "Lcom/unciv/models/ruleset/unique/Unique;", "uniqueType", "Lcom/unciv/models/ruleset/unique/UniqueType;", "gameContext", "Lcom/unciv/models/ruleset/unique/GameContext;", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nCityStateFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityStateFunctions.kt\ncom/unciv/logic/civilization/diplomacy/CityStateFunctions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,843:1\n774#2:844\n865#2,2:845\n1563#2:847\n1634#2,3:848\n774#2:851\n865#2,2:852\n1761#2,3:854\n774#2:857\n865#2,2:858\n774#2:860\n865#2,2:861\n1563#2:863\n1634#2,3:864\n774#2:875\n865#2,2:876\n774#2:878\n865#2,2:879\n1761#2,3:881\n1068#2:884\n774#2:895\n865#2,2:896\n1788#2,4:898\n295#2,2:902\n1869#2,2:907\n1869#2,2:909\n536#3:867\n521#3,6:868\n536#3:885\n521#3,6:886\n1#4:874\n1276#5,3:892\n1276#5,3:904\n630#6,3:911\n*S KotlinDebug\n*F\n+ 1 CityStateFunctions.kt\ncom/unciv/logic/civilization/diplomacy/CityStateFunctions\n*L\n32#1:844\n32#1:845,2\n32#1:847\n32#1:848,3\n78#1:851\n78#1:852,2\n111#1:854,3\n128#1:857\n128#1:858,2\n223#1:860\n223#1:861,2\n224#1:863\n224#1:864,3\n310#1:875\n310#1:876,2\n390#1:878\n390#1:879,2\n438#1:881,3\n457#1:884\n564#1:895\n564#1:896,2\n567#1:898,4\n576#1:902,2\n627#1:907,2\n771#1:909,2\n288#1:867\n288#1:868,6\n517#1:885\n517#1:886,6\n550#1:892,3\n578#1:904,3\n159#1:911,3\n*E\n"})
public final class CityStateFunctions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Civilization civInfo;

    public CityStateFunctions(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        this.civInfo = civInfo;
    }

    @NotNull
    public final Civilization getCivInfo() {
        return this.civInfo;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean initCityState(@NotNull Ruleset ruleset, @NotNull String startingEra, @NotNull Sequence<Nation> usedMajorCivs) {
        ArrayList<BaseUnit> possibleUnits;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        TileResource it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        Intrinsics.checkNotNullParameter(startingEra, "startingEra");
        Intrinsics.checkNotNullParameter(usedMajorCivs, "usedMajorCivs");
        Collection<TileResource> collection = ruleset.getTileResources().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (TileResource)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            if (!IHasUniques.hasUnique$default(it, UniqueType.CityStateOnlyResource, null, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (TileResource)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getName());
        }
        List allMercantileResources = (List)destination$iv$iv;
        HashSet uniqueTypes = new HashSet();
        Object v = ((Map)ruleset.getCityStateTypes()).get(this.civInfo.getNation().getCityStateType());
        Intrinsics.checkNotNull(v);
        CityStateType cityStateType = (CityStateType)v;
        CollectionsKt.addAll((Collection)uniqueTypes, SequencesKt.mapNotNull(cityStateType.getFriendBonusUniqueMap().getAllUniques(), CityStateFunctions::initCityState$lambda$2));
        CollectionsKt.addAll((Collection)uniqueTypes, SequencesKt.mapNotNull(cityStateType.getAllyBonusUniqueMap().getAllUniques(), CityStateFunctions::initCityState$lambda$3));
        this.civInfo.setCityStatePersonality((CityStatePersonality)((Object)CollectionsKt.random((Collection)CityStatePersonality.getEntries(), Random.Default)));
        if (uniqueTypes.contains((Object)UniqueType.CityStateUniqueLuxury)) {
            this.civInfo.setCityStateResource((String)CollectionsKt.randomOrNull(allMercantileResources, Random.Default));
        }
        if (uniqueTypes.contains((Object)UniqueType.CityStateMilitaryUnits) && !((Collection)(possibleUnits = CityStateFunctions.initCityState$possibleUnits(ruleset, startingEra, usedMajorCivs))).isEmpty()) {
            this.civInfo.setCityStateUniqueUnit(((BaseUnit)CollectionsKt.random((Collection)possibleUnits, Random.Default)).getName());
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void holdElections() {
        Civilization winner;
        String[] it;
        void $this$filterTo$iv$iv;
        this.civInfo.addFlag("TurnsTillCityStateElection", this.civInfo.getGameInfo().getRuleset().getModOptions().getConstants().getCityStateElectionTurns());
        City city = Civilization.getCapital$default(this.civInfo, false, 1, null);
        if (city == null) {
            return;
        }
        City capital = city;
        Iterable $this$filter$iv = capital.getEspionage().getAllStationedSpies();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String[])element$iv$iv;
            boolean bl = false;
            if (!(it.getAction() == SpyAction.RiggingElections)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List spies = (List)destination$iv$iv;
        if (spies.isEmpty()) {
            return;
        }
        List parties = CollectionsKt.toMutableList(spies);
        parties.add(null);
        float randomSeed = (float)(capital.getLocation().getX() * capital.getLocation().getY()) + 123.0f * (float)this.civInfo.getGameInfo().getTurns();
        Spy spy = CollectionExtensionsKt.randomWeighted(parties, RandomKt.Random((int)randomSeed), arg_0 -> CityStateFunctions.holdElections$lambda$1(this, arg_0));
        Civilization civilization = winner = spy != null ? spy.getCivInfo() : null;
        if (winner == null) {
            for (Spy spy2 : spies) {
                DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(spy2.getCivInfo());
                Intrinsics.checkNotNull(diplomacyManager);
                diplomacyManager.addInfluence(-5.0f);
                String[] stringArray = new String[]{"OtherIcons/Spy"};
                spy2.getCivInfo().addNotification("Your spy lost the election in [" + capital + "]!", capital.getLocation(), Notification.NotificationCategory.Espionage, stringArray);
            }
            return;
        }
        Civilization allyCiv = this.civInfo.getAllyCiv();
        for (Civilization civ : SequencesKt.toList(this.civInfo.getKnownCivs())) {
            String[] stringArray;
            boolean bl;
            block11: {
                float influence = Intrinsics.areEqual(civ, winner) ? 20.0f : -5.0f;
                DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(civ);
                Intrinsics.checkNotNull(diplomacyManager);
                diplomacyManager.addInfluence(influence);
                if (Intrinsics.areEqual(civ, winner)) {
                    it = new String[]{"OtherIcons/Spy"};
                    civ.addNotification("Your spy successfully rigged the election in [" + this.civInfo.getCivName() + "]!", capital.getLocation(), Notification.NotificationCategory.Espionage, it);
                    continue;
                }
                Iterable $this$any$iv = spies;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Spy it2 = (Spy)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(it2.getCivInfo(), civ)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            if (bl) {
                stringArray = new String[]{"OtherIcons/Spy"};
                civ.addNotification("Your spy lost the election in [" + this.civInfo.getCivName() + "] to [" + winner.getCivName() + "]!", capital.getLocation(), Notification.NotificationCategory.Espionage, stringArray);
                continue;
            }
            if (!Intrinsics.areEqual(civ, allyCiv)) continue;
            stringArray = new String[]{"OtherIcons/Spy"};
            allyCiv.addNotification("The election in [" + this.civInfo.getCivName() + "] was rigged by [" + winner.getCivName() + "]!", capital.getLocation(), Notification.NotificationCategory.Espionage, stringArray);
        }
    }

    @Readonly
    public final int turnsForGreatPersonFromCityState() {
        return (int)((float)(37 + Random.Default.nextInt(7)) * this.civInfo.getGameInfo().getSpeed().getModifier());
    }

    /*
     * Unable to fully structure code
     */
    public final void giveGreatPersonToPatron(@NotNull Civilization receivingCiv) {
        Intrinsics.checkNotNullParameter(receivingCiv, "receivingCiv");
        v0 = this.civInfo.getGameInfo().getRuleset().getUnits().values();
        Intrinsics.checkNotNullExpressionValue(v0, "<get-values>(...)");
        $this$filter$iv = v0;
        $i$f$filter = false;
        var5_5 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (BaseUnit)element$iv$iv;
            $i$a$-filter-CityStateFunctions$giveGreatPersonToPatron$giftableUnits$1 = false;
            if (!it.isGreatPerson()) ** GOTO lbl-1000
            Intrinsics.checkNotNull(it);
            if (!IHasUniques.hasUnique$default(it, UniqueType.MayFoundReligion, null, 2, null)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        giftableUnits = (List)destination$iv$iv;
        if (giftableUnits.isEmpty()) {
            return;
        }
        v2 = CollectionsKt.random(giftableUnits, Random.Default);
        Intrinsics.checkNotNullExpressionValue(v2, "random(...)");
        giftedUnit = (BaseUnit)v2;
        v3 = NextTurnAutomation.INSTANCE.getForeignCityNearCapital(Civilization.getCapital$default(this.civInfo, false, 1, null), receivingCiv);
        if (v3 == null || (v3 = v3.getCity()) == null) {
            return;
        }
        city = v3;
        v4 = UnitManager.placeUnitNearTile$default(receivingCiv.getUnits(), city.getLocation().toHexCoord(), giftedUnit, null, null, 12, null);
        if (v4 == null) {
            return;
        }
        placedUnit = v4;
        var7_8 = new HexCoord[2];
        var7_8[0] = placedUnit.getTile().getPosition();
        v5 = Civilization.getCapital$default(this.civInfo, false, 1, null);
        Intrinsics.checkNotNull(v5);
        var7_8[1] = v5.getLocation().toHexCoord();
        locations = LocationAction.Companion.invoke((HexCoord[])var7_8);
        var7_8 = new String[]{this.civInfo.getCivName(), giftedUnit.getName()};
        receivingCiv.addNotification('[' + this.civInfo.getCivName() + "] gave us a [" + giftedUnit.getName() + "] as a gift!", locations, Notification.NotificationCategory.Units, (String[])var7_8);
    }

    public final void giveMilitaryUnitToPatron(@NotNull Civilization receivingCiv) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(receivingCiv, "receivingCiv");
        Object object = NextTurnAutomation.INSTANCE.getForeignCityNearCapital(Civilization.getCapital$default(this.civInfo, false, 1, null), receivingCiv);
        if (object == null || (object = ((NextTurnAutomation.CityDistance)object).getCity()) == null) {
            return;
        }
        Object city = object;
        BaseUnit baseUnit = CityStateFunctions.giveMilitaryUnitToPatron$giftableUniqueUnit(this, receivingCiv);
        if (baseUnit == null && (baseUnit = CityStateFunctions.giveMilitaryUnitToPatron$randomGiftableUnit((City)city, receivingCiv)) == null) {
            return;
        }
        BaseUnit militaryUnit = baseUnit;
        MapUnit mapUnit = receivingCiv.getUnits().placeUnitNearTile(((City)city).getLocation().toHexCoord(), militaryUnit.getName());
        if (mapUnit == null) {
            return;
        }
        MapUnit placedUnit = mapUnit;
        City city2 = Civilization.getCapital$default(this.civInfo, false, 1, null);
        Intrinsics.checkNotNull(city2);
        militaryUnit.addConstructionBonuses(placedUnit, city2.getCityConstructions());
        Iterator iterator2 = Civilization.getMatchingUniques$default(receivingCiv, UniqueType.CityStateGiftedUnitsStartWithXp, null, 2, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            objectArray = placedUnit.getPromotions();
            objectArray.setXP(objectArray.getXP() + Integer.parseInt(unique.getParams().get(0)));
        }
        Sequence<MapUnitAction> unitAction = SequencesKt.sequenceOf(new MapUnitAction(placedUnit));
        objectArray = new HexCoord[]{((City)city).getLocation(), ((City)city).getLocation()};
        Sequence<LocationAction> notificationActions = SequencesKt.plus(unitAction, LocationAction.Companion.invoke((HexCoord[])objectArray));
        objectArray = new String[]{this.civInfo.getCivName(), militaryUnit.getName()};
        receivingCiv.addNotification('[' + this.civInfo.getCivName() + "] gave us a [" + militaryUnit.getName() + "] as gift near [" + ((City)city).getName() + "]!", notificationActions, Notification.NotificationCategory.Units, (String[])objectArray);
    }

    @Readonly
    public final int influenceGainedByGift(@NotNull Civilization donorCiv, int giftAmount) {
        Intrinsics.checkNotNullParameter(donorCiv, "donorCiv");
        float influenceGained = (float)Math.pow(giftAmount, 1.01f) / 9.8f;
        Speed speed = this.civInfo.getGameInfo().getSpeed();
        float gameProgressApproximate = Math.min((float)this.civInfo.getGameInfo().getTurns() / (400.0f * speed.getModifier()), 1.0f);
        influenceGained *= 1.0f - 0.6666667f * gameProgressApproximate;
        influenceGained *= speed.getGoldGiftModifier();
        Iterator iterator2 = Civilization.getMatchingUniques$default(donorCiv, UniqueType.CityStateGoldGiftsProvideMoreInfluence, null, 2, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            influenceGained *= 1.0f + Float.parseFloat(unique.getParams().get(0)) / 100.0f;
        }
        influenceGained *= this.civInfo.getQuestManager().getInvestmentMultiplier(donorCiv);
        if ((influenceGained -= influenceGained % (float)5) < 5.0f) {
            influenceGained = 5.0f;
        }
        return (int)influenceGained;
    }

    public final void receiveGoldGift(@NotNull Civilization donorCiv, int giftAmount) {
        Intrinsics.checkNotNullParameter(donorCiv, "donorCiv");
        if (!this.civInfo.isCityState()) {
            throw new Exception("You can only gain influence with City-States!");
        }
        donorCiv.addGold(-giftAmount);
        this.civInfo.addGold(giftAmount);
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(donorCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        diplomacyManager.addInfluence(this.influenceGainedByGift(donorCiv, giftAmount));
        this.civInfo.getQuestManager().receivedGoldGift(donorCiv);
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    @NotNull
    public final List<Civilization> getProtectorCivs() {
        void $this$mapTo$iv$iv;
        DiplomacyManager it;
        Iterable $this$filterTo$iv$iv;
        if (this.civInfo.isMajorCiv()) {
            return CollectionsKt.emptyList();
        }
        Collection<DiplomacyManager> collection = this.civInfo.getDiplomacy().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DiplomacyManager)element$iv$iv;
            boolean bl = false;
            if (!(!it.getOtherCiv().isDefeated() && it.getDiplomaticStatus() == DiplomaticStatus.Protector)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (DiplomacyManager)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getOtherCiv());
        }
        return (List)destination$iv$iv;
    }

    public final void addProtectorCiv(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        if (!this.otherCivCanPledgeProtection(otherCiv)) {
            return;
        }
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(otherCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager diplomacy = diplomacyManager;
        diplomacy.setDiplomaticStatus(DiplomaticStatus.Protector);
        diplomacy.setFlag(DiplomacyFlags.RecentlyPledgedProtection, 10);
    }

    public final void removeProtectorCiv(@NotNull Civilization otherCiv, boolean forced) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        if (!forced && !this.otherCivCanWithdrawProtection(otherCiv)) {
            return;
        }
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(otherCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager diplomacy = diplomacyManager;
        diplomacy.setDiplomaticStatus(DiplomaticStatus.Peace);
        diplomacy.setFlag(DiplomacyFlags.RecentlyWithdrewProtection, 20);
        diplomacy.addInfluence(-20.0f);
    }

    public static /* synthetic */ void removeProtectorCiv$default(CityStateFunctions cityStateFunctions, Civilization civilization, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        cityStateFunctions.removeProtectorCiv(civilization, bl);
    }

    @Readonly
    public final boolean otherCivCanPledgeProtection(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        if (!this.civInfo.isCityState() || !otherCiv.isMajorCiv() || otherCiv.isDefeated() || !this.civInfo.knows(otherCiv)) {
            return false;
        }
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(otherCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager diplomacy = diplomacyManager;
        if (diplomacy.hasFlag(DiplomacyFlags.RecentlyWithdrewProtection)) {
            return false;
        }
        if (diplomacy.getInfluence() < 0.0f) {
            return false;
        }
        if (this.civInfo.isAtWarWith(otherCiv)) {
            return false;
        }
        return diplomacy.getDiplomaticStatus() != DiplomaticStatus.Protector;
    }

    @Readonly
    public final boolean otherCivCanWithdrawProtection(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        if (!this.civInfo.isCityState() || !otherCiv.isMajorCiv() || otherCiv.isDefeated() || !this.civInfo.knows(otherCiv)) {
            return false;
        }
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(otherCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager diplomacy = diplomacyManager;
        if (diplomacy.hasFlag(DiplomacyFlags.RecentlyPledgedProtection)) {
            return false;
        }
        return diplomacy.getDiplomaticStatus() == DiplomaticStatus.Protector;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateAllyCivForCityState() {
        String text2;
        Map map2;
        Iterator $this$filterTo$iv$iv;
        void $this$filter$iv;
        if (!this.civInfo.isCityState()) {
            return;
        }
        Civilization oldAlly = this.civInfo.getAllyCiv();
        Civilization newAlly = null;
        Map map3 = this.civInfo.getDiplomacy();
        boolean $i$f$filter22 = false;
        void var6_6 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!(((DiplomacyManager)it.getValue()).getOtherCiv().isMajorCiv() && !((DiplomacyManager)it.getValue()).getOtherCiv().isDefeated())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Object $i$f$filter22 = (String[])destination$iv$iv.entrySet();
        $this$filterTo$iv$iv = $i$f$filter22.iterator();
        if (!$this$filterTo$iv$iv.hasNext()) {
            map2 = null;
        } else {
            destination$iv$iv = $this$filterTo$iv$iv.next();
            if (!$this$filterTo$iv$iv.hasNext()) {
                map2 = destination$iv$iv;
            } else {
                Map.Entry it22 = (Map.Entry)((Object)destination$iv$iv);
                boolean bl2 = false;
                float it22 = ((DiplomacyManager)it22.getValue()).getInfluence();
                do {
                    Object bl2 = $this$filterTo$iv$iv.next();
                    Map.Entry it32 = (Map.Entry)bl2;
                    boolean $i$a$-maxByOrNull-CityStateFunctions$updateAllyCivForCityState$maxInfluence$3 = false;
                    float it32 = ((DiplomacyManager)it32.getValue()).getInfluence();
                    if (Float.compare(it22, it32) >= 0) continue;
                    destination$iv$iv = bl2;
                    it22 = it32;
                } while ($this$filterTo$iv$iv.hasNext());
                map2 = destination$iv$iv;
            }
        }
        Map.Entry maxInfluence = (Map.Entry)((Object)map2);
        if (maxInfluence != null && ((DiplomacyManager)maxInfluence.getValue()).getInfluence() >= 60.0f) {
            newAlly = ((DiplomacyManager)maxInfluence.getValue()).getOtherCiv();
        }
        if (Intrinsics.areEqual(oldAlly, newAlly)) {
            return;
        }
        this.civInfo.setAllyCiv(newAlly);
        if (newAlly != null) {
            void $this$filterTo$iv$iv2;
            text2 = "We have allied with [" + this.civInfo.getCivName() + "].";
            $i$f$filter22 = new String[]{this.civInfo.getCivName(), "OtherIcons/Diplomacy"};
            newAlly.addNotification(text2, this.getNotificationActions(), Notification.NotificationCategory.Diplomacy, (String[])$i$f$filter22);
            CivInfoTransientCache.updateViewableTiles$default(newAlly.getCache(), null, 1, null);
            newAlly.getCache().updateCivResources();
            $i$f$filter22 = Civilization.getMatchingUniques$default(newAlly, UniqueType.CityStateCanBeBoughtForGold, null, 2, null).iterator();
            while ($i$f$filter22.hasNext()) {
                Unique unique = (Unique)$i$f$filter22.next();
                DiplomacyManager diplomacyManager = newAlly.getDiplomacyManager(this.civInfo);
                Intrinsics.checkNotNull(diplomacyManager);
                diplomacyManager.setFlag(DiplomacyFlags.MarriageCooldown, Integer.parseInt(unique.getParams().get(0)));
            }
            Iterable $this$filter$iv2 = this.civInfo.getGameInfo().getCivilizations();
            boolean $i$f$filter = false;
            Iterable it22 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                Civilization it = (Civilization)element$iv$iv;
                boolean bl = false;
                if (!(it.isAtWarWith(newAlly) && it.isAlive())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            for (Civilization newEnemy : (List)destination$iv$iv2) {
                if (this.civInfo.isAtWarWith(newEnemy)) continue;
                if (!this.civInfo.knows(newEnemy)) {
                    this.civInfo.getDiplomacyFunctions().makeCivilizationsMeet(newEnemy, true);
                }
                DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(newEnemy);
                Intrinsics.checkNotNull(diplomacyManager);
                diplomacyManager.declareWar(new DeclareWarReason(WarType.CityStateAllianceWar, newAlly));
            }
        }
        if (oldAlly != null && this.civInfo.isAlive()) {
            text2 = "We have lost alliance with [" + this.civInfo.getCivName() + "].";
            $i$f$filter22 = new String[]{this.civInfo.getCivName(), "OtherIcons/Diplomacy"};
            oldAlly.addNotification(text2, this.getNotificationActions(), Notification.NotificationCategory.Diplomacy, (String[])$i$f$filter22);
            if (newAlly != null && oldAlly.knows(newAlly)) {
                DiplomacyManager diplomacyManager = oldAlly.getDiplomacyManager(newAlly);
                Intrinsics.checkNotNull(diplomacyManager);
                DiplomacyManager diplomacyManager2 = diplomacyManager;
                diplomacyManager2.addModifier(DiplomaticModifiers.StoleOurAlly, -10.0f);
            }
            CivInfoTransientCache.updateViewableTiles$default(oldAlly.getCache(), null, 1, null);
            oldAlly.getCache().updateCivResources();
        }
    }

    @Readonly
    @NotNull
    public final Sequence<NotificationAction> getNotificationActions() {
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super NotificationAction>, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ CityStateFunctions this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (SequenceScope)this.L$0;
                var4_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        capital = Civilization.getCapital$default(this.this$0.getCivInfo(), false, 1, null);
                        if (capital != null) {
                            this.L$0 = $this$sequence;
                            this.L$1 = SpillingKt.nullOutSpilledVariable(capital);
                            this.label = 1;
                            v0 = $this$sequence.yield(new LocationAction(capital.getLocation()), this);
                            if (v0 == var4_3) {
                                return var4_3;
                            }
                        }
                        ** GOTO lbl19
                    }
                    case 1: {
                        capital = (City)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl19:
                        // 2 sources

                        this.L$0 = SpillingKt.nullOutSpilledVariable($this$sequence);
                        this.L$1 = SpillingKt.nullOutSpilledVariable(capital);
                        this.label = 2;
                        v1 = $this$sequence.yield(new DiplomacyAction(this.this$0.getCivInfo(), false, 2, null), this);
                        if (v1 == var4_3) {
                            return var4_3;
                        }
                        ** GOTO lbl30
                    }
                    case 2: {
                        capital = (City)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl30:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super NotificationAction>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super NotificationAction> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @Readonly
    public final int getDiplomaticMarriageCost() {
        int cost = (int)((float)500 * this.civInfo.getGameInfo().getSpeed().getGoldCostModifier());
        Iterator<MapUnit> iterator2 = this.civInfo.getUnits().getCivUnits().iterator();
        while (iterator2.hasNext()) {
            MapUnit unit = iterator2.next();
            cost += unit.getBaseUnit().getDisbandGold(this.civInfo);
        }
        cost /= 5;
        return cost *= 5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Readonly
    public final boolean canBeMarriedBy(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        if (this.civInfo.isDefeated()) return false;
        if (!this.civInfo.isCityState()) return false;
        if (!CollectionsKt.any((Iterable)this.civInfo.getCities())) return false;
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(otherCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        if (!diplomacyManager.isRelationshipLevelEQ(RelationshipLevel.Ally)) return false;
        DiplomacyManager diplomacyManager2 = otherCiv.getDiplomacyManager(this.civInfo);
        Intrinsics.checkNotNull(diplomacyManager2);
        if (diplomacyManager2.hasFlag(DiplomacyFlags.MarriageCooldown)) return false;
        if (!SequencesKt.any(Civilization.getMatchingUniques$default(otherCiv, UniqueType.CityStateCanBeBoughtForGold, null, 2, null))) return false;
        if (otherCiv.getGold() < this.getDiplomaticMarriageCost()) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void diplomaticMarriage(@NotNull Civilization otherCiv) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        if (!this.canBeMarriedBy(otherCiv)) {
            return;
        }
        otherCiv.addGold(-this.getDiplomaticMarriageCost());
        City city = Civilization.getCapital$default(this.civInfo, false, 1, null);
        Intrinsics.checkNotNull(city);
        HexCoord notificationLocation = city.getLocation();
        Object object = new String[]{this.civInfo.getCivName(), "OtherIcons/Diplomacy", otherCiv.getCivName()};
        otherCiv.addNotification("We have married into the ruling family of [" + this.civInfo.getCivName() + "], bringing them under our control.", notificationLocation, Notification.NotificationCategory.Diplomacy, (String[])object);
        Iterable $this$filter$iv = this.civInfo.getGameInfo().getCivilizations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it, otherCiv))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Civilization civ : (List)destination$iv$iv) {
            String[] stringArray = new String[]{this.civInfo.getCivName(), "OtherIcons/Diplomacy", otherCiv.getCivName()};
            civ.addNotification('[' + otherCiv.getCivName() + "] has married into the ruling family of [" + this.civInfo.getCivName() + "], bringing them under their control.", notificationLocation, Notification.NotificationCategory.Diplomacy, stringArray);
        }
        object = this.civInfo.getUnits().getCivUnits().iterator();
        while (object.hasNext()) {
            MapUnit unit = (MapUnit)object.next();
            unit.gift(otherCiv);
        }
        object = SequencesKt.filter(this.civInfo.getGameInfo().getCities(), arg_0 -> CityStateFunctions.diplomaticMarriage$lambda$1(this, arg_0)).iterator();
        while (object.hasNext()) {
            City it = (City)object.next();
            it.setFoundingCivObject(null);
            it.setOriginalCapital(false);
        }
        for (City city2 : this.civInfo.getCities()) {
            city2.getEspionage().removeAllPresentSpies(SpyFleeReason.CityTakenOverByMarriage);
            city2.moveToCiv(otherCiv);
            city2.setPuppet(true);
        }
        this.civInfo.destroy(notificationLocation.toHexCoord());
    }

    @Readonly
    public final int getTributeWillingness(@NotNull Civilization demandingCiv, boolean demandingWorker) {
        Intrinsics.checkNotNullParameter(demandingCiv, "demandingCiv");
        Collection collection = CityStateFunctions.getTributeModifiers$default(this, demandingCiv, demandingWorker, false, 4, null).values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return CollectionsKt.sumOfInt(collection);
    }

    public static /* synthetic */ int getTributeWillingness$default(CityStateFunctions cityStateFunctions, Civilization civilization, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return cityStateFunctions.getTributeWillingness(civilization, bl);
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    @NotNull
    public final HashMap<String, Integer> getTributeModifiers(@NotNull Civilization demandingCiv, boolean demandingWorker, boolean requireWholeList) {
        int n;
        int n2;
        Tile tile;
        Object object;
        Sequence<Tile> inRangeTiles;
        Integer recentBullying;
        boolean bl;
        LinkedHashMap modifiers;
        block25: {
            Intrinsics.checkNotNullParameter(demandingCiv, "demandingCiv");
            modifiers = new LinkedHashMap();
            if (!this.civInfo.isCityState()) {
                ((Map)modifiers).put("Major Civ", -999);
                return modifiers;
            }
            if (this.civInfo.getCities().isEmpty() || Civilization.getCapital$default(this.civInfo, false, 1, null) == null) {
                ((Map)modifiers).put("No Cities", -999);
                return modifiers;
            }
            ((Map)modifiers).put("Base value", -110);
            if (this.civInfo.getCityStatePersonality() == CityStatePersonality.Hostile) {
                ((Map)modifiers).put("Hostile", -10);
            }
            if (this.civInfo.getAllyCiv() != null && !Intrinsics.areEqual(this.civInfo.getAllyCiv(), demandingCiv)) {
                ((Map)modifiers).put("Has Ally", -10);
            }
            Iterable $this$any$iv = this.getProtectorCivs();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Civilization it = (Civilization)element$iv;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual(it, demandingCiv))) continue;
                    bl = true;
                    break block25;
                }
                bl = false;
            }
        }
        if (bl) {
            ((Map)modifiers).put("Has Protector", -20);
        }
        if (demandingWorker) {
            ((Map)modifiers).put("Demanding a Worker", -30);
        }
        if (demandingWorker) {
            City city = Civilization.getCapital$default(this.civInfo, false, 1, null);
            Intrinsics.checkNotNull(city);
            if (city.getPopulation().getPopulation() < 4) {
                ((Map)modifiers).put("Demanding a Worker from small City-State", -300);
            }
        }
        if ((recentBullying = this.civInfo.getRecentBullyingCountdown()) != null && recentBullying > 10) {
            ((Map)modifiers).put("Very recently paid tribute", -300);
        } else if (recentBullying != null && recentBullying > 0) {
            ((Map)modifiers).put("Recently paid tribute", -40);
        }
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(demandingCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        if (diplomacyManager.getInfluence() < -30.0f) {
            ((Map)modifiers).put("Influence below -30", -300);
        }
        if (!requireWholeList) {
            Collection collection = modifiers.values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            if (CollectionsKt.sumOfInt(collection) < -200) {
                return modifiers;
            }
        }
        Iterable $this$sortedByDescending$iv = this.civInfo.getGameInfo().getAliveMajorCivs();
        boolean $i$f$sortedByDescending = false;
        int forceRank = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Civilization it = (Civilization)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getStatForRanking(RankingType.Force));
                it = (Civilization)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getStatForRanking(RankingType.Force));
            }
        }).indexOf(demandingCiv);
        int numAlivePlayers = Math.max(this.civInfo.getGameInfo().getAliveMajorCivs().size(), 1);
        int globalModifier = this.civInfo.getGameInfo().getRuleset().getModOptions().getConstants().getTributeGlobalModifier();
        ((Map)modifiers).put("Military Rank", globalModifier * (numAlivePlayers - forceRank) / numAlivePlayers);
        if (!requireWholeList) {
            Collection collection = modifiers.values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            if (CollectionsKt.sumOfInt(collection) < -100) {
                return modifiers;
            }
        }
        int bullyRange = RangesKt.coerceIn(this.civInfo.getGameInfo().getTileMap().getTileMatrix().size() / 10, 5, 10);
        City city = Civilization.getCapital$default(this.civInfo, false, 1, null);
        Intrinsics.checkNotNull(city);
        Sequence<Tile> sequence = inRangeTiles = city.getCenterTile().getTilesInDistanceRange(new IntRange(1, bullyRange));
        int n3 = 0;
        Iterator<Tile> iterator2 = sequence.iterator();
        while (iterator2.hasNext()) {
            int n4;
            void it;
            object = iterator2.next();
            tile = object;
            n2 = n3;
            boolean bl3 = false;
            MapUnit mapUnit = it.getMilitaryUnit();
            if (Intrinsics.areEqual(mapUnit != null ? mapUnit.getCiv() : null, demandingCiv)) {
                MapUnit mapUnit2 = it.getMilitaryUnit();
                Intrinsics.checkNotNull(mapUnit2);
                n4 = mapUnit2.getForceEvaluation();
            } else {
                n4 = 0;
            }
            n = n4;
            n3 = n2 + n;
        }
        int forceNearCity = n3;
        City city2 = Civilization.getCapital$default(this.civInfo, false, 1, null);
        Intrinsics.checkNotNull(city2);
        Sequence<Tile> sequence2 = inRangeTiles;
        n2 = (int)Math.pow(ICombatant.getDefendingStrength$default(new CityCombatant(city2), null, 1, null), 1.5f);
        int n5 = 0;
        object = sequence2.iterator();
        while (object.hasNext()) {
            int n6;
            void it;
            Tile bl3 = tile = object.next();
            n = n5;
            boolean bl4 = false;
            MapUnit mapUnit = it.getMilitaryUnit();
            if (Intrinsics.areEqual(mapUnit != null ? mapUnit.getCiv() : null, this.civInfo)) {
                MapUnit mapUnit3 = it.getMilitaryUnit();
                Intrinsics.checkNotNull(mapUnit3);
                n6 = mapUnit3.getForceEvaluation();
            } else {
                n6 = 0;
            }
            int n7 = n6;
            n5 = n + n7;
        }
        n = n5;
        int csForce = n2 + n;
        float forceRatio = (float)forceNearCity / (float)csForce;
        int localModifier = this.civInfo.getGameInfo().getRuleset().getModOptions().getConstants().getTributeLocalModifier();
        ((Map)modifiers).put("Military near City-State", forceRatio > 3.0f ? localModifier : (forceRatio > 2.0f ? localModifier * 4 / 5 : (forceRatio > 1.5f ? localModifier * 3 / 5 : (forceRatio > 1.0f ? localModifier * 2 / 5 : (forceRatio > 0.5f ? localModifier / 5 : 0)))));
        return modifiers;
    }

    public static /* synthetic */ HashMap getTributeModifiers$default(CityStateFunctions cityStateFunctions, Civilization civilization, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return cityStateFunctions.getTributeModifiers(civilization, bl, bl2);
    }

    @Readonly
    public final int goldGainedByTribute() {
        int gold = (int)((float)10 * this.civInfo.getGameInfo().getSpeed().getGoldGiftModifier()) * 5;
        float turnsToIncrement = this.civInfo.getGameInfo().getSpeed().getCityStateTributeScalingInterval();
        return gold += 5 * (int)((float)this.civInfo.getGameInfo().getTurns() / turnsToIncrement);
    }

    public final void tributeGold(@NotNull Civilization demandingCiv) {
        Intrinsics.checkNotNullParameter(demandingCiv, "demandingCiv");
        if (!this.civInfo.isCityState()) {
            throw new Exception("You can only demand gold from City-States!");
        }
        int goldAmount = this.goldGainedByTribute();
        demandingCiv.addGold(goldAmount);
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(demandingCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        diplomacyManager.addInfluence(-15.0f);
        this.cityStateBullied(demandingCiv);
        this.civInfo.addFlag("RecentlyBullied", 20);
    }

    /*
     * WARNING - void declaration
     */
    public final void tributeWorker(@NotNull Civilization demandingCiv) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(demandingCiv, "demandingCiv");
        if (!this.civInfo.isCityState()) {
            throw new Exception("You can only demand workers from City-States!");
        }
        Map $this$filter$iv = this.civInfo.getGameInfo().getRuleset().getUnits();
        boolean $i$f$filter = false;
        Map map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!(IHasUniques.hasUnique$default((IHasUniques)it.getValue(), UniqueType.BuildImprovements, null, 2, null) && ((BaseUnit)it.getValue()).isCivilian() && ((BaseUnit)it.getValue()).isBuildable(this.civInfo))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map buildableWorkerLikeUnits = destination$iv$iv;
        if (buildableWorkerLikeUnits.isEmpty()) {
            return;
        }
        UnitManager unitManager = demandingCiv.getUnits();
        City city = Civilization.getCapital$default(this.civInfo, false, 1, null);
        Intrinsics.checkNotNull(city);
        UnitManager.placeUnitNearTile$default(unitManager, city.getLocation().toHexCoord(), (BaseUnit)CollectionsKt.random(buildableWorkerLikeUnits.values(), Random.Default), null, null, 12, null);
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(demandingCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        diplomacyManager.addInfluence(-50.0f);
        this.cityStateBullied(demandingCiv);
        this.civInfo.addFlag("RecentlyBullied", 20);
    }

    @Readonly
    public final boolean canProvideStat(@NotNull Stat statType) {
        Intrinsics.checkNotNullParameter(statType, "statType");
        if (!this.civInfo.isCityState()) {
            return false;
        }
        Iterator iterator2 = com.unciv.logic.civilization.diplomacy.CityStateFunctions$Companion.getCityStateBonuses$default(Companion, this.civInfo.getCityStateType(), RelationshipLevel.Ally, null, 4, null).iterator();
        while (iterator2.hasNext()) {
            Unique bonus = (Unique)iterator2.next();
            if (!(bonus.getStats().get(statType) > 0.0f)) continue;
            return true;
        }
        return false;
    }

    public final void updateDiplomaticRelationshipForCityState() {
        if (this.getNumThreateningBarbarians() > 0) {
            return;
        }
        for (Civilization otherCiv : SequencesKt.toList(SequencesKt.filter(this.civInfo.getKnownCivs(), CityStateFunctions::updateDiplomaticRelationshipForCityState$lambda$0))) {
            DiplomacyManager diplomacy;
            if (this.civInfo.isAtWarWith(otherCiv) || Civilization.hasUnique$default(otherCiv, UniqueType.CityStateTerritoryAlwaysFriendly, null, 2, null)) continue;
            Intrinsics.checkNotNull(this.civInfo.getDiplomacyManager(otherCiv));
            if (diplomacy.hasFlag(DiplomacyFlags.AngerFreeIntrusion)) continue;
            Sequence<MapUnit> $this$count$iv = otherCiv.getUnits().getCivUnits();
            boolean $i$f$count = false;
            int count$iv = 0;
            Iterator<MapUnit> iterator2 = $this$count$iv.iterator();
            while (iterator2.hasNext()) {
                MapUnit element$iv;
                MapUnit it = element$iv = iterator2.next();
                boolean bl = false;
                if (!(!it.isCivilian() && Intrinsics.areEqual(it.getTile().getOwner(), this.civInfo)) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            int unitsInBorder = count$iv;
            if (unitsInBorder <= 0 || !diplomacy.isRelationshipLevelLT(RelationshipLevel.Friend)) continue;
            diplomacy.addInfluence(-10.0f);
            if (diplomacy.hasFlag(DiplomacyFlags.BorderConflict)) continue;
            otherCiv.getPopupAlerts().add(new PopupAlert(AlertType.BorderConflict, this.civInfo.getCivID()));
            diplomacy.setFlag(DiplomacyFlags.BorderConflict, 10);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void getFreeTechForCityState() {
        void $this$filterTo$iv$iv;
        Collection<Technology> collection = this.civInfo.getGameInfo().getRuleset().getTechnologies().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Technology it = (Technology)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            if (!(!IHasUniques.hasUnique$default(it, UniqueType.ResearchableMultipleTimes, null, 2, null) && this.civInfo.getTech().canBeResearched(it.getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List researchableTechs = (List)destination$iv$iv;
        for (Object e : researchableTechs) {
            int n;
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            Technology tech = (Technology)e;
            List<Civilization> aliveMajorCivs = this.civInfo.getGameInfo().getAliveMajorCivs();
            Iterable $this$count$iv = aliveMajorCivs;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Civilization it = (Civilization)element$iv;
                    boolean bl = false;
                    if (!it.getTech().isResearched(tech.getName()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            if (n <= aliveMajorCivs.size() / 2) continue;
            TechManager.addTechnology$default(this.civInfo.getTech(), tech.getName(), false, 2, null);
        }
    }

    @Readonly
    public final int getNumThreateningBarbarians() {
        Object v0;
        IsPartOfGameInfoSerialization it;
        block4: {
            if (this.civInfo.getGameInfo().getGameParameters().getNoBarbarians()) {
                return 0;
            }
            Iterable $this$firstOrNull$iv = this.civInfo.getGameInfo().getCivilizations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (Civilization)element$iv;
                boolean bl = false;
                if (!((Civilization)it).isBarbarian()) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        Civilization civilization = v0;
        if (civilization == null) {
            return 0;
        }
        Civilization barbarianCiv = civilization;
        Sequence<MapUnit> $this$count$iv = barbarianCiv.getUnits().getCivUnits();
        boolean $i$f$count = false;
        int count$iv = 0;
        Iterator<Object> iterator2 = $this$count$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            element$iv = iterator2.next();
            it = (MapUnit)element$iv;
            boolean bl = false;
            if (!((MapUnit)it).threatensCiv(this.civInfo) || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        return count$iv;
    }

    public final void threateningBarbarianKilledBy(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(otherCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager diplomacy = diplomacyManager;
        if (diplomacy.getDiplomaticStatus() == DiplomaticStatus.War) {
            return;
        }
        diplomacy.addInfluence(12.0f);
        if (diplomacy.hasFlag(DiplomacyFlags.AngerFreeIntrusion)) {
            diplomacy.setFlag(DiplomacyFlags.AngerFreeIntrusion, diplomacy.getFlag(DiplomacyFlags.AngerFreeIntrusion) + 5);
        } else {
            diplomacy.setFlag(DiplomacyFlags.AngerFreeIntrusion, 5);
        }
        String[] stringArray = new String[]{this.civInfo.getCivName()};
        otherCiv.addNotification('[' + this.civInfo.getCivName() + "] is grateful that you killed a Barbarian that was threatening them!", new DiplomacyAction(this.civInfo, false, 2, null), Notification.NotificationCategory.Diplomacy, stringArray);
    }

    private final void cityStateBullied(Civilization bully) {
        if (!this.civInfo.isCityState()) {
            return;
        }
        for (Civilization protector : this.civInfo.getCityStateFunctions().getProtectorCivs()) {
            DiplomacyManager protectorDiplomacy;
            if (!protector.knows(bully)) continue;
            Intrinsics.checkNotNull(protector.getDiplomacyManager(bully));
            if (protectorDiplomacy.hasModifier(DiplomaticModifiers.BulliedProtectedMinor) && protectorDiplomacy.getFlag(DiplomacyFlags.RememberBulliedProtectedMinor) > 50) {
                protectorDiplomacy.addModifier(DiplomaticModifiers.BulliedProtectedMinor, -10.0f);
            } else {
                protectorDiplomacy.addModifier(DiplomaticModifiers.BulliedProtectedMinor, -15.0f);
            }
            protectorDiplomacy.setFlag(DiplomacyFlags.RememberBulliedProtectedMinor, 75);
            if (protector.getPlayerType() != PlayerType.Human) {
                String[] stringArray = new String[]{"OtherIcons/Diplomacy", protector.getCivName()};
                bully.addNotification('[' + protector.getCivName() + "] is upset that you demanded tribute from [" + this.civInfo.getCivName() + "], whom they have pledged to protect!", Notification.NotificationCategory.Diplomacy, stringArray);
                continue;
            }
            protector.getPopupAlerts().add(new PopupAlert(AlertType.BulliedProtectedMinor, bully.getCivName() + '@' + this.civInfo.getCivName()));
        }
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(bully);
        Intrinsics.checkNotNull(diplomacyManager);
        diplomacyManager.setFlag(DiplomacyFlags.Bullied, 20);
        Iterable $this$forEach$iv = this.civInfo.getGameInfo().getAliveCityStates();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Civilization it = (Civilization)element$iv;
            boolean bl = false;
            it.getQuestManager().cityStateBullied(this.civInfo, bully);
        }
    }

    public final void cityStateAttacked(@NotNull Civilization attacker) {
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        if (!this.civInfo.isCityState()) {
            return;
        }
        if (attacker.isCityState()) {
            return;
        }
        if (attacker.isMinorCivWarmonger()) {
            DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(attacker);
            Intrinsics.checkNotNull(diplomacyManager);
            diplomacyManager.becomeWary();
        } else if (attacker.isMinorCivAggressor() && Random.Default.nextBoolean()) {
            DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(attacker);
            Intrinsics.checkNotNull(diplomacyManager);
            diplomacyManager.becomeWary();
        }
        if (attacker.isMinorCivAggressor()) {
            this.makeOtherCityStatesWaryOfAttacker(attacker);
        }
        this.triggerProtectorCivs(attacker);
        this.triggerAllyCivs(attacker);
        this.civInfo.getQuestManager().wasAttackedBy(attacker);
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(attacker);
        Intrinsics.checkNotNull(diplomacyManager);
        diplomacyManager.setFlag(DiplomacyFlags.RecentlyAttacked, 2);
    }

    private final void makeOtherCityStatesWaryOfAttacker(Civilization attacker) {
        for (Civilization cityState : this.civInfo.getGameInfo().getAliveCityStates()) {
            int probability;
            int n;
            if (Intrinsics.areEqual(cityState, this.civInfo) || Intrinsics.areEqual(cityState.getAllyCiv(), attacker) || !cityState.knows(attacker) || cityState.getQuestManager().wantsDead(this.civInfo.getCivID())) continue;
            if (attacker.isMinorCivWarmonger()) {
                switch (WhenMappings.$EnumSwitchMapping$0[cityState.getProximity(attacker).ordinal()]) {
                    case 1: {
                        n = 100;
                        break;
                    }
                    case 2: {
                        n = 75;
                        break;
                    }
                    case 3: {
                        n = 50;
                        break;
                    }
                    case 4: {
                        n = 25;
                        break;
                    }
                    default: {
                        n = 0;
                        break;
                    }
                }
            } else {
                switch (WhenMappings.$EnumSwitchMapping$0[cityState.getProximity(attacker).ordinal()]) {
                    case 1: {
                        n = 50;
                        break;
                    }
                    case 2: {
                        n = 20;
                        break;
                    }
                    default: {
                        n = probability = 0;
                    }
                }
            }
            if (cityState.isAtWarWith(attacker)) {
                probability += 50;
            }
            if (Random.Default.nextInt(100) > probability) continue;
            DiplomacyManager diplomacyManager = cityState.getDiplomacyManager(attacker);
            Intrinsics.checkNotNull(diplomacyManager);
            diplomacyManager.becomeWary();
        }
    }

    private final void triggerProtectorCivs(Civilization attacker) {
        for (Civilization protector : this.civInfo.getCityStateFunctions().getProtectorCivs()) {
            DiplomacyManager protectorDiplomacy;
            if (protector.getDiplomacyManager(attacker) == null) continue;
            if (protectorDiplomacy.hasModifier(DiplomaticModifiers.AttackedProtectedMinor) && protectorDiplomacy.getFlag(DiplomacyFlags.RememberAttackedProtectedMinor) > 50) {
                protectorDiplomacy.addModifier(DiplomaticModifiers.AttackedProtectedMinor, -15.0f);
            } else {
                protectorDiplomacy.addModifier(DiplomaticModifiers.AttackedProtectedMinor, -20.0f);
            }
            protectorDiplomacy.setFlag(DiplomacyFlags.RememberAttackedProtectedMinor, 75);
            if (protector.getPlayerType() != PlayerType.Human) {
                String[] stringArray = new String[]{"OtherIcons/Diplomacy", protector.getCivName()};
                attacker.addNotification('[' + protector.getCivName() + "] is upset that you attacked [" + this.civInfo.getCivName() + "], whom they have pledged to protect!", Notification.NotificationCategory.Diplomacy, stringArray);
                continue;
            }
            protector.getPopupAlerts().add(new PopupAlert(AlertType.AttackedProtectedMinor, attacker.getCivName() + '@' + this.civInfo.getCivName()));
        }
    }

    private final void triggerAllyCivs(Civilization attacker) {
        Civilization allyCiv = this.civInfo.getAllyCiv();
        if (allyCiv != null && !this.civInfo.getCityStateFunctions().getProtectorCivs().contains(allyCiv) && allyCiv.knows(attacker)) {
            DiplomacyManager diplomacyManager = allyCiv.getDiplomacyManager(attacker);
            Intrinsics.checkNotNull(diplomacyManager);
            DiplomacyManager allyDiplomacy = diplomacyManager;
            allyDiplomacy.addModifier(DiplomaticModifiers.AttackedAlliedMinor, -10.0f);
            if (allyCiv.getPlayerType() != PlayerType.Human) {
                String[] stringArray = new String[]{"OtherIcons/Diplomacy", allyCiv.getCivName()};
                attacker.addNotification('[' + allyCiv.getCivName() + "] is upset that you attacked [" + this.civInfo.getCivName() + "], whom they are allied with!", Notification.NotificationCategory.Diplomacy, stringArray);
            } else {
                allyCiv.getPopupAlerts().add(new PopupAlert(AlertType.AttackedAllyMinor, attacker.getCivName() + '@' + this.civInfo.getCivName()));
            }
        }
    }

    public final void cityStateDestroyed(@NotNull Civilization attacker) {
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        if (!this.civInfo.isCityState()) {
            return;
        }
        for (Civilization protector : this.civInfo.getCityStateFunctions().getProtectorCivs()) {
            String[] stringArray;
            DiplomacyManager protectorDiplomacy;
            if (!protector.knows(attacker)) continue;
            Intrinsics.checkNotNull(protector.getDiplomacyManager(attacker));
            if (protectorDiplomacy.hasModifier(DiplomaticModifiers.DestroyedProtectedMinor)) {
                protectorDiplomacy.addModifier(DiplomaticModifiers.DestroyedProtectedMinor, -10.0f);
            } else {
                protectorDiplomacy.addModifier(DiplomaticModifiers.DestroyedProtectedMinor, -40.0f);
            }
            protectorDiplomacy.setFlag(DiplomacyFlags.RememberDestroyedProtectedMinor, 125);
            if (protector.getPlayerType() != PlayerType.Human) {
                stringArray = new String[]{"OtherIcons/Diplomacy", protector.getCivName()};
                attacker.addNotification('[' + protector.getCivName() + "] is outraged that you destroyed [" + this.civInfo.getCivName() + "], whom they had pledged to protect!", Notification.NotificationCategory.Diplomacy, stringArray);
            }
            stringArray = new String[]{attacker.getCivName(), "OtherIcons/DisbandUnit", this.civInfo.getCivName()};
            protector.addNotification('[' + attacker.getCivName() + "] has destroyed [" + this.civInfo.getCivName() + "], whom you had pledged to protect!", Notification.NotificationCategory.Diplomacy, stringArray);
        }
        Iterable $this$forEach$iv = this.civInfo.getGameInfo().getAliveCityStates();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Civilization it = (Civilization)element$iv;
            boolean bl = false;
            it.getQuestManager().cityStateConquered(this.civInfo, attacker);
        }
    }

    public final void askForUnitGifts(@NotNull Civilization attacker) {
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        if (attacker.isDefeated() || this.civInfo.isDefeated()) {
            return;
        }
        if (this.civInfo.getCities().isEmpty()) {
            return;
        }
        Iterator<Civilization> iterator2 = SequencesKt.filter(this.civInfo.getKnownCivs(), arg_0 -> CityStateFunctions.askForUnitGifts$lambda$0(attacker, arg_0)).iterator();
        while (iterator2.hasNext()) {
            Civilization thirdCiv = iterator2.next();
            String string = '[' + this.civInfo.getCivName() + "] is being attacked by [" + attacker.getCivName() + "] and asks all major civilizations to help them out by gifting them military units.";
            City city = Civilization.getCapital$default(this.civInfo, false, 1, null);
            Intrinsics.checkNotNull(city);
            String[] stringArray = new String[]{this.civInfo.getCivName(), "OtherIcons/Present"};
            thirdCiv.addNotification(string, city.getLocation(), Notification.NotificationCategory.Diplomacy, stringArray);
        }
    }

    @Readonly
    @NotNull
    public final ResourceSupplyList getCityStateResourcesForAlly() {
        ResourceSupplyList resourceSupplyList = new ResourceSupplyList(false, 1, null);
        for (City city : this.civInfo.getCities()) {
            resourceSupplyList.addPositiveByResource(city.getResourcesGeneratedByCity(city.getResourceModifiers()), "City-States");
        }
        return resourceSupplyList;
    }

    @Readonly
    @NotNull
    public final Sequence<Unique> getUniquesProvidedByCityStates(@NotNull UniqueType uniqueType, @NotNull GameContext gameContext) {
        Intrinsics.checkNotNullParameter((Object)uniqueType, "uniqueType");
        Intrinsics.checkNotNullParameter(gameContext, "gameContext");
        if (this.civInfo.isCityState()) {
            return SequencesKt.emptySequence();
        }
        return SequencesKt.flatMap(SequencesKt.filter(SequencesKt.flatMap(SequencesKt.filter(this.civInfo.getKnownCivs(), CityStateFunctions::getUniquesProvidedByCityStates$lambda$0), arg_0 -> CityStateFunctions.getUniquesProvidedByCityStates$lambda$1(this, uniqueType, arg_0)), arg_0 -> CityStateFunctions.getUniquesProvidedByCityStates$lambda$2(gameContext, arg_0)), arg_0 -> CityStateFunctions.getUniquesProvidedByCityStates$lambda$3(gameContext, arg_0));
    }

    private static final UniqueType initCityState$lambda$2(Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getType();
    }

    private static final UniqueType initCityState$lambda$3(Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getType();
    }

    private static final ArrayList<BaseUnit> initCityState$possibleUnits(Ruleset $ruleset, String $startingEra, Sequence<Nation> $usedMajorCivs) {
        ArrayList<BaseUnit> units = new ArrayList<BaseUnit>();
        Iterator<BaseUnit> iterator2 = $ruleset.getUnits().values().iterator();
        while (iterator2.hasNext()) {
            Nation uniqueNation;
            BaseUnit unit;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            if (unit.availableInEra($ruleset, $startingEra) || (uniqueNation = (Nation)((Map)$ruleset.getNations()).get(unit.getUniqueTo())) == null || !uniqueNation.isMajorCiv() || SequencesKt.contains($usedMajorCivs, uniqueNation)) continue;
            UnitType unitType = $ruleset.getUnitTypes().get(unit.getUnitType());
            Intrinsics.checkNotNull(unitType);
            if (!unitType.isLandUnit() || unit.getStrength() <= 0 && unit.getRangedStrength() <= 0) continue;
            units.add(unit);
        }
        return units;
    }

    private static final float holdElections$getVotesFromSpy(CityStateFunctions this$0, Spy spy) {
        if (spy == null) {
            return 20.0f;
        }
        float votes = this$0.civInfo.getDiplomacyManagerOrMeet(spy.getCivInfo()).getInfluence$core() / (float)2;
        return votes += (float)((double)spy.getSkillModifierPercent() * spy.getEfficiencyModifier());
    }

    private static final float holdElections$lambda$1(CityStateFunctions this$0, Spy it) {
        return CityStateFunctions.holdElections$getVotesFromSpy(this$0, it);
    }

    @Readonly
    private static final BaseUnit giveMilitaryUnitToPatron$giftableUniqueUnit(CityStateFunctions this$0, Civilization $receivingCiv) {
        BaseUnit baseUnit = (BaseUnit)((Map)this$0.civInfo.getGameInfo().getRuleset().getUnits()).get(this$0.civInfo.getCityStateUniqueUnit());
        if (baseUnit == null) {
            return null;
        }
        BaseUnit uniqueUnit = baseUnit;
        if (!$receivingCiv.getTech().isResearched(uniqueUnit)) {
            return null;
        }
        if ($receivingCiv.getTech().isObsolete(uniqueUnit)) {
            return null;
        }
        return uniqueUnit;
    }

    @Readonly
    private static final BaseUnit giveMilitaryUnitToPatron$randomGiftableUnit(City city, Civilization $receivingCiv) {
        return (BaseUnit)CollectionsKt.randomOrNull((Collection)SequencesKt.toList(SequencesKt.filter(SequencesKt.filter(city.getCityConstructions().getConstructableUnits(), CityStateFunctions::giveMilitaryUnitToPatron$randomGiftableUnit$lambda$0), arg_0 -> CityStateFunctions.giveMilitaryUnitToPatron$randomGiftableUnit$lambda$1($receivingCiv, arg_0))), Random.Default);
    }

    private static final boolean giveMilitaryUnitToPatron$randomGiftableUnit$lambda$0(BaseUnit it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !it.isCivilian() && it.isLandUnit() && it.getUniqueTo() == null;
    }

    private static final boolean giveMilitaryUnitToPatron$randomGiftableUnit$lambda$1(Civilization $receivingCiv, BaseUnit it) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(it, "it");
            Map $this$none$iv = it.getResourceRequirementsPerTurn($receivingCiv.getState());
            boolean $i$f$none = false;
            if ($this$none$iv.isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$none$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it2 = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (!(((Number)it2.getValue()).intValue() > 0 && $receivingCiv.getResourceAmount((String)it2.getKey()) < ((Number)it2.getValue()).intValue())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean diplomaticMarriage$lambda$1(CityStateFunctions this$0, City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getFoundingCivObject(), this$0.civInfo);
    }

    private static final boolean updateDiplomaticRelationshipForCityState$lambda$0(Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isMajorCiv();
    }

    private static final boolean askForUnitGifts$lambda$0(Civilization $attacker, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !Intrinsics.areEqual(it, $attacker) && it.isAlive() && it.knows($attacker) && !it.isAtWarWith($attacker) && it.isMajorCiv();
    }

    private static final boolean getUniquesProvidedByCityStates$lambda$0(Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isCityState();
    }

    private static final Sequence getUniquesProvidedByCityStates$lambda$1(CityStateFunctions this$0, UniqueType $uniqueType, Civilization it) {
        RelationshipLevel relationshipLevel;
        Intrinsics.checkNotNullParameter(it, "it");
        if (Intrinsics.areEqual(it.getAllyCiv(), this$0.civInfo)) {
            relationshipLevel = RelationshipLevel.Ally;
        } else {
            DiplomacyManager diplomacyManager = it.getDiplomacyManager(this$0.civInfo);
            Intrinsics.checkNotNull(diplomacyManager);
            relationshipLevel = diplomacyManager.getInfluence() >= 30.0f ? RelationshipLevel.Friend : RelationshipLevel.Neutral;
        }
        RelationshipLevel relationshipLevel2 = relationshipLevel;
        return Companion.getCityStateBonuses(it.getCityStateType(), relationshipLevel2, $uniqueType);
    }

    private static final boolean getUniquesProvidedByCityStates$lambda$2(GameContext $gameContext, Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.conditionalsApply($gameContext);
    }

    private static final Sequence getUniquesProvidedByCityStates$lambda$3(GameContext $gameContext, Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getMultiplied($gameContext);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007\u00a8\u0006\r"}, d2={"Lcom/unciv/logic/civilization/diplomacy/CityStateFunctions$Companion;", "", "<init>", "()V", "getCityStateBonuses", "Lkotlin/sequences/Sequence;", "Lcom/unciv/models/ruleset/unique/Unique;", "cityStateType", "Lcom/unciv/models/ruleset/nation/CityStateType;", "relationshipLevel", "Lcom/unciv/logic/civilization/diplomacy/RelationshipLevel;", "uniqueType", "Lcom/unciv/models/ruleset/unique/UniqueType;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @Readonly
        @NotNull
        public final Sequence<Unique> getCityStateBonuses(@NotNull CityStateType cityStateType, @NotNull RelationshipLevel relationshipLevel, @Nullable UniqueType uniqueType) {
            UniqueMap uniqueMap2;
            Intrinsics.checkNotNullParameter(cityStateType, "cityStateType");
            Intrinsics.checkNotNullParameter((Object)relationshipLevel, "relationshipLevel");
            switch (WhenMappings.$EnumSwitchMapping$0[relationshipLevel.ordinal()]) {
                case 1: {
                    uniqueMap2 = cityStateType.getAllyBonusUniqueMap();
                    break;
                }
                case 2: {
                    uniqueMap2 = cityStateType.getFriendBonusUniqueMap();
                    break;
                }
                default: {
                    return SequencesKt.emptySequence();
                }
            }
            UniqueMap cityStateUniqueMap = uniqueMap2;
            return uniqueType == null ? cityStateUniqueMap.getAllUniques() : cityStateUniqueMap.getUniques(uniqueType);
        }

        public static /* synthetic */ Sequence getCityStateBonuses$default(Companion companion, CityStateType cityStateType, RelationshipLevel relationshipLevel, UniqueType uniqueType, int n, Object object) {
            if ((n & 4) != 0) {
                uniqueType = null;
            }
            return companion.getCityStateBonuses(cityStateType, relationshipLevel, uniqueType);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[RelationshipLevel.values().length];
                try {
                    nArray[RelationshipLevel.Ally.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[RelationshipLevel.Friend.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Proximity.values().length];
            try {
                nArray[Proximity.Neighbors.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Proximity.Close.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Proximity.Far.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Proximity.Distant.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

