/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.tile;

import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.logic.city.CityStats;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.LocationAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.managers.ImprovementFunctions;
import com.unciv.logic.map.HexCoord;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.ImprovementBuildingProblem;
import com.unciv.logic.map.tile.RoadStatus;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.NamedStats;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007JE\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u0012\u001a\u00020\t2\u0010\b\u0002\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00142\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u0015\u001a\u00020\tH\u0001\u00a2\u0006\u0002\b\u0016J(\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ$\u0010\u001f\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u001a\u0010!\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0018\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001cH\u0002J\u000e\u0010$\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u001aJ\u0006\u0010%\u001a\u00020\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006&"}, d2={"Lcom/unciv/logic/map/tile/TileImprovementFunctions;", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "<init>", "(Lcom/unciv/logic/map/tile/Tile;)V", "getTile", "()Lcom/unciv/logic/map/tile/Tile;", "canBuildImprovement", "", "improvement", "Lcom/unciv/models/ruleset/tile/TileImprovement;", "gameContext", "Lcom/unciv/models/ruleset/unique/GameContext;", "getImprovementBuildingProblems", "Lkotlin/sequences/Sequence;", "Lcom/unciv/logic/map/tile/ImprovementBuildingProblem;", "canImprovementBeBuiltHere", "resourceIsVisible", "knownFeatureRemovals", "", "isNormalizeCheck", "canImprovementBeBuiltHere$core", "setImprovement", "", "improvementName", "", "civToActivateBroaderEffects", "Lcom/unciv/logic/civilization/Civilization;", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "triggerImprovementUniques", "civ", "activateRemovalImprovement", "tryProvideProductionToClosestCity", "removedTerrainFeature", "markForCreatesOneImprovement", "removeCreatesOneImprovementMarker", "core"})
@SourceDebugExtension(value={"SMAP\nTileImprovementFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileImprovementFunctions.kt\ncom/unciv/logic/map/tile/TileImprovementFunctions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,316:1\n1761#2,3:317\n1761#2,3:320\n1761#2,3:323\n2746#2,3:327\n774#2:336\n865#2,2:337\n827#2:339\n855#2:340\n1761#2,3:341\n856#2:344\n1761#2,3:345\n1761#2,3:348\n2423#2,14:351\n1617#2,9:365\n1869#2:374\n295#2,2:375\n1870#2:378\n1626#2:379\n1761#2,3:380\n827#2:383\n855#2:384\n1761#2,3:385\n856#2:388\n1#3:326\n1#3:377\n1255#4,2:330\n1255#4,2:332\n1255#4,2:334\n*S KotlinDebug\n*F\n+ 1 TileImprovementFunctions.kt\ncom/unciv/logic/map/tile/TileImprovementFunctions\n*L\n94#1:317,3\n96#1:320,3\n99#1:323,3\n112#1:327,3\n193#1:336\n193#1:337,2\n200#1:339\n200#1:340\n200#1:341,3\n200#1:344\n253#1:345,3\n259#1:348,3\n276#1:351,14\n75#1:365,9\n75#1:374\n76#1:375,2\n75#1:378\n75#1:379\n78#1:380,3\n80#1:383\n80#1:384\n81#1:385,3\n80#1:388\n75#1:377\n117#1:330,2\n125#1:332,2\n129#1:334,2\n*E\n"})
public final class TileImprovementFunctions {
    @NotNull
    private final Tile tile;

    public TileImprovementFunctions(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        this.tile = tile;
    }

    @NotNull
    public final Tile getTile() {
        return this.tile;
    }

    @Readonly
    public final boolean canBuildImprovement(@NotNull TileImprovement improvement, @NotNull GameContext gameContext) {
        Intrinsics.checkNotNullParameter(improvement, "improvement");
        Intrinsics.checkNotNullParameter(gameContext, "gameContext");
        return SequencesKt.none(this.getImprovementBuildingProblems(improvement, gameContext));
    }

    @Readonly
    @NotNull
    public final Sequence<ImprovementBuildingProblem> getImprovementBuildingProblems(@NotNull TileImprovement improvement, @NotNull GameContext gameContext) {
        Intrinsics.checkNotNullParameter(improvement, "improvement");
        Intrinsics.checkNotNullParameter(gameContext, "gameContext");
        return ImprovementFunctions.INSTANCE.getImprovementBuildingProblems(improvement, gameContext, this.tile);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Readonly
    public final boolean canImprovementBeBuiltHere$core(@NotNull TileImprovement improvement, boolean resourceIsVisible, @Nullable List<TileImprovement> knownFeatureRemovals, @NotNull GameContext gameContext, boolean isNormalizeCheck) {
        Object it;
        Iterator iterator2;
        boolean bl;
        boolean $i$f$any;
        Sequence<Unique> $this$any$iv;
        block39: {
            Intrinsics.checkNotNullParameter(improvement, "improvement");
            Intrinsics.checkNotNullParameter(gameContext, "gameContext");
            if (Intrinsics.areEqual(improvement.getName(), this.tile.getImprovement()) && !isNormalizeCheck) {
                return false;
            }
            if (this.tile.isCityCenter()) {
                if (!isNormalizeCheck) return false;
                if (!Intrinsics.areEqual(improvement.getName(), "City center")) return false;
                return true;
            }
            if (Intrinsics.areEqual(improvement.getName(), "Cancel improvement order")) {
                if (this.tile.getImprovementInProgress() == null) return false;
                return true;
            }
            $this$any$iv = RoadStatus.getEntries();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)((Object)$this$any$iv)).isEmpty()) {
                bl = false;
            } else {
                iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    Object t = iterator2.next();
                    it = (RoadStatus)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(((RoadStatus)it).getRemoveAction(), improvement.getName())) continue;
                    bl = true;
                    break block39;
                }
                bl = false;
            }
        }
        if (!bl) {
            Unique unique;
            boolean bl3;
            block40: {
                if (StringsKt.startsWith$default(improvement.getName(), "Remove ", false, 2, null)) {
                    boolean bl4;
                    $this$any$iv = this.tile.getTerrainFeatures();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)((Object)$this$any$iv)).isEmpty()) {
                        bl4 = false;
                    } else {
                        iterator2 = $this$any$iv.iterator();
                        while (iterator2.hasNext()) {
                            Object t = iterator2.next();
                            it = (String)t;
                            boolean bl5 = false;
                            if (!Intrinsics.areEqual("Remove " + (String)it, improvement.getName())) continue;
                            return true;
                        }
                        bl4 = false;
                    }
                    if (bl4) return true;
                    if (!Intrinsics.areEqual("Remove " + this.tile.getImprovement(), improvement.getName())) return false;
                    return true;
                }
                $this$any$iv = RoadStatus.getEntries();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)((Object)$this$any$iv)).isEmpty()) {
                    bl3 = false;
                } else {
                    iterator2 = $this$any$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object t = iterator2.next();
                        it = (RoadStatus)t;
                        boolean bl6 = false;
                        if (!Intrinsics.areEqual(((Enum)it).name(), improvement.getName())) continue;
                        bl3 = true;
                        break block40;
                    }
                    bl3 = false;
                }
            }
            if (bl3) {
                if (this.tile.isWater()) return false;
                if (RoadStatus.valueOf(improvement.getName()).compareTo((Enum)this.tile.getRoadStatus()) <= 0) return false;
                return true;
            }
            if (this.tile.getImprovement() != null) {
                TileImprovement tileImprovement = this.tile.getTileImprovement();
                Intrinsics.checkNotNull(tileImprovement);
                if (tileImprovement.hasUnique(UniqueType.Irremovable, gameContext)) {
                    return false;
                }
            }
            if (this.tile.getLastTerrain().getUnbuildable() && !TileImprovementFunctions.canImprovementBeBuiltHere$canBeBuiltOnThisUnbuildableTerrain(improvement, this, gameContext, improvement, resourceIsVisible, knownFeatureRemovals)) {
                return false;
            }
            List<Unique> it2 = SequencesKt.toList(this.tile.getTerrainMatchingUniques(UniqueType.RestrictedBuildableImprovements, gameContext));
            boolean $i$a$-let-TileImprovementFunctions$canImprovementBeBuiltHere$52 = false;
            if (CollectionsKt.any((Iterable)it2)) {
                Iterable iterable = it2;
                boolean $i$f$none = false;
                if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                    return false;
                }
                Iterator bl6 = iterable.iterator();
                do {
                    if (!bl6.hasNext()) return false;
                    Object t = bl6.next();
                    unique = (Unique)t;
                    boolean bl7 = false;
                } while (!TileImprovement.matchesFilter$default(improvement, unique.getParams().get(0), new GameContext(null, null, null, this.tile, null, null, null, null, null, null, false, 2039, null), false, 4, null));
                boolean bl8 = false;
                if (bl8) {
                    return false;
                }
            }
            boolean bl9 = false;
            if (bl9) {
                return false;
            }
            $this$any$iv = improvement.getMatchingUniques(UniqueType.CannotBuildOnTile, gameContext);
            boolean $i$f$any2 = false;
            Iterator $i$a$-let-TileImprovementFunctions$canImprovementBeBuiltHere$52 = $this$any$iv.iterator();
            while ($i$a$-let-TileImprovementFunctions$canImprovementBeBuiltHere$52.hasNext()) {
                Object t = $i$a$-let-TileImprovementFunctions$canImprovementBeBuiltHere$52.next();
                Unique unique2 = (Unique)t;
                boolean bl10 = false;
                if (!this.tile.matchesFilter(unique2.getParams().get(0), gameContext.getCivInfo())) continue;
                return false;
            }
            boolean bl11 = false;
            if (bl11) {
                return false;
            }
            Sequence<Unique> it22 = improvement.getMatchingUniques(UniqueType.CanOnlyBeBuiltOnTile, gameContext);
            boolean bl12 = false;
            if (SequencesKt.any(it22)) {
                Sequence<Unique> sequence = it22;
                boolean $i$f$any3 = false;
                Iterator<Unique> bl10 = sequence.iterator();
                while (bl10.hasNext()) {
                    Unique unique3;
                    unique = unique3 = bl10.next();
                    boolean bl13 = false;
                    if (!this.tile.matchesFilter(unique.getParams().get(0), gameContext.getCivInfo())) {
                        return false;
                    }
                    boolean bl14 = false;
                    if (!bl14) continue;
                    return false;
                }
                boolean bl15 = false;
                if (bl15) {
                    return false;
                }
            }
            boolean bl16 = false;
            if (bl16) {
                return false;
            }
            $this$any$iv = improvement.getMatchingUniques(UniqueType.MustBeNextTo, gameContext);
            $i$f$any = false;
            Iterator<Unique> iterator3 = $this$any$iv.iterator();
            while (iterator3.hasNext()) {
                Unique unique4;
                Unique it3 = unique4 = iterator3.next();
                boolean bl17 = false;
                if (!Tile.isAdjacentTo$default(this.tile, it3.getParams().get(0), null, 2, null)) {
                    return false;
                }
                boolean bl18 = false;
                if (!bl18) continue;
                return false;
            }
            boolean bl19 = false;
            if (bl19) {
                return false;
            }
            if (improvement.hasUnique(UniqueType.CanOnlyImproveResource, gameContext)) {
                if (!resourceIsVisible) return false;
                if (!this.tile.getTileResource().isImprovedBy(improvement.getName())) {
                    return false;
                }
            }
            if (improvement.isAllowedOnFeature(this.tile.getLastTerrain())) {
                return true;
            }
            if (this.tile.isLand() && improvement.canBeBuiltOn("Land")) {
                return true;
            }
            if (this.tile.isWater() && improvement.canBeBuiltOn("Water")) {
                return true;
            }
            if (improvement.hasUnique(UniqueType.ImprovementBuildableByFreshWater, gameContext) && Tile.isAdjacentTo$default(this.tile, "Fresh water", null, 2, null)) {
                return true;
            }
            if (!resourceIsVisible) return false;
            if (!this.tile.getTileResource().isImprovedBy(improvement.getName())) return false;
            return true;
        }
        boolean bl20 = Intrinsics.areEqual(this.tile.getRoadStatus().getRemoveAction(), improvement.getName());
        return bl20;
    }

    public static /* synthetic */ boolean canImprovementBeBuiltHere$core$default(TileImprovementFunctions tileImprovementFunctions, TileImprovement tileImprovement, boolean bl, List list2, GameContext gameContext, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            boolean bl3 = bl = tileImprovementFunctions.tile.getResource() != null;
        }
        if ((n & 4) != 0) {
            list2 = null;
        }
        if ((n & 8) != 0) {
            gameContext = new GameContext(null, null, null, tileImprovementFunctions.tile, null, null, null, null, null, null, false, 2039, null);
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        return tileImprovementFunctions.canImprovementBeBuiltHere$core(tileImprovement, bl, list2, gameContext, bl2);
    }

    /*
     * WARNING - void declaration
     */
    public final void setImprovement(@Nullable String improvementName, @Nullable Civilization civToActivateBroaderEffects, @Nullable MapUnit unit) {
        TileImprovement improvementObject = (TileImprovement)((Map)this.tile.getRuleset().getTileImprovements()).get(improvementName);
        boolean improvementFieldHasChanged = false;
        String string = improvementName;
        boolean bl = string != null ? StringsKt.startsWith$default(string, "Remove ", false, 2, null) : false;
        if (bl) {
            this.activateRemovalImprovement(improvementName, civToActivateBroaderEffects);
        } else if (Intrinsics.areEqual(improvementName, "Road")) {
            this.tile.setRoadStatus(RoadStatus.Road, civToActivateBroaderEffects);
        } else if (Intrinsics.areEqual(improvementName, "Railroad")) {
            this.tile.setRoadStatus(RoadStatus.Railroad, civToActivateBroaderEffects);
        } else if (Intrinsics.areEqual(improvementName, "Repair")) {
            this.tile.setRepaired();
        } else {
            this.tile.setImprovementIsPillaged(false);
            this.tile.setImprovement(improvementName);
            improvementFieldHasChanged = true;
            if (improvementName != null) {
                TileImprovement tileImprovement = improvementObject;
                Intrinsics.checkNotNull(tileImprovement);
                if (IHasUniques.hasUnique$default(tileImprovement, UniqueType.Irremovable, null, 2, null) || this.tile.isMarkedForCreatesOneImprovement(improvementName)) {
                    this.removeCreatesOneImprovementMarker();
                }
            }
        }
        if (improvementFieldHasChanged && this.tile.getTileMap().hasGameInfo()) {
            Iterator<Civilization> iterator2 = this.tile.getTileMap().getGameInfo().getCivilizations().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
            Iterator<Civilization> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Civilization civ;
                Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
                if (civ.isDefeated() || !civ.isMajorCiv() || !Intrinsics.areEqual(civ, civToActivateBroaderEffects) && !this.tile.isVisible(civ)) continue;
                civ.setLastSeenImprovement(this.tile.getPosition(), improvementName);
            }
        }
        if (improvementObject != null && IHasUniques.hasUnique$default(improvementObject, UniqueType.RemovesFeaturesIfBuilt, null, 2, null)) {
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv;
            Object feature;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.tile.getTerrainFeatureObjects();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                feature = (Terrain)element$iv$iv;
                boolean bl2 = false;
                String removingAction = "Remove " + ((NamedStats)feature).getName();
                if (!(((Map)this.tile.getRuleset().getTileImprovements()).containsKey(removingAction) && !improvementObject.isAllowedOnFeature((Terrain)feature))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List removableTerrainFeatures = (List)destination$iv$iv;
            $this$filter$iv = this.tile.getTerrainFeatures();
            Tile tile = this.tile;
            boolean $i$f$filterNot = false;
            $this$filterTo$iv$iv = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                boolean bl3;
                block20: {
                    feature = (String)element$iv$iv;
                    boolean bl4 = false;
                    Iterable $this$any$iv = removableTerrainFeatures;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Terrain it = (Terrain)element$iv;
                            boolean bl5 = false;
                            if (!Intrinsics.areEqual(it.getName(), feature)) continue;
                            bl3 = true;
                            break block20;
                        }
                        bl3 = false;
                    }
                }
                if (bl3) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            tile.setTerrainFeatures((List)destination$iv$iv);
        }
        if (civToActivateBroaderEffects != null && improvementObject != null) {
            this.triggerImprovementUniques(improvementObject, civToActivateBroaderEffects, unit);
        }
        City city = this.tile.getOwningCity();
        if (civToActivateBroaderEffects != null && city != null) {
            CityStats.update$default(city.getCityStats(), null, false, false, null, false, 31, null);
            city.getCiv().getCache().updateCivResources();
            city.reassignPopulationDeferred();
        }
    }

    public static /* synthetic */ void setImprovement$default(TileImprovementFunctions tileImprovementFunctions, String string, Civilization civilization, MapUnit mapUnit, int n, Object object) {
        if ((n & 2) != 0) {
            civilization = null;
        }
        if ((n & 4) != 0) {
            mapUnit = null;
        }
        tileImprovementFunctions.setImprovement(string, civilization, mapUnit);
    }

    private final void triggerImprovementUniques(TileImprovement improvement, Civilization civ, MapUnit unit) {
        Unique unique2;
        GameContext gameContext = new GameContext(civ, null, unit, this.tile, null, null, null, null, null, null, false, 2034, null);
        Iterator<Unique> iterator2 = improvement.getMatchingUniques(UniqueType.CostsResources, gameContext).iterator();
        while (iterator2.hasNext()) {
            TileResource resource;
            unique2 = iterator2.next();
            if (this.tile.getRuleset().getTileResources().get(unique2.getParams().get(1)) == null) continue;
            int amount = Integer.parseInt(unique2.getParams().get(0));
            if (unique2.isModifiedByGameSpeed()) {
                amount = (int)((float)amount * civ.getGameInfo().getSpeed().getModifier());
            }
            civ.gainStockpiledResource(resource, -amount);
        }
        for (Unique unique2 : improvement.getUniqueObjects()) {
            if (unique2.hasTriggerConditional() || !unique2.conditionalsApply(gameContext)) continue;
            int n = unique2.getUniqueMultiplier(gameContext);
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique2, civ, null, unit, this.tile, null, null, 100, null);
            }
        }
        iterator2 = civ.getTriggeredUniques(UniqueType.TriggerUponBuildingImprovement, gameContext, arg_0 -> TileImprovementFunctions.triggerImprovementUniques$lambda$1(improvement, gameContext, arg_0)).iterator();
        while (iterator2.hasNext()) {
            unique2 = iterator2.next();
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique2, civ, null, unit, this.tile, null, null, 100, null);
        }
        if (unit == null) {
            return;
        }
        iterator2 = unit.getTriggeredUniques(UniqueType.TriggerUponBuildingImprovement, gameContext, arg_0 -> TileImprovementFunctions.triggerImprovementUniques$lambda$2(improvement, gameContext, arg_0)).iterator();
        while (iterator2.hasNext()) {
            unique2 = iterator2.next();
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique2, civ, null, unit, this.tile, null, null, 100, null);
        }
    }

    static /* synthetic */ void triggerImprovementUniques$default(TileImprovementFunctions tileImprovementFunctions, TileImprovement tileImprovement, Civilization civilization, MapUnit mapUnit, int n, Object object) {
        if ((n & 4) != 0) {
            mapUnit = null;
        }
        tileImprovementFunctions.triggerImprovementUniques(tileImprovement, civilization, mapUnit);
    }

    private final void activateRemovalImprovement(String improvementName, Civilization civToActivateBroaderEffects) {
        boolean bl;
        String removedFeatureName;
        block14: {
            Object it;
            boolean $i$f$any;
            Iterable $this$any$iv;
            removedFeatureName = StringsKt.removePrefix(improvementName, (CharSequence)"Remove ");
            TileImprovement currentTileImprovement = this.tile.getTileImprovement();
            if (currentTileImprovement != null) {
                boolean bl2;
                block13: {
                    $this$any$iv = this.tile.getTerrainFeatures();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (String)element$iv;
                            boolean bl3 = false;
                            if (!(currentTileImprovement.getTerrainsCanBeBuiltOn().contains(it) && Intrinsics.areEqual(it, removedFeatureName))) continue;
                            bl2 = true;
                            break block13;
                        }
                        bl2 = false;
                    }
                }
                if (bl2 && !currentTileImprovement.getTerrainsCanBeBuiltOn().contains(this.tile.getBaseTerrain())) {
                    this.tile.removeImprovement();
                }
            }
            $this$any$iv = RoadStatus.getEntries();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (RoadStatus)element$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual(improvementName, ((RoadStatus)it).getRemoveAction())) continue;
                    bl = true;
                    break block14;
                }
                bl = false;
            }
        }
        if (bl) {
            this.tile.removeRoad();
        } else if (Intrinsics.areEqual(this.tile.getImprovement(), removedFeatureName)) {
            this.tile.removeImprovement();
        } else {
            Terrain removedFeatureObject = this.tile.getRuleset().getTerrains().get(removedFeatureName);
            if (removedFeatureObject != null && civToActivateBroaderEffects != null && IHasUniques.hasUnique$default(removedFeatureObject, UniqueType.ProductionBonusWhenRemoved, null, 2, null)) {
                this.tryProvideProductionToClosestCity(removedFeatureName, civToActivateBroaderEffects);
            }
            this.tile.removeTerrainFeature(removedFeatureName);
        }
    }

    private final void tryProvideProductionToClosestCity(String removedTerrainFeature, Civilization civ) {
        Stats stats;
        City closestCity;
        block17: {
            block16: {
                Object v0;
                Iterable $this$minByOrNull$iv = civ.getCities();
                boolean $i$f$minByOrNull = false;
                Iterator iterator$iv = $this$minByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v0 = null;
                } else {
                    Object minElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v0 = minElem$iv;
                    } else {
                        City it = (City)minElem$iv;
                        boolean bl = false;
                        int minValue$iv = it.getCenterTile().aerialDistanceTo(this.tile);
                        do {
                            Object e$iv = iterator$iv.next();
                            City it2 = (City)e$iv;
                            $i$a$-minByOrNull-TileImprovementFunctions$tryProvideProductionToClosestCity$closestCity$1 = false;
                            int v$iv = it2.getCenterTile().aerialDistanceTo(this.tile);
                            if (minValue$iv <= v$iv) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v0 = minElem$iv;
                    }
                }
                City city = v0;
                if (city == null) {
                    return;
                }
                closestCity = city;
                int distance = closestCity.getCenterTile().aerialDistanceTo(this.tile);
                if (distance > 5) {
                    return;
                }
                stats = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
                Iterator<Object> iterator2 = Tile.getTerrainMatchingUniques$default(this.tile, UniqueType.ProductionBonusWhenRemoved, null, 2, null).iterator();
                while (iterator2.hasNext()) {
                    Unique unique = (Unique)iterator2.next();
                    Stats statsToAdd = unique.getStats();
                    if (unique.isModifiedByGameSpeed()) {
                        statsToAdd = statsToAdd.times(civ.getGameInfo().getSpeed().getModifier());
                    }
                    if (unique.isModifiedByGameProgress()) {
                        statsToAdd = statsToAdd.times(unique.getGameProgressModifier(civ));
                    }
                    stats.add(statsToAdd);
                }
                if (stats.isEmpty()) {
                    return;
                }
                if (distance != 1) {
                    stats = stats.times((float)(6 - distance) / 4.0f);
                }
                if (this.tile.getOwningCity() == null) break block16;
                City city2 = this.tile.getOwningCity();
                Intrinsics.checkNotNull(city2);
                if (Intrinsics.areEqual(city2.getCiv(), civ)) break block17;
            }
            stats = stats.times(0.6666667f);
        }
        for (Stats.StatValuePair statValuePair : stats) {
            Stat stat = statValuePair.component1();
            float value = statValuePair.component2();
            closestCity.addStat(stat, (int)value);
            Object[] objectArray = new HexCoord[]{this.tile.getPosition(), closestCity.getLocation().toHexCoord()};
            Sequence<LocationAction> locations = LocationAction.Companion.invoke((HexCoord[])objectArray);
            objectArray = new String[]{"StatIcons/Production"};
            civ.addNotification("Clearing a [" + removedTerrainFeature + "] has created [" + stats.toStringForNotifications() + "] for [" + closestCity.getName() + ']', locations, Notification.NotificationCategory.Production, (String[])objectArray);
        }
    }

    public final void markForCreatesOneImprovement(@NotNull String improvement) {
        Intrinsics.checkNotNullParameter(improvement, "improvement");
        this.tile.stopWorkingOnImprovement();
        this.tile.queueImprovement(improvement, -1);
    }

    public final void removeCreatesOneImprovementMarker() {
        if (!this.tile.isMarkedForCreatesOneImprovement()) {
            return;
        }
        IsPartOfGameInfoSerialization isPartOfGameInfoSerialization = this.tile.getOwningCity();
        if (isPartOfGameInfoSerialization != null && (isPartOfGameInfoSerialization = ((City)isPartOfGameInfoSerialization).getCityConstructions()) != null) {
            String string = this.tile.getImprovementInProgress();
            Intrinsics.checkNotNull(string);
            ((CityConstructions)isPartOfGameInfoSerialization).removeCreateOneImprovementConstruction(string);
        }
        this.tile.stopWorkingOnImprovement();
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private static final boolean canImprovementBeBuiltHere$canBeBuiltOnThisUnbuildableTerrain(TileImprovement $this$canImprovementBeBuiltHere_u24canBeBuiltOnThisUnbuildableTerrain, TileImprovementFunctions this$0, GameContext $gameContext, TileImprovement $improvement, boolean $resourceIsVisible, List<TileImprovement> knownFeatureRemovals) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Object element$iv3;
        boolean bl;
        List featureRemovals;
        block15: {
            Iterator $this$mapNotNullTo$iv$iv;
            Terrain topTerrain = this$0.tile.getLastTerrain();
            if ($this$canImprovementBeBuiltHere_u24canBeBuiltOnThisUnbuildableTerrain.isAllowedOnFeature(topTerrain)) {
                return true;
            }
            if (!$this$canImprovementBeBuiltHere_u24canBeBuiltOnThisUnbuildableTerrain.hasUnique(UniqueType.RemovesFeaturesIfBuilt, $gameContext)) {
                return false;
            }
            Collection collection = knownFeatureRemovals;
            if (collection == null || collection.isEmpty()) {
                return false;
            }
            Iterable $this$mapNotNull$iv = this$0.tile.getTerrainFeatures();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                TileImprovement it$iv$iv;
                Object v0;
                block14: {
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl2 = false;
                    String feature = (String)element$iv$iv;
                    boolean bl3 = false;
                    Iterable $this$firstOrNull$iv = this$0.tile.getRuleset().getTileRemovals();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        TileImprovement it = (TileImprovement)element$iv2;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual(it.getName(), "Remove " + feature)) continue;
                        v0 = element$iv2;
                        break block14;
                    }
                    v0 = null;
                }
                if ((TileImprovement)v0 == null) continue;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            featureRemovals = (List)destination$iv$iv;
            if (featureRemovals.isEmpty()) {
                return false;
            }
            Iterable $this$any$iv = featureRemovals;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv3 : $this$any$iv) {
                    TileImprovement it = (TileImprovement)element$iv3;
                    boolean bl6 = false;
                    if (!(!knownFeatureRemovals.contains(it))) continue;
                    bl = true;
                    break block15;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        Tile clonedTile = this$0.tile.clone(false);
        Iterable $i$f$any = this$0.tile.getTerrainFeatures();
        Tile tile = clonedTile;
        boolean $i$f$filterNot = false;
        element$iv3 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            boolean bl7;
            block16: {
                String feature = (String)element$iv$iv;
                boolean bl8 = false;
                Iterable $this$any$iv = featureRemovals;
                boolean $i$f$any2 = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl7 = false;
                } else {
                    for (Object element$iv4 : $this$any$iv) {
                        TileImprovement it = (TileImprovement)element$iv4;
                        boolean bl9 = false;
                        if (!Intrinsics.areEqual(StringsKt.removePrefix(it.getName(), (CharSequence)"Remove "), feature)) continue;
                        bl7 = true;
                        break block16;
                    }
                    bl7 = false;
                }
            }
            if (bl7) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        tile.setTerrainFeatures((List)destination$iv$iv);
        return TileImprovementFunctions.canImprovementBeBuiltHere$core$default(clonedTile.getImprovementFunctions(), $improvement, $resourceIsVisible, knownFeatureRemovals, $gameContext, false, 16, null);
    }

    static /* synthetic */ boolean canImprovementBeBuiltHere$canBeBuiltOnThisUnbuildableTerrain$default(TileImprovement tileImprovement, TileImprovementFunctions tileImprovementFunctions, GameContext gameContext, TileImprovement tileImprovement2, boolean bl, List list2, int n, Object object) {
        if ((n & 0x10) != 0) {
            list2 = null;
        }
        return TileImprovementFunctions.canImprovementBeBuiltHere$canBeBuiltOnThisUnbuildableTerrain(tileImprovement, tileImprovementFunctions, gameContext, tileImprovement2, bl, list2);
    }

    private static final boolean triggerImprovementUniques$lambda$1(TileImprovement $improvement, GameContext $gameContext, Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return TileImprovement.matchesFilter$default($improvement, it.getParams().get(0), $gameContext, false, 4, null);
    }

    private static final boolean triggerImprovementUniques$lambda$2(TileImprovement $improvement, GameContext $gameContext, Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return TileImprovement.matchesFilter$default($improvement, it.getParams().get(0), $gameContext, false, 4, null);
    }
}

