/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.savescreens;

import com.badlogic.gdx.utils.Base64Coder;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\tH\u0002J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\tJ\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/unciv/ui/screens/savescreens/Gzip;", "", "<init>", "()V", "zip", "", "data", "unzip", "compress", "", "decompress", "compressed", "encode", "bytes", "decode", "base64Str", "core"})
public final class Gzip {
    @NotNull
    public static final Gzip INSTANCE = new Gzip();

    private Gzip() {
    }

    @NotNull
    public final String zip(@NotNull String data) {
        Intrinsics.checkNotNullParameter(data, "data");
        return this.encode(this.compress(data));
    }

    @NotNull
    public final String unzip(@NotNull String data) {
        Intrinsics.checkNotNullParameter(data, "data");
        return this.decompress(this.decode(data));
    }

    private final byte[] compress(String data) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length());
        GZIPOutputStream gzip = new GZIPOutputStream(bos);
        String string = data;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        gzip.write(byArray);
        gzip.close();
        byte[] compressed = bos.toByteArray();
        bos.close();
        Intrinsics.checkNotNull(compressed);
        return compressed;
    }

    private final String decompress(byte[] compressed) {
        ByteArrayInputStream bis = new ByteArrayInputStream(compressed);
        GZIPInputStream gis = new GZIPInputStream(bis);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)gis, Charsets.UTF_8));
        StringBuilder sb = new StringBuilder();
        String line = br.readLine();
        while (line != null) {
            sb.append(line);
            line = br.readLine();
        }
        br.close();
        gis.close();
        bis.close();
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public final String encode(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        char[] cArray = Base64Coder.encode(bytes);
        Intrinsics.checkNotNullExpressionValue(cArray, "encode(...)");
        char[] cArray2 = cArray;
        return new String(cArray2);
    }

    private final byte[] decode(String base64Str) {
        byte[] byArray = Base64Coder.decode(base64Str);
        Intrinsics.checkNotNullExpressionValue(byArray, "decode(...)");
        return byArray;
    }
}

