/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.savescreens;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.SerializationException;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfoPreview;
import com.unciv.logic.UncivShowableException;
import com.unciv.logic.civilization.CivilizationInfoPreview;
import com.unciv.logic.files.UncivFiles;
import com.unciv.logic.github.Github;
import com.unciv.logic.github.GithubAPI;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.UncivTooltip;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.extensions.UncivDateFormat;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.pickerscreens.PickerScreen;
import com.unciv.ui.screens.savescreens.LoadOrSaveScreen;
import com.unciv.ui.screens.savescreens.VerticalFileListScrollPane;
import com.unciv.utils.Concurrency;
import com.unciv.utils.ConcurrencyKt;
import com.unciv.utils.Log;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.DosFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 .2\u00020\u0001:\u0002./B\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\b\u0010!\u001a\u00020\u0007H\u0016J\b\u0010\"\u001a\u00020\u0007H\u0002J\u0010\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010'\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010(\u001a\u00020%2\n\u0010)\u001a\u00060*j\u0002`+2\u0006\u0010,\u001a\u00020\u00032\n\b\u0002\u0010-\u001a\u0004\u0018\u00010\tH\u0004R\"\u0010\f\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\t@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u00060"}, d2={"Lcom/unciv/ui/screens/savescreens/LoadOrSaveScreen;", "Lcom/unciv/ui/screens/pickerscreens/PickerScreen;", "fileListHeaderText", "", "<init>", "(Ljava/lang/String;)V", "onExistingSaveSelected", "", "saveGameFile", "Lcom/badlogic/gdx/files/FileHandle;", "doubleClickAction", "value", "selectedSave", "getSelectedSave", "()Lcom/badlogic/gdx/files/FileHandle;", "savesScrollPane", "Lcom/unciv/ui/screens/savescreens/VerticalFileListScrollPane;", "rightSideTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "getRightSideTable", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "deleteSaveButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "getDeleteSaveButton", "()Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "showAutosavesCheckbox", "Lcom/badlogic/gdx/scenes/scene2d/ui/CheckBox;", "getShowAutosavesCheckbox", "()Lcom/badlogic/gdx/scenes/scene2d/ui/CheckBox;", "errorLabel", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "getErrorLabel", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "resetWindowState", "onDeleteClicked", "updateShownSaves", "showAutosaves", "", "selectExistingSave", "showSaveInfo", "handleException", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "primaryText", "file", "Companion", "Helpers", "core"})
public abstract class LoadOrSaveScreen
extends PickerScreen {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private FileHandle selectedSave;
    @NotNull
    private final VerticalFileListScrollPane savesScrollPane;
    @NotNull
    private final Table rightSideTable;
    @NotNull
    private final TextButton deleteSaveButton;
    @NotNull
    private final CheckBox showAutosavesCheckbox;
    @NotNull
    private final Label errorLabel;
    @NotNull
    public static final String saveToClipboardErrorMessage = "Could not save game to clipboard!";

    public LoadOrSaveScreen(@Nullable String fileListHeaderText) {
        super(true);
        this.savesScrollPane = new VerticalFileListScrollPane(null, 1, null);
        this.rightSideTable = new Table();
        this.deleteSaveButton = Scene2dExtensionsKt.toTextButton$default("Delete save", BaseScreen.Companion.getSkin().get("negative", TextButton.TextButtonStyle.class), false, 2, null);
        this.showAutosavesCheckbox = new CheckBox(TranslationsKt.tr$default("Show autosaves", false, false, 3, null), BaseScreen.Companion.getSkin());
        Color color = Color.RED;
        Intrinsics.checkNotNullExpressionValue(color, "RED");
        this.errorLabel = Scene2dExtensionsKt.toLabel$default("", color, 0, 1, false, 10, null);
        this.savesScrollPane.onChange((Function1<? super FileHandle, Unit>)new Function1<FileHandle, Unit>((Object)this){

            @Override
            public final void invoke(FileHandle p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                ((LoadOrSaveScreen)this.receiver).selectExistingSave(p0);
            }
        });
        this.savesScrollPane.onDoubleClick((Function1<? super FileHandle, Unit>)new Function1<FileHandle, Unit>((Object)this){

            @Override
            public final void invoke(FileHandle p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                ((LoadOrSaveScreen)this.receiver).doubleClickAction(p0);
            }
        });
        Cell cell = this.rightSideTable.defaults();
        Intrinsics.checkNotNullExpressionValue(cell, "defaults(...)");
        Scene2dExtensionsKt.pad(cell, 5.0f, 10.0f);
        this.showAutosavesCheckbox.setChecked(UncivGame.Companion.getCurrent().getSettings().getShowAutosaves());
        ActivationExtensionsKt.onChange(this.showAutosavesCheckbox, arg_0 -> LoadOrSaveScreen._init_$lambda$0(this, arg_0));
        KeyCharAndCode ctrlA = KeyCharAndCode.Companion.ctrl('a');
        ActivationExtensionsKt.getKeyShortcuts(this.showAutosavesCheckbox).add(ctrlA, () -> LoadOrSaveScreen._init_$lambda$1(this));
        UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, (Actor)this.showAutosavesCheckbox, ctrlA, 0.0f, 2, null);
        Scene2dExtensionsKt.disable(this.deleteSaveButton);
        ActivationExtensionsKt.onActivation(this.deleteSaveButton, () -> LoadOrSaveScreen._init_$lambda$2(this));
        ActivationExtensionsKt.getKeyShortcuts(this.deleteSaveButton).add(KeyCharAndCode.Companion.getDEL());
        UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, (Actor)this.deleteSaveButton, KeyCharAndCode.Companion.getDEL(), 0.0f, 2, null);
        if (fileListHeaderText != null) {
            this.getTopTable().add((Actor)Scene2dExtensionsKt.toLabel(fileListHeaderText)).pad(10.0f).row();
        }
        this.updateShownSaves(this.showAutosavesCheckbox.isChecked());
        this.getTopTable().add((Actor)this.savesScrollPane);
        this.getTopTable().add((Actor)this.rightSideTable);
        this.getTopTable().pack();
    }

    public /* synthetic */ LoadOrSaveScreen(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string);
    }

    public abstract void onExistingSaveSelected(@NotNull FileHandle var1);

    public abstract void doubleClickAction(@NotNull FileHandle var1);

    @Nullable
    protected final FileHandle getSelectedSave() {
        return this.selectedSave;
    }

    @NotNull
    protected final Table getRightSideTable() {
        return this.rightSideTable;
    }

    @NotNull
    protected final TextButton getDeleteSaveButton() {
        return this.deleteSaveButton;
    }

    @NotNull
    protected final CheckBox getShowAutosavesCheckbox() {
        return this.showAutosavesCheckbox;
    }

    @NotNull
    protected final Label getErrorLabel() {
        return this.errorLabel;
    }

    public void resetWindowState() {
        this.updateShownSaves(this.showAutosavesCheckbox.isChecked());
        Scene2dExtensionsKt.disable(this.deleteSaveButton);
        this.getDescriptionLabel().setText("");
    }

    private final void onDeleteClicked() {
        if (this.selectedSave == null) {
            return;
        }
        FileHandle fileHandle = this.selectedSave;
        Intrinsics.checkNotNull(fileHandle);
        String name = fileHandle.name();
        Popup.open$default(new ConfirmPopup(this, "Are you sure you want to delete this save?", "Delete save", false, null, () -> LoadOrSaveScreen.onDeleteClicked$lambda$0(this, name), 24, null), false, 1, null);
    }

    private final void updateShownSaves(boolean showAutosaves) {
        this.savesScrollPane.updateSaveGames(this.getGame().getFiles(), showAutosaves);
    }

    private final void selectExistingSave(FileHandle saveGameFile) {
        this.errorLabel.setVisible(false);
        Scene2dExtensionsKt.enable(this.deleteSaveButton);
        this.selectedSave = saveGameFile;
        this.showSaveInfo(saveGameFile);
        this.getRightSideButton().setVisible(true);
        this.onExistingSaveSelected(saveGameFile);
    }

    private final void showSaveInfo(FileHandle saveGameFile) {
        this.getDescriptionLabel().setText(TranslationsKt.tr$default("Loading...", false, false, 3, null));
        Concurrency.run$default(Concurrency.INSTANCE, "LoadMetaData", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(saveGameFile, this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ FileHandle $saveGameFile;
            final /* synthetic */ LoadOrSaveScreen this$0;
            {
                this.$saveGameFile = $saveGameFile;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$run;
                        String string;
                        ResultKt.throwOnFailure($result);
                        try {
                            void $this$filterTo$iv$iv;
                            void $this$filter$iv;
                            Date savedAt = new Date(this.$saveGameFile.lastModified());
                            GameInfoPreview game = this.this$0.getGame().getFiles().loadGamePreviewFromFile(this.$saveGameFile);
                            Iterable iterable = game.getCivilizations();
                            boolean $i$f$filter = false;
                            void var9_8 = $this$filter$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                CivilizationInfoPreview it = (CivilizationInfoPreview)element$iv$iv;
                                boolean bl = false;
                                if (!it.isPlayerCivilization()) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            String playerCivNames = CollectionsKt.joinToString$default((List)destination$iv$iv, null, null, null, 0, null, showSaveInfo.1::invokeSuspend$lambda$1, 31, null);
                            String mods = game.getGameParameters().getMods().isEmpty() ? "" : "\n{Mods:} " + CollectionsKt.joinToString$default(game.getGameParameters().getMods(), null, null, null, 0, null, null, 63, null);
                            string = this.$saveGameFile.name() + "\n{Saved at}: " + UncivDateFormat.INSTANCE.formatDate(savedAt) + '\n' + playerCivNames + ", " + TranslationsKt.tr$default(game.getDifficulty(), false, false, 3, null) + ", \u23f3" + game.getTurns() + "\n{Base ruleset:} " + game.getGameParameters().getBaseRuleset() + mods;
                        }
                        catch (Exception exception2) {
                            string = "Could not load game!";
                        }
                        String textToSet = string;
                        ConcurrencyKt.launchOnGLThread$default((CoroutineScope)$this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, textToSet, null){
                            int label;
                            final /* synthetic */ LoadOrSaveScreen this$0;
                            final /* synthetic */ String $textToSet;
                            {
                                this.this$0 = $receiver;
                                this.$textToSet = $textToSet;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure($result);
                                        this.this$0.getDescriptionLabel().setText(TranslationsKt.tr$default(this.$textToSet, false, false, 3, null));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, 1, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final CharSequence invokeSuspend$lambda$1(CivilizationInfoPreview it) {
                return TranslationsKt.tr$default(it.getCivName(), false, false, 3, null);
            }
        }, 2, null);
    }

    protected final boolean handleException(@NotNull Exception ex, @NotNull String primaryText, @Nullable FileHandle file) {
        Intrinsics.checkNotNullParameter(ex, "ex");
        Intrinsics.checkNotNullParameter(primaryText, "primaryText");
        Pair<String, Boolean> pair = Companion.getLoadExceptionMessage(ex, primaryText, file);
        String errorText = pair.component1();
        boolean isUserFixable = pair.component2();
        if (!isUserFixable) {
            Log.INSTANCE.error(primaryText, ex);
        }
        this.errorLabel.setText(errorText);
        this.errorLabel.setVisible(true);
        return isUserFixable;
    }

    public static /* synthetic */ boolean handleException$default(LoadOrSaveScreen loadOrSaveScreen, Exception exception2, String string, FileHandle fileHandle, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: handleException");
        }
        if ((n & 4) != 0) {
            fileHandle = null;
        }
        return loadOrSaveScreen.handleException(exception2, string, fileHandle);
    }

    private static final Unit _init_$lambda$0(LoadOrSaveScreen this$0, ChangeListener.ChangeEvent it) {
        this$0.updateShownSaves(this$0.showAutosavesCheckbox.isChecked());
        UncivGame.Companion.getCurrent().getSettings().setShowAutosaves(this$0.showAutosavesCheckbox.isChecked());
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(LoadOrSaveScreen this$0) {
        this$0.showAutosavesCheckbox.toggle();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(LoadOrSaveScreen this$0) {
        this$0.onDeleteClicked();
        return Unit.INSTANCE;
    }

    private static final Unit onDeleteClicked$lambda$0(LoadOrSaveScreen this$0, String $name) {
        String string;
        try {
            String string2;
            UncivFiles uncivFiles = this$0.getGame().getFiles();
            FileHandle fileHandle = this$0.selectedSave;
            Intrinsics.checkNotNull(fileHandle);
            if (uncivFiles.deleteSave(fileHandle)) {
                this$0.resetWindowState();
                string2 = '[' + $name + "] deleted successfully.";
            } else {
                string2 = "Failed to delete [" + $name + "].";
            }
            string = string2;
        }
        catch (SecurityException securityException) {
            string = "Insufficient permissions to delete [" + $name + "].";
        }
        catch (Throwable throwable) {
            string = "Failed to delete [" + $name + "].";
        }
        String result2 = string;
        this$0.getDescriptionLabel().setText(TranslationsKt.tr$default(result2, false, false, 3, null));
        return Unit.INSTANCE;
    }

    public LoadOrSaveScreen() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/unciv/ui/screens/savescreens/LoadOrSaveScreen$Companion;", "Lcom/unciv/ui/screens/savescreens/LoadOrSaveScreen$Helpers;", "<init>", "()V", "saveToClipboardErrorMessage", "", "core"})
    public static final class Companion
    implements Helpers {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J2\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00042\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J>\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H\u0096@\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014\u00c0\u0006\u0003"}, d2={"Lcom/unciv/ui/screens/savescreens/LoadOrSaveScreen$Helpers;", "", "getLoadExceptionMessage", "Lkotlin/Pair;", "", "", "ex", "", "primaryText", "file", "Lcom/badlogic/gdx/files/FileHandle;", "loadMissingMods", "", "missingMods", "", "onModDownloaded", "Lkotlin/Function1;", "onCompleted", "Lkotlin/Function0;", "(Ljava/lang/Iterable;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "core"})
    @SourceDebugExtension(value={"SMAP\nLoadOrSaveScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoadOrSaveScreen.kt\ncom/unciv/ui/screens/savescreens/LoadOrSaveScreen$Helpers\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,232:1\n295#2,2:233\n*S KotlinDebug\n*F\n+ 1 LoadOrSaveScreen.kt\ncom/unciv/ui/screens/savescreens/LoadOrSaveScreen$Helpers\n*L\n222#1:233,2\n*E\n"})
    public static interface Helpers {
        @NotNull
        default public Pair<String, Boolean> getLoadExceptionMessage(@NotNull Throwable ex, @NotNull String primaryText, @Nullable FileHandle file) {
            boolean bl;
            Intrinsics.checkNotNullParameter(ex, "ex");
            Intrinsics.checkNotNullParameter(primaryText, "primaryText");
            StringBuilder errorText = new StringBuilder(TranslationsKt.tr$default(primaryText, false, false, 3, null));
            errorText.append('\n');
            Throwable cause = ex;
            while (cause.getCause() != null && cause instanceof GdxRuntimeException) {
                Intrinsics.checkNotNull(cause.getCause());
            }
            Throwable throwable = cause;
            if (throwable instanceof UncivShowableException) {
                errorText.append(ex.getLocalizedMessage());
                bl = true;
            } else if (throwable instanceof SerializationException) {
                errorText.append(TranslationsKt.tr$default("The file data seems to be corrupted.", false, false, 3, null));
                bl = false;
            } else if (throwable instanceof FileNotFoundException) {
                boolean isPermissionDenied;
                boolean bl2;
                String localizedMessage = UncivGame.Companion.getCurrent().getSystemErrorMessage(5);
                String string = cause.getMessage();
                if (string != null) {
                    String $this$getLoadExceptionMessage_u24lambda_u240 = string;
                    boolean bl3 = false;
                    bl2 = StringsKt.contains$default((CharSequence)$this$getLoadExceptionMessage_u24lambda_u240, "Permission denied", false, 2, null) || localizedMessage != null && StringsKt.contains$default((CharSequence)$this$getLoadExceptionMessage_u24lambda_u240, localizedMessage, false, 2, null);
                } else {
                    bl2 = isPermissionDenied = false;
                }
                if (isPermissionDenied) {
                    StringBuilder stringBuilder = file != null && Helpers.getLoadExceptionMessage$isReadOnly(file) ? errorText.append(TranslationsKt.tr$default("The file is marked read-only.", false, false, 3, null)) : errorText.append(TranslationsKt.tr$default("You do not have sufficient permissions to access the file.", false, false, 3, null));
                }
                bl = isPermissionDenied;
            } else {
                errorText.append(TranslationsKt.tr$default("Unhandled problem, [" + Reflection.getOrCreateKotlinClass(ex.getClass()).getSimpleName() + ' ' + ExceptionsKt.stackTraceToString(ex) + ']', false, false, 3, null));
                bl = false;
            }
            boolean isUserFixable = bl;
            return new Pair<String, Boolean>(errorText.toString(), isUserFixable);
        }

        public static /* synthetic */ Pair getLoadExceptionMessage$default(Helpers helpers, Throwable throwable, String string, FileHandle fileHandle, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getLoadExceptionMessage");
            }
            if ((n & 2) != 0) {
                string = "Could not load game!";
            }
            if ((n & 4) != 0) {
                fileHandle = null;
            }
            return helpers.getLoadExceptionMessage(throwable, string, fileHandle);
        }

        @Nullable
        default public Object loadMissingMods(@NotNull Iterable<String> missingMods, @NotNull Function1<? super String, Unit> onModDownloaded, @NotNull Function0<Unit> onCompleted, @NotNull Continuation<? super Unit> $completion) {
            return Helpers.loadMissingMods$suspendImpl(this, missingMods, onModDownloaded, onCompleted, $completion);
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object loadMissingMods$suspendImpl(Helpers $this, Iterable<String> missingMods, Function1<? super String, Unit> onModDownloaded, Function0<Unit> onCompleted, Continuation<? super Unit> $completion) {
            if (!($completion instanceof loadMissingMods.1)) ** GOTO lbl-1000
            var17_5 = $completion;
            if ((var17_5.label & -2147483648) != 0) {
                var17_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl($this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    Object L$6;
                    Object L$7;
                    Object L$8;
                    /* synthetic */ Object result;
                    final /* synthetic */ Helpers this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return Helpers.loadMissingMods$suspendImpl(this.this$0, null, null, null, this);
                    }
                };
            }
            $result = $continuation.result;
            var18_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure($result);
                    var5_8 = missingMods.iterator();
lbl13:
                    // 2 sources

                    while (var5_8.hasNext()) {
                        rawName = var5_8.next();
                        Intrinsics.checkNotNullExpressionValue(Github.INSTANCE.folderNameToRepoName(rawName).toLowerCase(Locale.ROOT), "toLowerCase(...)");
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable($this);
                        $continuation.L$1 = SpillingKt.nullOutSpilledVariable(missingMods);
                        $continuation.L$2 = onModDownloaded;
                        $continuation.L$3 = onCompleted;
                        $continuation.L$4 = var5_8;
                        $continuation.L$5 = SpillingKt.nullOutSpilledVariable(rawName);
                        $continuation.L$6 = modName;
                        $continuation.L$7 = null;
                        $continuation.L$8 = null;
                        $continuation.label = 1;
                        v0 = Github.INSTANCE.tryGetGithubReposWithTopic(1, 10, modName, $continuation);
                        if (v0 == var18_7) {
                            return var18_7;
                        }
                        ** GOTO lbl41
                    }
                    break;
                }
                case 1: {
                    modName = (String)$continuation.L$6;
                    rawName = (String)$continuation.L$5;
                    var5_8 = (Iterator)$continuation.L$4;
                    onCompleted = (Function0)$continuation.L$3;
                    onModDownloaded = (Function1)$continuation.L$2;
                    missingMods = (Iterable)$continuation.L$1;
                    $this = (Helpers)$continuation.L$0;
                    ResultKt.throwOnFailure($result);
                    v0 = $result;
lbl41:
                    // 2 sources

                    if ((GithubAPI.RepoSearch)v0 == null) {
                        throw new UncivShowableException("Could not download mod list.", null, 2, null);
                    }
                    $this$firstOrNull$iv = repos.getItems();
                    $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        it = (GithubAPI.Repo)element$iv;
                        $i$a$-firstOrNull-LoadOrSaveScreen$Helpers$loadMissingMods$repo$1 = false;
                        v1 = it.getName().toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(v1, "toLowerCase(...)");
                        if (!Intrinsics.areEqual(v1, modName)) continue;
                        v2 = element$iv;
                        ** GOTO lbl54
                    }
                    v2 = null;
lbl54:
                    // 2 sources

                    if ((GithubAPI.Repo)v2 == null) {
                        throw new UncivShowableException("Could not find a mod named \"[" + modName + "]\".", null, 2, null);
                    }
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable($this);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable(missingMods);
                    $continuation.L$2 = onModDownloaded;
                    $continuation.L$3 = onCompleted;
                    $continuation.L$4 = var5_8;
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable(rawName);
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable(modName);
                    $continuation.L$7 = SpillingKt.nullOutSpilledVariable(repos);
                    $continuation.L$8 = repo;
                    $continuation.label = 2;
                    v3 = GithubAPI.downloadAndExtract$default(GithubAPI.INSTANCE, repo, null, $continuation, 1, null);
                    if (v3 == var18_7) {
                        return var18_7;
                    }
                    ** GOTO lbl82
                }
                case 2: {
                    repo = (GithubAPI.Repo)$continuation.L$8;
                    repos = (GithubAPI.RepoSearch)$continuation.L$7;
                    modName = (String)$continuation.L$6;
                    rawName = (String)$continuation.L$5;
                    var5_8 = (Iterator)$continuation.L$4;
                    onCompleted = (Function0)$continuation.L$3;
                    onModDownloaded = (Function1)$continuation.L$2;
                    missingMods = (Iterable)$continuation.L$1;
                    $this = (Helpers)$continuation.L$0;
                    ResultKt.throwOnFailure($result);
                    v3 = $result;
lbl82:
                    // 2 sources

                    if ((FileHandle)v3 == null) {
                        throw new Exception("Unexpected 404 error");
                    }
                    onModDownloaded.invoke(repo.getName());
                    ** GOTO lbl13
                }
            }
            onCompleted.invoke();
            return Unit.INSTANCE;
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private static boolean getLoadExceptionMessage$isReadOnly(FileHandle $this$getLoadExceptionMessage_u24isReadOnly) {
            try {
                String string = $this$getLoadExceptionMessage_u24isReadOnly.file().getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue(string, "getAbsolutePath(...)");
                Path path = Paths.get(string, new String[0]);
                Intrinsics.checkNotNullExpressionValue(path, "get(...)");
                Path path2 = path;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                DosFileAttributes dosFileAttributes = Files.readAttributes(path2, DosFileAttributes.class, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
                Intrinsics.checkNotNullExpressionValue(dosFileAttributes, "readAttributes(...)");
                DosFileAttributes attr = dosFileAttributes;
                return attr.isReadOnly();
            }
            catch (Throwable throwable) {
                return false;
            }
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            @Deprecated
            @NotNull
            public static Pair<String, Boolean> getLoadExceptionMessage(@NotNull Helpers $this, @NotNull Throwable ex, @NotNull String primaryText, @Nullable FileHandle file) {
                Intrinsics.checkNotNullParameter(ex, "ex");
                Intrinsics.checkNotNullParameter(primaryText, "primaryText");
                return $this.getLoadExceptionMessage(ex, primaryText, file);
            }

            public static /* synthetic */ Pair getLoadExceptionMessage$default(Helpers helpers, Throwable throwable, String string, FileHandle fileHandle, int n, Object object) {
                return Helpers.getLoadExceptionMessage$default(helpers, throwable, string, fileHandle, n, object);
            }

            @Deprecated
            @Nullable
            public static Object loadMissingMods(@NotNull Helpers $this, @NotNull Iterable<String> missingMods, @NotNull Function1<? super String, Unit> onModDownloaded, @NotNull Function0<Unit> onCompleted, @NotNull Continuation<? super Unit> $completion) {
                return $this.loadMissingMods(missingMods, onModDownloaded, onCompleted, $completion);
            }
        }
    }
}

