/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.unit.actions;

import com.unciv.Constants;
import com.unciv.GUI;
import com.unciv.UncivGame;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.PlayerType;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.managers.ImprovementFunctions;
import com.unciv.logic.civilization.transients.CivInfoTransientCache;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.ImprovementBuildingProblem;
import com.unciv.logic.map.tile.RoadStatus;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Counter;
import com.unciv.models.UncivSound;
import com.unciv.models.UnitAction;
import com.unciv.models.UnitActionType;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.stats.Stat;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.screens.pickerscreens.ImprovementPickerScreen;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.unit.actions.UnitActionModifiers;
import com.unciv.ui.screens.worldscreen.unit.actions.UnitActionsFromUniques;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ\u001f\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\rJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0003J#\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0013J#\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0015J#\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0017J#\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0019J#\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u001bJ#\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u001dJ#\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u001fJ\u001a\u0010 \u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ#\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b#J#\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b%J#\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b'J\u0015\u0010(\u001a\u00020)2\u0006\u0010\u0007\u001a\u00020\bH\u0001\u00a2\u0006\u0002\b*J#\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b,J\u0010\u0010-\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006."}, d2={"Lcom/unciv/ui/screens/worldscreen/unit/actions/UnitActionsFromUniques;", "", "<init>", "()V", "getFoundCityActions", "Lkotlin/sequences/Sequence;", "Lcom/unciv/models/UnitAction;", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "tile", "Lcom/unciv/logic/map/tile/Tile;", "getFoundCityActions$core", "getFoundCityAction", "getFoundCityAction$core", "getLeadersWePromisedNotToSettleNear", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "getSetupActions", "getSetupActions$core", "getParadropActions", "getParadropActions$core", "getAirSweepActions", "getAirSweepActions$core", "getGuardActions", "getGuardActions$core", "getTriggerUniqueActions", "getTriggerUniqueActions$core", "getAddInCapitalActions", "getAddInCapitalActions$core", "getImprovementCreationActions", "getImprovementCreationActions$core", "getWaterImprovementAction", "getImprovementConstructionActionsFromGeneralUnique", "getConnectRoadActions", "getConnectRoadActions$core", "getTransformActions", "getTransformActions$core", "getBuildingImprovementsActions", "getBuildingImprovementsActions$core", "getRepairTurns", "", "getRepairTurns$core", "getRepairActions", "getRepairActions$core", "getRepairAction", "core"})
@SourceDebugExtension(value={"SMAP\nUnitActionsFromUniques.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitActionsFromUniques.kt\ncom/unciv/ui/screens/worldscreen/unit/actions/UnitActionsFromUniques\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,528:1\n1761#2,3:529\n774#2:533\n865#2,2:534\n774#2:536\n865#2,2:537\n1761#2,3:539\n1#3:532\n2275#4,2:542\n*S KotlinDebug\n*F\n+ 1 UnitActionsFromUniques.kt\ncom/unciv/ui/screens/worldscreen/unit/actions/UnitActionsFromUniques\n*L\n58#1:529,3\n127#1:533\n127#1:534,2\n128#1:536\n128#1:537,2\n464#1:539,3\n515#1:542,2\n*E\n"})
public final class UnitActionsFromUniques {
    @NotNull
    public static final UnitActionsFromUniques INSTANCE = new UnitActionsFromUniques();

    private UnitActionsFromUniques() {
    }

    @NotNull
    public final Sequence<UnitAction> getFoundCityActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        return SequencesKt.filterNotNull(SequencesKt.sequenceOf(this.getFoundCityAction$core(unit, tile)));
    }

    @Nullable
    public final UnitAction getFoundCityAction$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        Object element$iv2;
        boolean bl;
        Unique unique;
        block8: {
            Intrinsics.checkNotNullParameter(unit, "unit");
            Intrinsics.checkNotNullParameter(tile, "tile");
            Unique unique2 = SequencesKt.firstOrNull(UnitActionModifiers.INSTANCE.getUsableUnitActionUniques(unit, UniqueType.FoundCity));
            if (unique2 == null && (unique2 = SequencesKt.firstOrNull(UnitActionModifiers.INSTANCE.getUsableUnitActionUniques(unit, UniqueType.FoundPuppetCity))) == null) {
                return null;
            }
            unique = unique2;
            if (tile.isWater() || tile.isImpassible()) {
                return null;
            }
            if (unit.getCiv().isOneCityChallenger() && unit.getCiv().getHasEverOwnedOriginalCapital()) {
                return null;
            }
            if (!unit.hasMovement() || !tile.canBeSettled(unit.getCiv())) {
                return new UnitAction(UnitActionType.FoundCity, 80.0f, null, false, null, null, null, 60, null);
            }
            Iterable $this$any$iv = unique.getModifiers();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    Unique it = (Unique)element$iv2;
                    boolean bl2 = false;
                    Object object = it.getType();
                    boolean bl3 = object != null && (object = object.getTargetTypes()) != null ? ((HashSet)object).contains((Object)UniqueTarget.UnitActionModifier) : false;
                    if (!bl3) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        boolean hasActionModifiers = bl;
        Function0<Unit> foundAction = () -> UnitActionsFromUniques.getFoundCityAction$lambda$1(unit, unique, tile, hasActionModifiers);
        if (unit.getCiv().getPlayerType() == PlayerType.AI) {
            return new UnitAction(UnitActionType.FoundCity, 80.0f, null, false, null, null, foundAction, 60, null);
        }
        String title = hasActionModifiers ? UnitActionModifiers.INSTANCE.actionTextWithSideEffects(UnitActionType.FoundCity.getValue(), unique, unit) : UnitActionType.FoundCity.getValue();
        Function0<Unit> function0 = () -> UnitActionsFromUniques.getFoundCityAction$lambda$2(unit, tile, foundAction);
        element$iv2 = function0;
        Unique unique3 = unique;
        UncivSound uncivSound = UncivSound.Companion.getChimes();
        boolean bl4 = false;
        String string = title;
        float f = 80.0f;
        UnitActionType unitActionType = UnitActionType.FoundCity;
        boolean bl5 = false;
        boolean bl6 = UnitActionModifiers.INSTANCE.canActivateSideEffects(unit, unique);
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 8;
        Object object = bl6 ? function0 : null;
        Unique unique4 = unique3;
        UncivSound uncivSound2 = uncivSound;
        boolean bl7 = bl4;
        String string2 = string;
        float f2 = f;
        UnitActionType unitActionType2 = unitActionType;
        return new UnitAction(unitActionType2, f2, string2, bl7, uncivSound2, unique4, (Function0)object, n, defaultConstructorMarker);
    }

    @Readonly
    private final String getLeadersWePromisedNotToSettleNear(Civilization civInfo, Tile tile) {
        HashSet leadersWePromisedNotToSettleNear = new HashSet();
        Iterator<Civilization> iterator2 = SequencesKt.filter(civInfo.getKnownCivs(), arg_0 -> UnitActionsFromUniques.getLeadersWePromisedNotToSettleNear$lambda$0(civInfo, arg_0)).iterator();
        while (iterator2.hasNext()) {
            City it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            DiplomacyManager diplomacyManager;
            Civilization otherCiv = iterator2.next();
            Intrinsics.checkNotNull(otherCiv.getDiplomacyManager(civInfo));
            if (!diplomacyManager.hasFlag(DiplomacyFlags.AgreedToNotSettleNearUs)) continue;
            Iterable iterable = otherCiv.getCities();
            boolean $i$f$filter = false;
            void var10_10 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (City)element$iv$iv;
                boolean bl = false;
                if (!(it.getCenterTile().aerialDistanceTo(tile) <= 6)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (City)element$iv$iv;
                boolean bl = false;
                if (!otherCiv.hasExplored(it.getCenterTile())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List citiesWithin6Tiles = (List)destination$iv$iv;
            if (!(!((Collection)citiesWithin6Tiles).isEmpty())) continue;
            ((Collection)leadersWePromisedNotToSettleNear).add(otherCiv.getLeaderDisplayName());
        }
        return leadersWePromisedNotToSettleNear.isEmpty() ? null : CollectionsKt.joinToString$default(leadersWePromisedNotToSettleNear, ", ", null, null, 0, null, null, 62, null);
    }

    @NotNull
    public final Sequence<UnitAction> getSetupActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        Function0<Unit> function0;
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        if (!MapUnit.hasUnique$default(unit, UniqueType.MustSetUp, null, false, 6, null) || unit.isEmbarked()) {
            return SequencesKt.emptySequence();
        }
        boolean isSetUp = unit.isSetUpForSiege();
        UnitActionType unitActionType = UnitActionType.SetUp;
        Function0<Unit> it = function0 = () -> UnitActionsFromUniques.getSetupActions$lambda$0(unit);
        boolean bl = false;
        Function0<Unit> function02 = unit.hasMovement() && !isSetUp ? function0 : null;
        return SequencesKt.sequenceOf(new UnitAction(unitActionType, 85.0f, null, isSetUp, null, null, function02, 52, null));
    }

    @NotNull
    public final Sequence<UnitAction> getParadropActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        Function0<Unit> function0;
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        unit.getCache().getParadropDestinationTileFilters().clear();
        Sequence paradropUniques = MapUnit.getMatchingUniques$default(unit, UniqueType.MayParadrop, unit.getCache().getState(), false, 4, null);
        Object object = paradropUniques.iterator();
        while (object.hasNext()) {
            Unique unique = (Unique)object.next();
            String tileFilter = unique.getParams().get(0);
            int distance = Integer.parseInt(unique.getParams().get(1));
            Integer existingDistance = unit.getCache().getParadropDestinationTileFilters().get(tileFilter);
            if (existingDistance != null && distance <= existingDistance) continue;
            unit.getCache().getParadropDestinationTileFilters().put(tileFilter, distance);
        }
        if (unit.getCache().getParadropDestinationTileFilters().isEmpty()) {
            return SequencesKt.emptySequence();
        }
        object = UnitActionType.Paradrop;
        boolean bl = unit.isPreparingParadrop();
        Function0<Unit> it = function0 = () -> UnitActionsFromUniques.getParadropActions$lambda$0(unit);
        boolean bl2 = false;
        Function0<Unit> function02 = !unit.hasUnitMovedThisTurn() ? function0 : null;
        return SequencesKt.sequenceOf(new UnitAction((UnitActionType)((Object)object), 60.0f, null, bl, null, null, function02, 52, null));
    }

    @NotNull
    public final Sequence<UnitAction> getAirSweepActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        Function0<Unit> function0;
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        Sequence airsweepUniques = MapUnit.getMatchingUniques$default(unit, UniqueType.CanAirsweep, null, false, 6, null);
        if (!SequencesKt.any(airsweepUniques)) {
            return SequencesKt.emptySequence();
        }
        UnitActionType unitActionType = UnitActionType.AirSweep;
        boolean bl = unit.isPreparingAirSweep();
        Function0<Unit> it = function0 = () -> UnitActionsFromUniques.getAirSweepActions$lambda$0(unit);
        boolean bl2 = false;
        Function0<Unit> function02 = unit.canAttack() ? function0 : null;
        return SequencesKt.sequenceOf(new UnitAction(unitActionType, 90.0f, null, bl, null, null, function02, 52, null));
    }

    @NotNull
    public final Sequence<UnitAction> getGuardActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        Function0<Unit> function0;
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        if (!MapUnit.hasUnique$default(unit, UniqueType.WithdrawsBeforeMeleeCombat, null, false, 6, null)) {
            return SequencesKt.emptySequence();
        }
        if (unit.isGuarding()) {
            String title = MapUnit.canFortify$default(unit, false, 1, null) ? TranslationsKt.tr$default("Guarding", false, false, 3, null) + ' ' + unit.getFortificationTurns() * 20 + '%' : TranslationsKt.tr$default("Guarding", false, false, 3, null);
            UnitActionType unitActionType = UnitActionType.Guard;
            return SequencesKt.sequenceOf(new UnitAction(unitActionType, 0.0f, title, true, null, null, null, 112, null));
        }
        if (!unit.hasMovement()) {
            return SequencesKt.emptySequence();
        }
        Function0<Unit> function02 = function0 = () -> UnitActionsFromUniques.getGuardActions$lambda$0(unit);
        Unique unique = null;
        UncivSound uncivSound = null;
        boolean bl = false;
        String string = null;
        float f = 0.0f;
        UnitActionType unitActionType = UnitActionType.Guard;
        boolean bl2 = false;
        boolean bl3 = !unit.isGuarding();
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 60;
        Function0<Unit> function03 = bl3 ? function0 : null;
        Unique unique2 = unique;
        UncivSound uncivSound2 = uncivSound;
        boolean bl4 = bl;
        String string2 = string;
        float f2 = f;
        UnitActionType unitActionType2 = unitActionType;
        return SequencesKt.sequenceOf(new UnitAction(unitActionType2, f2, string2, bl4, uncivSound2, unique2, function03, n, defaultConstructorMarker));
    }

    @NotNull
    public final Sequence<UnitAction> getTriggerUniqueActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super UnitAction>, Continuation<? super Unit>, Object>(unit, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ MapUnit $unit;
            {
                this.$unit = $unit;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Object invokeSuspend(Object $result) {
                Object object;
                Unique unique;
                String baseTitle;
                String title;
                Function0<R> unitAction;
                Iterator iterator2;
                SequenceScope sequenceScope = (SequenceScope)this.L$0;
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        iterator2 = this.$unit.getUniques().iterator();
                        break;
                    }
                    case 1: {
                        unitAction = (Function0<R>)this.L$5;
                        title = (String)this.L$4;
                        baseTitle = (String)this.L$3;
                        unique = (Unique)this.L$2;
                        iterator2 = (Iterator)this.L$1;
                        ResultKt.throwOnFailure($result);
                        object = $result;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }
                while (iterator2.hasNext()) {
                    void $this$sequence;
                    void var8_19;
                    String string;
                    boolean bl;
                    block19: {
                        unique = iterator2.next();
                        Iterable $this$none$iv = unique.getModifiers();
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (T t : $this$none$iv) {
                                Unique it = (Unique)t;
                                boolean bl2 = false;
                                Object object3 = it.getType();
                                boolean bl3 = object3 != null && (object3 = object3.getTargetTypes()) != null ? ((HashSet)object3).contains((Object)((Object)UniqueTarget.UnitActionModifier)) : false;
                                if (!bl3) continue;
                                bl = false;
                                break block19;
                            }
                            bl = true;
                        }
                    }
                    if (bl || unique.hasModifier(UniqueType.UnitActionExtraLimitedTimes) || !unique.isTriggerable() || !unique.conditionalsApply(this.$unit.getCache().getState()) || !UnitActionModifiers.INSTANCE.canUse(this.$unit, unique)) continue;
                    UniqueType uniqueType = unique.getType();
                    switch (uniqueType == null ? -1 : getTriggerUniqueActions.WhenMappings.$EnumSwitchMapping$0[uniqueType.ordinal()]) {
                        case 1: {
                            String[] stringArray = new String[]{TranslationsKt.tr(Boxing.boxInt(this.$unit.getCiv().getGoldenAges().calculateGoldenAgeLength(Integer.parseInt(unique.getParams().get(0)))))};
                            string = TranslationsKt.fillPlaceholders(unique.getPlaceholderText(), stringArray);
                            break;
                        }
                        case 2: {
                            if (unique.hasModifier(UniqueType.ModifiedByGameSpeed)) {
                                String string2 = unique.getParams().get(1);
                                Float f = this.$unit.getCiv().getGameInfo().getSpeed().getStatCostModifiers().get(Stat.Companion.safeValueOf(string2));
                                float modifier = f != null ? f.floatValue() : this.$unit.getCiv().getGameInfo().getSpeed().getModifier();
                                String[] bl2 = new String[]{TranslationsKt.tr(Boxing.boxInt((int)((float)Integer.parseInt(unique.getParams().get(0)) * modifier))), string2};
                                string = TranslationsKt.fillPlaceholders(UniqueType.OneTimeGainStat.getPlaceholderText(), bl2);
                                break;
                            }
                            string = TranslationsKt.removeConditionals(unique.getText());
                            break;
                        }
                        case 3: {
                            String string3 = unique.getParams().get(2);
                            Float f = this.$unit.getCiv().getGameInfo().getSpeed().getStatCostModifiers().get(Stat.Companion.safeValueOf(string3));
                            float modifier = f != null ? f.floatValue() : this.$unit.getCiv().getGameInfo().getSpeed().getModifier();
                            String[] bl2 = new String[]{TranslationsKt.tr(Boxing.boxInt((int)((float)Integer.parseInt(unique.getParams().get(0)) * modifier))), TranslationsKt.tr(Boxing.boxInt((int)((float)Integer.parseInt(unique.getParams().get(1)) * modifier))), string3};
                            string = TranslationsKt.fillPlaceholders(unique.getPlaceholderText(), bl2);
                            break;
                        }
                        case 4: {
                            string = unique.getParams().get(0);
                            break;
                        }
                        default: {
                            string = TranslationsKt.removeConditionals(unique.getText());
                        }
                    }
                    baseTitle = string;
                    title = UnitActionModifiers.INSTANCE.actionTextWithSideEffects(baseTitle, unique, this.$unit);
                    if (!this.$unit.hasMovement()) {
                        Object var8_16 = null;
                    } else if (UniqueTriggerActivation.getTriggerFunction$default(UniqueTriggerActivation.INSTANCE, unique, this.$unit.getCiv(), null, this.$unit, this.$unit.getCurrentTile(), null, null, 100, null) == null) {
                        Object var8_17 = null;
                    } else {
                        Function0 triggerFunction;
                        Function0<Unit> function0 = () -> getTriggerUniqueActions.1.invokeSuspend$lambda$1(unique, this.$unit, triggerFunction);
                    }
                    Function0<R> function0 = unitAction = var8_19;
                    MapUnit mapUnit = this.$unit;
                    Function0<R> bl2 = function0;
                    Unique unique2 = unique;
                    UncivSound uncivSound = null;
                    boolean bl4 = false;
                    String string4 = title;
                    float f = 80.0f;
                    UnitActionType unitActionType = UnitActionType.TriggerUnique;
                    void var12_29 = $this$sequence;
                    boolean bl5 = false;
                    boolean bl6 = UnitActionModifiers.INSTANCE.canActivateSideEffects(mapUnit, unique);
                    DefaultConstructorMarker defaultConstructorMarker = null;
                    int n = 24;
                    Function0<R> function02 = bl6 ? function0 : null;
                    Unique unique3 = unique2;
                    UncivSound uncivSound2 = uncivSound;
                    String string5 = string4;
                    float f2 = f;
                    UnitActionType unitActionType2 = unitActionType;
                    this.L$0 = $this$sequence;
                    this.L$1 = iterator2;
                    this.L$2 = SpillingKt.nullOutSpilledVariable(unique);
                    this.L$3 = SpillingKt.nullOutSpilledVariable(baseTitle);
                    this.L$4 = SpillingKt.nullOutSpilledVariable(title);
                    this.L$5 = SpillingKt.nullOutSpilledVariable(unitAction);
                    this.label = 1;
                    object = var12_29.yield(new UnitAction(unitActionType2, f2, string5, false, uncivSound2, unique3, function02, n, defaultConstructorMarker), this);
                    if (object != object2) continue;
                    return object2;
                }
                return Unit.INSTANCE;
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super UnitAction>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super UnitAction> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$1(Unique $unique, MapUnit $unit, Function0 $triggerFunction) {
                int n = $unique.getUniqueMultiplier($unit.getCache().getState());
                int n2 = 0;
                while (n2 < n) {
                    int it = n2++;
                    boolean bl = false;
                    $triggerFunction.invoke();
                }
                UnitActionModifiers.activateSideEffects$default(UnitActionModifiers.INSTANCE, $unit, $unique, false, 4, null);
                return Unit.INSTANCE;
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final Sequence<UnitAction> getAddInCapitalActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        if (!MapUnit.hasUnique$default(unit, UniqueType.AddInCapital, null, false, 6, null)) {
            return SequencesKt.emptySequence();
        }
        var3_3 = UnitActionType.AddInCapital;
        var4_4 = "Add to [" + ((Unique)SequencesKt.first(MapUnit.getMatchingUniques$default(unit, UniqueType.AddInCapital, null, false, 6, null))).getParams().get(0) + ']';
        it = var6_5 = (Function0<Unit>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getAddInCapitalActions$lambda$0(com.unciv.logic.map.mapunit.MapUnit ), ()Lkotlin/Unit;)((MapUnit)unit);
        $i$a$-takeIf-UnitActionsFromUniques$getAddInCapitalActions$2 = false;
        if (!tile.isCityCenter()) ** GOTO lbl-1000
        v0 = tile.getCity();
        Intrinsics.checkNotNull(v0);
        if (!v0.isCapital()) ** GOTO lbl-1000
        v1 = tile.getCity();
        Intrinsics.checkNotNull(v1);
        if (Intrinsics.areEqual(v1.getCiv(), unit.getCiv())) {
            v2 = true;
        } else lbl-1000:
        // 3 sources

        {
            v2 = false;
        }
        var5_8 = v2 != false ? var6_5 : null;
        return SequencesKt.sequenceOf(new UnitAction(var3_3, 80.0f, var4_4, false, null, null, var5_8, 56, null));
    }

    @NotNull
    public final Sequence<UnitAction> getImprovementCreationActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super UnitAction>, Continuation<? super Unit>, Object>(unit, tile, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ MapUnit $unit;
            final /* synthetic */ Tile $tile;
            {
                this.$unit = $unit;
                this.$tile = $tile;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (SequenceScope)this.L$0;
                var4_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        waterImprovementAction = UnitActionsFromUniques.access$getWaterImprovementAction(UnitActionsFromUniques.INSTANCE, this.$unit, this.$tile);
                        if (waterImprovementAction != null) {
                            this.L$0 = $this$sequence;
                            this.L$1 = SpillingKt.nullOutSpilledVariable(waterImprovementAction);
                            this.label = 1;
                            v0 = $this$sequence.yield(waterImprovementAction, this);
                            if (v0 == var4_3) {
                                return var4_3;
                            }
                        }
                        ** GOTO lbl19
                    }
                    case 1: {
                        waterImprovementAction = (UnitAction)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl19:
                        // 2 sources

                        this.L$0 = SpillingKt.nullOutSpilledVariable($this$sequence);
                        this.L$1 = SpillingKt.nullOutSpilledVariable(waterImprovementAction);
                        this.label = 2;
                        v1 = $this$sequence.yieldAll(UnitActionsFromUniques.INSTANCE.getImprovementConstructionActionsFromGeneralUnique(this.$unit, this.$tile), (Continuation<? super Unit>)this);
                        if (v1 == var4_3) {
                            return var4_3;
                        }
                        ** GOTO lbl30
                    }
                    case 2: {
                        waterImprovementAction = (UnitAction)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl30:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super UnitAction>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super UnitAction> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private final UnitAction getWaterImprovementAction(MapUnit unit, Tile tile) {
        Function0<Unit> function0;
        if (!tile.isWater() || !MapUnit.hasUnique$default(unit, UniqueType.CreateWaterImprovements, null, false, 6, null) || tile.getResource() == null) {
            return null;
        }
        String string = tile.getTileResource().getImprovingImprovement(tile, unit.getCache().getState());
        if (string == null) {
            return null;
        }
        String improvementName = string;
        TileImprovement tileImprovement = tile.getRuleset().getTileImprovements().get(improvementName);
        if (tileImprovement == null) {
            return null;
        }
        TileImprovement improvement = tileImprovement;
        if (!tile.getImprovementFunctions().canBuildImprovement(improvement, unit.getCache().getState())) {
            return null;
        }
        Function0<Unit> function02 = function0 = () -> UnitActionsFromUniques.getWaterImprovementAction$lambda$0(tile, improvementName, unit);
        Unique unique = null;
        UncivSound uncivSound = null;
        boolean bl = false;
        String string2 = "Create [" + improvementName + ']';
        float f = 82.0f;
        UnitActionType unitActionType = UnitActionType.CreateImprovement;
        boolean bl2 = false;
        boolean bl3 = unit.hasMovement();
        Function0<Unit> function03 = bl3 ? function0 : null;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 56;
        Function0<Unit> function04 = function03;
        Unique unique2 = unique;
        UncivSound uncivSound2 = uncivSound;
        boolean bl4 = bl;
        String string3 = string2;
        float f2 = f;
        UnitActionType unitActionType2 = unitActionType;
        return new UnitAction(unitActionType2, f2, string3, bl4, uncivSound2, unique2, function04, n, defaultConstructorMarker);
    }

    @NotNull
    public final Sequence<UnitAction> getImprovementConstructionActionsFromGeneralUnique(@NotNull MapUnit unit, @NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super UnitAction>, Continuation<? super Unit>, Object>(unit, tile, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            Object L$6;
            Object L$7;
            Object L$8;
            Object L$9;
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ MapUnit $unit;
            final /* synthetic */ Tile $tile;
            {
                this.$unit = $unit;
                this.$tile = $tile;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (SequenceScope)this.L$0;
                var35_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        uniquesToCheck = UnitActionModifiers.INSTANCE.getUsableUnitActionUniques(this.$unit, UniqueType.ConstructImprovementInstantly);
                        civResources = this.$unit.getCiv().getCivResourcesByName();
                        gameContext = new GameContext(this.$unit.getCiv(), null, this.$unit, this.$tile, null, null, null, null, null, null, false, 2034, null);
                        var6_7 = uniquesToCheck.iterator();
                        while (var6_7.hasNext()) {
                            unique = var6_7.next();
                            improvementFilter = unique.getParams().get(0);
                            v0 = this.$tile.getRuleset().getTileImprovements().values();
                            Intrinsics.checkNotNullExpressionValue(v0, "<get-values>(...)");
                            $this$filter$iv = v0;
                            $i$f$filter = false;
                            var12_14 = $this$filter$iv;
                            destination$iv$iv = new ArrayList<E>();
                            $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                it = (TileImprovement)element$iv$iv;
                                $i$a$-filter-UnitActionsFromUniques$getImprovementConstructionActionsFromGeneralUnique$1$improvements$1 = false;
                                Intrinsics.checkNotNull(it);
                                if (!TileImprovement.matchesFilter$default(it, improvementFilter, gameContext, false, 4, null)) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            improvements = (List)destination$iv$iv;
                            var10_11 = improvements.iterator();
lbl30:
                            // 4 sources

                            while (var10_11.hasNext()) {
                                v1 = var10_11.next();
                                Intrinsics.checkNotNullExpressionValue(v1, "next(...)");
                                improvement = (TileImprovement)v1;
                                $this$any$iv = this.$tile.getImprovementFunctions().getImprovementBuildingProblems(improvement, gameContext);
                                $i$f$any = false;
                                $i$f$filterTo = $this$any$iv.iterator();
                                while ($i$f$filterTo.hasNext()) {
                                    it = element$iv = $i$f$filterTo.next();
                                    $i$a$-any-UnitActionsFromUniques$getImprovementConstructionActionsFromGeneralUnique$1$1 = false;
                                    if (!it.getPermanent()) continue;
                                    v2 = true;
                                    ** GOTO lbl44
                                }
                                v2 = false;
lbl44:
                                // 2 sources

                                if (v2) continue;
                                $this$none$iv = IHasUniques.getMatchingUniques$default(improvement, UniqueType.ConsumesResources, null, 2, null);
                                $i$f$none = false;
                                var15_23 = $this$none$iv.iterator();
                                while (var15_23.hasNext()) {
                                    element$iv /* !! */  = var15_23.next();
                                    improvementUnique = (Unique)element$iv /* !! */ ;
                                    $i$a$-none-UnitActionsFromUniques$getImprovementConstructionActionsFromGeneralUnique$1$resourcesAvailable$1 = false;
                                    v3 = (Integer)civResources.get(improvementUnique.getParams().get(1));
                                    if (!((v3 != null ? v3 : 0) < Integer.parseInt(improvementUnique.getParams().get(0)))) continue;
                                    v4 = 0;
                                    ** GOTO lbl57
                                }
                                v4 = 1;
lbl57:
                                // 2 sources

                                resourcesAvailable = v4;
                                var13_18 = (Function0<Unit>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$3(com.unciv.logic.map.mapunit.MapUnit com.unciv.models.ruleset.tile.TileImprovement com.unciv.models.ruleset.unique.Unique ), ()Lkotlin/Unit;)((MapUnit)this.$unit, (TileImprovement)improvement, (Unique)unique);
                                var14_22 = this.$unit;
                                var15_23 = this.$tile;
                                element$iv /* !! */  = var13_18;
                                var25_36 = unique;
                                var24_35 = null;
                                var23_34 = false;
                                var22_33 = UnitActionModifiers.INSTANCE.actionTextWithSideEffects("Create [" + improvement.getName() + ']', unique, this.$unit);
                                var21_32 = 85.0f;
                                var20_31 = UnitActionType.CreateImprovement;
                                var19_30 = $this$sequence;
                                $i$a$-takeIf-UnitActionsFromUniques$getImprovementConstructionActionsFromGeneralUnique$1$3 = false;
                                var26_37 = resourcesAvailable != 0 && var14_22.hasMovement() != false && var15_23.getImprovementFunctions().canBuildImprovement(improvement, var14_22.getCache().getState()) != false && var15_23.isMarkedForCreatesOneImprovement() == false && UnitActionModifiers.INSTANCE.canActivateSideEffects(var14_22, unique) != false;
                                var27_38 = null;
                                var28_39 = 24;
                                var29_40 = var26_37 != false ? var13_18 : null;
                                var30_41 = var25_36;
                                var31_42 = var24_35;
                                var32_43 = var22_33;
                                var33_44 = var21_32;
                                var34_45 = var20_31;
                                this.L$0 = $this$sequence;
                                this.L$1 = SpillingKt.nullOutSpilledVariable(uniquesToCheck);
                                this.L$2 = civResources;
                                this.L$3 = gameContext;
                                this.L$4 = var6_7;
                                this.L$5 = unique;
                                this.L$6 = SpillingKt.nullOutSpilledVariable(improvementFilter);
                                this.L$7 = SpillingKt.nullOutSpilledVariable(improvements);
                                this.L$8 = var10_11;
                                this.L$9 = SpillingKt.nullOutSpilledVariable(improvement);
                                this.I$0 = resourcesAvailable;
                                this.label = 1;
                                v5 = var19_30.yield(new UnitAction(var34_45, var33_44, var32_43, false, var31_42, var30_41, var29_40, var28_39, var27_38), this);
                                if (v5 != var35_3) continue;
                                return var35_3;
                            }
                        }
                        break;
                    }
                    case 1: {
                        resourcesAvailable = this.I$0;
                        improvement = (TileImprovement)this.L$9;
                        var10_11 = (Iterator<E>)this.L$8;
                        improvements = (List)this.L$7;
                        improvementFilter = (String)this.L$6;
                        unique = (Unique)this.L$5;
                        var6_7 = (Iterator<Unique>)this.L$4;
                        gameContext = (GameContext)this.L$3;
                        civResources = (HashMap)this.L$2;
                        uniquesToCheck = (Sequence)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v5 = $result;
                        ** GOTO lbl30
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super UnitAction>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super UnitAction> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$3(MapUnit $unit, TileImprovement $improvement, Unique $unique) {
                Tile unitTile = $unit.getTile();
                unitTile.setImprovement($improvement.getName(), $unit.getCiv(), $unit);
                CivInfoTransientCache.updateViewableTiles$default($unit.getCiv().getCache(), null, 1, null);
                UnitActionModifiers.activateSideEffects$default(UnitActionModifiers.INSTANCE, $unit, $unique, false, 4, null);
                return Unit.INSTANCE;
            }
        });
    }

    @NotNull
    public final Sequence<UnitAction> getConnectRoadActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super UnitAction>, Continuation<? super Unit>, Object>(unit, null){
            Object L$1;
            Object L$2;
            Object L$3;
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ MapUnit $unit;
            {
                this.$unit = $unit;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (SequenceScope)this.L$0;
                var12_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        if (!MapUnit.hasUnique$default(this.$unit, UniqueType.BuildImprovements, null, false, 6, null)) {
                            return Unit.INSTANCE;
                        }
                        unitCivBestRoad = this.$unit.getCiv().getTech().getBestRoadAvailable();
                        if (unitCivBestRoad == RoadStatus.None) {
                            return Unit.INSTANCE;
                        }
                        $this$any$iv = uniquesToCheck = UnitActionModifiers.INSTANCE.getUsableUnitActionUniques(this.$unit, UniqueType.BuildImprovements);
                        $i$f$any = false;
                        var8_11 = $this$any$iv.iterator();
                        while (var8_11.hasNext()) {
                            it = element$iv = var8_11.next();
                            $i$a$-any-UnitActionsFromUniques$getConnectRoadActions$1$unitCanBuildRoad$1 = false;
                            if (!(Intrinsics.areEqual(it.getParams().get(0), "Land") != false || Constants.INSTANCE.getAll().contains(it.getParams().get(0)) != false)) continue;
                            v0 = true;
                            ** GOTO lbl21
                        }
                        v0 = false;
lbl21:
                        // 2 sources

                        if (v0) ** GOTO lbl-1000
                        $this$any$iv = uniquesToCheck;
                        $i$f$any = false;
                        var8_11 = $this$any$iv.iterator();
                        while (var8_11.hasNext()) {
                            it = element$iv = var8_11.next();
                            $i$a$-any-UnitActionsFromUniques$getConnectRoadActions$1$unitCanBuildRoad$2 = false;
                            if (!Intrinsics.areEqual(it.getParams().get(0), "Road")) continue;
                            v1 = true;
                            ** GOTO lbl32
                        }
                        v1 = false;
lbl32:
                        // 2 sources

                        if (v1 && (unitCivBestRoad == RoadStatus.Road || unitCivBestRoad == RoadStatus.Railroad)) ** GOTO lbl-1000
                        $this$any$iv = uniquesToCheck;
                        $i$f$any = false;
                        var8_11 = $this$any$iv.iterator();
                        while (var8_11.hasNext()) {
                            it = element$iv = var8_11.next();
                            $i$a$-any-UnitActionsFromUniques$getConnectRoadActions$1$unitCanBuildRoad$3 = false;
                            if (!Intrinsics.areEqual(it.getParams().get(0), "Railroad")) continue;
                            v2 = true;
                            ** GOTO lbl43
                        }
                        v2 = false;
lbl43:
                        // 2 sources

                        if (v2 && unitCivBestRoad == RoadStatus.Railroad) lbl-1000:
                        // 3 sources

                        {
                            v3 = 1;
                        } else {
                            v3 = unitCanBuildRoad = 0;
                        }
                        if (unitCanBuildRoad == 0) {
                            return Unit.INSTANCE;
                        }
                        worldScreen = GUI.INSTANCE.getWorldScreen();
                        this.L$0 = SpillingKt.nullOutSpilledVariable($this$sequence);
                        this.L$1 = SpillingKt.nullOutSpilledVariable(unitCivBestRoad);
                        this.L$2 = SpillingKt.nullOutSpilledVariable(uniquesToCheck);
                        this.L$3 = SpillingKt.nullOutSpilledVariable(worldScreen);
                        this.I$0 = unitCanBuildRoad;
                        this.label = 1;
                        v4 = $this$sequence.yield(new UnitAction(UnitActionType.ConnectRoad, 25.0f, null, this.$unit.isAutomatingRoadConnection(), null, null, (Function0<Unit>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$3(com.unciv.ui.screens.worldscreen.WorldScreen ), ()Lkotlin/Unit;)((WorldScreen)worldScreen), 52, null), this);
                        if (v4 == var12_3) {
                            return var12_3;
                        }
                        ** GOTO lbl67
                    }
                    case 1: {
                        unitCanBuildRoad = this.I$0;
                        worldScreen = (WorldScreen)this.L$3;
                        uniquesToCheck = (Sequence)this.L$2;
                        unitCivBestRoad = (RoadStatus)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v4 = $result;
lbl67:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super UnitAction>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super UnitAction> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$3(WorldScreen $worldScreen) {
                $worldScreen.getBottomUnitTable$core().setSelectedUnitIsConnectingRoad(!$worldScreen.getBottomUnitTable$core().getSelectedUnitIsConnectingRoad());
                $worldScreen.setShouldUpdate(true);
                return Unit.INSTANCE;
            }
        });
    }

    @NotNull
    public final Sequence<UnitAction> getTransformActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super UnitAction>, Continuation<? super Unit>, Object>(unit, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            Object L$6;
            Object L$7;
            Object L$8;
            Object L$9;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ MapUnit $unit;
            {
                this.$unit = $unit;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Object invokeSuspend(Object $result) {
                Object object;
                Unique unique;
                BaseUnit unitToTransformTo;
                Counter<String> resourceRequirementsDelta;
                String newResourceRequirementsString;
                Iterator<T> iterator2;
                GameContext stateForConditionals;
                Civilization civInfo;
                Tile unitTile;
                SequenceScope sequenceScope = (SequenceScope)this.L$0;
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        unitTile = this.$unit.getTile();
                        civInfo = this.$unit.getCiv();
                        stateForConditionals = this.$unit.getCache().getState();
                        iterator2 = MapUnit.getMatchingUniques$default(this.$unit, UniqueType.CanTransform, stateForConditionals, false, 4, null).iterator();
                        break;
                    }
                    case 1: {
                        String string = (String)this.L$9;
                        newResourceRequirementsString = (String)this.L$8;
                        resourceRequirementsDelta = (Counter<String>)this.L$7;
                        unitToTransformTo = (BaseUnit)this.L$6;
                        unique = (Unique)this.L$5;
                        iterator2 = (Iterator<T>)this.L$4;
                        stateForConditionals = (GameContext)this.L$3;
                        civInfo = (Civilization)this.L$2;
                        unitTile = (Tile)this.L$1;
                        ResultKt.throwOnFailure($result);
                        object = $result;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }
                while (iterator2.hasNext()) {
                    void $this$sequence;
                    void var11_23;
                    void $this$filterTo$iv$iv;
                    String resource;
                    boolean bl;
                    block10: {
                        void $this$any$iv;
                        unique = (Unique)iterator2.next();
                        unitToTransformTo = civInfo.getEquivalentUnit(unique.getParams().get(0));
                        Sequence<Unique> sequence = unitToTransformTo.getMatchingUniques(UniqueType.OnlyAvailable, GameContext.Companion.getIgnoreConditionals());
                        boolean $i$f$any = false;
                        for (T element$iv : $this$any$iv) {
                            Unique it = (Unique)element$iv;
                            boolean bl2 = false;
                            if (!(!it.conditionalsApply(stateForConditionals))) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                    if (bl) continue;
                    resourceRequirementsDelta = new Counter<String>(null, 1, null);
                    for (Map.Entry<K, V> entry : ((Map)this.$unit.getResourceRequirementsPerTurn()).entrySet()) {
                        resource = (String)entry.getKey();
                        int amount = ((Number)entry.getValue()).intValue();
                        resourceRequirementsDelta.add(resource, -amount);
                    }
                    for (Map.Entry<K, V> entry : ((Map)unitToTransformTo.getResourceRequirementsPerTurn(this.$unit.getCache().getState())).entrySet()) {
                        resource = (String)entry.getKey();
                        int amount = ((Number)entry.getValue()).intValue();
                        resourceRequirementsDelta.add(resource, amount);
                    }
                    Set<Map.Entry<K, Integer>> set = resourceRequirementsDelta.entrySet();
                    Intrinsics.checkNotNullExpressionValue(set, "<get-entries>(...)");
                    Iterable iterable = set;
                    boolean $i$f$filter = false;
                    Iterable amount = iterable;
                    Object destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        Map.Entry it = (Map.Entry)element$iv$iv;
                        boolean bl3 = false;
                        if (!(((Number)it.getValue()).intValue() > 0)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    newResourceRequirementsString = CollectionsKt.joinToString$default((List)destination$iv$iv, null, null, null, 0, null, getTransformActions.1::invokeSuspend$lambda$2, 31, null);
                    String string2 = "Transform to [" + unitToTransformTo.getName() + "] ";
                    string2 = string2 + UnitActionModifiers.INSTANCE.getSideEffectString(this.$unit, unique, true);
                    if (((CharSequence)newResourceRequirementsString).length() > 0) {
                        String string3 = string2 + "\n([" + newResourceRequirementsString + "])";
                    }
                    Function0<Unit> function0 = () -> getTransformActions.1.invokeSuspend$lambda$3(this.$unit, civInfo, unitTile, unitToTransformTo, unique);
                    MapUnit mapUnit = this.$unit;
                    destination$iv$iv = function0;
                    Unique unique2 = unique;
                    UncivSound uncivSound = null;
                    boolean bl4 = false;
                    void var23_41 = var11_23;
                    float f = 70.0f;
                    UnitActionType unitActionType = UnitActionType.Transform;
                    void var20_38 = $this$sequence;
                    boolean bl5 = false;
                    boolean bl6 = !mapUnit.isEmbarked() && UnitActionModifiers.INSTANCE.canActivateSideEffects(mapUnit, unique);
                    DefaultConstructorMarker defaultConstructorMarker = null;
                    int n = 24;
                    Function0<Unit> function02 = bl6 ? function0 : null;
                    Unique unique3 = unique2;
                    UncivSound uncivSound2 = uncivSound;
                    void var33_51 = var23_41;
                    float f2 = f;
                    UnitActionType unitActionType2 = unitActionType;
                    this.L$0 = $this$sequence;
                    this.L$1 = unitTile;
                    this.L$2 = civInfo;
                    this.L$3 = stateForConditionals;
                    this.L$4 = iterator2;
                    this.L$5 = SpillingKt.nullOutSpilledVariable(unique);
                    this.L$6 = SpillingKt.nullOutSpilledVariable(unitToTransformTo);
                    this.L$7 = SpillingKt.nullOutSpilledVariable(resourceRequirementsDelta);
                    this.L$8 = SpillingKt.nullOutSpilledVariable(newResourceRequirementsString);
                    this.L$9 = SpillingKt.nullOutSpilledVariable(var11_23);
                    this.label = 1;
                    object = var20_38.yield(new UnitAction(unitActionType2, f2, (String)var33_51, false, uncivSound2, unique3, function02, n, defaultConstructorMarker), this);
                    if (object != object2) continue;
                    return object2;
                }
                return Unit.INSTANCE;
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super UnitAction>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super UnitAction> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final CharSequence invokeSuspend$lambda$2(Map.Entry it) {
                return TranslationsKt.tr$default(((Number)it.getValue()).intValue() + " {" + (String)it.getKey() + '}', false, false, 3, null);
            }

            private static final Unit invokeSuspend$lambda$3(MapUnit $unit, Civilization $civInfo, Tile $unitTile, BaseUnit $unitToTransformTo, Unique $unique) {
                float oldMovement = $unit.getCurrentMovement();
                MapUnit.destroy$default($unit, false, 1, null);
                MapUnit newUnit = $civInfo.getUnits().placeUnitNearTile($unitTile.getPosition(), $unitToTransformTo, $unit.getId(), $unit);
                if (newUnit == null) {
                    MapUnit mapUnit = $civInfo.getUnits().placeUnitNearTile($unitTile.getPosition(), $unit.getBaseUnit(), $unit.getId(), $unit);
                    Intrinsics.checkNotNull(mapUnit);
                    MapUnit mapUnit2 = mapUnit;
                } else {
                    newUnit.setCurrentMovement(oldMovement);
                    if ((int)newUnit.getCurrentMovement() > MapUnit.getMaxMovement$default(newUnit, false, 1, null)) {
                        newUnit.setCurrentMovement(MapUnit.getMaxMovement$default(newUnit, false, 1, null));
                    }
                    UnitActionModifiers.INSTANCE.activateSideEffects(newUnit, $unique, true);
                }
                return Unit.INSTANCE;
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final Sequence<UnitAction> getBuildingImprovementsActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        block6: {
            Intrinsics.checkNotNullParameter(unit, "unit");
            Intrinsics.checkNotNullParameter(tile, "tile");
            if (!unit.getCache().getHasUniqueToBuildImprovements()) {
                return SequencesKt.emptySequence();
            }
            if (!unit.hasMovement() || tile.isCityCenter()) ** GOTO lbl-1000
            v0 = unit.getCiv().getGameInfo().getRuleset().getTileImprovements().values();
            Intrinsics.checkNotNullExpressionValue(v0, "<get-values>(...)");
            $this$any$iv = v0;
            $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                v1 = false;
            } else {
                for (T element$iv : $this$any$iv) {
                    it = (TileImprovement)element$iv;
                    $i$a$-any-UnitActionsFromUniques$getBuildingImprovementsActions$couldConstruct$1 = false;
                    v2 = tile.getImprovementFunctions();
                    Intrinsics.checkNotNull(it);
                    if (!(ImprovementPickerScreen.Companion.canReport((Collection<? extends ImprovementBuildingProblem>)SequencesKt.toSet(v2.getImprovementBuildingProblems(it, unit.getCache().getState()))) != false && MapUnit.canBuildImprovement$default(unit, it, null, 2, null) != false)) continue;
                    v1 = true;
                    break block6;
                }
                v1 = false;
            }
        }
        if (v1) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = false;
        }
        couldConstruct = v3;
        $i$f$any = var4_3 = (Function0<Unit>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getBuildingImprovementsActions$lambda$1(com.unciv.logic.map.tile.Tile com.unciv.logic.map.mapunit.MapUnit ), ()Lkotlin/Unit;)((Tile)tile, (MapUnit)unit);
        var15_12 = null;
        var14_13 = null;
        var13_14 = tile.hasImprovementInProgress();
        var12_15 = null;
        var11_16 = 85.0f;
        var10_17 = UnitActionType.ConstructImprovement;
        $i$a$-takeIf-UnitActionsFromUniques$getBuildingImprovementsActions$2 = false;
        var16_18 = couldConstruct;
        var17_19 = null;
        var18_20 = 52;
        var19_21 = var16_18 != false ? var4_3 : null;
        var20_22 = var15_12;
        var21_23 = var14_13;
        var22_24 = var13_14;
        var23_25 = var12_15;
        var24_26 = var11_16;
        var25_27 = var10_17;
        return SequencesKt.sequenceOf(new UnitAction(var25_27, var24_26, var23_25, var22_24, var21_23, var20_22, var19_21, var18_20, var17_19));
    }

    @Readonly
    public final int getRepairTurns$core(@NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Tile tile = unit.getCurrentTile();
        if (!tile.isPillaged()) {
            return 0;
        }
        if (Intrinsics.areEqual(tile.getImprovementInProgress(), "Repair")) {
            return tile.getTurnsToImprovement();
        }
        TileImprovement tileImprovement = tile.getRuleset().getTileImprovements().get("Repair");
        Intrinsics.checkNotNull(tileImprovement);
        int repairTurns = tileImprovement.getTurnsToBuild(unit.getCiv(), unit);
        TileImprovement tileImprovement2 = tile.getImprovementToRepair();
        Intrinsics.checkNotNull(tileImprovement2);
        TileImprovement pillagedImprovement = tileImprovement2;
        int turnsToBuild = pillagedImprovement.getTurnsToBuild(unit.getCiv(), unit);
        return RangesKt.coerceAtMost(repairTurns, turnsToBuild);
    }

    @NotNull
    public final Sequence<UnitAction> getRepairActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        return SequencesKt.filterNotNull(SequencesKt.sequenceOf(this.getRepairAction(unit)));
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final UnitAction getRepairAction(@NotNull MapUnit unit) {
        block8: {
            Intrinsics.checkNotNullParameter(unit, "unit");
            if (!unit.getCurrentTile().getRuleset().getTileImprovements().containsKey("Repair")) {
                return null;
            }
            if (!unit.getCache().getHasUniqueToBuildImprovements()) {
                return null;
            }
            if (unit.isEmbarked()) {
                return null;
            }
            tile = unit.getTile();
            if (tile.isCityCenter()) {
                return null;
            }
            if (!tile.isPillaged()) {
                return null;
            }
            if (!unit.hasMovement() || tile.isCityCenter() || Intrinsics.areEqual(tile.getImprovementInProgress(), "Repair") || tile.isEnemyTerritory(unit.getCiv())) ** GOTO lbl-1000
            v0 = unit.getCurrentTile().getImprovementToRepair();
            Intrinsics.checkNotNull(v0);
            var4_3 = ImprovementFunctions.getImprovementBuildingProblems$default(ImprovementFunctions.INSTANCE, v0, new GameContext(unit.getCiv(), null, unit, tile, null, null, null, null, null, null, false, 2034, null), null, 4, null);
            $i$f$none = false;
            for (E element$iv : $this$none$iv) {
                it = (ImprovementBuildingProblem)element$iv;
                $i$a$-none-UnitActionsFromUniques$getRepairAction$couldConstruct$1 = false;
                if (!(it == ImprovementBuildingProblem.OutsideBorders)) continue;
                v1 = false;
                break block8;
            }
            v1 = true;
        }
        if (v1) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        couldConstruct = v2;
        turnsToBuild = this.getRepairTurns$core(unit);
        v3 = new StringBuilder().append((Object)UnitActionType.Repair).append(" [");
        v4 = unit.getCurrentTile().getImprovementToRepair();
        Intrinsics.checkNotNull(v4);
        var5_6 = (Function0<Unit>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getRepairAction$lambda$1(com.unciv.logic.map.tile.Tile int com.unciv.logic.map.mapunit.MapUnit ), ()Lkotlin/Unit;)((Tile)tile, (int)turnsToBuild, (MapUnit)unit);
        var6_7 = var5_6;
        var15_13 = null;
        var14_14 = null;
        var13_15 = false;
        var12_16 = v3.append(v4.getName()).append("] - [").append(turnsToBuild).append("\u23f3]").toString();
        var11_17 = 90.0f;
        var10_18 = UnitActionType.Repair;
        $i$a$-takeIf-UnitActionsFromUniques$getRepairAction$2 = false;
        var16_19 = couldConstruct;
        var17_20 = null;
        var18_21 = 56;
        var19_22 = var16_19 != false ? var5_6 : null;
        var20_23 = var15_13;
        var21_24 = var14_14;
        var22_25 = var13_15;
        var23_26 = var12_16;
        var24_27 = var11_17;
        var25_28 = var10_18;
        return new UnitAction(var25_28, var24_27, var23_26, var22_25, var21_24, var20_23, var19_22, var18_21, var17_20);
    }

    private static final Unit getFoundCityAction$lambda$1(MapUnit $unit, Unique $unique, Tile $tile, boolean $hasActionModifiers) {
        if ($unit.getCiv().getPlayerType() != PlayerType.AI) {
            UncivGame.Companion.getCurrent().getSettings().addCompletedTutorialTask($unique.getText());
        }
        City city = $unit.getCiv().addCity($tile.getPosition(), $unit);
        if ($hasActionModifiers) {
            UnitActionModifiers.activateSideEffects$default(UnitActionModifiers.INSTANCE, $unit, $unique, false, 4, null);
        } else {
            MapUnit.destroy$default($unit, false, 1, null);
        }
        GUI.INSTANCE.setUpdateWorldOnNextRender();
        if ($unique.getType() == UniqueType.FoundPuppetCity) {
            city.setPuppet(true);
        }
        return Unit.INSTANCE;
    }

    private static final Unit getFoundCityAction$lambda$2(MapUnit $unit, Tile $tile, Function0 $foundAction) {
        String leadersPromisedNotToSettleNear = INSTANCE.getLeadersWePromisedNotToSettleNear($unit.getCiv(), $tile);
        if (leadersPromisedNotToSettleNear == null) {
            $foundAction.invoke();
        } else {
            String text2 = "Do you want to break your promise to [" + leadersPromisedNotToSettleNear + "]?";
            new ConfirmPopup(GUI.INSTANCE.getWorldScreen(), text2, "Break promise", false, null, $foundAction, 24, null).open(true);
        }
        return Unit.INSTANCE;
    }

    private static final boolean getLeadersWePromisedNotToSettleNear$lambda$0(Civilization $civInfo, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isMajorCiv() && !$civInfo.isAtWarWith(it);
    }

    private static final Unit getSetupActions$lambda$0(MapUnit $unit) {
        $unit.setAction(UnitActionType.SetUp.getValue());
        $unit.useMovementPoints(1.0f);
        return Unit.INSTANCE;
    }

    private static final Unit getParadropActions$lambda$0(MapUnit $unit) {
        if ($unit.isPreparingParadrop()) {
            $unit.setAction(null);
        } else {
            $unit.setAction(UnitActionType.Paradrop.getValue());
        }
        return Unit.INSTANCE;
    }

    private static final Unit getAirSweepActions$lambda$0(MapUnit $unit) {
        if ($unit.isPreparingAirSweep()) {
            $unit.setAction(null);
        } else {
            $unit.setAction(UnitActionType.AirSweep.getValue());
        }
        return Unit.INSTANCE;
    }

    private static final Unit getGuardActions$lambda$0(MapUnit $unit) {
        $unit.setAction(UnitActionType.Guard.getValue());
        return Unit.INSTANCE;
    }

    private static final Unit getAddInCapitalActions$lambda$0(MapUnit $unit) {
        $unit.getCiv().getVictoryManager().getCurrentsSpaceshipParts().add($unit.getName(), 1);
        MapUnit.destroy$default($unit, false, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit getWaterImprovementAction$lambda$0(Tile $tile, String $improvementName, MapUnit $unit) {
        $tile.setImprovement($improvementName, $unit.getCiv(), $unit);
        MapUnit.destroy$default($unit, false, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit getBuildingImprovementsActions$lambda$1(Tile $tile, MapUnit $unit) {
        GUI.INSTANCE.pushScreen(new ImprovementPickerScreen($tile, $unit, UnitActionsFromUniques::getBuildingImprovementsActions$lambda$1$0));
        return Unit.INSTANCE;
    }

    private static final Unit getBuildingImprovementsActions$lambda$1$0() {
        if (GUI.INSTANCE.getSettings().getAutoUnitCycle()) {
            WorldScreen.switchToNextUnit$default(GUI.INSTANCE.getWorldScreen(), false, 1, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit getRepairAction$lambda$1(Tile $tile, int $turnsToBuild, MapUnit $unit) {
        $tile.queueImprovement("Repair", $turnsToBuild);
        $unit.setAction(null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ UnitAction access$getWaterImprovementAction(UnitActionsFromUniques $this, MapUnit unit, Tile tile) {
        return $this.getWaterImprovementAction(unit, tile);
    }
}

