if(NOT _VCPKG_LINUX_TOOLCHAIN)
    set(_VCPKG_LINUX_TOOLCHAIN 1)

    if(POLICY CMP0056)
        cmake_policy(SET CMP0056 NEW)
    endif()
    if(POLICY CMP0066)
        cmake_policy(SET CMP0066 NEW)
    endif()
    if(POLICY CMP0067)
        cmake_policy(SET CMP0067 NEW)
    endif()
    if(POLICY CMP0137)
        cmake_policy(SET CMP0137 NEW)
    endif()
    list(APPEND CMAKE_TRY_COMPILE_PLATFORM_VARIABLES
        VCPKG_CRT_LINKAGE VCPKG_TARGET_ARCHITECTURE
        VCPKG_C_FLAGS VCPKG_CXX_FLAGS
        VCPKG_C_FLAGS_DEBUG VCPKG_CXX_FLAGS_DEBUG
        VCPKG_C_FLAGS_RELEASE VCPKG_CXX_FLAGS_RELEASE
        VCPKG_LINKER_FLAGS VCPKG_LINKER_FLAGS_RELEASE VCPKG_LINKER_FLAGS_DEBUG
    )

    set(CMAKE_SYSTEM_NAME Linux CACHE STRING "")
    if(VCPKG_TARGET_ARCHITECTURE STREQUAL "x64")
       set(CMAKE_SYSTEM_PROCESSOR x86_64 CACHE STRING "")
    elseif(VCPKG_TARGET_ARCHITECTURE STREQUAL "x86")
       set(CMAKE_SYSTEM_PROCESSOR i686 CACHE STRING "")
       string(APPEND VCPKG_C_FLAGS " -m32")
       string(APPEND VCPKG_CXX_FLAGS " -m32")
       string(APPEND VCPKG_LINKER_FLAGS " -m32")
    elseif(VCPKG_TARGET_ARCHITECTURE STREQUAL "arm")
        set(CMAKE_SYSTEM_PROCESSOR armv7l CACHE STRING "")
    elseif(VCPKG_TARGET_ARCHITECTURE STREQUAL "arm64")
        set(CMAKE_SYSTEM_PROCESSOR aarch64 CACHE STRING "")
    elseif(VCPKG_TARGET_ARCHITECTURE STREQUAL "riscv64")
        set(CMAKE_SYSTEM_PROCESSOR riscv64 CACHE STRING "")
    endif()

    if(CMAKE_HOST_SYSTEM_NAME STREQUAL "Linux" AND CMAKE_SYSTEM_PROCESSOR AND NOT CMAKE_HOST_SYSTEM_PROCESSOR STREQUAL CMAKE_SYSTEM_PROCESSOR)
        if(NOT(CMAKE_SYSTEM_PROCESSOR STREQUAL "i686" AND CMAKE_HOST_SYSTEM_PROCESSOR STREQUAL "x86_64"))
            set(GNU_TRIPLET "${CMAKE_SYSTEM_PROCESSOR}-linux-gnu")
            if(CMAKE_SYSTEM_PROCESSOR STREQUAL "armv7l")
                set(GNU_TRIPLET "arm-linux-gnueabihf")
            endif()
            if(NOT DEFINED CMAKE_CXX_COMPILER)
                set(CMAKE_CXX_COMPILER "${GNU_TRIPLET}-g++")
            endif()
            if(NOT DEFINED CMAKE_C_COMPILER)
                set(CMAKE_C_COMPILER "${GNU_TRIPLET}-gcc")
            endif()
            if(NOT DEFINED CMAKE_Fortran_COMPILER)
                set(CMAKE_Fortran_COMPILER "${GNU_TRIPLET}-gfortran")
            endif()
            if(NOT DEFINED CMAKE_ASM_COMPILER)
                set(CMAKE_ASM_COMPILER "${GNU_TRIPLET}-gcc")
            endif()
            if(NOT DEFINED CMAKE_ASM-ATT_COMPILER)
                set(CMAKE_ASM-ATT_COMPILER "${GNU_TRIPLET}-as")
            endif()
            if(NOT DEFINED CMAKE_LINKER)
                set(CMAKE_LINKER "${GNU_TRIPLET}-ld")
            endif()
            if(NOT DEFINED CMAKE_OBJCOPY)
                set(CMAKE_OBJCOPY "${GNU_TRIPLET}-objcopy")
            endif()
            if(NOT DEFINED CMAKE_AR)
                set(CMAKE_AR "${GNU_TRIPLET}-ar")
            endif()
            if(NOT DEFINED CMAKE_NM)
                set(CMAKE_NM "${GNU_TRIPLET}-nm")
            endif()
            if(NOT DEFINED CMAKE_RANLIB)
                set(CMAKE_RANLIB "${GNU_TRIPLET}-ranlib")
            endif()
        endif()
        message(STATUS "Cross-compiling for target ${VCPKG_TARGET_ARCHITECTURE} (${CMAKE_SYSTEM_PROCESSOR}) on host ${VCPKG_HOST_ARCHITECTURE} (${CMAKE_HOST_SYSTEM_PROCESSOR}).")
    endif()

    if(CMAKE_HOST_SYSTEM_NAME STREQUAL "Linux" AND CMAKE_SYSTEM_PROCESSOR STREQUAL CMAKE_HOST_SYSTEM_PROCESSOR)
        set(CMAKE_CROSSCOMPILING OFF CACHE BOOL "")
    endif()

    string(APPEND CMAKE_C_FLAGS_INIT " -fPIC ${VCPKG_C_FLAGS} ")
    string(APPEND CMAKE_CXX_FLAGS_INIT " -fPIC ${VCPKG_CXX_FLAGS} ")
    string(APPEND CMAKE_C_FLAGS_DEBUG_INIT " ${VCPKG_C_FLAGS_DEBUG} ")
    string(APPEND CMAKE_CXX_FLAGS_DEBUG_INIT " ${VCPKG_CXX_FLAGS_DEBUG} ")
    string(APPEND CMAKE_C_FLAGS_RELEASE_INIT " ${VCPKG_C_FLAGS_RELEASE} ")
    string(APPEND CMAKE_CXX_FLAGS_RELEASE_INIT " ${VCPKG_CXX_FLAGS_RELEASE} ")

    string(APPEND CMAKE_MODULE_LINKER_FLAGS_INIT " ${VCPKG_LINKER_FLAGS} ")
    string(APPEND CMAKE_SHARED_LINKER_FLAGS_INIT " ${VCPKG_LINKER_FLAGS} ")
    string(APPEND CMAKE_EXE_LINKER_FLAGS_INIT " ${VCPKG_LINKER_FLAGS} ")
    if(VCPKG_CRT_LINKAGE STREQUAL "static")
        string(APPEND CMAKE_MODULE_LINKER_FLAGS_INIT "-static ")
        string(APPEND CMAKE_SHARED_LINKER_FLAGS_INIT "-static ")
        string(APPEND CMAKE_EXE_LINKER_FLAGS_INIT "-static ")
    endif()
    string(APPEND CMAKE_MODULE_LINKER_FLAGS_DEBUG_INIT " ${VCPKG_LINKER_FLAGS_DEBUG} ")
    string(APPEND CMAKE_SHARED_LINKER_FLAGS_DEBUG_INIT " ${VCPKG_LINKER_FLAGS_DEBUG} ")
    string(APPEND CMAKE_EXE_LINKER_FLAGS_DEBUG_INIT " ${VCPKG_LINKER_FLAGS_DEBUG} ")
    string(APPEND CMAKE_MODULE_LINKER_FLAGS_RELEASE_INIT " ${VCPKG_LINKER_FLAGS_RELEASE} ")
    string(APPEND CMAKE_SHARED_LINKER_FLAGS_RELEASE_INIT " ${VCPKG_LINKER_FLAGS_RELEASE} ")
    string(APPEND CMAKE_EXE_LINKER_FLAGS_RELEASE_INIT " ${VCPKG_LINKER_FLAGS_RELEASE} ")
    string(APPEND CMAKE_ASM_FLAGS_INIT " ${VCPKG_C_FLAGS} ")
endif()
