if(MSVC)
    string(APPEND CMAKE_CFLAGS " /wd4703")
endif()

block(SCOPE_FOR VARIABLES)
    set(prefix [[${pcfiledir}/../..]])
    set(libdir [[${prefix}/lib]])
    set(includedir [[${prefix}/include]])
    set(PACKAGE_NAME "${PROJECT_NAME}")
    set(PACKAGE_VERSION "${PROJECT_VERSION}")
    set(LIBS "")
    if(WIN32)
        set(LIBS "-lws2_32")
    endif()
    configure_file("${PROJECT_SOURCE_DIR}/libsrtp2.pc.in" "${PROJECT_BINARY_DIR}/libsrtp2.pc" @ONLY)
    if(ENABLE_OPENSSL)
        file(APPEND "${PROJECT_BINARY_DIR}/libsrtp2.pc" "Requires.private: libcrypto")
    endif()
    install(FILES "${PROJECT_BINARY_DIR}/libsrtp2.pc" DESTINATION "lib/pkgconfig")
endblock()
