if(EXISTS "${CURRENT_INSTALLED_DIR}/include/gmp.h" OR EXISTS "${CURRENT_INSTALLED_DIR}/include/gmpxx.h")
    message(FATAL_ERROR "Can't build ${PORT} if gmp is installed. Please remove gmp, and try to install ${PORT} again if you need it.")
endif()

vcpkg_from_github(
    OUT_SOURCE_PATH SOURCE_PATH
    REPO wbhart/mpir
    REF cdd444aedfcbb190f00328526ef278428702d56e # tag: mpir-3.0.0
    SHA512 f46e45bdba27c9f89953ba23186b694486fd3010bd370ea2de71a4649a2816e716a6520c9baa96936f1884437ef03f92b21c0b1fb5b757beba5a05fed30b2bfc
    HEAD_REF master
    PATCHES 
        enable-runtimelibrary-toggle.patch
        fix-static-include-files.patch
        subdirs.diff
        vcpkg-cross-builds.diff
)

if(NOT VCPKG_TARGET_IS_WINDOWS OR VCPKG_TARGET_IS_MINGW)
    vcpkg_find_acquire_program(YASM)

    vcpkg_make_configure(
        SOURCE_PATH "${SOURCE_PATH}"
        AUTORECONF
        OPTIONS
            --enable-cxx
            --enable-gmpcompat
            --with-pic
            "--with-yasm=${YASM}"
            "CFLAGS=\$CFLAGS -Wno-implicit-function-declaration"
            "CCAS=" # use default $CC -c
    )
    vcpkg_make_install()
else()
    set(MSVC_VERSION 14)
    if(VCPKG_PLATFORM_TOOLSET MATCHES "v14(1|2|3)")
        set(MSVC_VERSION 15)
    endif()

    set(DLL_OR_LIB dll)
    if (VCPKG_LIBRARY_LINKAGE STREQUAL "static")
        set(DLL_OR_LIB lib)
    endif()

    # Note: Could probably be moved to use vcpkg_configure_make on windows
    vcpkg_msbuild_install(
        SOURCE_PATH "${SOURCE_PATH}"
        PROJECT_SUBPATH "build.vc${MSVC_VERSION}/${DLL_OR_LIB}_mpir_gc/${DLL_OR_LIB}_mpir_gc.vcxproj"
    )

    if(VCPKG_LIBRARY_LINKAGE STREQUAL "static")
        vcpkg_msbuild_install(
            SOURCE_PATH "${SOURCE_PATH}"
            PROJECT_SUBPATH "build.vc${MSVC_VERSION}/${DLL_OR_LIB}_mpir_cxx/${DLL_OR_LIB}_mpir_cxx.vcxproj"
        )
    endif()

    file(GLOB HEADERS
        "${CURRENT_BUILDTREES_DIR}/${TARGET_TRIPLET}-rel/*/*/Release/gmp.h"
        "${CURRENT_BUILDTREES_DIR}/${TARGET_TRIPLET}-rel/*/*/Release/gmpxx.h"
        "${CURRENT_BUILDTREES_DIR}/${TARGET_TRIPLET}-rel/*/*/Release/mpir.h"
        "${CURRENT_BUILDTREES_DIR}/${TARGET_TRIPLET}-rel/*/*/Release/mpirxx.h"
    )
    file(INSTALL ${HEADERS} DESTINATION "${CURRENT_PACKAGES_DIR}/include")

    file(REMOVE "${CURRENT_PACKAGES_DIR}/lib/COPYING.LIB" "${CURRENT_PACKAGES_DIR}/debug/lib/COPYING.LIB")
endif()

file(REMOVE_RECURSE
    "${CURRENT_PACKAGES_DIR}/debug/include"
    "${CURRENT_PACKAGES_DIR}/debug/share"
)

vcpkg_install_copyright(FILE_LIST "${SOURCE_PATH}/COPYING" "${SOURCE_PATH}/COPYING.LIB")
