/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.core.CommandAPDU;
import apdu4j.core.HexUtils;
import apdu4j.core.ResponseAPDU;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.NoSuchPaddingException;
import pro.javacard.gp.GPCrypto;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPUtils;
import pro.javacard.gp.SecureChannelWrapper;

class SCP03Wrapper
extends SecureChannelWrapper {
    private byte[] chaining_value = new byte[16];
    private byte[] encryption_counter = new byte[16];
    static final String COUNTER_WORKAROUND = "globalplatformpro.scp03.buggycounterworkaround";
    private String buggyCounterEnv = System.getenv().getOrDefault("globalplatformpro.scp03.buggycounterworkaround".replace(".", "_").toUpperCase(), "false");
    private boolean counterIsBuggy = System.getProperty("globalplatformpro.scp03.buggycounterworkaround", this.buggyCounterEnv).equalsIgnoreCase("true");
    private boolean s16 = false;

    SCP03Wrapper(byte[] enc, byte[] mac, byte[] rmac, int bs, boolean s16) {
        super(enc, mac, rmac, bs);
        this.s16 = s16;
    }

    @Override
    protected CommandAPDU wrap(CommandAPDU command) throws GPException {
        byte[] cmd_mac = null;
        int maclen = this.s16 ? 16 : 8;
        try {
            int cla = command.getCLA();
            int lc = command.getNc();
            byte[] data = command.getData();
            if (this.enc) {
                cla |= 4;
                if (!this.counterIsBuggy || command.getData().length > 0) {
                    GPCrypto.buffer_increment(this.encryption_counter);
                }
                if (command.getData().length > 0) {
                    byte[] d = GPCrypto.pad80(command.getData(), 16);
                    byte[] iv = GPCrypto.aes_cbc(this.encryption_counter, this.encKey, new byte[16]);
                    data = GPCrypto.aes_cbc(d, this.encKey, iv);
                    lc = data.length;
                }
            }
            if (this.mac) {
                lc += maclen;
                ByteArrayOutputStream bo = new ByteArrayOutputStream();
                bo.write(this.chaining_value);
                bo.write(cla |= 4);
                bo.write(command.getINS());
                bo.write(command.getP1());
                bo.write(command.getP2());
                bo.write(GPUtils.encodeLcLength(lc, command.getNe()));
                bo.write(data);
                byte[] cmac_input = bo.toByteArray();
                byte[] cmac = GPCrypto.aes_cmac(this.macKey, cmac_input, 128);
                System.arraycopy(cmac, 0, this.chaining_value, 0, this.chaining_value.length);
                cmd_mac = Arrays.copyOf(cmac, maclen);
            }
            CommandAPDU newAPDU = null;
            ByteArrayOutputStream newData = new ByteArrayOutputStream();
            newData.write(data);
            if (this.mac) {
                newData.write(cmd_mac);
            }
            newAPDU = command.getNe() > 0 ? new CommandAPDU(cla, command.getINS(), command.getP1(), command.getP2(), newData.toByteArray(), command.getNe()) : new CommandAPDU(cla, command.getINS(), command.getP1(), command.getP2(), newData.toByteArray());
            return newAPDU;
        }
        catch (IOException e) {
            throw new RuntimeException("APDU wrapping failed", e);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalStateException("APDU wrapping failed", e);
        }
        catch (GeneralSecurityException e) {
            throw new GPException("APDU wrapping failed", e);
        }
    }

    @Override
    protected ResponseAPDU unwrap(ResponseAPDU response) throws GPException {
        int maclen = this.s16 ? 16 : 8;
        try {
            if (this.rmac) {
                if (response.getData().length < maclen) {
                    if (response.getSW() == 36864 || response.getSW1() == 98 || response.getSW1() == 99) {
                        throw new GPException("Received R-APDU without authentication data in RMAC session.");
                    }
                    return response;
                }
                int respLen = response.getData().length - maclen;
                byte[] actualMac = new byte[maclen];
                System.arraycopy(response.getData(), respLen, actualMac, 0, maclen);
                ByteArrayOutputStream bo = new ByteArrayOutputStream();
                bo.write(this.chaining_value);
                bo.write(response.getData(), 0, respLen);
                bo.write(response.getSW1());
                bo.write(response.getSW2());
                byte[] cmac_input = bo.toByteArray();
                byte[] cmac = GPCrypto.aes_cmac(this.rmacKey, cmac_input, 128);
                byte[] resp_mac = Arrays.copyOf(cmac, maclen);
                if (!Arrays.equals(resp_mac, actualMac)) {
                    throw new GPException("RMAC invalid: " + HexUtils.bin2hex(actualMac) + " vs " + HexUtils.bin2hex(resp_mac));
                }
                ByteArrayOutputStream o = new ByteArrayOutputStream();
                o.write(response.getData(), 0, respLen);
                o.write(response.getSW1());
                o.write(response.getSW2());
                response = new ResponseAPDU(o.toByteArray());
            }
            if (this.renc && response.getData().length > 0) {
                byte[] response_encryption_counter = (byte[])this.encryption_counter.clone();
                response_encryption_counter[0] = -128;
                byte[] iv = GPCrypto.aes_cbc(response_encryption_counter, this.encKey, new byte[16]);
                byte[] data = GPCrypto.aes_cbc_decrypt(response.getData(), this.encKey, iv);
                ByteArrayOutputStream o = new ByteArrayOutputStream();
                o.write(GPCrypto.unpad80(data));
                o.write(response.getSW1());
                o.write(response.getSW2());
                response = new ResponseAPDU(o.toByteArray());
            }
            return response;
        }
        catch (IOException e) {
            throw new RuntimeException("APDU unwrapping failed", e);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalStateException("APDU unwrapping failed", e);
        }
        catch (GeneralSecurityException e) {
            throw new GPException("APDU unwrapping failed", e);
        }
    }
}

