/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import java.util.Optional;

public final class GPSecureChannelVersion {
    public final int i;
    public final SCP scp;

    public GPSecureChannelVersion(SCP scp, int i) {
        this.scp = scp;
        this.i = i;
    }

    public static GPSecureChannelVersion valueOf(int v) {
        return GPSecureChannelVersion.valueOf(v, 0);
    }

    public static GPSecureChannelVersion valueOf(int v, int i) {
        SCP scp = SCP.valueOf(v).orElseThrow(() -> new IllegalArgumentException("Unknown SCP version: " + v));
        return new GPSecureChannelVersion(scp, i);
    }

    public String toString() {
        return this.i == 0 ? this.scp.name() : "%s (i=%02x)".formatted(this.scp.name(), this.i);
    }

    public static enum SCP {
        SCP01(1),
        SCP02(2),
        SCP03(3),
        SCP11(17),
        SCP80(128);

        private final int value;

        private SCP(int value) {
            this.value = value;
        }

        public byte getValue() {
            return (byte)(this.value & 0xFF);
        }

        public static Optional<SCP> valueOf(int i) {
            for (SCP v : SCP.values()) {
                if (v.value != i) continue;
                return Optional.of(v);
            }
            return Optional.empty();
        }
    }
}

