/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gptool;

import apdu4j.core.CommandAPDU;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.dataformat.cbor.databind.CBORMapper;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.encoders.Hex;
import pro.javacard.gp.GPUtils;

public class APDUParsers {
    static final ObjectMapper cbor;
    static final ObjectMapper json;
    public static final ObjectWriter pretty;

    public static JsonNode hexify(JsonNode node) {
        return APDUParsers.hexify_(node.deepCopy());
    }

    public static String pretty(Object o) {
        try {
            if (o instanceof JsonNode) {
                JsonNode node = (JsonNode)o;
                o = APDUParsers.hexify(node);
            }
            if (o instanceof byte[]) {
                byte[] bytes = (byte[])o;
                o = APDUParsers.hexify(cbor.readTree(bytes));
            }
            return pretty.writeValueAsString(o);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static JsonNode hexify_(JsonNode node) {
        if (node.isArray()) {
            ArrayNode hexified = json.createArrayNode();
            node.forEach(e -> hexified.add(APDUParsers.hexify_(e)));
            return hexified;
        }
        if (node.isObject()) {
            ObjectNode obj = (ObjectNode)node;
            obj.fieldNames().forEachRemaining(fn -> obj.set((String)fn, APDUParsers.hexify_(obj.get((String)fn))));
            return obj;
        }
        if (node.isBinary()) {
            byte[] bytes = Base64.decode(node.asText());
            return new TextNode(Hex.toHexString(bytes));
        }
        return node;
    }

    static String hex_cleanup(String s) {
        return s.replaceAll("(\\s+|0x|0X|:)", "");
    }

    static byte[] validate(byte[] apdu) {
        return new CommandAPDU(apdu).getBytes();
    }

    public static String visualize_structure(byte[] b) {
        try {
            JsonNode json = cbor.readTree(b);
            if (json.isArray() || json.isObject()) {
                return "# CBOR: " + APDUParsers.pretty(json);
            }
        }
        catch (IOException json) {
            // empty catch block
        }
        try {
            List<String> tlv = GPUtils.visualize_tlv(b);
            return String.join((CharSequence)"\n", tlv);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Hex.toHexString(b);
        }
    }

    static byte[] stringToAPDU(String s) {
        block9: {
            Objects.requireNonNull(s);
            s = s.trim();
            if (s.length() == 0) {
                throw new IllegalArgumentException("Empty APDU string");
            }
            try {
                int curly = s.indexOf(123);
                if (curly > 0) {
                    byte[] header = Hex.decode(APDUParsers.hex_cleanup(s.substring(0, curly)));
                    if (header.length == 4) {
                        JsonNode j = json.readTree(s.substring(curly));
                        byte[] c = cbor.writeValueAsBytes(j);
                        return APDUParsers.validate(GPUtils.concatenate(header, {(byte)(c.length & 0xFF)}, c));
                    }
                    break block9;
                }
                try {
                    return APDUParsers.validate(Hex.decode(APDUParsers.hex_cleanup(s)));
                }
                catch (IllegalArgumentException | DecoderException e) {
                    String[] pieces = s.split("\\s+");
                    if (pieces.length == 2) {
                        byte[][] pcs = new byte[][]{Hex.decode(APDUParsers.hex_cleanup(pieces[0])), Hex.decode(APDUParsers.hex_cleanup(pieces[1]))};
                        if (pcs[0].length == 4) {
                            return APDUParsers.validate(GPUtils.concatenate(pcs[0], {(byte)(pcs[1].length & 0xFF)}, pcs[1]));
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not parse \"%s\": %s".formatted(s, e.getMessage()), e);
            }
        }
        throw new IllegalArgumentException("Don't know how to handle \"%s\"".formatted(s));
    }

    static {
        SimpleModule hexModule = new SimpleModule();
        hexModule.addSerializer(byte[].class, new BytesAsHexSerializer());
        hexModule.addDeserializer(byte[].class, new BytesAsHexDeserializer());
        json = new ObjectMapper();
        json.registerModule(hexModule);
        json.enable(JsonReadFeature.ALLOW_UNQUOTED_FIELD_NAMES.mappedFeature());
        json.enable(JsonReadFeature.ALLOW_JAVA_COMMENTS.mappedFeature());
        json.enable(JsonReadFeature.ALLOW_YAML_COMMENTS.mappedFeature());
        json.enable(JsonReadFeature.ALLOW_SINGLE_QUOTES.mappedFeature());
        json.enable(JsonReadFeature.ALLOW_TRAILING_COMMA.mappedFeature());
        pretty = json.writerWithDefaultPrettyPrinter();
        cbor = new CBORMapper();
    }

    public static class BytesAsHexSerializer
    extends JsonSerializer<byte[]> {
        @Override
        public void serialize(byte[] bytes, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(Hex.toHexString(bytes));
        }
    }

    public static class BytesAsHexDeserializer
    extends JsonDeserializer<byte[]> {
        @Override
        public byte[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JacksonException {
            return Hex.decode(jsonParser.getValueAsString());
        }
    }
}

