/*
 * Decompiled with CFR 0.152.
 */
package kala.compress.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;

public class Charsets {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Charset NATIVE_CHARSET;

    public static Charset nativeCharset() {
        return NATIVE_CHARSET;
    }

    public static boolean isUTF8(Charset charset) {
        return charset == null || charset == StandardCharsets.UTF_8;
    }

    public static Charset toCharset(String name) {
        return name != null ? Charset.forName(name) : StandardCharsets.UTF_8;
    }

    public static Charset toCharset(String name, Charset defaultCharset) {
        if (name == null) {
            return defaultCharset;
        }
        try {
            return Charset.forName(name);
        }
        catch (Throwable ignored) {
            return defaultCharset;
        }
    }

    public static Charset toCharset(Charset charset) {
        return charset != null ? charset : StandardCharsets.UTF_8;
    }

    public static Charset toCharset(Charset charset, Charset defaultCharset) {
        return charset != null ? charset : defaultCharset;
    }

    public static boolean canEncode(Charset charset, String name) {
        if (charset == StandardCharsets.UTF_8 || charset.name().startsWith("UTF-")) {
            int length = name.length();
            for (int i = 0; i < length; ++i) {
                char ch = name.charAt(i);
                if (Character.isLowSurrogate(ch)) {
                    return false;
                }
                if (!Character.isHighSurrogate(ch) || ++i < length && Character.isLowSurrogate(name.charAt(i))) continue;
                return false;
            }
            return true;
        }
        if (charset == StandardCharsets.US_ASCII || charset == StandardCharsets.ISO_8859_1) {
            char maxChar = charset == StandardCharsets.US_ASCII ? (char)'\u007f' : '\u00ff';
            int length = name.length();
            for (int i = 0; i < length; ++i) {
                char ch = name.charAt(i);
                if (ch <= maxChar) continue;
                return false;
            }
            return true;
        }
        return Charsets.encoderFor(charset).canEncode(name);
    }

    public static ByteBuffer encode(Charset charset, String name) {
        if (charset == StandardCharsets.UTF_8) {
            return ByteBuffer.wrap(name.getBytes(StandardCharsets.UTF_8));
        }
        CharsetEncoder enc = Charsets.encoderFor(charset);
        CharBuffer cb = CharBuffer.wrap(name);
        CharBuffer tmp = null;
        ByteBuffer out = ByteBuffer.allocate(Charsets.estimateInitialBufferSize(enc, cb.remaining()));
        while (cb.hasRemaining()) {
            CoderResult res = enc.encode(cb, out, false);
            if (res.isUnmappable() || res.isMalformed()) {
                int spaceForSurrogate = Charsets.estimateIncrementalEncodingSize(enc, 6 * res.length());
                if (spaceForSurrogate > out.remaining()) {
                    int charCount = 0;
                    for (int i = cb.position(); i < cb.limit(); ++i) {
                        charCount += !enc.canEncode(cb.get(i)) ? 6 : 1;
                    }
                    int totalExtraSpace = Charsets.estimateIncrementalEncodingSize(enc, charCount);
                    out = Charsets.growBufferBy(out, totalExtraSpace - out.remaining());
                }
                if (tmp == null) {
                    tmp = CharBuffer.allocate(6);
                }
                for (int i = 0; i < res.length(); ++i) {
                    out = Charsets.encodeFully(enc, Charsets.encodeSurrogate(tmp, cb.get()), out);
                }
                continue;
            }
            if (res.isOverflow()) {
                int increment = Charsets.estimateIncrementalEncodingSize(enc, cb.remaining());
                out = Charsets.growBufferBy(out, increment);
                continue;
            }
            if (!res.isUnderflow() && !res.isError()) continue;
            break;
        }
        enc.encode(cb, out, true);
        out.limit(out.position());
        out.rewind();
        return out;
    }

    public static String decode(Charset charset, byte[] data) throws IOException {
        if (charset == StandardCharsets.UTF_8) {
            return new String(data, StandardCharsets.UTF_8);
        }
        return Charsets.decoderFor(charset).decode(ByteBuffer.wrap(data)).toString();
    }

    private static ByteBuffer growBufferBy(ByteBuffer buffer, int increment) {
        buffer.limit(buffer.position());
        buffer.rewind();
        ByteBuffer on = ByteBuffer.allocate(buffer.capacity() + increment);
        on.put(buffer);
        return on;
    }

    private static ByteBuffer encodeFully(CharsetEncoder enc, CharBuffer cb, ByteBuffer out) {
        ByteBuffer o = out;
        while (cb.hasRemaining()) {
            CoderResult result = enc.encode(cb, o, false);
            if (!result.isOverflow()) continue;
            int increment = Charsets.estimateIncrementalEncodingSize(enc, cb.remaining());
            o = Charsets.growBufferBy(o, increment);
        }
        return o;
    }

    private static CharBuffer encodeSurrogate(CharBuffer cb, char c) {
        cb.position(0).limit(6);
        cb.put('%');
        cb.put('U');
        cb.put(HEX_CHARS[c >> 12 & 0xF]);
        cb.put(HEX_CHARS[c >> 8 & 0xF]);
        cb.put(HEX_CHARS[c >> 4 & 0xF]);
        cb.put(HEX_CHARS[c & 0xF]);
        cb.flip();
        return cb;
    }

    private static CharsetEncoder encoderFor(Charset charset) {
        return charset.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    }

    private static CharsetDecoder decoderFor(Charset charset) {
        return charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    }

    private static int estimateInitialBufferSize(CharsetEncoder enc, int charChount) {
        float first = enc.maxBytesPerChar();
        float rest = (float)(charChount - 1) * enc.averageBytesPerChar();
        return (int)Math.ceil(first + rest);
    }

    private static int estimateIncrementalEncodingSize(CharsetEncoder enc, int charCount) {
        return (int)Math.ceil((float)charCount * enc.averageBytesPerChar());
    }

    static {
        String property = System.getProperty("kala.compress.native.charset");
        Charset charset = Charset.defaultCharset();
        if (property != null) {
            charset = Charset.forName(property);
        } else {
            property = System.getProperty("native.encoding");
            if (property != null && !property.equals(charset.name())) {
                try {
                    charset = Charset.forName(property);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        NATIVE_CHARSET = charset;
    }
}

