/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.setting;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javax.net.ssl.SSLException;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.auth.Account;
import org.jackhuang.hmcl.auth.AccountFactory;
import org.jackhuang.hmcl.auth.AuthenticationException;
import org.jackhuang.hmcl.auth.CharacterDeletedException;
import org.jackhuang.hmcl.auth.NoCharacterException;
import org.jackhuang.hmcl.auth.OAuthAccount;
import org.jackhuang.hmcl.auth.ServerDisconnectException;
import org.jackhuang.hmcl.auth.ServerResponseMalformedException;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorAccount;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorAccountFactory;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorArtifactProvider;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorDownloadException;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorExtractor;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorServer;
import org.jackhuang.hmcl.auth.authlibinjector.BoundAuthlibInjectorAccountFactory;
import org.jackhuang.hmcl.auth.authlibinjector.SimpleAuthlibInjectorArtifactProvider;
import org.jackhuang.hmcl.auth.microsoft.MicrosoftAccount;
import org.jackhuang.hmcl.auth.microsoft.MicrosoftAccountFactory;
import org.jackhuang.hmcl.auth.microsoft.MicrosoftService;
import org.jackhuang.hmcl.auth.offline.OfflineAccount;
import org.jackhuang.hmcl.auth.offline.OfflineAccountFactory;
import org.jackhuang.hmcl.auth.yggdrasil.RemoteAuthenticationException;
import org.jackhuang.hmcl.game.OAuthServer;
import org.jackhuang.hmcl.setting.Config;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.util.FileSaver;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.JarUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.skin.InvalidSkinException;

public final class Accounts {
    private static final AuthlibInjectorArtifactProvider AUTHLIB_INJECTOR_DOWNLOADER;
    public static final OAuthServer.Factory OAUTH_CALLBACK;
    public static final OfflineAccountFactory FACTORY_OFFLINE;
    public static final AuthlibInjectorAccountFactory FACTORY_AUTHLIB_INJECTOR;
    public static final MicrosoftAccountFactory FACTORY_MICROSOFT;
    public static final List<AccountFactory<?>> FACTORIES;
    private static final Map<String, AccountFactory<?>> type2factory;
    private static final Map<AccountFactory<?>, String> factory2type;
    private static final String GLOBAL_PREFIX = "$GLOBAL:";
    private static final ObservableList<Map<Object, Object>> globalAccountStorages;
    private static final ObservableList<Account> accounts;
    private static final ObjectProperty<Account> selectedAccount;
    private static boolean initialized;
    private static final Map<AccountFactory<?>, String> unlocalizedLoginTypeNames;

    private Accounts() {
    }

    public static String getLoginType(AccountFactory<?> factory) {
        String type = factory2type.get(factory);
        if (type != null) {
            return type;
        }
        if (factory instanceof BoundAuthlibInjectorAccountFactory) {
            return factory2type.get(FACTORY_AUTHLIB_INJECTOR);
        }
        throw new IllegalArgumentException("Unrecognized account factory");
    }

    public static AccountFactory<?> getAccountFactory(String loginType) {
        return Optional.ofNullable(type2factory.get(loginType)).orElseThrow(() -> new IllegalArgumentException("Unrecognized login type"));
    }

    public static BoundAuthlibInjectorAccountFactory getAccountFactoryByAuthlibInjectorServer(AuthlibInjectorServer server) {
        return new BoundAuthlibInjectorAccountFactory(AUTHLIB_INJECTOR_DOWNLOADER, server);
    }

    public static AccountFactory<?> getAccountFactory(Account account) {
        if (account instanceof OfflineAccount) {
            return FACTORY_OFFLINE;
        }
        if (account instanceof AuthlibInjectorAccount) {
            return FACTORY_AUTHLIB_INJECTOR;
        }
        if (account instanceof MicrosoftAccount) {
            return FACTORY_MICROSOFT;
        }
        throw new IllegalArgumentException("Failed to determine account type: " + String.valueOf(account));
    }

    private static Map<Object, Object> getAccountStorage(Account account) {
        Map<Object, Object> storage = account.toStorage();
        storage.put("type", Accounts.getLoginType(Accounts.getAccountFactory(account)));
        return storage;
    }

    private static void updateAccountStorages() {
        if (!initialized) {
            return;
        }
        ArrayList<Map<Object, Object>> global = new ArrayList<Map<Object, Object>>();
        ArrayList<Map<Object, Object>> portable = new ArrayList<Map<Object, Object>>();
        for (Account account : accounts) {
            Map<Object, Object> storage = Accounts.getAccountStorage(account);
            if (account.isPortable()) {
                portable.add(storage);
                continue;
            }
            global.add(storage);
        }
        if (!global.equals(globalAccountStorages)) {
            globalAccountStorages.setAll(global);
        }
        if (!portable.equals(ConfigHolder.config().getAccountStorages())) {
            ConfigHolder.config().getAccountStorages().setAll(portable);
        }
    }

    private static void loadGlobalAccountStorages() {
        Path globalAccountsFile = Metadata.HMCL_GLOBAL_DIRECTORY.resolve("accounts.json");
        if (Files.exists(globalAccountsFile, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(globalAccountsFile);){
                globalAccountStorages.setAll((Collection)Config.CONFIG_GSON.fromJson((Reader)reader, JsonUtils.listTypeOf(JsonUtils.mapTypeOf(Object.class, Object.class))));
            }
            catch (Throwable e) {
                Logger.LOG.warning("Failed to load global accounts", e);
            }
        }
        globalAccountStorages.addListener(FXUtils.onInvalidating(() -> FileSaver.save(globalAccountsFile, Config.CONFIG_GSON.toJson(globalAccountStorages))));
    }

    private static Account parseAccount(Map<Object, Object> storage) {
        AccountFactory<?> factory = type2factory.get(storage.get("type"));
        if (factory == null) {
            Logger.LOG.warning("Unrecognized account type: " + String.valueOf(storage));
            return null;
        }
        try {
            return factory.fromStorage(storage);
        }
        catch (Exception e) {
            Logger.LOG.warning("Failed to load account: " + String.valueOf(storage), e);
            return null;
        }
    }

    static void init() {
        Object account3;
        if (initialized) {
            throw new IllegalStateException("Already initialized");
        }
        if (!ConfigHolder.config().isAddedLittleSkin()) {
            AuthlibInjectorServer littleSkin = new AuthlibInjectorServer("https://littleskin.cn/api/yggdrasil/");
            if (ConfigHolder.config().getAuthlibInjectorServers().stream().noneMatch(it -> littleSkin.getUrl().equals(it.getUrl()))) {
                ConfigHolder.config().getAuthlibInjectorServers().add(0, (Object)littleSkin);
            }
            ConfigHolder.config().setAddedLittleSkin(true);
        }
        Accounts.loadGlobalAccountStorages();
        Object selected = null;
        for (Map storage : ConfigHolder.config().getAccountStorages()) {
            account3 = Accounts.parseAccount(storage);
            if (account3 == null) continue;
            ((Account)account3).setPortable(true);
            accounts.add(account3);
            if (!Boolean.TRUE.equals(storage.get("selected"))) continue;
            selected = account3;
        }
        for (Map storage : globalAccountStorages) {
            account3 = Accounts.parseAccount(storage);
            if (account3 == null) continue;
            accounts.add(account3);
        }
        String selectedAccountIdentifier = ConfigHolder.config().getSelectedAccount();
        if (selected == null && selectedAccountIdentifier != null) {
            boolean portable = true;
            if (selectedAccountIdentifier.startsWith(GLOBAL_PREFIX)) {
                portable = false;
                selectedAccountIdentifier = selectedAccountIdentifier.substring(GLOBAL_PREFIX.length());
            }
            for (Account account2 : accounts) {
                if (!selectedAccountIdentifier.equals(account2.getIdentifier())) continue;
                if (portable == account2.isPortable()) {
                    selected = account2;
                    break;
                }
                if (selected != null) continue;
                selected = account2;
            }
        }
        if (selected == null && !accounts.isEmpty()) {
            selected = (Account)accounts.get(0);
        }
        if (!ConfigHolder.globalConfig().isEnableOfflineAccount()) {
            for (Object account3 : accounts) {
                if (!(account3 instanceof MicrosoftAccount)) continue;
                ConfigHolder.globalConfig().setEnableOfflineAccount(true);
                break;
            }
        }
        if (!ConfigHolder.globalConfig().isEnableOfflineAccount()) {
            accounts.addListener((ListChangeListener)new ListChangeListener<Account>(){

                public void onChanged(ListChangeListener.Change<? extends Account> change) {
                    while (change.next()) {
                        for (Account account : change.getAddedSubList()) {
                            if (!(account instanceof MicrosoftAccount)) continue;
                            accounts.removeListener((ListChangeListener)this);
                            ConfigHolder.globalConfig().setEnableOfflineAccount(true);
                            return;
                        }
                    }
                }
            });
        }
        selectedAccount.set(selected);
        InvalidationListener listener = o -> {
            Account account = (Account)selectedAccount.get();
            if (accounts.isEmpty()) {
                if (account != null) {
                    selectedAccount.set(null);
                }
            } else if (!accounts.contains((Object)account)) {
                selectedAccount.set((Object)((Account)accounts.get(0)));
            }
        };
        selectedAccount.addListener(listener);
        selectedAccount.addListener(FXUtils.onInvalidating(() -> {
            Account account = (Account)selectedAccount.get();
            if (account != null) {
                ConfigHolder.config().setSelectedAccount((String)(account.isPortable() ? account.getIdentifier() : GLOBAL_PREFIX + account.getIdentifier()));
            } else {
                ConfigHolder.config().setSelectedAccount(null);
            }
        }));
        accounts.addListener(listener);
        accounts.addListener(FXUtils.onInvalidating(Accounts::updateAccountStorages));
        initialized = true;
        ConfigHolder.config().getAuthlibInjectorServers().addListener(FXUtils.onInvalidating(Accounts::removeDanglingAuthlibInjectorAccounts));
        if (selected != null) {
            Object finalSelected = selected;
            Schedulers.io().execute(() -> Accounts.lambda$init$7((Account)finalSelected));
        }
        for (AuthlibInjectorServer server : ConfigHolder.config().getAuthlibInjectorServers()) {
            if (selected instanceof AuthlibInjectorAccount && ((AuthlibInjectorAccount)selected).getServer() == server) continue;
            Schedulers.io().execute(() -> {
                try {
                    server.fetchMetadataResponse();
                }
                catch (IOException e) {
                    Logger.LOG.warning("Failed to fetch authlib-injector server metadata: " + String.valueOf(server), e);
                }
            });
        }
    }

    public static ObservableList<Account> getAccounts() {
        return accounts;
    }

    public static Account getSelectedAccount() {
        return (Account)selectedAccount.get();
    }

    public static void setSelectedAccount(Account selectedAccount) {
        Accounts.selectedAccount.set((Object)selectedAccount);
    }

    public static ObjectProperty<Account> selectedAccountProperty() {
        return selectedAccount;
    }

    private static AuthlibInjectorArtifactProvider createAuthlibInjectorArtifactProvider() {
        String authlibinjectorLocation = System.getProperty("hmcl.authlibinjector.location");
        if (authlibinjectorLocation != null) {
            Logger.LOG.info("Using specified authlib-injector: " + authlibinjectorLocation);
            return new SimpleAuthlibInjectorArtifactProvider(Paths.get(authlibinjectorLocation, new String[0]));
        }
        String authlibInjectorVersion = JarUtils.getAttribute("hmcl.authlib-injector.version", null);
        if (authlibInjectorVersion == null) {
            throw new AssertionError((Object)"Missing hmcl.authlib-injector.version");
        }
        String authlibInjectorFileName = "authlib-injector-" + authlibInjectorVersion + ".jar";
        return new AuthlibInjectorExtractor(Accounts.class.getResource("/assets/" + authlibInjectorFileName), Metadata.DEPENDENCIES_DIRECTORY.resolve("universal").resolve(authlibInjectorFileName));
    }

    private static AuthlibInjectorServer getOrCreateAuthlibInjectorServer(String url) {
        return ConfigHolder.config().getAuthlibInjectorServers().stream().filter(server -> url.equals(server.getUrl())).findFirst().orElseGet(() -> {
            AuthlibInjectorServer server = new AuthlibInjectorServer(url);
            ConfigHolder.config().getAuthlibInjectorServers().add((Object)server);
            return server;
        });
    }

    private static void removeDanglingAuthlibInjectorAccounts() {
        accounts.stream().filter(AuthlibInjectorAccount.class::isInstance).map(AuthlibInjectorAccount.class::cast).filter(it -> !ConfigHolder.config().getAuthlibInjectorServers().contains((Object)it.getServer())).collect(Collectors.toList()).forEach(arg_0 -> accounts.remove(arg_0));
    }

    public static String getLocalizedLoginTypeName(AccountFactory<?> factory) {
        return I18n.i18n(Optional.ofNullable(unlocalizedLoginTypeNames.get(factory)).orElseThrow(() -> new IllegalArgumentException("Unrecognized account factory")));
    }

    public static String localizeErrorMessage(Exception exception) {
        if (exception instanceof NoCharacterException) {
            return I18n.i18n("account.failed.no_character");
        }
        if (exception instanceof ServerDisconnectException) {
            if (exception.getCause() instanceof SSLException) {
                if (exception.getCause().getMessage() != null && exception.getCause().getMessage().contains("Remote host terminated")) {
                    return I18n.i18n("account.failed.connect_authentication_server");
                }
                if (exception.getCause().getMessage() != null && (exception.getCause().getMessage().contains("No name matching") || exception.getCause().getMessage().contains("No subject alternative DNS name matching"))) {
                    return I18n.i18n("account.failed.dns");
                }
                return I18n.i18n("account.failed.ssl");
            }
            return I18n.i18n("account.failed.connect_authentication_server");
        }
        if (exception instanceof ServerResponseMalformedException) {
            return I18n.i18n("account.failed.server_response_malformed");
        }
        if (exception instanceof RemoteAuthenticationException) {
            RemoteAuthenticationException remoteException = (RemoteAuthenticationException)exception;
            String remoteMessage = remoteException.getRemoteMessage();
            if ("ForbiddenOperationException".equals(remoteException.getRemoteName()) && remoteMessage != null) {
                if (remoteMessage.contains("Invalid credentials")) {
                    return I18n.i18n("account.failed.invalid_credentials");
                }
                if (remoteMessage.contains("Invalid token")) {
                    return I18n.i18n("account.failed.invalid_token");
                }
                if (remoteMessage.contains("Invalid username or password")) {
                    return I18n.i18n("account.failed.invalid_password");
                }
                return remoteMessage;
            }
            if ("ResourceException".equals(remoteException.getRemoteName()) && remoteMessage != null) {
                if (remoteMessage.contains("The requested resource is no longer available")) {
                    return I18n.i18n("account.failed.migration");
                }
                return remoteMessage;
            }
            return exception.getMessage();
        }
        if (exception instanceof AuthlibInjectorDownloadException) {
            return I18n.i18n("account.failed.injector_download_failure");
        }
        if (exception instanceof CharacterDeletedException) {
            return I18n.i18n("account.failed.character_deleted");
        }
        if (exception instanceof InvalidSkinException) {
            return I18n.i18n("account.skin.invalid_skin");
        }
        if (exception instanceof MicrosoftService.XboxAuthorizationException) {
            long errorCode = ((MicrosoftService.XboxAuthorizationException)exception).getErrorCode();
            if (errorCode == 2148916238L) {
                return I18n.i18n("account.methods.microsoft.error.add_family");
            }
            if (errorCode == 2148916235L) {
                return I18n.i18n("account.methods.microsoft.error.country_unavailable");
            }
            if (errorCode == 2148916233L) {
                return I18n.i18n("account.methods.microsoft.error.missing_xbox_account");
            }
            if (errorCode == 2148916227L) {
                return I18n.i18n("account.methods.microsoft.error.banned");
            }
            return I18n.i18n("account.methods.microsoft.error.unknown", errorCode);
        }
        if (exception instanceof MicrosoftService.XBox400Exception) {
            return I18n.i18n("account.methods.microsoft.error.wrong_verify_method");
        }
        if (exception instanceof MicrosoftService.NoMinecraftJavaEditionProfileException) {
            return I18n.i18n("account.methods.microsoft.error.no_character");
        }
        if (exception instanceof MicrosoftService.NoXuiException) {
            return I18n.i18n("account.methods.microsoft.error.add_family");
        }
        if (exception instanceof OAuthServer.MicrosoftAuthenticationNotSupportedException) {
            return I18n.i18n("account.methods.microsoft.snapshot");
        }
        if (exception instanceof OAuthAccount.WrongAccountException) {
            return I18n.i18n("account.failed.wrong_account");
        }
        if (exception.getClass() == AuthenticationException.class) {
            return exception.getLocalizedMessage();
        }
        return exception.getClass().getName() + ": " + exception.getLocalizedMessage();
    }

    private static /* synthetic */ void lambda$init$7(Account finalSelected) {
        try {
            finalSelected.logIn();
        }
        catch (Throwable e) {
            Logger.LOG.warning("Failed to log " + String.valueOf(finalSelected) + " in", e);
        }
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

