/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.skin;

import javafx.scene.AmbientLight;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.SceneAntialiasing;
import javafx.scene.SubScene;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Shape3D;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.jackhuang.hmcl.ui.skin.FunctionHelper;
import org.jackhuang.hmcl.ui.skin.SkinAnimationPlayer;
import org.jackhuang.hmcl.ui.skin.SkinCube;
import org.jackhuang.hmcl.ui.skin.SkinGroup;
import org.jackhuang.hmcl.ui.skin.SkinHelper;
import org.jackhuang.hmcl.ui.skin.SkinMultipleCubes;
import org.jetbrains.annotations.Nullable;

public class SkinCanvas
extends Group {
    public static final SkinCube ALEX_LARM = new SkinCube(3.0f, 12.0f, 4.0f, 0.21875f, 0.25f, 0.5f, 0.75f, 0.0f, true);
    public static final SkinCube ALEX_RARM = new SkinCube(3.0f, 12.0f, 4.0f, 0.21875f, 0.25f, 0.625f, 0.25f, 0.0f, true);
    public static final SkinCube STEVEN_LARM = new SkinCube(4.0f, 12.0f, 4.0f, 0.25f, 0.25f, 0.5f, 0.75f, 0.0f, false);
    public static final SkinCube STEVEN_RARM = new SkinCube(4.0f, 12.0f, 4.0f, 0.25f, 0.25f, 0.625f, 0.25f, 0.0f, false);
    protected Image srcSkin;
    protected Image skin;
    protected Image srcCape;
    protected Image cape;
    protected boolean isSlim;
    protected double preW;
    protected double preH;
    protected boolean msaa;
    protected SubScene subScene;
    protected Group root = new Group();
    public final SkinMultipleCubes headOuter = new SkinMultipleCubes(8, 8, 8, 0.5f, 0.0f, 1.125, 0.2);
    public final SkinMultipleCubes bodyOuter = new SkinMultipleCubes(8, 12, 4, 0.25f, 0.5f, 1.0, 0.2);
    public final SkinMultipleCubes larmOuter = new SkinMultipleCubes(4, 12, 4, 0.75f, 0.75f, 1.0625, 0.2);
    public final SkinMultipleCubes rarmOuter = new SkinMultipleCubes(4, 12, 4, 0.625f, 0.5f, 1.0625, 0.2);
    public final SkinMultipleCubes llegOuter = new SkinMultipleCubes(4, 12, 4, 0.0f, 0.75f, 1.0625, 0.2);
    public final SkinMultipleCubes rlegOuter = new SkinMultipleCubes(4, 12, 4, 0.0f, 0.5f, 1.0625, 0.2);
    public final SkinCube headInside = new SkinCube(8.0f, 8.0f, 8.0f, 0.5f, 0.25f, 0.0f, 0.0f, 0.0f, false);
    public final SkinCube bodyInside = new SkinCube(8.0f, 12.0f, 4.0f, 0.375f, 0.25f, 0.25f, 0.25f, 0.03f, false);
    public final SkinCube larmInside = new SkinCube(4.0f, 12.0f, 4.0f, 0.25f, 0.25f, 0.5f, 0.75f, 0.0f, false);
    public final SkinCube rarmInside = new SkinCube(4.0f, 12.0f, 4.0f, 0.25f, 0.25f, 0.625f, 0.25f, 0.0f, false);
    public final SkinCube llegInside = new SkinCube(4.0f, 12.0f, 4.0f, 0.25f, 0.25f, 0.25f, 0.75f, 0.0f, false);
    public final SkinCube rlegInside = new SkinCube(4.0f, 12.0f, 4.0f, 0.25f, 0.25f, 0.0f, 0.25f, 0.0f, false);
    public final SkinCube capeCube = new SkinCube(10.0f, 16.0f, 1.0f, 0.34375f, 0.53125f, 0.0f, 0.0f, 0.0f, false);
    public final SkinGroup head = new SkinGroup(new Rotate(0.0, 0.0, this.headInside.getHeight() / 2.0, 0.0, Rotate.X_AXIS), new Rotate(0.0, Rotate.Y_AXIS), new Rotate(0.0, 0.0, this.headInside.getHeight() / 2.0, 0.0, Rotate.Z_AXIS), new Node[]{this.headOuter, this.headInside});
    public final SkinGroup body = new SkinGroup(new Rotate(0.0, Rotate.X_AXIS), new Rotate(0.0, Rotate.Y_AXIS), new Rotate(0.0, Rotate.Z_AXIS), new Node[]{this.bodyOuter, this.bodyInside});
    public final SkinGroup larm = new SkinGroup(new Rotate(0.0, 0.0, -this.larmInside.getHeight() / 2.0, 0.0, Rotate.X_AXIS), new Rotate(0.0, Rotate.Y_AXIS), new Rotate(0.0, this.larmInside.getWidth() / 2.0, -this.larmInside.getHeight() / 2.0, 0.0, Rotate.Z_AXIS), new Node[]{this.larmOuter, this.larmInside});
    public final SkinGroup rarm = new SkinGroup(new Rotate(0.0, 0.0, -this.rarmInside.getHeight() / 2.0, 0.0, Rotate.X_AXIS), new Rotate(0.0, Rotate.Y_AXIS), new Rotate(0.0, -this.rarmInside.getWidth() / 2.0, -this.rarmInside.getHeight() / 2.0, 0.0, Rotate.Z_AXIS), new Node[]{this.rarmOuter, this.rarmInside});
    public final SkinGroup lleg = new SkinGroup(new Rotate(0.0, 0.0, -this.llegInside.getHeight() / 2.0, 0.0, Rotate.X_AXIS), new Rotate(0.0, Rotate.Y_AXIS), new Rotate(0.0, 0.0, -this.llegInside.getHeight() / 2.0, 0.0, Rotate.Z_AXIS), new Node[]{this.llegOuter, this.llegInside});
    public final SkinGroup rleg = new SkinGroup(new Rotate(0.0, 0.0, -this.rlegInside.getHeight() / 2.0, 0.0, Rotate.X_AXIS), new Rotate(0.0, Rotate.Y_AXIS), new Rotate(0.0, 0.0, -this.rlegInside.getHeight() / 2.0, 0.0, Rotate.Z_AXIS), new Node[]{this.rlegOuter, this.rlegInside});
    public final SkinGroup capeGroup = new SkinGroup(new Rotate(0.0, 0.0, -this.capeCube.getHeight() / 2.0, 0.0, Rotate.X_AXIS), new Rotate(0.0, Rotate.Y_AXIS), new Rotate(0.0, Rotate.Z_AXIS), new Node[]{this.capeCube});
    protected PerspectiveCamera camera = new PerspectiveCamera(true);
    protected Rotate xRotate = new Rotate(0.0, Rotate.X_AXIS);
    protected Rotate yRotate = new Rotate(180.0, Rotate.Y_AXIS);
    protected Rotate zRotate = new Rotate(0.0, Rotate.Z_AXIS);
    protected Translate translate = new Translate(0.0, 0.0, -80.0);
    protected Scale scale = new Scale(1.0, 1.0);
    protected SkinAnimationPlayer animationPlayer = new SkinAnimationPlayer();
    private double lastX;
    private double lastY;

    public SkinAnimationPlayer getAnimationPlayer() {
        return this.animationPlayer;
    }

    public Image getSrcSkin() {
        return this.srcSkin;
    }

    public Image getSkin() {
        return this.skin;
    }

    public void updateSkin(Image skin, boolean isSlim, @Nullable Image cape) {
        if (SkinHelper.isNoRequest(skin) && SkinHelper.isSkin(skin)) {
            this.srcSkin = skin;
            this.skin = SkinHelper.x32Tox64(skin);
            this.srcCape = cape;
            this.cape = cape == null ? null : (cape.getWidth() < 256.0 ? SkinHelper.enlarge(cape, 4, 8) : cape);
            int multiple = Math.max((int)(1024.0 / skin.getWidth()), 1);
            if (multiple > 1) {
                this.skin = SkinHelper.enlarge(this.skin, multiple, multiple);
            }
            this.updateSkinModel(isSlim, cape != null);
            this.bindMaterial(this.root);
        }
    }

    protected void updateSkinModel(boolean isSlim, boolean hasCape) {
        this.isSlim = isSlim;
        FunctionHelper.alwaysB(SkinMultipleCubes::setWidth, isSlim ? 3 : 4, this.larmOuter, this.rarmOuter);
        FunctionHelper.alwaysB(SkinCube::setWidth, isSlim ? 3.0 : 4.0, this.larmInside, this.rarmInside);
        FunctionHelper.alwaysB(Node::setTranslateX, -(this.bodyInside.getWidth() + this.larmInside.getWidth()) / 2.0, this.larm);
        FunctionHelper.alwaysB(Node::setTranslateX, (this.bodyInside.getWidth() + this.rarmInside.getWidth()) / 2.0, this.rarm);
        if (isSlim) {
            this.larmInside.setModel(ALEX_LARM.getModel());
            this.rarmInside.setModel(ALEX_RARM.getModel());
        } else {
            this.larmInside.setModel(STEVEN_LARM.getModel());
            this.rarmInside.setModel(STEVEN_RARM.getModel());
        }
        this.larm.getZRotate().setPivotX(-this.larmInside.getWidth() / 2.0);
        this.rarm.getZRotate().setPivotX(this.rarmInside.getWidth() / 2.0);
        this.capeGroup.setVisible(hasCape);
    }

    public SkinCanvas(Image skin, double preW, double preH, boolean msaa) {
        this.skin = skin;
        this.preW = preW;
        this.preH = preH;
        this.msaa = msaa;
        this.init();
    }

    protected Material createMaterial(Image image) {
        PhongMaterial material = new PhongMaterial();
        material.setDiffuseMap(image);
        return material;
    }

    protected void bindMaterial(Group group) {
        Material material = this.createMaterial(this.skin);
        for (Node node : group.getChildren()) {
            if (node instanceof Shape3D) {
                ((Shape3D)node).setMaterial(node == this.capeCube ? this.createMaterial(this.cape) : material);
                continue;
            }
            if (node instanceof SkinMultipleCubes) {
                ((SkinMultipleCubes)node).updateSkin(this.skin);
                continue;
            }
            if (!(node instanceof Group)) continue;
            this.bindMaterial((Group)node);
        }
    }

    protected Group createPlayerModel() {
        this.head.setTranslateY(-(this.bodyInside.getHeight() + this.headInside.getHeight()) / 2.0);
        this.larm.setTranslateX(-(this.bodyInside.getWidth() + this.larmInside.getWidth()) / 2.0);
        this.rarm.setTranslateX((this.bodyInside.getWidth() + this.rarmInside.getWidth()) / 2.0);
        this.lleg.setTranslateX(-(this.bodyInside.getWidth() - this.llegInside.getWidth()) / 2.0);
        this.rleg.setTranslateX((this.bodyInside.getWidth() - this.rlegInside.getWidth()) / 2.0);
        this.lleg.setTranslateY((this.bodyInside.getHeight() + this.llegInside.getHeight()) / 2.0);
        this.rleg.setTranslateY((this.bodyInside.getHeight() + this.rlegInside.getHeight()) / 2.0);
        this.capeGroup.setTranslateY((this.capeCube.getHeight() - (double)this.bodyOuter.getHeight()) / 2.0);
        this.capeGroup.setTranslateZ(-(this.bodyInside.getDepth() + (double)this.bodyOuter.getDepth()) / 2.0);
        this.capeGroup.getTransforms().addAll((Object[])new Transform[]{new Rotate(180.0, Rotate.Y_AXIS), new Rotate(10.0, Rotate.X_AXIS)});
        this.root.getTransforms().addAll((Object[])new Transform[]{this.xRotate});
        this.root.getChildren().addAll((Object[])new Node[]{this.head, this.body, this.larm, this.rarm, this.lleg, this.rleg, this.capeGroup});
        this.updateSkin(this.skin, false, null);
        return this.root;
    }

    protected SubScene createSubScene() {
        Group group = new Group();
        AmbientLight light = new AmbientLight(Color.WHITE);
        group.getChildren().add((Object)light);
        group.getChildren().add((Object)this.createPlayerModel());
        group.getTransforms().add((Object)this.zRotate);
        this.camera.getTransforms().addAll((Object[])new Transform[]{this.yRotate, this.translate, this.scale});
        this.subScene = new SubScene((Parent)group, this.preW, this.preH, true, this.msaa ? SceneAntialiasing.BALANCED : SceneAntialiasing.DISABLED);
        this.subScene.setCamera((Camera)this.camera);
        return this.subScene;
    }

    protected void init() {
        this.getChildren().add((Object)this.createSubScene());
    }

    public void enableRotation(double sensitivity) {
        this.addEventHandler(MouseEvent.MOUSE_PRESSED, e -> {
            this.lastX = -1.0;
            this.lastY = -1.0;
        });
        this.addEventHandler(MouseEvent.MOUSE_DRAGGED, e -> {
            if (this.lastX != -1.0 && this.lastY != -1.0) {
                if (e.isAltDown() || e.isControlDown() || e.isShiftDown()) {
                    if (e.isShiftDown()) {
                        this.zRotate.setAngle(this.zRotate.getAngle() - (e.getSceneY() - this.lastY) * sensitivity);
                    }
                    if (e.isAltDown()) {
                        this.yRotate.setAngle(this.yRotate.getAngle() + (e.getSceneX() - this.lastX) * sensitivity);
                    }
                    if (e.isControlDown()) {
                        this.xRotate.setAngle(this.xRotate.getAngle() + (e.getSceneY() - this.lastY) * sensitivity);
                    }
                } else {
                    double yaw = this.yRotate.getAngle() + (e.getSceneX() - this.lastX) * sensitivity;
                    if ((yaw %= 360.0) < 0.0) {
                        yaw += 360.0;
                    }
                    int flagX = yaw < 90.0 || yaw > 270.0 ? 1 : -1;
                    int flagZ = yaw < 180.0 ? -1 : 1;
                    double kx = Math.abs(90.0 - yaw % 180.0) / 90.0 * (double)flagX;
                    double kz = Math.abs(90.0 - (yaw + 90.0) % 180.0) / 90.0 * (double)flagZ;
                    this.xRotate.setAngle(this.xRotate.getAngle() + (e.getSceneY() - this.lastY) * sensitivity * kx);
                    this.yRotate.setAngle(yaw);
                    this.zRotate.setAngle(this.zRotate.getAngle() + (e.getSceneY() - this.lastY) * sensitivity * kz);
                }
            }
            this.lastX = e.getSceneX();
            this.lastY = e.getSceneY();
        });
        this.addEventHandler(ScrollEvent.SCROLL, e -> {
            double delta = (double)(e.getDeltaY() > 0.0 ? 1 : (e.getDeltaY() == 0.0 ? 0 : -1)) / 10.0 * sensitivity;
            this.scale.setX(Math.min(Math.max(this.scale.getX() - delta, 0.1), 10.0));
            this.scale.setY(Math.min(Math.max(this.scale.getY() - delta, 0.1), 10.0));
        });
    }
}

