/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.liteloader;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.download.liteloader.LiteLoaderBranch;
import org.jackhuang.hmcl.download.liteloader.LiteLoaderGameVersions;
import org.jackhuang.hmcl.download.liteloader.LiteLoaderRemoteVersion;
import org.jackhuang.hmcl.download.liteloader.LiteLoaderRepository;
import org.jackhuang.hmcl.download.liteloader.LiteLoaderVersion;
import org.jackhuang.hmcl.download.liteloader.LiteLoaderVersionsRoot;
import org.jackhuang.hmcl.task.GetTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.io.HttpRequest;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public final class LiteLoaderVersionList
extends VersionList<LiteLoaderRemoteVersion> {
    private final DownloadProvider downloadProvider;
    public static final String LITELOADER_LIST = "https://dl.liteloader.com/versions/versions.json";
    private static final String SNAPSHOT_METADATA = "https://repo.mumfrey.com/content/repositories/snapshots/com/mumfrey/liteloader/%s-SNAPSHOT/maven-metadata.xml";
    private static final String SNAPSHOT_FILE = "https://repo.mumfrey.com/content/repositories/snapshots/com/mumfrey/liteloader/%s-SNAPSHOT/liteloader-%s-%s-%s-release.jar";

    public LiteLoaderVersionList(DownloadProvider downloadProvider) {
        this.downloadProvider = downloadProvider;
    }

    @Override
    public boolean hasType() {
        return true;
    }

    @Override
    public Task<?> refreshAsync(String gameVersion) {
        return new GetTask(this.downloadProvider.injectURL(LITELOADER_LIST)).thenGetJsonAsync(LiteLoaderVersionsRoot.class).thenAcceptAsync(root -> {
            LiteLoaderGameVersions versions = root.getVersions().get(gameVersion);
            if (versions == null) {
                return;
            }
            LiteLoaderRemoteVersion snapshot = null;
            if (versions.getSnapshots() != null) {
                try {
                    snapshot = this.loadSnapshotVersion(gameVersion, versions.getSnapshots().getLiteLoader().get("latest"));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            this.lock.writeLock().lock();
            try {
                this.versions.clear();
                if (versions.getRepoitory() != null && versions.getArtifacts() != null) {
                    this.loadArtifactVersion(gameVersion, versions.getRepoitory(), versions.getArtifacts());
                }
                if (snapshot != null) {
                    this.versions.put(gameVersion, snapshot);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        });
    }

    @Override
    public Task<?> refreshAsync() {
        throw new UnsupportedOperationException();
    }

    private void loadArtifactVersion(String gameVersion, LiteLoaderRepository repository, LiteLoaderBranch branch) {
        for (Map.Entry<String, LiteLoaderVersion> entry : branch.getLiteLoader().entrySet()) {
            String branchName = entry.getKey();
            LiteLoaderVersion v = entry.getValue();
            if ("latest".equals(branchName)) continue;
            this.versions.put(gameVersion, new LiteLoaderRemoteVersion(gameVersion, v.getVersion(), RemoteVersion.Type.RELEASE, Collections.singletonList(repository.getUrl() + "com/mumfrey/liteloader/" + gameVersion + "/" + v.getFile()), v.getTweakClass(), v.getLibraries()));
        }
    }

    private LiteLoaderRemoteVersion loadSnapshotVersion(String gameVersion, LiteLoaderVersion v) throws IOException {
        String root = HttpRequest.GET(String.format(SNAPSHOT_METADATA, gameVersion)).getString();
        Document document = Jsoup.parseBodyFragment(root);
        String timestamp = Objects.requireNonNull(document.select("timestamp"), "timestamp").text();
        String buildNumber = Objects.requireNonNull(document.select("buildNumber"), "buildNumber").text();
        return new LiteLoaderRemoteVersion(gameVersion, timestamp + "-" + buildNumber, RemoteVersion.Type.SNAPSHOT, Collections.singletonList(String.format(SNAPSHOT_FILE, gameVersion, gameVersion, timestamp, buildNumber)), v.getTweakClass(), v.getLibraries());
    }
}

