/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.mcbbs;

import com.google.gson.JsonParseException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.GameBuilder;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.mod.MinecraftInstanceTask;
import org.jackhuang.hmcl.mod.Modpack;
import org.jackhuang.hmcl.mod.ModpackConfiguration;
import org.jackhuang.hmcl.mod.ModpackInstallTask;
import org.jackhuang.hmcl.mod.mcbbs.McbbsModpackCompletionTask;
import org.jackhuang.hmcl.mod.mcbbs.McbbsModpackManifest;
import org.jackhuang.hmcl.mod.mcbbs.McbbsModpackProvider;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.gson.JsonUtils;

public final class McbbsModpackLocalInstallTask
extends Task<Void> {
    private final DefaultDependencyManager dependencyManager;
    private final Path zipFile;
    private final Modpack modpack;
    private final McbbsModpackManifest manifest;
    private final String name;
    private final boolean update;
    private final DefaultGameRepository repository;
    private final MinecraftInstanceTask<McbbsModpackManifest> instanceTask;
    private final List<Task<?>> dependencies = new ArrayList(2);
    private final List<Task<?>> dependents = new ArrayList(4);
    private static final String PATCH_NAME = "mcbbs";

    public McbbsModpackLocalInstallTask(DefaultDependencyManager dependencyManager, Path zipFile, Modpack modpack, McbbsModpackManifest manifest, String name) {
        this.dependencyManager = dependencyManager;
        this.zipFile = zipFile;
        this.modpack = modpack;
        this.manifest = manifest;
        this.name = name;
        this.repository = dependencyManager.getGameRepository();
        Path run = this.repository.getRunDirectory(name);
        Path json = this.repository.getModpackConfiguration(name);
        if (this.repository.hasVersion(name) && Files.notExists(json, new LinkOption[0])) {
            throw new IllegalArgumentException("Version " + name + " already exists.");
        }
        this.update = this.repository.hasVersion(name);
        GameBuilder builder = dependencyManager.gameBuilder().name(name);
        for (McbbsModpackManifest.Addon addon : manifest.getAddons()) {
            builder.version(addon.getId(), addon.getVersion());
        }
        this.dependents.add(builder.buildAsync());
        this.onDone().register(event -> {
            if (event.isFailed()) {
                this.repository.removeVersionFromDisk(name);
            }
        });
        ModpackConfiguration<McbbsModpackManifest> config = null;
        try {
            if (Files.exists(json, new LinkOption[0])) {
                config = JsonUtils.fromJsonFile(json, ModpackConfiguration.typeOf(McbbsModpackManifest.class));
                if (!McbbsModpackProvider.INSTANCE.getName().equals(config.getType())) {
                    throw new IllegalArgumentException("Version " + name + " is not a Mcbbs modpack. Cannot update this version.");
                }
            }
        }
        catch (JsonParseException | IOException exception) {
            // empty catch block
        }
        this.dependents.add(new ModpackInstallTask<McbbsModpackManifest>(zipFile, run, modpack.getEncoding(), Collections.singletonList("/overrides"), any -> true, config).withStage("hmcl.modpack"));
        this.instanceTask = new MinecraftInstanceTask<McbbsModpackManifest>(zipFile, modpack.getEncoding(), Collections.singletonList("/overrides"), manifest, McbbsModpackProvider.INSTANCE, modpack.getName(), modpack.getVersion(), this.repository.getModpackConfiguration(name));
        this.dependents.add(this.instanceTask.withStage("hmcl.modpack"));
    }

    @Override
    public List<Task<?>> getDependents() {
        return this.dependents;
    }

    @Override
    public List<Task<?>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public void execute() throws Exception {
        Version version = this.repository.readVersionJson(this.name);
        Optional<Version> mcbbsPatch = version.getPatches().stream().filter(patch -> PATCH_NAME.equals(patch.getId())).findFirst();
        if (!this.update) {
            Version patch2 = new Version(PATCH_NAME).setLibraries(this.manifest.getLibraries());
            this.dependencies.add(this.repository.saveAsync(version.addPatch(patch2)));
        } else if (mcbbsPatch.isPresent()) {
            Version patch3 = mcbbsPatch.get().setLibraries(this.manifest.getLibraries());
            this.dependencies.add(this.repository.saveAsync(version.addPatch(patch3)));
        }
        this.dependencies.add(new McbbsModpackCompletionTask(this.dependencyManager, this.name, (ModpackConfiguration)this.instanceTask.getResult()));
    }
}

