/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.i18n;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.download.game.GameRemoteVersion;
import org.jackhuang.hmcl.util.i18n.DefaultResourceBundleControl;
import org.jackhuang.hmcl.util.i18n.LocaleUtils;
import org.jackhuang.hmcl.util.i18n.MinecraftWiki;
import org.jackhuang.hmcl.util.i18n.SupportedLocale;
import org.jackhuang.hmcl.util.i18n.translator.Translator;
import org.jackhuang.hmcl.util.versioning.GameVersionNumber;
import org.jetbrains.annotations.Nullable;

public final class I18n {
    private static volatile SupportedLocale locale = SupportedLocale.DEFAULT;

    private I18n() {
    }

    public static void setLocale(SupportedLocale locale) {
        I18n.locale = locale;
    }

    public static SupportedLocale getLocale() {
        return locale;
    }

    public static boolean isUpsideDown() {
        return LocaleUtils.getScript(locale.getLocale()).equals("Qabs");
    }

    public static boolean isUseChinese() {
        return LocaleUtils.isChinese(locale.getLocale());
    }

    public static ResourceBundle getResourceBundle() {
        return locale.getResourceBundle();
    }

    public static Translator getTranslator() {
        return locale.getTranslator();
    }

    public static String i18n(String key, Object ... formatArgs) {
        return locale.i18n(key, formatArgs);
    }

    public static String i18n(String key) {
        return locale.i18n(key);
    }

    public static String formatDateTime(TemporalAccessor time) {
        return I18n.getTranslator().formatDateTime(time);
    }

    public static String formatSpeed(long bytes) {
        return I18n.getTranslator().formatSpeed(bytes);
    }

    public static String getDisplayVersion(RemoteVersion version) {
        return I18n.getTranslator().getDisplayVersion(version);
    }

    public static String getDisplayVersion(GameVersionNumber version) {
        return I18n.getTranslator().getDisplayVersion(version);
    }

    @Nullable
    public static URL getBuiltinResource(String name, String suffix) {
        DefaultResourceBundleControl control = DefaultResourceBundleControl.INSTANCE;
        ClassLoader classLoader = I18n.class.getClassLoader();
        for (Locale locale : I18n.locale.getCandidateLocales()) {
            String resourceName = control.toResourceName(control.toBundleName(name, locale), suffix);
            URL input = classLoader.getResource(resourceName);
            if (input == null) continue;
            return input;
        }
        return null;
    }

    @Nullable
    public static InputStream getBuiltinResourceAsStream(String name, String suffix) {
        URL resource = I18n.getBuiltinResource(name, suffix);
        try {
            return resource != null ? resource.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getWikiLink(GameRemoteVersion remoteVersion) {
        return MinecraftWiki.getWikiLink(locale, remoteVersion);
    }

    public static boolean hasKey(String key) {
        return I18n.getResourceBundle().containsKey(key);
    }
}

