/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.platform.hardware;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.IOUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.SystemUtils;
import org.jackhuang.hmcl.util.platform.hardware.CentralProcessor;
import org.jackhuang.hmcl.util.platform.hardware.GraphicsCard;
import org.jackhuang.hmcl.util.platform.hardware.HardwareVendor;
import org.jetbrains.annotations.Nullable;

final class FastFetchUtils {
    private FastFetchUtils() {
    }

    private static <T> T get(String type, TypeToken<T> resultType) {
        String output;
        Path fastfetch = SystemUtils.which(OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS ? "fastfetch.exe" : "fastfetch");
        if (fastfetch == null) {
            return null;
        }
        try {
            output = SystemUtils.run(Arrays.asList(fastfetch.toString(), "--structure", type, "--format", "json"), inputStream -> IOUtils.readFullyAsString(inputStream, OperatingSystem.NATIVE_CHARSET));
        }
        catch (Throwable e) {
            Logger.LOG.warning("Failed to get result from fastfetch", e);
            return null;
        }
        try {
            Result<T> result;
            int idx = output.indexOf(91);
            String json = idx >= 0 ? output.substring(idx) : output;
            List<Result<T>> list = JsonUtils.GSON.fromJson(json, JsonUtils.listTypeOf(Result.typeOf(resultType)));
            if (list == null || list.size() != 1 || (result = list.get(0)) == null || !type.equalsIgnoreCase(result.type) || result.result == null) {
                throw new IOException("Illegal output format");
            }
            return result.result;
        }
        catch (Throwable e) {
            Logger.LOG.warning("Failed to parse fastfetch output: " + output, e);
            return null;
        }
    }

    @Nullable
    static CentralProcessor detectCentralProcessor() {
        CPUInfo cpuInfo = FastFetchUtils.get("CPU", TypeToken.get(CPUInfo.class));
        if (cpuInfo == null) {
            return null;
        }
        CentralProcessor.Builder builder = new CentralProcessor.Builder().setName(cpuInfo.cpu).setVendor(HardwareVendor.of(cpuInfo.vendor));
        if (cpuInfo.cores != null) {
            try {
                String physical = cpuInfo.cores.get("physical");
                String logical = cpuInfo.cores.get("logical");
                int cores = physical != null ? Integer.parseInt(physical) : 0;
                int threads = logical != null ? Integer.parseInt(logical) : 0;
                int packages = Integer.max(cpuInfo.packages, 1);
                if (cores > 0 && threads == 0) {
                    threads = cores;
                } else if (threads > 0 && cores == 0) {
                    cores = threads;
                }
                builder.setCores(new CentralProcessor.Cores(cores, threads, packages));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return builder.build();
    }

    @Nullable
    static List<GraphicsCard> detectGraphicsCards() {
        List<GPUInfo> gpuInfos = FastFetchUtils.get("GPU", JsonUtils.listTypeOf(GPUInfo.class));
        if (gpuInfos == null) {
            return null;
        }
        ArrayList<GraphicsCard> result = new ArrayList<GraphicsCard>(gpuInfos.size());
        for (GPUInfo gpuInfo : gpuInfos) {
            if (gpuInfo == null) continue;
            GraphicsCard.Builder builder = new GraphicsCard.Builder().setName(gpuInfo.name).setVendor(HardwareVendor.of(gpuInfo.vendor)).setDriver(gpuInfo.driver);
            if ("Discrete".equalsIgnoreCase(gpuInfo.type)) {
                builder.setType(GraphicsCard.Type.Discrete);
            } else if ("Integrated".equalsIgnoreCase(gpuInfo.type)) {
                builder.setType(GraphicsCard.Type.Integrated);
            }
            result.add(builder.build());
        }
        return result;
    }

    private static final class Result<T> {
        String type;
        T result;

        private Result() {
        }

        static <T> TypeToken<Result<T>> typeOf(TypeToken<T> type) {
            return TypeToken.getParameterized(Result.class, new Type[]{type.getType()});
        }
    }

    private static final class CPUInfo {
        String cpu;
        String vendor;
        int packages;
        Map<String, String> cores;

        private CPUInfo() {
        }
    }

    private static final class GPUInfo {
        String name;
        String vendor;
        String type;
        String driver;

        private GPUInfo() {
        }
    }
}

