/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.monetfx.beans.property;

import java.lang.ref.WeakReference;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.glavo.monetfx.ColorScheme;
import org.glavo.monetfx.beans.property.ColorSchemeProperty;
import org.glavo.monetfx.internal.beans.ExpressionHelper;

public abstract class ColorSchemePropertyBase
extends ColorSchemeProperty {
    private ColorScheme value;
    private ObservableValue<? extends ColorScheme> observable = null;
    private InvalidationListener listener = null;
    private boolean valid = true;
    private ExpressionHelper<ColorScheme> helper = null;

    public ColorSchemePropertyBase() {
    }

    public ColorSchemePropertyBase(ColorScheme initialValue) {
        this.value = initialValue;
    }

    public void addListener(InvalidationListener listener) {
        this.helper = ExpressionHelper.addListener(this.helper, this, listener);
    }

    public void removeListener(InvalidationListener listener) {
        this.helper = ExpressionHelper.removeListener(this.helper, listener);
    }

    public void addListener(ChangeListener<? super ColorScheme> listener) {
        this.helper = ExpressionHelper.addListener(this.helper, this, listener);
    }

    public void removeListener(ChangeListener<? super ColorScheme> listener) {
        this.helper = ExpressionHelper.removeListener(this.helper, listener);
    }

    protected void fireValueChangedEvent() {
        ExpressionHelper.fireValueChangedEvent(this.helper);
    }

    private void markInvalid() {
        if (this.valid) {
            this.valid = false;
            this.invalidated();
            this.fireValueChangedEvent();
        }
    }

    protected void invalidated() {
    }

    public ColorScheme get() {
        this.valid = true;
        return this.observable == null ? this.value : (ColorScheme)this.observable.getValue();
    }

    public void set(ColorScheme newValue) {
        if (this.isBound()) {
            throw new RuntimeException((this.getBean() != null && this.getName() != null ? this.getBean().getClass().getSimpleName() + "." + this.getName() + " : " : "") + "A bound value cannot be set.");
        }
        if (!Objects.equals(this.value, newValue)) {
            this.value = newValue;
            this.markInvalid();
        }
    }

    public boolean isBound() {
        return this.observable != null;
    }

    public void bind(ObservableValue<? extends ColorScheme> newObservable) {
        if (newObservable == null) {
            throw new NullPointerException("Cannot bind to null");
        }
        if (!newObservable.equals(this.observable)) {
            this.unbind();
            this.observable = newObservable;
            if (this.listener == null) {
                this.listener = new Listener(this);
            }
            this.observable.addListener(this.listener);
            this.markInvalid();
        }
    }

    public void unbind() {
        if (this.observable != null) {
            this.value = (ColorScheme)this.observable.getValue();
            this.observable.removeListener(this.listener);
            this.observable = null;
        }
    }

    @Override
    public String toString() {
        Object bean = this.getBean();
        String name = this.getName();
        StringBuilder result = new StringBuilder("ColorSchemeProperty [");
        if (bean != null) {
            result.append("bean: ").append(bean).append(", ");
        }
        if (name != null && !name.isEmpty()) {
            result.append("name: ").append(name).append(", ");
        }
        if (this.isBound()) {
            result.append("bound, ");
            if (this.valid) {
                result.append("value: ").append(this.get());
            } else {
                result.append("invalid");
            }
        } else {
            result.append("value: ").append(this.get());
        }
        result.append("]");
        return result.toString();
    }

    private static final class Listener
    implements InvalidationListener,
    WeakListener {
        private final WeakReference<ColorSchemePropertyBase> weakRef;

        public Listener(ColorSchemePropertyBase ref) {
            this.weakRef = new WeakReference<ColorSchemePropertyBase>(ref);
        }

        public boolean wasGarbageCollected() {
            return this.weakRef.get() == null;
        }

        public void invalidated(Observable observable) {
            ColorSchemePropertyBase ref = (ColorSchemePropertyBase)this.weakRef.get();
            if (ref != null) {
                ref.markInvalid();
            } else {
                observable.removeListener((InvalidationListener)this);
            }
        }
    }
}

