/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.monetfx.internal.dynamiccolor;

import java.util.ArrayList;
import java.util.Optional;
import org.glavo.monetfx.ColorSpecVersion;
import org.glavo.monetfx.ColorStyle;
import org.glavo.monetfx.TargetPlatform;
import org.glavo.monetfx.internal.contrast.Contrast;
import org.glavo.monetfx.internal.dynamiccolor.ColorSpec2021;
import org.glavo.monetfx.internal.dynamiccolor.ContrastCurve;
import org.glavo.monetfx.internal.dynamiccolor.DynamicColor;
import org.glavo.monetfx.internal.dynamiccolor.DynamicScheme;
import org.glavo.monetfx.internal.dynamiccolor.ToneDeltaPair;
import org.glavo.monetfx.internal.dynamiccolor.TonePolarity;
import org.glavo.monetfx.internal.hct.Hct;
import org.glavo.monetfx.internal.palettes.TonalPalette;
import org.glavo.monetfx.internal.utils.MathUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ColorSpec2025
extends ColorSpec2021 {
    ColorSpec2025() {
    }

    @Override
    @NotNull
    public DynamicColor background() {
        DynamicColor color2025 = this.surface().toBuilder().setName("background").build();
        return super.background().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor onBackground() {
        DynamicColor.Builder color2025Builder = this.onSurface().toBuilder().setName("on_background");
        color2025Builder.setTone(s -> s.platform == TargetPlatform.WATCH ? 100.0 : this.onSurface().getTone((DynamicScheme)s));
        return super.onBackground().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025Builder.build()).build();
    }

    @Override
    @NotNull
    public DynamicColor surface() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("surface").setPalette(s -> s.neutralPalette).setTone(s -> {
            if (s.platform == TargetPlatform.PHONE) {
                if (s.isDark) {
                    return 4.0;
                }
                if (Hct.isYellow(s.neutralPalette.getHue())) {
                    return 99.0;
                }
                if (s.variant == ColorStyle.VIBRANT) {
                    return 97.0;
                }
                return 98.0;
            }
            return 0.0;
        }).setIsBackground(true).build();
        return super.surface().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor surfaceDim() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("surface_dim").setPalette(s -> s.neutralPalette).setTone(s -> {
            if (s.isDark) {
                return 4.0;
            }
            if (Hct.isYellow(s.neutralPalette.getHue())) {
                return 90.0;
            }
            if (s.variant == ColorStyle.VIBRANT) {
                return 85.0;
            }
            return 87.0;
        }).setIsBackground(true).setChromaMultiplier(s -> {
            if (!s.isDark) {
                if (s.variant == ColorStyle.NEUTRAL) {
                    return 2.5;
                }
                if (s.variant == ColorStyle.TONAL_SPOT) {
                    return 1.7;
                }
                if (s.variant == ColorStyle.EXPRESSIVE) {
                    return Hct.isYellow(s.neutralPalette.getHue()) ? 2.7 : 1.75;
                }
                if (s.variant == ColorStyle.VIBRANT) {
                    return 1.36;
                }
            }
            return 1.0;
        }).build();
        return super.surfaceDim().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor surfaceBright() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("surface_bright").setPalette(s -> s.neutralPalette).setTone(s -> {
            if (s.isDark) {
                return 18.0;
            }
            if (Hct.isYellow(s.neutralPalette.getHue())) {
                return 99.0;
            }
            if (s.variant == ColorStyle.VIBRANT) {
                return 97.0;
            }
            return 98.0;
        }).setIsBackground(true).setChromaMultiplier(s -> {
            if (s.isDark) {
                if (s.variant == ColorStyle.NEUTRAL) {
                    return 2.5;
                }
                if (s.variant == ColorStyle.TONAL_SPOT) {
                    return 1.7;
                }
                if (s.variant == ColorStyle.EXPRESSIVE) {
                    return Hct.isYellow(s.neutralPalette.getHue()) ? 2.7 : 1.75;
                }
                if (s.variant == ColorStyle.VIBRANT) {
                    return 1.36;
                }
            }
            return 1.0;
        }).build();
        return super.surfaceBright().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor surfaceContainerLowest() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("surface_container_lowest").setPalette(s -> s.neutralPalette).setTone(s -> s.isDark ? 0.0 : 100.0).setIsBackground(true).build();
        return super.surfaceContainerLowest().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor surfaceContainerLow() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("surface_container_low").setPalette(s -> s.neutralPalette).setTone(s -> {
            if (s.platform == TargetPlatform.PHONE) {
                if (s.isDark) {
                    return 6.0;
                }
                if (Hct.isYellow(s.neutralPalette.getHue())) {
                    return 98.0;
                }
                if (s.variant == ColorStyle.VIBRANT) {
                    return 95.0;
                }
                return 96.0;
            }
            return 15.0;
        }).setIsBackground(true).setChromaMultiplier(s -> {
            if (s.platform == TargetPlatform.PHONE) {
                if (s.variant == ColorStyle.NEUTRAL) {
                    return 1.3;
                }
                if (s.variant == ColorStyle.TONAL_SPOT) {
                    return 1.25;
                }
                if (s.variant == ColorStyle.EXPRESSIVE) {
                    return Hct.isYellow(s.neutralPalette.getHue()) ? 1.3 : 1.15;
                }
                if (s.variant == ColorStyle.VIBRANT) {
                    return 1.08;
                }
            }
            return 1.0;
        }).build();
        return super.surfaceContainerLow().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor surfaceContainer() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("surface_container").setPalette(s -> s.neutralPalette).setTone(s -> {
            if (s.platform == TargetPlatform.PHONE) {
                if (s.isDark) {
                    return 9.0;
                }
                if (Hct.isYellow(s.neutralPalette.getHue())) {
                    return 96.0;
                }
                if (s.variant == ColorStyle.VIBRANT) {
                    return 92.0;
                }
                return 94.0;
            }
            return 20.0;
        }).setIsBackground(true).setChromaMultiplier(s -> {
            if (s.platform == TargetPlatform.PHONE) {
                if (s.variant == ColorStyle.NEUTRAL) {
                    return 1.6;
                }
                if (s.variant == ColorStyle.TONAL_SPOT) {
                    return 1.4;
                }
                if (s.variant == ColorStyle.EXPRESSIVE) {
                    return Hct.isYellow(s.neutralPalette.getHue()) ? 1.6 : 1.3;
                }
                if (s.variant == ColorStyle.VIBRANT) {
                    return 1.15;
                }
            }
            return 1.0;
        }).build();
        return super.surfaceContainer().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor surfaceContainerHigh() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("surface_container_high").setPalette(s -> s.neutralPalette).setTone(s -> {
            if (s.platform == TargetPlatform.PHONE) {
                if (s.isDark) {
                    return 12.0;
                }
                if (Hct.isYellow(s.neutralPalette.getHue())) {
                    return 94.0;
                }
                if (s.variant == ColorStyle.VIBRANT) {
                    return 90.0;
                }
                return 92.0;
            }
            return 25.0;
        }).setIsBackground(true).setChromaMultiplier(s -> {
            if (s.platform == TargetPlatform.PHONE) {
                if (s.variant == ColorStyle.NEUTRAL) {
                    return 1.9;
                }
                if (s.variant == ColorStyle.TONAL_SPOT) {
                    return 1.5;
                }
                if (s.variant == ColorStyle.EXPRESSIVE) {
                    return Hct.isYellow(s.neutralPalette.getHue()) ? 1.95 : 1.45;
                }
                if (s.variant == ColorStyle.VIBRANT) {
                    return 1.22;
                }
            }
            return 1.0;
        }).build();
        return super.surfaceContainerHigh().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor surfaceContainerHighest() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("surface_container_highest").setPalette(s -> s.neutralPalette).setTone(s -> {
            if (s.isDark) {
                return 15.0;
            }
            if (Hct.isYellow(s.neutralPalette.getHue())) {
                return 92.0;
            }
            if (s.variant == ColorStyle.VIBRANT) {
                return 88.0;
            }
            return 90.0;
        }).setIsBackground(true).setChromaMultiplier(s -> {
            if (s.variant == ColorStyle.NEUTRAL) {
                return 2.2;
            }
            if (s.variant == ColorStyle.TONAL_SPOT) {
                return 1.7;
            }
            if (s.variant == ColorStyle.EXPRESSIVE) {
                return Hct.isYellow(s.neutralPalette.getHue()) ? 2.3 : 1.6;
            }
            if (s.variant == ColorStyle.VIBRANT) {
                return 1.29;
            }
            return 1.0;
        }).build();
        return super.surfaceContainerHighest().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor onSurface() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("on_surface").setPalette(s -> s.neutralPalette).setTone(s -> {
            if (s.variant == ColorStyle.VIBRANT) {
                return ColorSpec2025.tMaxC(s.neutralPalette, 0.0, 100.0, 1.1);
            }
            return DynamicColor.getInitialToneFromBackground(scheme -> {
                if (scheme.platform == TargetPlatform.PHONE) {
                    return scheme.isDark ? this.surfaceBright() : this.surfaceDim();
                }
                return this.surfaceContainerHigh();
            }).apply((DynamicScheme)s);
        }).setChromaMultiplier(s -> {
            if (s.platform == TargetPlatform.PHONE) {
                if (s.variant == ColorStyle.NEUTRAL) {
                    return 2.2;
                }
                if (s.variant == ColorStyle.TONAL_SPOT) {
                    return 1.7;
                }
                if (s.variant == ColorStyle.EXPRESSIVE) {
                    return Hct.isYellow(s.neutralPalette.getHue()) ? (s.isDark ? 3.0 : 2.3) : 1.6;
                }
            }
            return 1.0;
        }).setBackground(s -> {
            if (s.platform == TargetPlatform.PHONE) {
                return s.isDark ? this.surfaceBright() : this.surfaceDim();
            }
            return this.surfaceContainerHigh();
        }).setContrastCurve(s -> s.isDark && s.platform == TargetPlatform.PHONE ? ColorSpec2025.getContrastCurve(11.0) : ColorSpec2025.getContrastCurve(9.0)).build();
        return super.onSurface().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor surfaceVariant() {
        DynamicColor color2025 = this.surfaceContainerHighest().toBuilder().setName("surface_variant").build();
        return super.surfaceVariant().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor onSurfaceVariant() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("on_surface_variant").setPalette(s -> s.neutralPalette).setChromaMultiplier(s -> {
            if (s.platform == TargetPlatform.PHONE) {
                if (s.variant == ColorStyle.NEUTRAL) {
                    return 2.2;
                }
                if (s.variant == ColorStyle.TONAL_SPOT) {
                    return 1.7;
                }
                if (s.variant == ColorStyle.EXPRESSIVE) {
                    return Hct.isYellow(s.neutralPalette.getHue()) ? (s.isDark ? 3.0 : 2.3) : 1.6;
                }
            }
            return 1.0;
        }).setBackground(s -> {
            if (s.platform == TargetPlatform.PHONE) {
                return s.isDark ? this.surfaceBright() : this.surfaceDim();
            }
            return this.surfaceContainerHigh();
        }).setContrastCurve(s -> s.platform == TargetPlatform.PHONE ? (s.isDark ? ColorSpec2025.getContrastCurve(6.0) : ColorSpec2025.getContrastCurve(4.5)) : ColorSpec2025.getContrastCurve(7.0)).build();
        return super.onSurfaceVariant().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor inverseSurface() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("inverse_surface").setPalette(s -> s.neutralPalette).setTone(s -> s.isDark ? 98.0 : 4.0).setIsBackground(true).build();
        return super.inverseSurface().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor inverseOnSurface() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("inverse_on_surface").setPalette(s -> s.neutralPalette).setBackground(s -> this.inverseSurface()).setContrastCurve(s -> ColorSpec2025.getContrastCurve(7.0)).build();
        return super.inverseOnSurface().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor outline() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("outline").setPalette(s -> s.neutralPalette).setChromaMultiplier(s -> {
            if (s.platform == TargetPlatform.PHONE) {
                if (s.variant == ColorStyle.NEUTRAL) {
                    return 2.2;
                }
                if (s.variant == ColorStyle.TONAL_SPOT) {
                    return 1.7;
                }
                if (s.variant == ColorStyle.EXPRESSIVE) {
                    return Hct.isYellow(s.neutralPalette.getHue()) ? (s.isDark ? 3.0 : 2.3) : 1.6;
                }
            }
            return 1.0;
        }).setBackground(s -> {
            if (s.platform == TargetPlatform.PHONE) {
                return s.isDark ? this.surfaceBright() : this.surfaceDim();
            }
            return this.surfaceContainerHigh();
        }).setContrastCurve(s -> s.platform == TargetPlatform.PHONE ? ColorSpec2025.getContrastCurve(3.0) : ColorSpec2025.getContrastCurve(4.5)).build();
        return super.outline().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor outlineVariant() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("outline_variant").setPalette(s -> s.neutralPalette).setChromaMultiplier(s -> {
            if (s.platform == TargetPlatform.PHONE) {
                if (s.variant == ColorStyle.NEUTRAL) {
                    return 2.2;
                }
                if (s.variant == ColorStyle.TONAL_SPOT) {
                    return 1.7;
                }
                if (s.variant == ColorStyle.EXPRESSIVE) {
                    return Hct.isYellow(s.neutralPalette.getHue()) ? (s.isDark ? 3.0 : 2.3) : 1.6;
                }
            }
            return 1.0;
        }).setBackground(s -> {
            if (s.platform == TargetPlatform.PHONE) {
                return s.isDark ? this.surfaceBright() : this.surfaceDim();
            }
            return this.surfaceContainerHigh();
        }).setContrastCurve(s -> s.platform == TargetPlatform.PHONE ? ColorSpec2025.getContrastCurve(1.5) : ColorSpec2025.getContrastCurve(3.0)).build();
        return super.outlineVariant().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor surfaceTint() {
        DynamicColor color2025 = this.primary().toBuilder().setName("surface_tint").build();
        return super.surfaceTint().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor primary() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("primary").setPalette(s -> s.primaryPalette).setTone(s -> {
            if (s.variant == ColorStyle.NEUTRAL) {
                if (s.platform == TargetPlatform.PHONE) {
                    return s.isDark ? 80.0 : 40.0;
                }
                return 90.0;
            }
            if (s.variant == ColorStyle.TONAL_SPOT) {
                if (s.platform == TargetPlatform.PHONE) {
                    if (s.isDark) {
                        return 80.0;
                    }
                    return ColorSpec2025.tMaxC(s.primaryPalette);
                }
                return ColorSpec2025.tMaxC(s.primaryPalette, 0.0, 90.0);
            }
            if (s.variant == ColorStyle.EXPRESSIVE) {
                if (s.platform == TargetPlatform.PHONE) {
                    return ColorSpec2025.tMaxC(s.primaryPalette, 0.0, Hct.isYellow(s.primaryPalette.getHue()) ? 25.0 : (Hct.isCyan(s.primaryPalette.getHue()) ? 88.0 : 98.0));
                }
                return ColorSpec2025.tMaxC(s.primaryPalette);
            }
            if (s.platform == TargetPlatform.PHONE) {
                return ColorSpec2025.tMaxC(s.primaryPalette, 0.0, Hct.isCyan(s.primaryPalette.getHue()) ? 88.0 : 98.0);
            }
            return ColorSpec2025.tMaxC(s.primaryPalette);
        }).setIsBackground(true).setBackground(s -> {
            if (s.platform == TargetPlatform.PHONE) {
                return s.isDark ? this.surfaceBright() : this.surfaceDim();
            }
            return this.surfaceContainerHigh();
        }).setContrastCurve(s -> s.platform == TargetPlatform.PHONE ? ColorSpec2025.getContrastCurve(4.5) : ColorSpec2025.getContrastCurve(7.0)).setToneDeltaPair(s -> s.platform == TargetPlatform.PHONE ? new ToneDeltaPair(this.primaryContainer(), this.primary(), 5.0, TonePolarity.RELATIVE_LIGHTER, ToneDeltaPair.DeltaConstraint.FARTHER) : null).build();
        return super.primary().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor primaryDim() {
        return new DynamicColor.Builder().setName("primary_dim").setPalette(s -> s.primaryPalette).setTone(s -> {
            if (s.variant == ColorStyle.NEUTRAL) {
                return 85.0;
            }
            if (s.variant == ColorStyle.TONAL_SPOT) {
                return ColorSpec2025.tMaxC(s.primaryPalette, 0.0, 90.0);
            }
            return ColorSpec2025.tMaxC(s.primaryPalette);
        }).setIsBackground(true).setBackground(s -> this.surfaceContainerHigh()).setContrastCurve(s -> ColorSpec2025.getContrastCurve(4.5)).setToneDeltaPair(s -> new ToneDeltaPair(this.primaryDim(), this.primary(), 5.0, TonePolarity.DARKER, ToneDeltaPair.DeltaConstraint.FARTHER)).build();
    }

    @Override
    @NotNull
    public DynamicColor onPrimary() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("on_primary").setPalette(s -> s.primaryPalette).setBackground(s -> s.platform == TargetPlatform.PHONE ? this.primary() : this.primaryDim()).setContrastCurve(s -> s.platform == TargetPlatform.PHONE ? ColorSpec2025.getContrastCurve(6.0) : ColorSpec2025.getContrastCurve(7.0)).build();
        return super.onPrimary().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor primaryContainer() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("primary_container").setPalette(s -> s.primaryPalette).setTone(s -> {
            if (s.platform == TargetPlatform.WATCH) {
                return 30.0;
            }
            if (s.variant == ColorStyle.NEUTRAL) {
                return s.isDark ? 30.0 : 90.0;
            }
            if (s.variant == ColorStyle.TONAL_SPOT) {
                return s.isDark ? ColorSpec2025.tMinC(s.primaryPalette, 35.0, 93.0) : ColorSpec2025.tMaxC(s.primaryPalette, 0.0, 90.0);
            }
            if (s.variant == ColorStyle.EXPRESSIVE) {
                return s.isDark ? ColorSpec2025.tMaxC(s.primaryPalette, 30.0, 93.0) : ColorSpec2025.tMaxC(s.primaryPalette, 78.0, Hct.isCyan(s.primaryPalette.getHue()) ? 88.0 : 90.0);
            }
            return s.isDark ? ColorSpec2025.tMinC(s.primaryPalette, 66.0, 93.0) : ColorSpec2025.tMaxC(s.primaryPalette, 66.0, Hct.isCyan(s.primaryPalette.getHue()) ? 88.0 : 93.0);
        }).setIsBackground(true).setBackground(s -> {
            if (s.platform == TargetPlatform.PHONE) {
                return s.isDark ? this.surfaceBright() : this.surfaceDim();
            }
            return null;
        }).setToneDeltaPair(s -> s.platform == TargetPlatform.WATCH ? new ToneDeltaPair(this.primaryContainer(), this.primaryDim(), 10.0, TonePolarity.DARKER, ToneDeltaPair.DeltaConstraint.FARTHER) : null).setContrastCurve(s -> s.platform == TargetPlatform.PHONE && s.contrastLevel > 0.0 ? ColorSpec2025.getContrastCurve(1.5) : null).build();
        return super.primaryContainer().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor onPrimaryContainer() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("on_primary_container").setPalette(s -> s.primaryPalette).setBackground(s -> this.primaryContainer()).setContrastCurve(s -> s.platform == TargetPlatform.PHONE ? ColorSpec2025.getContrastCurve(6.0) : ColorSpec2025.getContrastCurve(7.0)).build();
        return super.onPrimaryContainer().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor inversePrimary() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("inverse_primary").setPalette(s -> s.primaryPalette).setTone(s -> ColorSpec2025.tMaxC(s.primaryPalette)).setBackground(s -> this.inverseSurface()).setContrastCurve(s -> s.platform == TargetPlatform.PHONE ? ColorSpec2025.getContrastCurve(6.0) : ColorSpec2025.getContrastCurve(7.0)).build();
        return super.inversePrimary().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor secondary() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("secondary").setPalette(s -> s.secondaryPalette).setTone(s -> {
            if (s.platform == TargetPlatform.WATCH) {
                return s.variant == ColorStyle.NEUTRAL ? 90.0 : ColorSpec2025.tMaxC(s.secondaryPalette, 0.0, 90.0);
            }
            if (s.variant == ColorStyle.NEUTRAL) {
                return s.isDark ? ColorSpec2025.tMinC(s.secondaryPalette, 0.0, 98.0) : ColorSpec2025.tMaxC(s.secondaryPalette);
            }
            if (s.variant == ColorStyle.VIBRANT) {
                return ColorSpec2025.tMaxC(s.secondaryPalette, 0.0, s.isDark ? 90.0 : 98.0);
            }
            return s.isDark ? 80.0 : ColorSpec2025.tMaxC(s.secondaryPalette);
        }).setIsBackground(true).setBackground(s -> {
            if (s.platform == TargetPlatform.PHONE) {
                return s.isDark ? this.surfaceBright() : this.surfaceDim();
            }
            return this.surfaceContainerHigh();
        }).setContrastCurve(s -> s.platform == TargetPlatform.PHONE ? ColorSpec2025.getContrastCurve(4.5) : ColorSpec2025.getContrastCurve(7.0)).setToneDeltaPair(s -> s.platform == TargetPlatform.PHONE ? new ToneDeltaPair(this.secondaryContainer(), this.secondary(), 5.0, TonePolarity.RELATIVE_LIGHTER, ToneDeltaPair.DeltaConstraint.FARTHER) : null).build();
        return super.secondary().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @Nullable
    public DynamicColor secondaryDim() {
        return new DynamicColor.Builder().setName("secondary_dim").setPalette(s -> s.secondaryPalette).setTone(s -> {
            if (s.variant == ColorStyle.NEUTRAL) {
                return 85.0;
            }
            return ColorSpec2025.tMaxC(s.secondaryPalette, 0.0, 90.0);
        }).setIsBackground(true).setBackground(s -> this.surfaceContainerHigh()).setContrastCurve(s -> ColorSpec2025.getContrastCurve(4.5)).setToneDeltaPair(s -> new ToneDeltaPair(this.secondaryDim(), this.secondary(), 5.0, TonePolarity.DARKER, ToneDeltaPair.DeltaConstraint.FARTHER)).build();
    }

    @Override
    @NotNull
    public DynamicColor onSecondary() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("on_secondary").setPalette(s -> s.secondaryPalette).setBackground(s -> s.platform == TargetPlatform.PHONE ? this.secondary() : this.secondaryDim()).setContrastCurve(s -> s.platform == TargetPlatform.PHONE ? ColorSpec2025.getContrastCurve(6.0) : ColorSpec2025.getContrastCurve(7.0)).build();
        return super.onSecondary().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor secondaryContainer() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("secondary_container").setPalette(s -> s.secondaryPalette).setTone(s -> {
            if (s.platform == TargetPlatform.WATCH) {
                return 30.0;
            }
            if (s.variant == ColorStyle.VIBRANT) {
                return s.isDark ? ColorSpec2025.tMinC(s.secondaryPalette, 30.0, 40.0) : ColorSpec2025.tMaxC(s.secondaryPalette, 84.0, 90.0);
            }
            if (s.variant == ColorStyle.EXPRESSIVE) {
                return s.isDark ? 15.0 : ColorSpec2025.tMaxC(s.secondaryPalette, 90.0, 95.0);
            }
            return s.isDark ? 25.0 : 90.0;
        }).setIsBackground(true).setBackground(s -> {
            if (s.platform == TargetPlatform.PHONE) {
                return s.isDark ? this.surfaceBright() : this.surfaceDim();
            }
            return null;
        }).setToneDeltaPair(s -> s.platform == TargetPlatform.WATCH ? new ToneDeltaPair(this.secondaryContainer(), this.secondaryDim(), 10.0, TonePolarity.DARKER, ToneDeltaPair.DeltaConstraint.FARTHER) : null).setContrastCurve(s -> s.platform == TargetPlatform.PHONE && s.contrastLevel > 0.0 ? ColorSpec2025.getContrastCurve(1.5) : null).build();
        return super.secondaryContainer().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor onSecondaryContainer() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("on_secondary_container").setPalette(s -> s.secondaryPalette).setBackground(s -> this.secondaryContainer()).setContrastCurve(s -> s.platform == TargetPlatform.PHONE ? ColorSpec2025.getContrastCurve(6.0) : ColorSpec2025.getContrastCurve(7.0)).build();
        return super.onSecondaryContainer().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor tertiary() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("tertiary").setPalette(s -> s.tertiaryPalette).setTone(s -> {
            if (s.platform == TargetPlatform.WATCH) {
                return s.variant == ColorStyle.TONAL_SPOT ? ColorSpec2025.tMaxC(s.tertiaryPalette, 0.0, 90.0) : ColorSpec2025.tMaxC(s.tertiaryPalette);
            }
            if (s.variant == ColorStyle.EXPRESSIVE || s.variant == ColorStyle.VIBRANT) {
                return ColorSpec2025.tMaxC(s.tertiaryPalette, 0.0, Hct.isCyan(s.tertiaryPalette.getHue()) ? 88.0 : (double)(s.isDark ? 98 : 100));
            }
            return s.isDark ? ColorSpec2025.tMaxC(s.tertiaryPalette, 0.0, 98.0) : ColorSpec2025.tMaxC(s.tertiaryPalette);
        }).setIsBackground(true).setBackground(s -> {
            if (s.platform == TargetPlatform.PHONE) {
                return s.isDark ? this.surfaceBright() : this.surfaceDim();
            }
            return this.surfaceContainerHigh();
        }).setContrastCurve(s -> s.platform == TargetPlatform.PHONE ? ColorSpec2025.getContrastCurve(4.5) : ColorSpec2025.getContrastCurve(7.0)).setToneDeltaPair(s -> s.platform == TargetPlatform.PHONE ? new ToneDeltaPair(this.tertiaryContainer(), this.tertiary(), 5.0, TonePolarity.RELATIVE_LIGHTER, ToneDeltaPair.DeltaConstraint.FARTHER) : null).build();
        return super.tertiary().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @Nullable
    public DynamicColor tertiaryDim() {
        return new DynamicColor.Builder().setName("tertiary_dim").setPalette(s -> s.tertiaryPalette).setTone(s -> {
            if (s.variant == ColorStyle.TONAL_SPOT) {
                return ColorSpec2025.tMaxC(s.tertiaryPalette, 0.0, 90.0);
            }
            return ColorSpec2025.tMaxC(s.tertiaryPalette);
        }).setIsBackground(true).setBackground(s -> this.surfaceContainerHigh()).setContrastCurve(s -> ColorSpec2025.getContrastCurve(4.5)).setToneDeltaPair(s -> new ToneDeltaPair(this.tertiaryDim(), this.tertiary(), 5.0, TonePolarity.DARKER, ToneDeltaPair.DeltaConstraint.FARTHER)).build();
    }

    @Override
    @NotNull
    public DynamicColor onTertiary() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("on_tertiary").setPalette(s -> s.tertiaryPalette).setBackground(s -> s.platform == TargetPlatform.PHONE ? this.tertiary() : this.tertiaryDim()).setContrastCurve(s -> s.platform == TargetPlatform.PHONE ? ColorSpec2025.getContrastCurve(6.0) : ColorSpec2025.getContrastCurve(7.0)).build();
        return super.onTertiary().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor tertiaryContainer() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("tertiary_container").setPalette(s -> s.tertiaryPalette).setTone(s -> {
            if (s.platform == TargetPlatform.WATCH) {
                return s.variant == ColorStyle.TONAL_SPOT ? ColorSpec2025.tMaxC(s.tertiaryPalette, 0.0, 90.0) : ColorSpec2025.tMaxC(s.tertiaryPalette);
            }
            if (s.variant == ColorStyle.NEUTRAL) {
                return s.isDark ? ColorSpec2025.tMaxC(s.tertiaryPalette, 0.0, 93.0) : ColorSpec2025.tMaxC(s.tertiaryPalette, 0.0, 96.0);
            }
            if (s.variant == ColorStyle.TONAL_SPOT) {
                return ColorSpec2025.tMaxC(s.tertiaryPalette, 0.0, s.isDark ? 93.0 : 100.0);
            }
            if (s.variant == ColorStyle.EXPRESSIVE) {
                return ColorSpec2025.tMaxC(s.tertiaryPalette, 75.0, Hct.isCyan(s.tertiaryPalette.getHue()) ? 88.0 : (double)(s.isDark ? 93 : 100));
            }
            return s.isDark ? ColorSpec2025.tMaxC(s.tertiaryPalette, 0.0, 93.0) : ColorSpec2025.tMaxC(s.tertiaryPalette, 72.0, 100.0);
        }).setIsBackground(true).setBackground(s -> {
            if (s.platform == TargetPlatform.PHONE) {
                return s.isDark ? this.surfaceBright() : this.surfaceDim();
            }
            return null;
        }).setToneDeltaPair(s -> s.platform == TargetPlatform.WATCH ? new ToneDeltaPair(this.tertiaryContainer(), this.tertiaryDim(), 10.0, TonePolarity.DARKER, ToneDeltaPair.DeltaConstraint.FARTHER) : null).setContrastCurve(s -> s.platform == TargetPlatform.PHONE && s.contrastLevel > 0.0 ? ColorSpec2025.getContrastCurve(1.5) : null).build();
        return super.tertiaryContainer().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor onTertiaryContainer() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("on_tertiary_container").setPalette(s -> s.tertiaryPalette).setBackground(s -> this.tertiaryContainer()).setContrastCurve(s -> s.platform == TargetPlatform.PHONE ? ColorSpec2025.getContrastCurve(6.0) : ColorSpec2025.getContrastCurve(7.0)).build();
        return super.onTertiaryContainer().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor error() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("error").setPalette(s -> s.errorPalette).setTone(s -> {
            if (s.platform == TargetPlatform.PHONE) {
                return s.isDark ? ColorSpec2025.tMinC(s.errorPalette, 0.0, 98.0) : ColorSpec2025.tMaxC(s.errorPalette);
            }
            return ColorSpec2025.tMinC(s.errorPalette);
        }).setIsBackground(true).setBackground(s -> {
            if (s.platform == TargetPlatform.PHONE) {
                return s.isDark ? this.surfaceBright() : this.surfaceDim();
            }
            return this.surfaceContainerHigh();
        }).setContrastCurve(s -> s.platform == TargetPlatform.PHONE ? ColorSpec2025.getContrastCurve(4.5) : ColorSpec2025.getContrastCurve(7.0)).setToneDeltaPair(s -> s.platform == TargetPlatform.PHONE ? new ToneDeltaPair(this.errorContainer(), this.error(), 5.0, TonePolarity.RELATIVE_LIGHTER, ToneDeltaPair.DeltaConstraint.FARTHER) : null).build();
        return super.error().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @Nullable
    public DynamicColor errorDim() {
        return new DynamicColor.Builder().setName("error_dim").setPalette(s -> s.errorPalette).setTone(s -> ColorSpec2025.tMinC(s.errorPalette)).setIsBackground(true).setBackground(s -> this.surfaceContainerHigh()).setContrastCurve(s -> ColorSpec2025.getContrastCurve(4.5)).setToneDeltaPair(s -> new ToneDeltaPair(this.errorDim(), this.error(), 5.0, TonePolarity.DARKER, ToneDeltaPair.DeltaConstraint.FARTHER)).build();
    }

    @Override
    @NotNull
    public DynamicColor onError() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("on_error").setPalette(s -> s.errorPalette).setBackground(s -> s.platform == TargetPlatform.PHONE ? this.error() : this.errorDim()).setContrastCurve(s -> s.platform == TargetPlatform.PHONE ? ColorSpec2025.getContrastCurve(6.0) : ColorSpec2025.getContrastCurve(7.0)).build();
        return super.onError().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor errorContainer() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("error_container").setPalette(s -> s.errorPalette).setTone(s -> {
            if (s.platform == TargetPlatform.WATCH) {
                return 30.0;
            }
            return s.isDark ? ColorSpec2025.tMinC(s.errorPalette, 30.0, 93.0) : ColorSpec2025.tMaxC(s.errorPalette, 0.0, 90.0);
        }).setIsBackground(true).setBackground(s -> {
            if (s.platform == TargetPlatform.PHONE) {
                return s.isDark ? this.surfaceBright() : this.surfaceDim();
            }
            return null;
        }).setToneDeltaPair(s -> s.platform == TargetPlatform.WATCH ? new ToneDeltaPair(this.errorContainer(), this.errorDim(), 10.0, TonePolarity.DARKER, ToneDeltaPair.DeltaConstraint.FARTHER) : null).setContrastCurve(s -> s.platform == TargetPlatform.PHONE && s.contrastLevel > 0.0 ? ColorSpec2025.getContrastCurve(1.5) : null).build();
        return super.errorContainer().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor onErrorContainer() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("on_error_container").setPalette(s -> s.errorPalette).setBackground(s -> this.errorContainer()).setContrastCurve(s -> s.platform == TargetPlatform.PHONE ? ColorSpec2025.getContrastCurve(4.5) : ColorSpec2025.getContrastCurve(7.0)).build();
        return super.onErrorContainer().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor primaryFixed() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("primary_fixed").setPalette(s -> s.primaryPalette).setTone(s -> {
            DynamicScheme tempS = DynamicScheme.from(s, false, 0.0);
            return this.primaryContainer().getTone(tempS);
        }).setIsBackground(true).setBackground(s -> {
            if (s.platform == TargetPlatform.PHONE) {
                return s.isDark ? this.surfaceBright() : this.surfaceDim();
            }
            return null;
        }).setContrastCurve(s -> s.platform == TargetPlatform.PHONE && s.contrastLevel > 0.0 ? ColorSpec2025.getContrastCurve(1.5) : null).build();
        return super.primaryFixed().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor primaryFixedDim() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("primary_fixed_dim").setPalette(s -> s.primaryPalette).setTone(s -> this.primaryFixed().getTone((DynamicScheme)s)).setIsBackground(true).setToneDeltaPair(s -> new ToneDeltaPair(this.primaryFixedDim(), this.primaryFixed(), 5.0, TonePolarity.DARKER, ToneDeltaPair.DeltaConstraint.EXACT)).build();
        return super.primaryFixedDim().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor onPrimaryFixed() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("on_primary_fixed").setPalette(s -> s.primaryPalette).setBackground(s -> this.primaryFixedDim()).setContrastCurve(s -> ColorSpec2025.getContrastCurve(7.0)).build();
        return super.onPrimaryFixed().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor onPrimaryFixedVariant() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("on_primary_fixed_variant").setPalette(s -> s.primaryPalette).setBackground(s -> this.primaryFixedDim()).setContrastCurve(s -> ColorSpec2025.getContrastCurve(4.5)).build();
        return super.onPrimaryFixedVariant().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor secondaryFixed() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("secondary_fixed").setPalette(s -> s.secondaryPalette).setTone(s -> {
            DynamicScheme tempS = DynamicScheme.from(s, false, 0.0);
            return this.secondaryContainer().getTone(tempS);
        }).setIsBackground(true).setBackground(s -> {
            if (s.platform == TargetPlatform.PHONE) {
                return s.isDark ? this.surfaceBright() : this.surfaceDim();
            }
            return null;
        }).setContrastCurve(s -> s.platform == TargetPlatform.PHONE && s.contrastLevel > 0.0 ? ColorSpec2025.getContrastCurve(1.5) : null).build();
        return super.secondaryFixed().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor secondaryFixedDim() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("secondary_fixed_dim").setPalette(s -> s.secondaryPalette).setTone(s -> this.secondaryFixed().getTone((DynamicScheme)s)).setIsBackground(true).setToneDeltaPair(s -> new ToneDeltaPair(this.secondaryFixedDim(), this.secondaryFixed(), 5.0, TonePolarity.DARKER, ToneDeltaPair.DeltaConstraint.EXACT)).build();
        return super.secondaryFixedDim().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor onSecondaryFixed() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("on_secondary_fixed").setPalette(s -> s.secondaryPalette).setBackground(s -> this.secondaryFixedDim()).setContrastCurve(s -> ColorSpec2025.getContrastCurve(7.0)).build();
        return super.onSecondaryFixed().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor onSecondaryFixedVariant() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("on_secondary_fixed_variant").setPalette(s -> s.secondaryPalette).setBackground(s -> this.secondaryFixedDim()).setContrastCurve(s -> ColorSpec2025.getContrastCurve(4.5)).build();
        return super.onSecondaryFixedVariant().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor tertiaryFixed() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("tertiary_fixed").setPalette(s -> s.tertiaryPalette).setTone(s -> {
            DynamicScheme tempS = DynamicScheme.from(s, false, 0.0);
            return this.tertiaryContainer().getTone(tempS);
        }).setIsBackground(true).setBackground(s -> {
            if (s.platform == TargetPlatform.PHONE) {
                return s.isDark ? this.surfaceBright() : this.surfaceDim();
            }
            return null;
        }).setContrastCurve(s -> s.platform == TargetPlatform.PHONE && s.contrastLevel > 0.0 ? ColorSpec2025.getContrastCurve(1.5) : null).build();
        return super.tertiaryFixed().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor tertiaryFixedDim() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("tertiary_fixed_dim").setPalette(s -> s.tertiaryPalette).setTone(s -> this.tertiaryFixed().getTone((DynamicScheme)s)).setIsBackground(true).setToneDeltaPair(s -> new ToneDeltaPair(this.tertiaryFixedDim(), this.tertiaryFixed(), 5.0, TonePolarity.DARKER, ToneDeltaPair.DeltaConstraint.EXACT)).build();
        return super.tertiaryFixedDim().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor onTertiaryFixed() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("on_tertiary_fixed").setPalette(s -> s.tertiaryPalette).setBackground(s -> this.tertiaryFixedDim()).setContrastCurve(s -> ColorSpec2025.getContrastCurve(7.0)).build();
        return super.onTertiaryFixed().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor onTertiaryFixedVariant() {
        DynamicColor color2025 = new DynamicColor.Builder().setName("on_tertiary_fixed_variant").setPalette(s -> s.tertiaryPalette).setBackground(s -> this.tertiaryFixedDim()).setContrastCurve(s -> ColorSpec2025.getContrastCurve(4.5)).build();
        return super.onTertiaryFixedVariant().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor controlActivated() {
        DynamicColor color2025 = this.primaryContainer().toBuilder().setName("control_activated").build();
        return super.controlActivated().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor controlNormal() {
        DynamicColor color2025 = this.onSurfaceVariant().toBuilder().setName("control_normal").build();
        return super.controlNormal().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    @Override
    @NotNull
    public DynamicColor textPrimaryInverse() {
        DynamicColor color2025 = this.inverseOnSurface().toBuilder().setName("text_primary_inverse").build();
        return super.textPrimaryInverse().toBuilder().extendSpecVersion(ColorSpecVersion.SPEC_2025, color2025).build();
    }

    private static double findBestToneForChroma(double hue, double chroma, double tone, boolean byDecreasingTone) {
        double answer = tone;
        Hct bestCandidate = Hct.from(hue, chroma, answer);
        while (bestCandidate.getChroma() < chroma && !(tone < 0.0) && !(tone > 100.0)) {
            Hct newCandidate = Hct.from(hue, chroma, tone += byDecreasingTone ? -1.0 : 1.0);
            if (!(bestCandidate.getChroma() < newCandidate.getChroma())) continue;
            bestCandidate = newCandidate;
            answer = tone;
        }
        return answer;
    }

    private static double tMaxC(TonalPalette palette) {
        return ColorSpec2025.tMaxC(palette, 0.0, 100.0);
    }

    private static double tMaxC(TonalPalette palette, double lowerBound, double upperBound) {
        return ColorSpec2025.tMaxC(palette, lowerBound, upperBound, 1.0);
    }

    private static double tMaxC(TonalPalette palette, double lowerBound, double upperBound, double chromaMultiplier) {
        double answer = ColorSpec2025.findBestToneForChroma(palette.getHue(), palette.getChroma() * chromaMultiplier, 100.0, true);
        return MathUtils.clampDouble(lowerBound, upperBound, answer);
    }

    private static double tMinC(TonalPalette palette) {
        return ColorSpec2025.tMinC(palette, 0.0, 100.0);
    }

    private static double tMinC(TonalPalette palette, double lowerBound, double upperBound) {
        double answer = ColorSpec2025.findBestToneForChroma(palette.getHue(), palette.getChroma(), 0.0, false);
        return MathUtils.clampDouble(lowerBound, upperBound, answer);
    }

    private static ContrastCurve getContrastCurve(double defaultContrast) {
        if (defaultContrast == 1.5) {
            return new ContrastCurve(1.5, 1.5, 3.0, 4.5);
        }
        if (defaultContrast == 3.0) {
            return new ContrastCurve(3.0, 3.0, 4.5, 7.0);
        }
        if (defaultContrast == 4.5) {
            return new ContrastCurve(4.5, 4.5, 7.0, 11.0);
        }
        if (defaultContrast == 6.0) {
            return new ContrastCurve(6.0, 6.0, 7.0, 11.0);
        }
        if (defaultContrast == 7.0) {
            return new ContrastCurve(7.0, 7.0, 11.0, 21.0);
        }
        if (defaultContrast == 9.0) {
            return new ContrastCurve(9.0, 9.0, 11.0, 21.0);
        }
        if (defaultContrast == 11.0) {
            return new ContrastCurve(11.0, 11.0, 21.0, 21.0);
        }
        if (defaultContrast == 21.0) {
            return new ContrastCurve(21.0, 21.0, 21.0, 21.0);
        }
        return new ContrastCurve(defaultContrast, defaultContrast, 7.0, 21.0);
    }

    @Override
    @NotNull
    public Hct getHct(DynamicScheme scheme, DynamicColor color) {
        TonalPalette palette = color.palette.apply(scheme);
        double tone = this.getTone(scheme, color);
        double hue = palette.getHue();
        double chromaMultiplier = color.chromaMultiplier == null ? 1.0 : color.chromaMultiplier.apply(scheme);
        double chroma = palette.getChroma() * chromaMultiplier;
        return Hct.from(hue, chroma, tone);
    }

    @Override
    public double getTone(DynamicScheme scheme, DynamicColor color) {
        boolean prefersLight;
        ToneDeltaPair toneDeltaPair;
        ToneDeltaPair toneDeltaPair2 = toneDeltaPair = color.toneDeltaPair == null ? null : color.toneDeltaPair.apply(scheme);
        if (toneDeltaPair != null) {
            DynamicColor roleA = toneDeltaPair.getRoleA();
            DynamicColor roleB = toneDeltaPair.getRoleB();
            TonePolarity polarity = toneDeltaPair.getPolarity();
            ToneDeltaPair.DeltaConstraint constraint = toneDeltaPair.getConstraint();
            double absoluteDelta = polarity == TonePolarity.DARKER || polarity == TonePolarity.RELATIVE_LIGHTER && scheme.isDark || polarity == TonePolarity.RELATIVE_DARKER && !scheme.isDark ? -toneDeltaPair.getDelta() : toneDeltaPair.getDelta();
            boolean amRoleA = color.name.equals(roleA.name);
            DynamicColor selfRole = amRoleA ? roleA : roleB;
            DynamicColor referenceRole = amRoleA ? roleB : roleA;
            double selfTone = selfRole.tone.apply(scheme);
            double referenceTone = referenceRole.getTone(scheme);
            double relativeDelta = absoluteDelta * (double)(amRoleA ? 1 : -1);
            switch (constraint) {
                case EXACT: {
                    selfTone = MathUtils.clampDouble(0.0, 100.0, referenceTone + relativeDelta);
                    break;
                }
                case NEARER: {
                    if (relativeDelta > 0.0) {
                        selfTone = MathUtils.clampDouble(0.0, 100.0, MathUtils.clampDouble(referenceTone, referenceTone + relativeDelta, selfTone));
                        break;
                    }
                    selfTone = MathUtils.clampDouble(0.0, 100.0, MathUtils.clampDouble(referenceTone + relativeDelta, referenceTone, selfTone));
                    break;
                }
                case FARTHER: {
                    selfTone = relativeDelta > 0.0 ? MathUtils.clampDouble(referenceTone + relativeDelta, 100.0, selfTone) : MathUtils.clampDouble(0.0, referenceTone + relativeDelta, selfTone);
                }
            }
            if (color.background != null && color.contrastCurve != null) {
                DynamicColor background = color.background.apply(scheme);
                ContrastCurve contrastCurve = color.contrastCurve.apply(scheme);
                if (background != null && contrastCurve != null) {
                    double bgTone = background.getTone(scheme);
                    double selfContrast = contrastCurve.get(scheme.contrastLevel);
                    double d = selfTone = Contrast.ratioOfTones(bgTone, selfTone) >= selfContrast && scheme.contrastLevel >= 0.0 ? selfTone : DynamicColor.foregroundTone(bgTone, selfContrast);
                }
            }
            if (color.isBackground && !color.name.endsWith("_fixed_dim")) {
                selfTone = selfTone >= 57.0 ? MathUtils.clampDouble(65.0, 100.0, selfTone) : MathUtils.clampDouble(0.0, 49.0, selfTone);
            }
            return selfTone;
        }
        double answer = color.tone.apply(scheme);
        if (color.background == null || color.background.apply(scheme) == null || color.contrastCurve == null || color.contrastCurve.apply(scheme) == null) {
            return answer;
        }
        double bgTone = color.background.apply(scheme).getTone(scheme);
        double desiredRatio = color.contrastCurve.apply(scheme).get(scheme.contrastLevel);
        double d = answer = Contrast.ratioOfTones(bgTone, answer) >= desiredRatio && scheme.contrastLevel >= 0.0 ? answer : DynamicColor.foregroundTone(bgTone, desiredRatio);
        if (color.isBackground && !color.name.endsWith("_fixed_dim")) {
            answer = answer >= 57.0 ? MathUtils.clampDouble(65.0, 100.0, answer) : MathUtils.clampDouble(0.0, 49.0, answer);
        }
        if (color.secondBackground == null || color.secondBackground.apply(scheme) == null) {
            return answer;
        }
        double bgTone1 = color.background.apply(scheme).getTone(scheme);
        double bgTone2 = color.secondBackground.apply(scheme).getTone(scheme);
        double upper = Math.max(bgTone1, bgTone2);
        double lower = Math.min(bgTone1, bgTone2);
        if (Contrast.ratioOfTones(upper, answer) >= desiredRatio && Contrast.ratioOfTones(lower, answer) >= desiredRatio) {
            return answer;
        }
        double lightOption = Contrast.lighter(upper, desiredRatio);
        double darkOption = Contrast.darker(lower, desiredRatio);
        ArrayList<Double> availables = new ArrayList<Double>();
        if (lightOption != -1.0) {
            availables.add(lightOption);
        }
        if (darkOption != -1.0) {
            availables.add(darkOption);
        }
        boolean bl = prefersLight = DynamicColor.tonePrefersLightForeground(bgTone1) || DynamicColor.tonePrefersLightForeground(bgTone2);
        if (prefersLight) {
            return lightOption < 0.0 ? 100.0 : lightOption;
        }
        if (availables.size() == 1) {
            return (Double)availables.get(0);
        }
        return darkOption < 0.0 ? 0.0 : darkOption;
    }

    @Override
    @NotNull
    public TonalPalette getPrimaryPalette(ColorStyle variant, Hct sourceColorHct, boolean isDark, TargetPlatform platform, double contrastLevel) {
        switch (variant) {
            case NEUTRAL: {
                return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), platform == TargetPlatform.PHONE ? (double)(Hct.isBlue(sourceColorHct.getHue()) ? 12 : 8) : (double)(Hct.isBlue(sourceColorHct.getHue()) ? 16 : 12));
            }
            case TONAL_SPOT: {
                return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), platform == TargetPlatform.PHONE && isDark ? 26.0 : 32.0);
            }
            case EXPRESSIVE: {
                return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), platform == TargetPlatform.PHONE ? (double)(isDark ? 36 : 48) : 40.0);
            }
            case VIBRANT: {
                return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), platform == TargetPlatform.PHONE ? 74.0 : 56.0);
            }
        }
        return super.getPrimaryPalette(variant, sourceColorHct, isDark, platform, contrastLevel);
    }

    @Override
    @NotNull
    public TonalPalette getSecondaryPalette(ColorStyle variant, Hct sourceColorHct, boolean isDark, TargetPlatform platform, double contrastLevel) {
        switch (variant) {
            case NEUTRAL: {
                return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), platform == TargetPlatform.PHONE ? (double)(Hct.isBlue(sourceColorHct.getHue()) ? 6 : 4) : (double)(Hct.isBlue(sourceColorHct.getHue()) ? 10 : 6));
            }
            case TONAL_SPOT: {
                return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), 16.0);
            }
            case EXPRESSIVE: {
                return TonalPalette.fromHueAndChroma(DynamicScheme.getRotatedHue(sourceColorHct, new double[]{0.0, 105.0, 140.0, 204.0, 253.0, 278.0, 300.0, 333.0, 360.0}, new double[]{-160.0, 155.0, -100.0, 96.0, -96.0, -156.0, -165.0, -160.0}), platform == TargetPlatform.PHONE ? (double)(isDark ? 16 : 24) : 24.0);
            }
            case VIBRANT: {
                return TonalPalette.fromHueAndChroma(DynamicScheme.getRotatedHue(sourceColorHct, new double[]{0.0, 38.0, 105.0, 140.0, 333.0, 360.0}, new double[]{-14.0, 10.0, -14.0, 10.0, -14.0}), platform == TargetPlatform.PHONE ? 56.0 : 36.0);
            }
        }
        return super.getSecondaryPalette(variant, sourceColorHct, isDark, platform, contrastLevel);
    }

    @Override
    @NotNull
    public TonalPalette getTertiaryPalette(ColorStyle variant, Hct sourceColorHct, boolean isDark, TargetPlatform platform, double contrastLevel) {
        switch (variant) {
            case NEUTRAL: {
                return TonalPalette.fromHueAndChroma(DynamicScheme.getRotatedHue(sourceColorHct, new double[]{0.0, 38.0, 105.0, 161.0, 204.0, 278.0, 333.0, 360.0}, new double[]{-32.0, 26.0, 10.0, -39.0, 24.0, -15.0, -32.0}), platform == TargetPlatform.PHONE ? 20.0 : 36.0);
            }
            case TONAL_SPOT: {
                return TonalPalette.fromHueAndChroma(DynamicScheme.getRotatedHue(sourceColorHct, new double[]{0.0, 20.0, 71.0, 161.0, 333.0, 360.0}, new double[]{-40.0, 48.0, -32.0, 40.0, -32.0}), platform == TargetPlatform.PHONE ? 28.0 : 32.0);
            }
            case EXPRESSIVE: {
                return TonalPalette.fromHueAndChroma(DynamicScheme.getRotatedHue(sourceColorHct, new double[]{0.0, 105.0, 140.0, 204.0, 253.0, 278.0, 300.0, 333.0, 360.0}, new double[]{-165.0, 160.0, -105.0, 101.0, -101.0, -160.0, -170.0, -165.0}), 48.0);
            }
            case VIBRANT: {
                return TonalPalette.fromHueAndChroma(DynamicScheme.getRotatedHue(sourceColorHct, new double[]{0.0, 38.0, 71.0, 105.0, 140.0, 161.0, 253.0, 333.0, 360.0}, new double[]{-72.0, 35.0, 24.0, -24.0, 62.0, 50.0, 62.0, -72.0}), 56.0);
            }
        }
        return super.getTertiaryPalette(variant, sourceColorHct, isDark, platform, contrastLevel);
    }

    @Override
    @NotNull
    public TonalPalette getNeutralPalette(ColorStyle variant, Hct sourceColorHct, boolean isDark, TargetPlatform platform, double contrastLevel) {
        switch (variant) {
            case NEUTRAL: {
                return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), platform == TargetPlatform.PHONE ? 1.4 : 6.0);
            }
            case TONAL_SPOT: {
                return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), platform == TargetPlatform.PHONE ? 5.0 : 10.0);
            }
            case EXPRESSIVE: {
                return TonalPalette.fromHueAndChroma(ColorSpec2025.getExpressiveNeutralHue(sourceColorHct), ColorSpec2025.getExpressiveNeutralChroma(sourceColorHct, isDark, platform));
            }
            case VIBRANT: {
                return TonalPalette.fromHueAndChroma(ColorSpec2025.getVibrantNeutralHue(sourceColorHct), ColorSpec2025.getVibrantNeutralChroma(sourceColorHct, platform));
            }
        }
        return super.getNeutralPalette(variant, sourceColorHct, isDark, platform, contrastLevel);
    }

    @Override
    @NotNull
    public TonalPalette getNeutralVariantPalette(ColorStyle variant, Hct sourceColorHct, boolean isDark, TargetPlatform platform, double contrastLevel) {
        switch (variant) {
            case NEUTRAL: {
                return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), (platform == TargetPlatform.PHONE ? 1.4 : 6.0) * 2.2);
            }
            case TONAL_SPOT: {
                return TonalPalette.fromHueAndChroma(sourceColorHct.getHue(), (double)(platform == TargetPlatform.PHONE ? 5 : 10) * 1.7);
            }
            case EXPRESSIVE: {
                double expressiveNeutralHue = ColorSpec2025.getExpressiveNeutralHue(sourceColorHct);
                double expressiveNeutralChroma = ColorSpec2025.getExpressiveNeutralChroma(sourceColorHct, isDark, platform);
                return TonalPalette.fromHueAndChroma(expressiveNeutralHue, expressiveNeutralChroma * (expressiveNeutralHue >= 105.0 && expressiveNeutralHue < 125.0 ? 1.6 : 2.3));
            }
            case VIBRANT: {
                double vibrantNeutralHue = ColorSpec2025.getVibrantNeutralHue(sourceColorHct);
                double vibrantNeutralChroma = ColorSpec2025.getVibrantNeutralChroma(sourceColorHct, platform);
                return TonalPalette.fromHueAndChroma(vibrantNeutralHue, vibrantNeutralChroma * 1.29);
            }
        }
        return super.getNeutralVariantPalette(variant, sourceColorHct, isDark, platform, contrastLevel);
    }

    @Override
    @NotNull
    public Optional<TonalPalette> getErrorPalette(ColorStyle variant, Hct sourceColorHct, boolean isDark, TargetPlatform platform, double contrastLevel) {
        double errorHue = DynamicScheme.getPiecewiseValue(sourceColorHct, new double[]{0.0, 3.0, 13.0, 23.0, 33.0, 43.0, 153.0, 273.0, 360.0}, new double[]{12.0, 22.0, 32.0, 12.0, 22.0, 32.0, 22.0, 12.0});
        switch (variant) {
            case NEUTRAL: {
                return Optional.of(TonalPalette.fromHueAndChroma(errorHue, platform == TargetPlatform.PHONE ? 50.0 : 40.0));
            }
            case TONAL_SPOT: {
                return Optional.of(TonalPalette.fromHueAndChroma(errorHue, platform == TargetPlatform.PHONE ? 60.0 : 48.0));
            }
            case EXPRESSIVE: {
                return Optional.of(TonalPalette.fromHueAndChroma(errorHue, platform == TargetPlatform.PHONE ? 64.0 : 48.0));
            }
            case VIBRANT: {
                return Optional.of(TonalPalette.fromHueAndChroma(errorHue, platform == TargetPlatform.PHONE ? 80.0 : 60.0));
            }
        }
        return super.getErrorPalette(variant, sourceColorHct, isDark, platform, contrastLevel);
    }

    private static double getExpressiveNeutralHue(Hct sourceColorHct) {
        return DynamicScheme.getRotatedHue(sourceColorHct, new double[]{0.0, 71.0, 124.0, 253.0, 278.0, 300.0, 360.0}, new double[]{10.0, 0.0, 10.0, 0.0, 10.0, 0.0});
    }

    private static double getExpressiveNeutralChroma(Hct sourceColorHct, boolean isDark, TargetPlatform platform) {
        double neutralHue = ColorSpec2025.getExpressiveNeutralHue(sourceColorHct);
        return platform == TargetPlatform.PHONE ? (double)(isDark ? (Hct.isYellow(neutralHue) ? 6 : 14) : 18) : 12.0;
    }

    private static double getVibrantNeutralHue(Hct sourceColorHct) {
        return DynamicScheme.getRotatedHue(sourceColorHct, new double[]{0.0, 38.0, 105.0, 140.0, 333.0, 360.0}, new double[]{-14.0, 10.0, -14.0, 10.0, -14.0});
    }

    private static double getVibrantNeutralChroma(Hct sourceColorHct, TargetPlatform platform) {
        double neutralHue = ColorSpec2025.getVibrantNeutralHue(sourceColorHct);
        return platform == TargetPlatform.PHONE ? 28.0 : (double)(Hct.isBlue(neutralHue) ? 28 : 20);
    }
}

