/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.pci.ids.model;

import java.util.Objects;
import org.glavo.pci.ids.internal.ArgumentValidator;

public final class ProgramInterface
implements Comparable<ProgramInterface> {
    private final int id;
    private final String name;
    private final String comment;

    public ProgramInterface(int id, String name, String comment) {
        ArgumentValidator.requireUnsignedByte(id, "Program interface ID");
        ArgumentValidator.requireNonBlank(name, "Program interface name");
        this.id = id;
        this.name = name;
        this.comment = comment;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public int compareTo(ProgramInterface t) {
        return Integer.compare(this.id, t.id);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ProgramInterface)) {
            return false;
        }
        ProgramInterface that = (ProgramInterface)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name);
    }

    public String toString() {
        return String.format("ProgramInterface[id=%02x, name='%s']", this.getId(), this.getName());
    }
}

