/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.setting;

import com.google.gson.JsonParseException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorServer;
import org.jackhuang.hmcl.setting.Accounts;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.gson.TolerableValidationException;
import org.jackhuang.hmcl.util.gson.Validation;
import org.jackhuang.hmcl.util.io.JarUtils;
import org.jackhuang.hmcl.util.logging.Logger;

public final class AuthlibInjectorServers
implements Validation {
    public static final String CONFIG_FILENAME = "authlib-injectors.json";
    private static final Set<AuthlibInjectorServer> servers = new CopyOnWriteArraySet<AuthlibInjectorServer>();
    private final List<String> urls;

    public static Set<AuthlibInjectorServer> getServers() {
        return servers;
    }

    private AuthlibInjectorServers(List<String> urls) {
        this.urls = urls;
    }

    @Override
    public void validate() throws JsonParseException, TolerableValidationException {
        if (this.urls == null) {
            throw new JsonParseException("authlib-injectors.json -> urls cannot be null.");
        }
    }

    public static void init() {
        Path jarPath = JarUtils.thisJarPath();
        Path configLocation = jarPath != null && Files.isRegularFile(jarPath, new LinkOption[0]) && Files.isWritable(jarPath) ? jarPath.getParent().resolve(CONFIG_FILENAME) : Paths.get(CONFIG_FILENAME, new String[0]);
        if (ConfigHolder.isNewlyCreated() && Files.exists(configLocation, new LinkOption[0])) {
            AuthlibInjectorServers configInstance;
            try {
                configInstance = JsonUtils.fromJsonFile(configLocation, AuthlibInjectorServers.class);
            }
            catch (JsonParseException | IOException e) {
                Logger.LOG.warning("Malformed authlib-injectors.json", e);
                return;
            }
            if (!configInstance.urls.isEmpty()) {
                ConfigHolder.config().setPreferredLoginType(Accounts.getLoginType(Accounts.FACTORY_AUTHLIB_INJECTOR));
                for (String url : configInstance.urls) {
                    Task.supplyAsync(Schedulers.io(), () -> AuthlibInjectorServer.locateServer(url)).thenAcceptAsync(Schedulers.javafx(), server -> {
                        ConfigHolder.config().getAuthlibInjectorServers().add(server);
                        servers.add((AuthlibInjectorServer)server);
                    }).start();
                }
            }
        }
    }
}

