/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.decorator;

import com.jfoenix.controls.JFXButton;
import java.util.List;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ListChangeListener;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;
import javafx.util.Duration;
import org.jackhuang.hmcl.theme.Themes;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.animation.Motion;
import org.jackhuang.hmcl.ui.animation.TransitionPane;
import org.jackhuang.hmcl.ui.decorator.Decorator;
import org.jackhuang.hmcl.ui.wizard.Navigation;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public class DecoratorSkin
extends SkinBase<Decorator> {
    private final StackPane root;
    private final StackPane parent;
    private final StackPane titleContainer;
    private final Stage primaryStage;
    private final TransitionPane navBarPane;
    private final InvalidationListener onWindowsStatusChange;
    private final EventHandler<MouseEvent> onTitleBarDoubleClick;
    private double mouseInitX;
    private double mouseInitY;
    private double stageInitX;
    private double stageInitY;
    private double stageInitWidth;
    private double stageInitHeight;

    public DecoratorSkin(Decorator control) {
        super((Control)control);
        this.primaryStage = control.getPrimaryStage();
        Decorator skinnable = (Decorator)this.getSkinnable();
        this.root = new StackPane();
        this.root.getStyleClass().add((Object)"window");
        StackPane shadowContainer = new StackPane();
        shadowContainer.getStyleClass().add((Object)"body");
        shadowContainer.setEffect((Effect)new DropShadow(BlurType.ONE_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.4), 10.0, 0.3, 0.0, 0.0));
        this.parent = new StackPane();
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)this.parent.widthProperty());
        clip.heightProperty().bind((ObservableValue)this.parent.heightProperty());
        clip.setArcWidth(8.0);
        clip.setArcHeight(8.0);
        this.parent.setClip((Node)clip);
        skinnable.getSnackbar().registerSnackbarContainer((Pane)this.parent);
        EventHandler onMouseReleased = this::onMouseReleased;
        EventHandler onMouseDragged = this::onMouseDragged;
        EventHandler onMouseMoved = this::onMouseMoved;
        if (OperatingSystem.CURRENT_OS != OperatingSystem.MACOS) {
            this.onWindowsStatusChange = observable -> {
                if (this.primaryStage.isIconified() || this.primaryStage.isFullScreen() || this.primaryStage.isMaximized()) {
                    this.root.removeEventFilter(MouseEvent.MOUSE_RELEASED, onMouseReleased);
                    this.root.removeEventFilter(MouseEvent.MOUSE_DRAGGED, onMouseDragged);
                    this.root.removeEventFilter(MouseEvent.MOUSE_MOVED, onMouseMoved);
                } else {
                    this.root.addEventFilter(MouseEvent.MOUSE_RELEASED, onMouseReleased);
                    this.root.addEventFilter(MouseEvent.MOUSE_DRAGGED, onMouseDragged);
                    this.root.addEventFilter(MouseEvent.MOUSE_MOVED, onMouseMoved);
                }
            };
            this.onTitleBarDoubleClick = event -> {
                if (event.getButton() == MouseButton.PRIMARY && event.getClickCount() == 2) {
                    this.primaryStage.setMaximized(!this.primaryStage.isMaximized());
                    event.consume();
                }
            };
            WeakInvalidationListener weakOnWindowsStatusChange = new WeakInvalidationListener(this.onWindowsStatusChange);
            this.primaryStage.iconifiedProperty().addListener((InvalidationListener)weakOnWindowsStatusChange);
            this.primaryStage.maximizedProperty().addListener((InvalidationListener)weakOnWindowsStatusChange);
            this.primaryStage.fullScreenProperty().addListener((InvalidationListener)weakOnWindowsStatusChange);
            this.onWindowsStatusChange.invalidated(null);
        } else {
            this.onWindowsStatusChange = null;
            this.onTitleBarDoubleClick = null;
            this.root.addEventFilter(MouseEvent.MOUSE_RELEASED, onMouseReleased);
            this.root.addEventFilter(MouseEvent.MOUSE_DRAGGED, onMouseDragged);
            this.root.addEventFilter(MouseEvent.MOUSE_MOVED, onMouseMoved);
        }
        shadowContainer.getChildren().setAll((Object[])new Node[]{this.parent});
        this.root.getChildren().setAll((Object[])new Node[]{shadowContainer});
        StackPane wrapper = new StackPane();
        BorderPane frame = new BorderPane();
        frame.getStyleClass().addAll((Object[])new String[]{"jfx-decorator"});
        wrapper.getChildren().setAll((Object[])new Node[]{frame});
        skinnable.setDrawerWrapper(wrapper);
        this.parent.getChildren().add((Object)wrapper);
        StackPane container = new StackPane();
        FXUtils.setOverflowHidden((Region)container);
        StackPane contentPlaceHolder = new StackPane();
        contentPlaceHolder.getStyleClass().add((Object)"jfx-decorator-content-container");
        Bindings.bindContent((List)contentPlaceHolder.getChildren(), skinnable.contentProperty());
        container.getChildren().add((Object)contentPlaceHolder);
        StackPane floatLayer = new StackPane();
        Bindings.bindContent((List)floatLayer.getChildren(), skinnable.containerProperty());
        ListChangeListener listener = c -> {
            if (skinnable.getContainer().isEmpty()) {
                floatLayer.setMouseTransparent(true);
                floatLayer.setVisible(false);
            } else {
                floatLayer.setMouseTransparent(false);
                floatLayer.setVisible(true);
            }
        };
        skinnable.containerProperty().addListener(listener);
        listener.onChanged(null);
        container.getChildren().add((Object)floatLayer);
        frame.setCenter((Node)container);
        this.titleContainer = new StackPane();
        this.titleContainer.setPickOnBounds(false);
        this.titleContainer.getStyleClass().addAll((Object[])new String[]{"jfx-tool-bar"});
        FXUtils.onChangeAndOperate(skinnable.titleTransparentProperty(), titleTransparent -> {
            if (titleTransparent.booleanValue()) {
                wrapper.backgroundProperty().bind(skinnable.contentBackgroundProperty());
                container.backgroundProperty().unbind();
                container.setBackground(null);
                this.titleContainer.getStyleClass().remove((Object)"background");
                this.titleContainer.getStyleClass().add((Object)"gray-background");
            } else {
                container.backgroundProperty().bind(skinnable.contentBackgroundProperty());
                wrapper.backgroundProperty().unbind();
                wrapper.setBackground(null);
                this.titleContainer.getStyleClass().add((Object)"background");
                this.titleContainer.getStyleClass().remove((Object)"gray-background");
            }
        });
        control.capableDraggingWindow((Node)this.titleContainer);
        BorderPane titleBar = new BorderPane();
        this.titleContainer.getChildren().add((Object)titleBar);
        Rectangle buttonsContainerPlaceHolder = new Rectangle();
        this.navBarPane = new TransitionPane();
        this.navBarPane.setId("decoratorTitleTransitionPane");
        FXUtils.onChangeAndOperate(skinnable.stateProperty(), s -> {
            if (s == null) {
                return;
            }
            Node node = this.createNavBar(skinnable, s.getLeftPaneWidth(), s.isBackable(), skinnable.canCloseProperty().get(), skinnable.showCloseAsHomeProperty().get(), s.isRefreshable(), s.getTitle(), s.getTitleNode());
            if (s.isAnimate()) {
                Enum animation = switch (skinnable.getNavigationDirection()) {
                    case Navigation.NavigationDirection.NEXT -> NavBarAnimations.NEXT;
                    case Navigation.NavigationDirection.PREVIOUS -> NavBarAnimations.PREVIOUS;
                    default -> ContainerAnimations.FADE;
                };
                skinnable.setNavigationDirection(Navigation.NavigationDirection.START);
                this.navBarPane.setContent(node, (TransitionPane.AnimationProducer)((Object)animation), Motion.SHORT4);
            } else {
                this.navBarPane.getChildren().setAll((Object[])new Node[]{node});
            }
        });
        titleBar.setCenter((Node)this.navBarPane);
        titleBar.setRight((Node)buttonsContainerPlaceHolder);
        frame.setTop((Node)this.titleContainer);
        HBox buttonsContainer = new HBox();
        buttonsContainer.setAlignment(Pos.TOP_RIGHT);
        buttonsContainer.setMaxHeight(40.0);
        JFXButton btnHelp = new JFXButton();
        btnHelp.setFocusTraversable(false);
        btnHelp.setGraphic(SVG.HELP.createIcon(Themes.titleFillProperty()));
        btnHelp.getStyleClass().add((Object)"jfx-decorator-button");
        btnHelp.setOnAction(e -> FXUtils.openLink("https://docs.hmcl.net/help.html"));
        JFXButton btnMin = new JFXButton();
        btnMin.setFocusTraversable(false);
        btnMin.setGraphic(SVG.MINIMIZE.createIcon(Themes.titleFillProperty()));
        btnMin.getStyleClass().add((Object)"jfx-decorator-button");
        btnMin.setOnAction(e -> skinnable.minimize());
        JFXButton btnClose = new JFXButton();
        btnClose.setFocusTraversable(false);
        btnClose.setGraphic(SVG.CLOSE.createIcon(Themes.titleFillProperty()));
        btnClose.getStyleClass().add((Object)"jfx-decorator-button");
        btnClose.setOnAction(e -> skinnable.close());
        buttonsContainer.getChildren().setAll((Object[])new Node[]{btnHelp, btnMin, btnClose});
        AnchorPane layer = new AnchorPane();
        layer.setPickOnBounds(false);
        layer.getChildren().add((Object)buttonsContainer);
        AnchorPane.setTopAnchor((Node)buttonsContainer, (Double)0.0);
        AnchorPane.setRightAnchor((Node)buttonsContainer, (Double)0.0);
        buttonsContainerPlaceHolder.widthProperty().bind((ObservableValue)buttonsContainer.widthProperty());
        this.parent.getChildren().add((Object)layer);
        this.getChildren().add((Object)this.root);
    }

    private Node createNavBar(Decorator skinnable, double leftPaneWidth, boolean canBack, boolean canClose, boolean showCloseAsHome, boolean canRefresh, String title, Node titleNode) {
        BorderPane navBar = new BorderPane();
        navBar.getStyleClass().add((Object)"navigation-bar");
        HBox navLeft = new HBox();
        navLeft.setAlignment(Pos.CENTER_LEFT);
        navLeft.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
        if (canBack) {
            JFXButton backNavButton = new JFXButton();
            backNavButton.setFocusTraversable(false);
            backNavButton.setGraphic(SVG.ARROW_BACK.createIcon(Themes.titleFillProperty()));
            backNavButton.getStyleClass().add((Object)"jfx-decorator-button");
            backNavButton.onActionProperty().bind(skinnable.onBackNavButtonActionProperty());
            backNavButton.visibleProperty().set(canBack);
            navLeft.getChildren().add((Object)backNavButton);
        }
        if (canClose) {
            JFXButton closeNavButton = new JFXButton();
            closeNavButton.setFocusTraversable(false);
            closeNavButton.setGraphic(SVG.CLOSE.createIcon(Themes.titleFillProperty()));
            closeNavButton.getStyleClass().add((Object)"jfx-decorator-button");
            closeNavButton.onActionProperty().bind(skinnable.onCloseNavButtonActionProperty());
            if (showCloseAsHome) {
                closeNavButton.setGraphic(SVG.HOME.createIcon(Themes.titleFillProperty()));
            } else {
                closeNavButton.setGraphic(SVG.CLOSE.createIcon(Themes.titleFillProperty()));
            }
            navLeft.getChildren().add((Object)closeNavButton);
        }
        if (canBack || canClose) {
            navBar.setLeft((Node)navLeft);
        }
        BorderPane center = new BorderPane();
        if (title != null) {
            Label titleLabel = new Label();
            titleLabel.textFillProperty().bind(Themes.titleFillProperty());
            BorderPane.setAlignment((Node)titleLabel, (Pos)Pos.CENTER_LEFT);
            titleLabel.getStyleClass().add((Object)"jfx-decorator-title");
            if (titleNode == null) {
                titleLabel.maxWidthProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> skinnable.getWidth() - 150.0 - navLeft.getWidth(), (Observable[])new Observable[]{skinnable.widthProperty(), navLeft.widthProperty()}));
            } else {
                titleLabel.prefWidthProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> leftPaneWidth - 8.0 - navLeft.getWidth(), (Observable[])new Observable[]{navLeft.widthProperty()}));
            }
            titleLabel.setText(title);
            center.setLeft((Node)titleLabel);
            BorderPane.setAlignment((Node)titleLabel, (Pos)Pos.CENTER_LEFT);
        }
        if (titleNode != null) {
            center.setCenter(titleNode);
            BorderPane.setAlignment((Node)titleNode, (Pos)Pos.CENTER_LEFT);
            BorderPane.setMargin((Node)titleNode, (Insets)new Insets(0.0, 0.0, 0.0, 8.0));
        }
        if (this.onTitleBarDoubleClick != null) {
            center.setOnMouseClicked(this.onTitleBarDoubleClick);
        }
        navBar.setCenter((Node)center);
        if (canRefresh) {
            HBox navRight = new HBox();
            navRight.setAlignment(Pos.CENTER_RIGHT);
            JFXButton refreshNavButton = new JFXButton();
            refreshNavButton.setGraphic(SVG.REFRESH.createIcon(Themes.titleFillProperty()));
            refreshNavButton.getStyleClass().add((Object)"jfx-decorator-button");
            refreshNavButton.onActionProperty().bind(skinnable.onRefreshNavButtonActionProperty());
            Rectangle separator = new Rectangle();
            separator.visibleProperty().bind((ObservableValue)refreshNavButton.visibleProperty());
            separator.heightProperty().bind((ObservableValue)navBar.heightProperty());
            separator.setFill((Paint)Color.GRAY);
            navRight.getChildren().setAll((Object[])new Node[]{refreshNavButton, separator});
            navBar.setRight((Node)navRight);
        }
        return navBar;
    }

    private boolean isRightEdge(double x, double y, Bounds boundsInParent) {
        return x < this.root.getWidth() && x >= this.root.getWidth() - this.root.snappedLeftInset();
    }

    private boolean isTopEdge(double x, double y, Bounds boundsInParent) {
        return y >= 0.0 && y <= this.root.snappedTopInset();
    }

    private boolean isBottomEdge(double x, double y, Bounds boundsInParent) {
        return y < this.root.getHeight() && y >= this.root.getHeight() - this.root.snappedLeftInset();
    }

    private boolean isLeftEdge(double x, double y, Bounds boundsInParent) {
        return x >= 0.0 && x <= this.root.snappedLeftInset();
    }

    private void resizeStage(double newWidth, double newHeight) {
        if (newWidth < 0.0) {
            newWidth = this.primaryStage.getWidth();
        }
        if (newWidth < this.primaryStage.getMinWidth()) {
            newWidth = this.primaryStage.getMinWidth();
        }
        if (newWidth < this.titleContainer.getMinWidth()) {
            newWidth = this.titleContainer.getMinWidth();
        }
        if (newHeight < 0.0) {
            newHeight = this.primaryStage.getHeight();
        }
        if (newHeight < this.primaryStage.getMinHeight()) {
            newHeight = this.primaryStage.getMinHeight();
        }
        if (newHeight < this.titleContainer.getMinHeight()) {
            newHeight = this.titleContainer.getMinHeight();
        }
        this.primaryStage.setWidth(newWidth);
        this.primaryStage.setHeight(newHeight);
    }

    private void onMouseMoved(MouseEvent mouseEvent) {
        if (!this.primaryStage.isFullScreen() && this.primaryStage.isResizable()) {
            double x = mouseEvent.getX();
            double y = mouseEvent.getY();
            Bounds boundsInParent = this.root.getBoundsInParent();
            double diagonalSize = this.root.snappedLeftInset() + 10.0;
            if (this.isRightEdge(x, y, boundsInParent)) {
                if (y < diagonalSize) {
                    this.root.setCursor(Cursor.NE_RESIZE);
                } else if (y > this.root.getHeight() - diagonalSize) {
                    this.root.setCursor(Cursor.SE_RESIZE);
                } else {
                    this.root.setCursor(Cursor.E_RESIZE);
                }
            } else if (this.isLeftEdge(x, y, boundsInParent)) {
                if (y < diagonalSize) {
                    this.root.setCursor(Cursor.NW_RESIZE);
                } else if (y > this.root.getHeight() - diagonalSize) {
                    this.root.setCursor(Cursor.SW_RESIZE);
                } else {
                    this.root.setCursor(Cursor.W_RESIZE);
                }
            } else if (this.isTopEdge(x, y, boundsInParent)) {
                if (x < diagonalSize) {
                    this.root.setCursor(Cursor.NW_RESIZE);
                } else if (x > this.root.getWidth() - diagonalSize) {
                    this.root.setCursor(Cursor.NE_RESIZE);
                } else {
                    this.root.setCursor(Cursor.N_RESIZE);
                }
            } else if (this.isBottomEdge(x, y, boundsInParent)) {
                if (x < diagonalSize) {
                    this.root.setCursor(Cursor.SW_RESIZE);
                } else if (x > this.root.getWidth() - diagonalSize) {
                    this.root.setCursor(Cursor.SE_RESIZE);
                } else {
                    this.root.setCursor(Cursor.S_RESIZE);
                }
            } else {
                this.root.setCursor(Cursor.DEFAULT);
            }
        } else {
            this.root.setCursor(Cursor.DEFAULT);
        }
    }

    private void onMouseReleased(MouseEvent mouseEvent) {
        ((Decorator)this.getSkinnable()).setDragging(false);
    }

    private void onMouseDragged(MouseEvent mouseEvent) {
        if (!((Decorator)this.getSkinnable()).isDragging()) {
            ((Decorator)this.getSkinnable()).setDragging(true);
            this.mouseInitX = mouseEvent.getScreenX();
            this.mouseInitY = mouseEvent.getScreenY();
            this.stageInitX = this.primaryStage.getX();
            this.stageInitY = this.primaryStage.getY();
            this.stageInitWidth = this.primaryStage.getWidth();
            this.stageInitHeight = this.primaryStage.getHeight();
        }
        if (this.primaryStage.isFullScreen() || !mouseEvent.isPrimaryButtonDown() || mouseEvent.isStillSincePress()) {
            return;
        }
        double dx = mouseEvent.getScreenX() - this.mouseInitX;
        double dy = mouseEvent.getScreenY() - this.mouseInitY;
        Cursor cursor = this.root.getCursor();
        if (((Decorator)this.getSkinnable()).isAllowMove() && cursor == Cursor.DEFAULT) {
            this.primaryStage.setX(this.stageInitX + dx);
            this.primaryStage.setY(this.stageInitY + dy);
            mouseEvent.consume();
        }
        if (((Decorator)this.getSkinnable()).isResizable()) {
            if (cursor == Cursor.E_RESIZE) {
                this.resizeStage(this.stageInitWidth + dx, -1.0);
                mouseEvent.consume();
            } else if (cursor == Cursor.S_RESIZE) {
                this.resizeStage(-1.0, this.stageInitHeight + dy);
                mouseEvent.consume();
            } else if (cursor == Cursor.W_RESIZE) {
                this.resizeStage(this.stageInitWidth - dx, -1.0);
                this.primaryStage.setX(this.stageInitX + this.stageInitWidth - this.primaryStage.getWidth());
                mouseEvent.consume();
            } else if (cursor == Cursor.N_RESIZE) {
                this.resizeStage(-1.0, this.stageInitHeight - dy);
                this.primaryStage.setY(this.stageInitY + this.stageInitHeight - this.primaryStage.getHeight());
                mouseEvent.consume();
            } else if (cursor == Cursor.SE_RESIZE) {
                this.resizeStage(this.stageInitWidth + dx, this.stageInitHeight + dy);
                mouseEvent.consume();
            } else if (cursor == Cursor.SW_RESIZE) {
                this.resizeStage(this.stageInitWidth - dx, this.stageInitHeight + dy);
                this.primaryStage.setX(this.stageInitX + this.stageInitWidth - this.primaryStage.getWidth());
                mouseEvent.consume();
            } else if (cursor == Cursor.NW_RESIZE) {
                this.resizeStage(this.stageInitWidth - dx, this.stageInitHeight - dy);
                this.primaryStage.setX(this.stageInitX + this.stageInitWidth - this.primaryStage.getWidth());
                this.primaryStage.setY(this.stageInitY + this.stageInitHeight - this.primaryStage.getHeight());
                mouseEvent.consume();
            } else if (cursor == Cursor.NE_RESIZE) {
                this.resizeStage(this.stageInitWidth + dx, this.stageInitHeight - dy);
                this.primaryStage.setY(this.stageInitY + this.stageInitHeight - this.primaryStage.getHeight());
                mouseEvent.consume();
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum NavBarAnimations implements TransitionPane.AnimationProducer
    {
        NEXT{

            @Override
            public void init(TransitionPane container, Node previousNode, Node nextNode) {
                super.init(container, previousNode, nextNode);
                nextNode.setTranslateX(container.getWidth());
            }

            public Timeline animate(Pane container, Node previousNode, Node nextNode, Duration duration, Interpolator interpolator) {
                return new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)nextNode.translateXProperty(), (Object)50, interpolator), new KeyValue((WritableValue)previousNode.translateXProperty(), (Object)0, interpolator), new KeyValue((WritableValue)nextNode.opacityProperty(), (Object)0, interpolator), new KeyValue((WritableValue)previousNode.opacityProperty(), (Object)1, interpolator)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)nextNode.translateXProperty(), (Object)0, interpolator), new KeyValue((WritableValue)previousNode.translateXProperty(), (Object)-50, interpolator), new KeyValue((WritableValue)nextNode.opacityProperty(), (Object)1, interpolator), new KeyValue((WritableValue)previousNode.opacityProperty(), (Object)0, interpolator)})});
            }

            @Override
            public TransitionPane.AnimationProducer opposite() {
                return NEXT;
            }
        }
        ,
        PREVIOUS{

            @Override
            public void init(TransitionPane container, Node previousNode, Node nextNode) {
                super.init(container, previousNode, nextNode);
                nextNode.setTranslateX(container.getWidth());
            }

            public Timeline animate(Pane container, Node previousNode, Node nextNode, Duration duration, Interpolator interpolator) {
                return new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)nextNode.translateXProperty(), (Object)-50, interpolator), new KeyValue((WritableValue)previousNode.translateXProperty(), (Object)0, interpolator), new KeyValue((WritableValue)nextNode.opacityProperty(), (Object)0, interpolator), new KeyValue((WritableValue)previousNode.opacityProperty(), (Object)1, interpolator)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)nextNode.translateXProperty(), (Object)0, interpolator), new KeyValue((WritableValue)previousNode.translateXProperty(), (Object)50, interpolator), new KeyValue((WritableValue)nextNode.opacityProperty(), (Object)1, interpolator), new KeyValue((WritableValue)previousNode.opacityProperty(), (Object)0, interpolator)})});
            }

            @Override
            public TransitionPane.AnimationProducer opposite() {
                return PREVIOUS;
            }
        };

    }
}

