/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.image.apng.argb8888;

import org.jackhuang.hmcl.ui.image.apng.argb8888.Argb8888Bitmap;
import org.jackhuang.hmcl.ui.image.apng.argb8888.Argb8888Palette;
import org.jackhuang.hmcl.ui.image.apng.chunks.PngHeader;
import org.jackhuang.hmcl.ui.image.apng.reader.BasicScanlineProcessor;

public abstract class Argb8888ScanlineProcessor
extends BasicScanlineProcessor {
    protected Argb8888Bitmap bitmap;
    protected Argb8888Palette palette;
    protected int y = 0;

    public Argb8888ScanlineProcessor(int bytesPerScanline, Argb8888Bitmap bitmap) {
        super(bytesPerScanline);
        this.bitmap = bitmap;
    }

    public Argb8888Bitmap getBitmap() {
        return this.bitmap;
    }

    public Argb8888Palette getPalette() {
        return this.palette;
    }

    public void setPalette(Argb8888Palette palette) {
        this.palette = palette;
    }

    public Argb8888ScanlineProcessor cloneWithNewBitmap(PngHeader header) {
        Argb8888ScanlineProcessor cloned = this.clone(header.bytesPerRow, new Argb8888Bitmap(header.width, header.height));
        if (this.palette != null) {
            cloned.setPalette(new Argb8888Palette(this.palette.argbArray));
        }
        return cloned;
    }

    public Argb8888ScanlineProcessor cloneWithSharedBitmap(PngHeader header) {
        Argb8888ScanlineProcessor cloned = this.clone(header.bytesPerRow, this.bitmap.makeView(header.width, header.height));
        if (this.palette != null) {
            cloned.setPalette(new Argb8888Palette(this.palette.argbArray));
        }
        return cloned;
    }

    abstract Argb8888ScanlineProcessor clone(int var1, Argb8888Bitmap var2);
}

