/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXRippler;
import com.jfoenix.transitions.CachedTransition;
import com.jfoenix.transitions.JFXFillTransition;
import com.jfoenix.utils.JFXNodeUtils;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.skin.CheckBoxSkin;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.Shape;
import javafx.util.Duration;
import org.jackhuang.hmcl.theme.Themes;

public class JFXCheckBoxSkin
extends CheckBoxSkin {
    private final StackPane box = new StackPane();
    private final StackPane mark = new StackPane();
    private final double lineThick = 2.0;
    private final double padding = 10.0;
    private final JFXRippler rippler;
    private final AnchorPane container = new AnchorPane();
    private final double labelOffset = -8.0;
    private final Transition transition;
    private boolean invalid = true;
    private JFXFillTransition select;

    public JFXCheckBoxSkin(JFXCheckBox control) {
        super((CheckBox)control);
        this.box.setMinSize(18.0, 18.0);
        this.box.setPrefSize(18.0, 18.0);
        this.box.setMaxSize(18.0, 18.0);
        this.box.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, new CornerRadii(2.0), Insets.EMPTY)}));
        this.box.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Themes.getColorScheme().getOnSurfaceVariant(), BorderStrokeStyle.SOLID, new CornerRadii(2.0), new BorderWidths(this.lineThick))}));
        StackPane boxContainer = new StackPane();
        boxContainer.getChildren().add((Object)this.box);
        boxContainer.setPadding(new Insets(this.padding));
        this.rippler = new JFXRippler((Node)boxContainer, JFXRippler.RipplerMask.CIRCLE, JFXRippler.RipplerPos.BACK);
        this.updateRippleColor();
        SVGPath shape = new SVGPath();
        shape.setContent("M384 690l452-452 60 60-512 512-238-238 60-60z");
        this.mark.setShape((Shape)shape);
        this.mark.setMaxSize(15.0, 12.0);
        this.mark.setStyle("-fx-background-color:-monet-on-primary; -fx-border-color:-monet-on-primary; -fx-border-width:2px;");
        this.mark.setVisible(false);
        this.mark.setScaleX(0.0);
        this.mark.setScaleY(0.0);
        boxContainer.getChildren().add((Object)this.mark);
        this.container.getChildren().add((Object)this.rippler);
        AnchorPane.setRightAnchor((Node)this.rippler, (Double)this.labelOffset);
        control.selectedProperty().addListener((o, oldVal, newVal) -> {
            this.updateRippleColor();
            this.playSelectAnimation((Boolean)newVal);
        });
        control.focusedProperty().addListener((o, oldVal, newVal) -> {
            if (newVal.booleanValue()) {
                if (!((CheckBox)this.getSkinnable()).isPressed()) {
                    this.rippler.showOverlay();
                }
            } else {
                this.rippler.hideOverlay();
            }
        });
        control.pressedProperty().addListener((o, oldVal, newVal) -> this.rippler.hideOverlay());
        this.updateChildren();
        this.registerChangeListener((ObservableValue)control.checkedColorProperty(), ignored -> {
            if (this.select != null) {
                this.select.stop();
            }
            this.createFillTransition();
            this.updateColors();
        });
        this.registerChangeListener((ObservableValue)control.unCheckedColorProperty(), ignored -> this.updateColors());
        this.transition = new CheckBoxTransition();
        this.createFillTransition();
    }

    private void updateRippleColor() {
        JFXCheckBox control = (JFXCheckBox)this.getSkinnable();
        this.rippler.setRipplerFill(control.isSelected() ? control.getCheckedColor() : control.getUnCheckedColor());
    }

    private void updateColors() {
        JFXCheckBox control = (JFXCheckBox)this.getSkinnable();
        boolean isSelected = control.isSelected();
        JFXNodeUtils.updateBackground(this.box.getBackground(), (Region)this.box, (Paint)(isSelected ? control.getCheckedColor() : Color.TRANSPARENT));
        this.rippler.setRipplerFill(isSelected ? control.getCheckedColor() : control.getUnCheckedColor());
        BorderStroke borderStroke = (BorderStroke)this.box.getBorder().getStrokes().get(0);
        this.box.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)(isSelected ? control.getCheckedColor() : Themes.getColorScheme().getOnSurfaceVariant()), borderStroke.getTopStyle(), borderStroke.getRadii(), borderStroke.getWidths())}));
    }

    protected void updateChildren() {
        super.updateChildren();
        if (this.container != null) {
            this.getChildren().remove(1);
            this.getChildren().add((Object)this.container);
        }
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset) + this.snapSizeX(this.box.minWidth(-1.0)) + this.labelOffset + 2.0 * this.padding;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset) + this.snapSizeY(this.box.prefWidth(-1.0)) + this.labelOffset + 2.0 * this.padding;
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        CheckBox checkBox = (CheckBox)this.getSkinnable();
        double boxWidth = this.snapSizeX(this.container.prefWidth(-1.0));
        double boxHeight = this.snapSizeY(this.container.prefHeight(-1.0));
        double computeWidth = Math.min(checkBox.prefWidth(-1.0), checkBox.minWidth(-1.0)) + this.labelOffset + 2.0 * this.padding;
        double labelWidth = Math.min(computeWidth - boxWidth, w - this.snapSizeX(boxWidth)) + this.labelOffset + 2.0 * this.padding;
        double labelHeight = Math.min(checkBox.prefHeight(labelWidth), h);
        double maxHeight = Math.max(boxHeight, labelHeight);
        double xOffset = JFXCheckBoxSkin.computeXOffset(w, labelWidth + boxWidth, checkBox.getAlignment().getHpos()) + x;
        double yOffset = JFXCheckBoxSkin.computeYOffset(h, maxHeight, checkBox.getAlignment().getVpos()) + x;
        if (this.invalid) {
            if (((CheckBox)this.getSkinnable()).isSelected()) {
                this.playSelectAnimation(true);
            }
            this.invalid = false;
        }
        this.layoutLabelInArea(xOffset + boxWidth, yOffset, labelWidth, maxHeight, checkBox.getAlignment());
        this.container.resize(boxWidth, boxHeight);
        this.positionInArea((Node)this.container, xOffset, yOffset, boxWidth, maxHeight, 0.0, checkBox.getAlignment().getHpos(), checkBox.getAlignment().getVpos());
    }

    static double computeXOffset(double width, double contentWidth, HPos hpos) {
        return switch (hpos) {
            default -> throw new IncompatibleClassChangeError();
            case HPos.LEFT -> 0.0;
            case HPos.CENTER -> (width - contentWidth) / 2.0;
            case HPos.RIGHT -> width - contentWidth;
        };
    }

    static double computeYOffset(double height, double contentHeight, VPos vpos) {
        return switch (vpos) {
            case VPos.TOP -> 0.0;
            case VPos.CENTER -> (height - contentHeight) / 2.0;
            case VPos.BOTTOM -> height - contentHeight;
            default -> 0.0;
        };
    }

    private void playSelectAnimation(Boolean selection) {
        if (selection == null) {
            selection = false;
        }
        JFXCheckBox control = (JFXCheckBox)this.getSkinnable();
        this.transition.setRate(selection != false ? 1.0 : -1.0);
        this.select.setRate(selection != false ? 1.0 : -1.0);
        this.transition.play();
        this.select.play();
        this.box.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)(selection != false ? control.getCheckedColor() : Themes.getColorScheme().getOnSurfaceVariant()), BorderStrokeStyle.SOLID, new CornerRadii(2.0), new BorderWidths(this.lineThick))}));
    }

    private void createFillTransition() {
        this.select = new JFXFillTransition(Duration.millis((double)120.0), (Region)this.box, Color.TRANSPARENT, (Color)((JFXCheckBox)this.getSkinnable()).getCheckedColor());
        this.select.setInterpolator(Interpolator.EASE_OUT);
    }

    private final class CheckBoxTransition
    extends CachedTransition {
        CheckBoxTransition() {
            super((Node)JFXCheckBoxSkin.this.mark, new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)JFXCheckBoxSkin.this.mark.visibleProperty(), (Object)false, Interpolator.EASE_OUT), new KeyValue((WritableValue)JFXCheckBoxSkin.this.mark.scaleXProperty(), (Object)0.5, Interpolator.EASE_OUT), new KeyValue((WritableValue)JFXCheckBoxSkin.this.mark.scaleYProperty(), (Object)0.5, Interpolator.EASE_OUT)}), new KeyFrame(Duration.millis((double)400.0), new KeyValue[]{new KeyValue((WritableValue)JFXCheckBoxSkin.this.mark.visibleProperty(), (Object)true, Interpolator.EASE_OUT), new KeyValue((WritableValue)JFXCheckBoxSkin.this.mark.scaleXProperty(), (Object)0.5, Interpolator.EASE_OUT), new KeyValue((WritableValue)JFXCheckBoxSkin.this.mark.scaleYProperty(), (Object)0.5, Interpolator.EASE_OUT)}), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)JFXCheckBoxSkin.this.mark.visibleProperty(), (Object)true, Interpolator.EASE_OUT), new KeyValue((WritableValue)JFXCheckBoxSkin.this.mark.scaleXProperty(), (Object)1, Interpolator.EASE_OUT), new KeyValue((WritableValue)JFXCheckBoxSkin.this.mark.scaleYProperty(), (Object)1, Interpolator.EASE_OUT)})}));
            this.setCycleDuration(Duration.seconds((double)0.12));
            this.setDelay(Duration.seconds((double)0.05));
        }
    }
}

