/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXRippler;
import java.util.List;
import javafx.animation.Transition;
import javafx.beans.DefaultProperty;
import javafx.beans.InvalidationListener;
import javafx.beans.NamedArg;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.util.Duration;
import org.jackhuang.hmcl.theme.Themes;
import org.jackhuang.hmcl.ui.animation.AnimationUtils;
import org.jackhuang.hmcl.ui.animation.Motion;
import org.jackhuang.hmcl.util.Lang;

@DefaultProperty(value="container")
public class RipplerContainer
extends StackPane {
    private static final String DEFAULT_STYLE_CLASS = "rippler-container";
    private static final Duration DURATION = Duration.millis((double)200.0);
    private final ObjectProperty<Node> container = new SimpleObjectProperty((Object)this, "container", null);
    private final StyleableObjectProperty<Paint> ripplerFill = new SimpleStyleableObjectProperty(StyleableProperties.RIPPLER_FILL, (Object)this, "ripplerFill", null);
    private final BooleanProperty selected = new SimpleBooleanProperty((Object)this, "selected", false);
    private final StackPane buttonContainer = new StackPane();
    private final JFXRippler buttonRippler = new JFXRippler((Node)new StackPane()){

        @Override
        protected Node getMask() {
            StackPane mask = new StackPane();
            mask.shapeProperty().bind((ObservableValue)RipplerContainer.this.buttonContainer.shapeProperty());
            mask.backgroundProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, RipplerContainer.this.buttonContainer.getBackground() != null && RipplerContainer.this.buttonContainer.getBackground().getFills().size() > 0 ? ((BackgroundFill)RipplerContainer.this.buttonContainer.getBackground().getFills().get(0)).getRadii() : RipplerContainer.this.defaultRadii, RipplerContainer.this.buttonContainer.getBackground() != null && RipplerContainer.this.buttonContainer.getBackground().getFills().size() > 0 ? ((BackgroundFill)RipplerContainer.this.buttonContainer.getBackground().getFills().get(0)).getInsets() : Insets.EMPTY)}), (Observable[])new Observable[]{RipplerContainer.this.buttonContainer.backgroundProperty()}));
            mask.resize(RipplerContainer.this.buttonContainer.getWidth() - RipplerContainer.this.buttonContainer.snappedRightInset() - RipplerContainer.this.buttonContainer.snappedLeftInset(), RipplerContainer.this.buttonContainer.getHeight() - RipplerContainer.this.buttonContainer.snappedBottomInset() - RipplerContainer.this.buttonContainer.snappedTopInset());
            return mask;
        }
    };
    private final CornerRadii defaultRadii = new CornerRadii(3.0);

    public RipplerContainer(@NamedArg(value="container") Node container) {
        this.setContainer(container);
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.buttonRippler.setPosition(JFXRippler.RipplerPos.BACK);
        this.buttonContainer.getChildren().add((Object)this.buttonRippler);
        this.focusedProperty().addListener((a, b, newValue) -> {
            if (newValue.booleanValue()) {
                if (!this.isPressed()) {
                    this.buttonRippler.showOverlay();
                }
            } else {
                this.buttonRippler.hideOverlay();
            }
        });
        this.pressedProperty().addListener(o -> this.buttonRippler.hideOverlay());
        this.setPickOnBounds(false);
        this.buttonContainer.setPickOnBounds(false);
        this.buttonRippler.ripplerFillProperty().bind(this.ripplerFillProperty());
        this.containerProperty().addListener(o -> this.updateChildren());
        this.updateChildren();
        InvalidationListener listener = o -> {
            if (this.isSelected()) {
                this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.getRipplerFill(), this.defaultRadii, null)}));
            } else {
                this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, this.defaultRadii, null)}));
            }
        };
        this.selectedProperty().addListener(listener);
        this.selectedProperty().addListener((a, b, newValue) -> this.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"selected"), (boolean)newValue));
        this.ripplerFillProperty().addListener(listener);
        this.setShape((Shape)Lang.apply(new Rectangle(), rectangle -> {
            rectangle.widthProperty().bind((ObservableValue)this.widthProperty());
            rectangle.heightProperty().bind((ObservableValue)this.heightProperty());
        }));
        if (AnimationUtils.isAnimationEnabled()) {
            this.setOnMouseEntered(e -> new Transition(){
                {
                    this.setCycleDuration(DURATION);
                    this.setInterpolator(Motion.EASE_IN);
                }

                protected void interpolate(double frac) {
                    RipplerContainer.this.interpolateBackground(frac);
                }
            }.play());
            this.setOnMouseExited(e -> new Transition(){
                {
                    this.setCycleDuration(DURATION);
                    this.setInterpolator(Motion.EASE_OUT);
                }

                protected void interpolate(double frac) {
                    RipplerContainer.this.interpolateBackground(1.0 - frac);
                }
            }.play());
        } else {
            this.setOnMouseEntered(e -> this.interpolateBackground(1.0));
            this.setOnMouseExited(e -> this.interpolateBackground(0.0));
        }
    }

    private void interpolateBackground(double frac) {
        Color onSurface = Themes.getColorScheme().getOnSurface();
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.color((double)onSurface.getRed(), (double)onSurface.getGreen(), (double)onSurface.getBlue(), (double)(frac * 0.04)), CornerRadii.EMPTY, Insets.EMPTY)}));
    }

    protected void updateChildren() {
        this.getChildren().addAll((Object[])new Node[]{this.buttonContainer, this.getContainer()});
        for (int i = 1; i < this.getChildren().size(); ++i) {
            ((Node)this.getChildren().get(i)).setPickOnBounds(false);
        }
    }

    public Node getContainer() {
        return (Node)this.container.get();
    }

    public ObjectProperty<Node> containerProperty() {
        return this.container;
    }

    public void setContainer(Node container) {
        this.container.set((Object)container);
    }

    public Paint getRipplerFill() {
        return (Paint)this.ripplerFill.get();
    }

    public StyleableObjectProperty<Paint> ripplerFillProperty() {
        return this.ripplerFill;
    }

    public void setRipplerFill(Paint ripplerFill) {
        this.ripplerFill.set((Object)ripplerFill);
    }

    public boolean isSelected() {
        return this.selected.get();
    }

    public BooleanProperty selectedProperty() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected.set(selected);
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return RipplerContainer.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.FACTORY.getCssMetaData();
    }

    private static final class StyleableProperties {
        private static final StyleablePropertyFactory<RipplerContainer> FACTORY = new StyleablePropertyFactory(StackPane.getClassCssMetaData());
        private static final CssMetaData<RipplerContainer, Paint> RIPPLER_FILL = FACTORY.createPaintCssMetaData("-jfx-rippler-fill", s -> s.ripplerFill, (Paint)Color.rgb((int)0, (int)200, (int)255));

        private StyleableProperties() {
        }
    }
}

