/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.monetfx.internal.quantize;

import java.util.LinkedHashMap;
import java.util.Map;
import org.glavo.monetfx.internal.quantize.Quantizer;
import org.glavo.monetfx.internal.quantize.QuantizerResult;

public final class QuantizerMap
implements Quantizer {
    Map<Integer, Integer> colorToCount;

    @Override
    public QuantizerResult quantize(int[] pixels, int colorCount) {
        LinkedHashMap<Integer, Integer> pixelByCount = new LinkedHashMap<Integer, Integer>();
        for (int pixel : pixels) {
            Integer currentPixelCount = (Integer)pixelByCount.get(pixel);
            int newPixelCount = currentPixelCount == null ? 1 : currentPixelCount + 1;
            pixelByCount.put(pixel, newPixelCount);
        }
        this.colorToCount = pixelByCount;
        return new QuantizerResult(pixelByCount);
    }

    public Map<Integer, Integer> getColorToCount() {
        return this.colorToCount;
    }
}

