/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Duration;
import org.jackhuang.hmcl.theme.Themes;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.animation.AnimationUtils;
import org.jackhuang.hmcl.ui.animation.Motion;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.ComponentSublist;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;

final class ComponentListCell
extends StackPane {
    private final Node content;
    private Animation expandAnimation;
    private boolean expanded = false;

    ComponentListCell(Node content) {
        this.content = content;
        this.updateLayout();
    }

    private void updateLayout() {
        Node node = this.content;
        if (node instanceof ComponentList) {
            ComponentSublist subList;
            boolean hasPadding;
            Node rightNode;
            Node leftNode;
            ComponentList list = (ComponentList)node;
            this.content.getStyleClass().remove((Object)"options-list");
            this.content.getStyleClass().add((Object)"options-sublist");
            this.getStyleClass().add((Object)"no-padding");
            VBox groupNode = new VBox();
            Node expandIcon = SVG.KEYBOARD_ARROW_DOWN.createIcon(20.0);
            expandIcon.setMouseTransparent(true);
            HBox.setMargin((Node)expandIcon, (Insets)new Insets(0.0, 8.0, 0.0, 8.0));
            VBox labelVBox = new VBox();
            labelVBox.setMouseTransparent(true);
            labelVBox.setAlignment(Pos.CENTER_LEFT);
            boolean overrideHeaderLeft = false;
            if (list instanceof ComponentSublist && (leftNode = ((ComponentSublist)list).getHeaderLeft()) != null) {
                labelVBox.getChildren().setAll((Object[])new Node[]{leftNode});
                overrideHeaderLeft = true;
            }
            if (!overrideHeaderLeft) {
                Label label = new Label();
                label.textProperty().bind((ObservableValue)list.titleProperty());
                label.getStyleClass().add((Object)"title-label");
                labelVBox.getChildren().add((Object)label);
                if (list.isHasSubtitle()) {
                    Label subtitleLabel = new Label();
                    subtitleLabel.textProperty().bind((ObservableValue)list.subtitleProperty());
                    subtitleLabel.getStyleClass().add((Object)"subtitle-label");
                    subtitleLabel.textFillProperty().bind(Themes.colorSchemeProperty().getOnSurfaceVariant());
                    labelVBox.getChildren().add((Object)subtitleLabel);
                }
            }
            HBox header = new HBox();
            header.setSpacing(16.0);
            header.getChildren().add((Object)labelVBox);
            header.setPadding(new Insets(10.0, 16.0, 10.0, 16.0));
            header.setAlignment(Pos.CENTER_LEFT);
            HBox.setHgrow((Node)labelVBox, (Priority)Priority.ALWAYS);
            if (list instanceof ComponentSublist && (rightNode = ((ComponentSublist)list).getHeaderRight()) != null) {
                header.getChildren().add((Object)rightNode);
            }
            header.getChildren().add((Object)expandIcon);
            RipplerContainer headerRippler = new RipplerContainer((Node)header);
            groupNode.getChildren().add((Object)headerRippler);
            VBox container = new VBox();
            boolean bl = hasPadding = !(list instanceof ComponentSublist) || (subList = (ComponentSublist)list).hasComponentPadding();
            if (hasPadding) {
                container.setPadding(new Insets(8.0, 16.0, 10.0, 16.0));
            }
            FXUtils.setLimitHeight((Region)container, 0.0);
            FXUtils.setOverflowHidden((Region)container);
            container.getChildren().setAll((Object[])new Node[]{this.content});
            groupNode.getChildren().add((Object)container);
            headerRippler.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
                boolean expanded;
                if (event.getButton() != MouseButton.PRIMARY) {
                    return;
                }
                event.consume();
                if (this.expandAnimation != null && this.expandAnimation.getStatus() == Animation.Status.RUNNING) {
                    this.expandAnimation.stop();
                }
                this.expanded = expanded = !this.expanded;
                if (expanded) {
                    list.doLazyInit();
                    list.layout();
                }
                Platform.runLater(() -> {
                    double targetRotate;
                    double newAnimatedHeight = (list.prefHeight(list.getWidth()) + (double)(hasPadding ? 18 : 4)) * (double)(expanded ? 1 : -1);
                    double contentHeight = expanded ? newAnimatedHeight : 0.0;
                    double d = targetRotate = expanded ? -180.0 : 0.0;
                    if (AnimationUtils.isAnimationEnabled()) {
                        double currentRotate = expandIcon.getRotate();
                        Duration duration = Motion.LONG2.multiply(Math.abs(currentRotate - targetRotate) / 180.0);
                        Interpolator interpolator = Motion.EASE_IN_OUT_CUBIC_EMPHASIZED;
                        this.expandAnimation = new Timeline(new KeyFrame[]{new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)container.minHeightProperty(), (Object)contentHeight, interpolator), new KeyValue((WritableValue)container.maxHeightProperty(), (Object)contentHeight, interpolator), new KeyValue((WritableValue)expandIcon.rotateProperty(), (Object)targetRotate, interpolator)})});
                        this.expandAnimation.play();
                    } else {
                        container.setMinHeight(contentHeight);
                        container.setMaxHeight(contentHeight);
                        expandIcon.setRotate(targetRotate);
                    }
                });
            });
            this.getChildren().setAll((Object[])new Node[]{groupNode});
        } else {
            this.getStyleClass().remove((Object)"no-padding");
            this.getChildren().setAll((Object[])new Node[]{this.content});
        }
    }
}

