/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download;

import java.net.URI;
import java.util.List;
import java.util.Objects;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.task.Task;

public final class DownloadProviderWrapper
implements DownloadProvider {
    private volatile DownloadProvider provider;

    public DownloadProviderWrapper(DownloadProvider provider) {
        this.provider = provider;
    }

    public DownloadProvider getProvider() {
        return this.provider;
    }

    public void setProvider(DownloadProvider provider) {
        this.provider = Objects.requireNonNull(provider);
    }

    @Override
    public List<URI> getAssetObjectCandidates(String assetObjectLocation) {
        return this.getProvider().getAssetObjectCandidates(assetObjectLocation);
    }

    @Override
    public List<URI> getVersionListURLs() {
        return this.getProvider().getVersionListURLs();
    }

    @Override
    public String injectURL(String baseURL) {
        return this.getProvider().injectURL(baseURL);
    }

    @Override
    public List<URI> injectURLWithCandidates(String baseURL) {
        return this.getProvider().injectURLWithCandidates(baseURL);
    }

    @Override
    public List<URI> injectURLsWithCandidates(List<String> urls) {
        return this.getProvider().injectURLsWithCandidates(urls);
    }

    @Override
    public VersionList<?> getVersionListById(final String id) {
        return new VersionList<RemoteVersion>(){

            @Override
            public boolean hasType() {
                return DownloadProviderWrapper.this.getProvider().getVersionListById(id).hasType();
            }

            @Override
            public Task<?> refreshAsync() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Task<?> refreshAsync(String gameVersion) {
                return DownloadProviderWrapper.this.getProvider().getVersionListById(id).refreshAsync(gameVersion).thenComposeAsync(() -> {
                    this.lock.writeLock().lock();
                    try {
                        this.versions.putAll(gameVersion, DownloadProviderWrapper.this.getProvider().getVersionListById(id).getVersions(gameVersion));
                    }
                    finally {
                        this.lock.writeLock().unlock();
                    }
                    return null;
                });
            }
        };
    }

    @Override
    public int getConcurrency() {
        return this.getProvider().getConcurrency();
    }

    public String toString() {
        return "DownloadProviderWrapper[provider=%s]".formatted(this.provider);
    }
}

