/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.task;

import com.google.gson.JsonParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import org.jackhuang.hmcl.task.CompletableFutureTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.task.TaskCompletableFuture;
import org.jackhuang.hmcl.task.TaskExecutor;
import org.jackhuang.hmcl.task.TaskListener;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.logging.Logger;

public final class AsyncTaskExecutor
extends TaskExecutor {
    private CompletableFuture<Boolean> future;
    private static Thread.UncaughtExceptionHandler uncaughtExceptionHandler = null;

    public AsyncTaskExecutor(Task<?> task) {
        super(task);
    }

    @Override
    public TaskExecutor start() {
        this.taskListeners.forEach(TaskListener::onStart);
        this.future = ((CompletableFuture)this.executeTasks(null, Collections.singleton(this.firstTask)).thenApplyAsync(exception -> {
            boolean success;
            boolean bl = success = exception == null;
            if (!success) {
                Logger.LOG.warning("An exception occurred in task execution", (Throwable)exception);
                Throwable resolvedException = Lang.resolveException(exception);
                if (resolvedException instanceof RuntimeException && !(resolvedException instanceof CancellationException) && !(resolvedException instanceof JsonParseException) && !(resolvedException instanceof RejectedExecutionException) && uncaughtExceptionHandler != null) {
                    uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), resolvedException);
                }
            }
            this.taskListeners.forEach(it -> it.onStop(success, this));
            return success;
        })).exceptionally(e -> {
            Lang.handleUncaughtException(Lang.resolveException(e));
            return false;
        });
        return this;
    }

    @Override
    public boolean test() {
        this.start();
        try {
            return this.future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
        }
        catch (CancellationException e) {
            Logger.LOG.info("Task " + String.valueOf(this.firstTask) + " has been cancelled.", e);
        }
        return false;
    }

    @Override
    public synchronized void cancel() {
        if (this.future == null) {
            throw new IllegalStateException("Cannot cancel a not started TaskExecutor");
        }
        this.cancelled = true;
    }

    private CompletableFuture<?> executeTasksExceptionally(Task<?> parentTask, Collection<? extends Task<?>> tasks) {
        if (tasks == null || tasks.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.completedFuture(null).thenComposeAsync(unused -> {
            if (this.isCancelled()) {
                for (Task task2 : tasks) {
                    task2.setException(new CancellationException());
                }
                return CompletableFuture.runAsync(this::checkCancellation);
            }
            return CompletableFuture.allOf((CompletableFuture[])tasks.stream().map(task -> CompletableFuture.completedFuture(null).thenComposeAsync(unused2 -> this.executeTask(parentTask, (Task)task))).toArray(CompletableFuture[]::new));
        });
    }

    private CompletableFuture<Exception> executeTasks(Task<?> parentTask, Collection<? extends Task<?>> tasks) {
        return ((CompletableFuture)this.executeTasksExceptionally(parentTask, tasks).thenApplyAsync(unused -> null)).exceptionally(throwable -> {
            Throwable resolved = Lang.resolveException(throwable);
            if (resolved instanceof Exception) {
                return (Exception)resolved;
            }
            throw new CompletionException((Throwable)throwable);
        });
    }

    private <T> CompletableFuture<T> executeCompletableFutureTask(Task<?> parentTask, final CompletableFutureTask<T> task) {
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.completedFuture(null).thenComposeAsync(unused -> {
            this.checkCancellation();
            task.setCancelled(this::isCancelled);
            task.setState(Task.TaskState.READY);
            if (parentTask != null && task.getStage() == null) {
                task.setStage(parentTask.getStage());
            }
            if (task.getSignificance().shouldLog()) {
                Logger.LOG.trace("Executing task: " + task.getName());
            }
            this.taskListeners.forEach(it -> it.onReady(task));
            return task.getFuture(new TaskCompletableFuture(){

                public <T2> CompletableFuture<T2> one(Task<T2> subtask) {
                    return AsyncTaskExecutor.this.executeTask(task, subtask);
                }

                @Override
                public CompletableFuture<?> all(Collection<Task<?>> tasks) {
                    return AsyncTaskExecutor.this.executeTasksExceptionally(task, tasks);
                }
            });
        })).thenApplyAsync(result -> {
            this.checkCancellation();
            if (task.getSignificance().shouldLog()) {
                Logger.LOG.trace("Task finished: " + task.getName());
            }
            task.setResult(result);
            task.fireDoneEvent(this, false);
            this.taskListeners.forEach(it -> it.onFinished(task));
            task.setState(Task.TaskState.SUCCEEDED);
            return result;
        })).exceptionally(throwable -> {
            Throwable resolved = Lang.resolveException(throwable);
            if (resolved instanceof Exception) {
                Exception e = (Exception)resolved;
                if (e instanceof InterruptedException || e instanceof CancellationException) {
                    task.setException(null);
                    if (task.getSignificance().shouldLog()) {
                        Logger.LOG.trace("Task aborted: " + task.getName());
                    }
                    task.fireDoneEvent(this, true);
                    this.taskListeners.forEach(it -> it.onFailed(task, e));
                } else {
                    task.setException(e);
                    this.exception = e;
                    if (task.getSignificance().shouldLog()) {
                        Logger.LOG.trace("Task failed: " + task.getName(), e);
                    }
                    task.fireDoneEvent(this, true);
                    this.taskListeners.forEach(it -> it.onFailed(task, e));
                }
                task.setState(Task.TaskState.FAILED);
            }
            throw new CompletionException(resolved);
        });
    }

    private <T> CompletableFuture<T> executeNormalTask(Task<?> parentTask, Task<T> task) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.completedFuture(null).thenComposeAsync(unused -> {
            this.checkCancellation();
            task.setCancelled(this::isCancelled);
            task.setState(Task.TaskState.READY);
            if (task.getStage() != null) {
                task.setInheritedStage(task.getStage());
            } else if (parentTask != null) {
                task.setInheritedStage(parentTask.getInheritedStage());
            }
            task.setNotifyPropertiesChanged(() -> this.taskListeners.forEach(it -> it.onPropertiesUpdate(task)));
            if (task.getSignificance().shouldLog()) {
                Logger.LOG.trace("Executing task: " + task.getName());
            }
            this.taskListeners.forEach(it -> it.onReady(task));
            if (task.doPreExecute()) {
                return CompletableFuture.runAsync(Lang.wrap(task::preExecute), task.getExecutor());
            }
            return CompletableFuture.completedFuture(null);
        })).thenComposeAsync(unused -> this.executeTasks(task, task.getDependents()))).thenComposeAsync(dependentsException -> {
            boolean isDependentsSucceeded;
            boolean bl = isDependentsSucceeded = dependentsException == null;
            if (isDependentsSucceeded) {
                task.setDependentsSucceeded();
            } else {
                task.setException((Exception)dependentsException);
                if (task.isRelyingOnDependents()) {
                    Lang.rethrow(dependentsException);
                }
            }
            return CompletableFuture.runAsync(Lang.wrap(() -> {
                task.setState(Task.TaskState.RUNNING);
                this.taskListeners.forEach(it -> it.onRunning(task));
                task.execute();
            }), task.getExecutor()).whenComplete((unused, throwable) -> {
                task.setState(Task.TaskState.EXECUTED);
                Lang.rethrow(throwable);
            });
        })).thenComposeAsync(unused -> this.executeTasks(task, task.getDependencies()))).thenComposeAsync(dependenciesException -> {
            boolean isDependenciesSucceeded;
            boolean bl = isDependenciesSucceeded = dependenciesException == null;
            if (isDependenciesSucceeded) {
                task.setDependenciesSucceeded();
            }
            if (task.doPostExecute()) {
                return CompletableFuture.runAsync(Lang.wrap(task::postExecute), task.getExecutor()).thenApply(unused -> dependenciesException);
            }
            return CompletableFuture.completedFuture(dependenciesException);
        })).thenApplyAsync(dependenciesException -> {
            boolean isDependenciesSucceeded;
            boolean bl = isDependenciesSucceeded = dependenciesException == null;
            if (!isDependenciesSucceeded) {
                Logger.LOG.error("Subtasks failed for " + task.getName());
                task.setException((Exception)dependenciesException);
                if (task.isRelyingOnDependencies()) {
                    Lang.rethrow(dependenciesException);
                }
            }
            this.checkCancellation();
            if (task.getSignificance().shouldLog()) {
                Logger.LOG.trace("Task finished: " + task.getName());
            }
            task.fireDoneEvent(this, false);
            this.taskListeners.forEach(it -> it.onFinished(task));
            task.setState(Task.TaskState.SUCCEEDED);
            return task.getResult();
        })).exceptionally(throwable -> {
            Throwable resolved = Lang.resolveException(throwable);
            if (resolved instanceof Exception) {
                Exception e = AsyncTaskExecutor.convertInterruptedException((Exception)resolved);
                task.setException(e);
                this.exception = e;
                if (e instanceof CancellationException) {
                    if (task.getSignificance().shouldLog()) {
                        Logger.LOG.trace("Task aborted: " + task.getName());
                    }
                } else if (task.getSignificance().shouldLog()) {
                    Logger.LOG.trace("Task failed: " + task.getName(), e);
                }
                task.fireDoneEvent(this, true);
                this.taskListeners.forEach(it -> it.onFailed(task, e));
                task.setState(Task.TaskState.FAILED);
            }
            throw new CompletionException(resolved);
        });
    }

    private <T> CompletableFuture<T> executeTask(Task<?> parentTask, Task<T> task) {
        if (task instanceof CompletableFutureTask) {
            CompletableFutureTask completableFutureTask = (CompletableFutureTask)task;
            return this.executeCompletableFutureTask(parentTask, completableFutureTask);
        }
        return this.executeNormalTask(parentTask, task);
    }

    private void checkCancellation() {
        if (this.isCancelled()) {
            throw new CancellationException("Cancelled by user");
        }
    }

    private static Exception convertInterruptedException(Exception e) {
        if (e instanceof InterruptedException) {
            return new CancellationException(e.getMessage());
        }
        return e;
    }

    public static void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        AsyncTaskExecutor.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }
}

