/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.account;

import com.jfoenix.controls.JFXPopup;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.stage.Window;
import org.jackhuang.hmcl.auth.Account;
import org.jackhuang.hmcl.setting.Accounts;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.account.AccountAdvancedListItem;
import org.jackhuang.hmcl.ui.construct.AdvancedListBox;
import org.jackhuang.hmcl.util.i18n.I18n;

public final class AccountListPopupMenu
extends StackPane {
    private final BooleanBinding isEmpty = Bindings.isEmpty(Accounts.getAccounts());
    private final InvalidationListener listener;

    public static void show(Node owner, JFXPopup.PopupVPosition vAlign, JFXPopup.PopupHPosition hAlign, double initOffsetX, double initOffsetY) {
        AccountListPopupMenu menu = new AccountListPopupMenu();
        JFXPopup popup = new JFXPopup((Region)menu);
        popup.show(owner, vAlign, hAlign, initOffsetX, initOffsetY);
    }

    public AccountListPopupMenu() {
        AdvancedListBox box = new AdvancedListBox();
        box.getStyleClass().add((Object)"no-padding");
        box.setPrefWidth(220.0);
        box.setPrefHeight(-1.0);
        box.setMaxHeight(260.0);
        this.listener = o -> {
            box.clear();
            for (Account account : Accounts.getAccounts()) {
                AccountAdvancedListItem item = new AccountAdvancedListItem(account);
                item.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> {
                    Accounts.setSelectedAccount(account);
                    Window patt0$temp = this.getScene().getWindow();
                    if (patt0$temp instanceof JFXPopup) {
                        JFXPopup popup = (JFXPopup)patt0$temp;
                        popup.hide();
                    }
                }));
                box.add((Node)item);
            }
        };
        this.listener.invalidated(null);
        Accounts.getAccounts().addListener((InvalidationListener)new WeakInvalidationListener(this.listener));
        Label placeholder = new Label(I18n.i18n("account.empty"));
        placeholder.setStyle("-fx-padding: 10px; -fx-text-fill: -monet-on-surface-variant; -fx-font-style: italic;");
        FXUtils.onChangeAndOperate(this.isEmpty, empty -> this.getChildren().setAll((Object[])new Node[]{empty != false ? placeholder : box}));
    }
}

