/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.AdvancedListItem;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;

public class AdvancedListItemSkin
extends SkinBase<AdvancedListItem> {
    private static final PseudoClass SELECTED = PseudoClass.getPseudoClass((String)"selected");

    public AdvancedListItemSkin(AdvancedListItem skinnable) {
        super((Control)skinnable);
        FXUtils.onChangeAndOperate(skinnable.activeProperty(), active -> skinnable.pseudoClassStateChanged(SELECTED, (boolean)active));
        BorderPane root = new BorderPane();
        root.getStyleClass().add((Object)"container");
        root.setPickOnBounds(false);
        RipplerContainer container = new RipplerContainer((Node)root);
        HBox left = new HBox();
        left.setAlignment(Pos.CENTER_LEFT);
        left.setMouseTransparent(true);
        TwoLineListItem item = new TwoLineListItem();
        root.setCenter((Node)item);
        item.setMouseTransparent(true);
        item.titleProperty().bind((ObservableValue)skinnable.titleProperty());
        item.subtitleProperty().bind((ObservableValue)skinnable.subtitleProperty());
        FXUtils.onChangeAndOperate(skinnable.leftGraphicProperty(), newGraphic -> {
            if (newGraphic == null) {
                left.getChildren().clear();
            } else {
                left.getChildren().setAll((Object[])new Node[]{newGraphic});
            }
        });
        root.setLeft((Node)left);
        HBox right = new HBox();
        right.setAlignment(Pos.CENTER);
        right.getStyleClass().add((Object)"toggle-icon4");
        FXUtils.setLimitWidth((Region)right, 40.0);
        FXUtils.onChangeAndOperate(skinnable.rightGraphicProperty(), newGraphic -> {
            if (newGraphic == null) {
                right.getChildren().clear();
            } else {
                right.getChildren().setAll((Object[])new Node[]{newGraphic});
            }
        });
        FXUtils.onChangeAndOperate(skinnable.actionButtonVisibleProperty(), visible -> root.setRight((Node)(visible != false ? right : null)));
        this.getChildren().setAll((Object[])new Node[]{container});
    }
}

