/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.download;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.JFXSpinner;
import com.jfoenix.controls.JFXTextField;
import java.util.Collection;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.download.cleanroom.CleanroomRemoteVersion;
import org.jackhuang.hmcl.download.fabric.FabricAPIRemoteVersion;
import org.jackhuang.hmcl.download.fabric.FabricRemoteVersion;
import org.jackhuang.hmcl.download.forge.ForgeRemoteVersion;
import org.jackhuang.hmcl.download.game.GameRemoteVersion;
import org.jackhuang.hmcl.download.legacyfabric.LegacyFabricAPIRemoteVersion;
import org.jackhuang.hmcl.download.legacyfabric.LegacyFabricRemoteVersion;
import org.jackhuang.hmcl.download.liteloader.LiteLoaderRemoteVersion;
import org.jackhuang.hmcl.download.neoforge.NeoForgeRemoteVersion;
import org.jackhuang.hmcl.download.optifine.OptiFineRemoteVersion;
import org.jackhuang.hmcl.download.quilt.QuiltAPIRemoteVersion;
import org.jackhuang.hmcl.download.quilt.QuiltRemoteVersion;
import org.jackhuang.hmcl.setting.VersionIconType;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.animation.TransitionPane;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.wizard.Navigation;
import org.jackhuang.hmcl.ui.wizard.Refreshable;
import org.jackhuang.hmcl.ui.wizard.WizardPage;
import org.jackhuang.hmcl.util.NativePatcher;
import org.jackhuang.hmcl.util.SettingsMap;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.Platform;
import org.jackhuang.hmcl.util.versioning.GameVersionNumber;

public final class VersionsPage
extends Control
implements WizardPage,
Refreshable {
    private final String gameVersion;
    private final String libraryId;
    private final String title;
    private final Navigation navigation;
    private final DownloadProvider downloadProvider;
    private final VersionList<?> versionList;
    private final Runnable callback;
    private final ObservableList<RemoteVersion> versions = FXCollections.observableArrayList();
    private final ObjectProperty<Status> status = new SimpleObjectProperty((Object)Status.LOADING);

    public VersionsPage(Navigation navigation, String title, String gameVersion, DownloadProvider downloadProvider, String libraryId, Runnable callback) {
        this.title = title;
        this.gameVersion = gameVersion;
        this.libraryId = libraryId;
        this.navigation = navigation;
        this.downloadProvider = downloadProvider;
        this.versionList = downloadProvider.getVersionListById(libraryId);
        this.callback = callback;
        this.refresh();
    }

    protected Skin<?> createDefaultSkin() {
        return new VersionsPageSkin(this);
    }

    @Override
    public void refresh() {
        this.status.set((Object)Status.LOADING);
        Task<Void> task = this.versionList.refreshAsync(this.gameVersion).thenSupplyAsync(() -> this.versionList.getVersions(this.gameVersion).stream().sorted().collect(Collectors.toList())).whenComplete(Schedulers.javafx(), (items, exception) -> {
            if (exception == null) {
                this.versions.setAll((Collection)items);
                this.status.set((Object)Status.SUCCESS);
            } else {
                Logger.LOG.warning("Failed to fetch versions list", exception);
                this.status.set((Object)Status.FAILED);
            }
        });
        task.start();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void cleanup(SettingsMap settings) {
        settings.remove(this.libraryId);
    }

    private void onRefresh() {
        this.refresh();
    }

    private void onBack() {
        this.navigation.onPrev(true);
    }

    private static enum Status {
        LOADING,
        FAILED,
        SUCCESS;

    }

    private static final class VersionsPageSkin
    extends SkinBase<VersionsPage> {
        private final JFXListView<RemoteVersion> list;
        private final TransitionPane transitionPane;
        private final JFXSpinner spinner;
        private final JFXTextField nameField;
        private final JFXComboBox<VersionTypeFilter> categoryField = new JFXComboBox();

        VersionsPageSkin(VersionsPage control) {
            super((Control)control);
            BorderPane root = new BorderPane();
            GridPane searchPane = new GridPane();
            root.setTop((Node)searchPane);
            searchPane.getStyleClass().addAll((Object[])new String[]{"card"});
            BorderPane.setMargin((Node)searchPane, (Insets)new Insets(10.0, 10.0, 0.0, 10.0));
            ColumnConstraints nameColumn = new ColumnConstraints();
            nameColumn.setMinWidth(Double.NEGATIVE_INFINITY);
            ColumnConstraints column1 = new ColumnConstraints();
            column1.setHgrow(Priority.ALWAYS);
            ColumnConstraints column2 = new ColumnConstraints();
            column2.setMaxWidth(150.0);
            ColumnConstraints column3 = new ColumnConstraints();
            if (control.versionList.hasType()) {
                searchPane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{nameColumn, column1, nameColumn, column2, column3});
            } else {
                searchPane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{nameColumn, column1, column3});
            }
            searchPane.setHgap(16.0);
            searchPane.setVgap(10.0);
            int rowIndex = 0;
            this.nameField = new JFXTextField();
            this.nameField.setPromptText(I18n.i18n("version.search.prompt"));
            this.nameField.textProperty().addListener(o -> this.updateList());
            if ("game".equals(control.libraryId)) {
                this.categoryField.getItems().setAll((Object[])new VersionTypeFilter[]{VersionTypeFilter.ALL, VersionTypeFilter.RELEASE, VersionTypeFilter.SNAPSHOTS, VersionTypeFilter.APRIL_FOOLS, VersionTypeFilter.OLD});
                this.categoryField.getSelectionModel().select((Object)VersionTypeFilter.RELEASE);
            } else {
                this.categoryField.getItems().setAll((Object[])new VersionTypeFilter[]{VersionTypeFilter.ALL, VersionTypeFilter.RELEASE, VersionTypeFilter.SNAPSHOTS});
                this.categoryField.getSelectionModel().select((Object)VersionTypeFilter.ALL);
            }
            this.categoryField.setConverter(FXUtils.stringConverter(type -> I18n.i18n("version.game." + type.name().toLowerCase(Locale.ROOT))));
            this.categoryField.getSelectionModel().selectedItemProperty().addListener(o -> this.updateList());
            JFXButton refreshButton = FXUtils.newRaisedButton(I18n.i18n("button.refresh"));
            refreshButton.setOnAction(event -> control.onRefresh());
            if (control.versionList.hasType()) {
                searchPane.addRow(rowIndex++, new Node[]{new Label(I18n.i18n("version.search")), this.nameField, new Label(I18n.i18n("version.game.type")), this.categoryField, refreshButton});
            } else {
                searchPane.addRow(rowIndex++, new Node[]{new Label(I18n.i18n("version.search")), this.nameField, refreshButton});
            }
            SpinnerPane spinnerPane = new SpinnerPane();
            root.setCenter((Node)spinnerPane);
            this.transitionPane = new TransitionPane();
            this.spinner = new JFXSpinner();
            StackPane centerWrapper = new StackPane();
            centerWrapper.setStyle("-fx-padding: 10;");
            ComponentList centrePane = new ComponentList();
            centrePane.getStyleClass().add((Object)"no-padding");
            this.list = new JFXListView();
            this.list.getStyleClass().add((Object)"jfx-list-view-float");
            VBox.setVgrow(this.list, (Priority)Priority.ALWAYS);
            control.versions.addListener(o -> this.updateList());
            this.list.setCellFactory(listView -> new RemoteVersionListCell(control));
            ComponentList.setVgrow(this.list, Priority.ALWAYS);
            FXUtils.ignoreEvent(this.list, KeyEvent.KEY_PRESSED, e -> e.getCode() == KeyCode.ESCAPE);
            centrePane.getContent().setAll((Object[])new Node[]{this.list});
            centerWrapper.getChildren().setAll((Object[])new Node[]{centrePane});
            StackPane failedPane = new StackPane();
            failedPane.getStyleClass().add((Object)"notice-pane");
            Label label = new Label(I18n.i18n("download.failed.refresh"));
            FXUtils.onClicked((Node)label, control::onRefresh);
            failedPane.getChildren().setAll((Object[])new Node[]{label});
            StackPane emptyPane = new StackPane();
            emptyPane.getStyleClass().add((Object)"notice-pane");
            Label label2 = new Label(I18n.i18n("download.failed.empty"));
            FXUtils.onClicked((Node)label2, control::onBack);
            emptyPane.getChildren().setAll((Object[])new Node[]{label2});
            FXUtils.onChangeAndOperate(control.status, status -> {
                if (status == Status.LOADING) {
                    this.transitionPane.setContent((Node)this.spinner, ContainerAnimations.FADE);
                } else if (status == Status.SUCCESS) {
                    this.transitionPane.setContent((Node)centerWrapper, ContainerAnimations.FADE);
                } else {
                    this.transitionPane.setContent((Node)failedPane, ContainerAnimations.FADE);
                }
            });
            root.setCenter((Node)this.transitionPane);
            this.getChildren().setAll((Object[])new Node[]{root});
        }

        private void updateList() {
            String nameQuery;
            Stream<RemoteVersion> versions = ((VersionsPage)this.getSkinnable()).versions.stream();
            VersionTypeFilter filter = (VersionTypeFilter)((Object)this.categoryField.getSelectionModel().getSelectedItem());
            if (filter != null) {
                versions = versions.filter(it -> {
                    RemoteVersion.Type versionType = it.getVersionType();
                    return switch (filter.ordinal()) {
                        case 1 -> {
                            if (versionType == RemoteVersion.Type.RELEASE) {
                                yield true;
                            }
                            yield false;
                        }
                        case 2 -> {
                            if (versionType == RemoteVersion.Type.SNAPSHOT || versionType == RemoteVersion.Type.PENDING || versionType == RemoteVersion.Type.UNOBFUSCATED) {
                                yield true;
                            }
                            yield false;
                        }
                        case 3 -> {
                            if (versionType == RemoteVersion.Type.SNAPSHOT && GameVersionNumber.asGameVersion(it.getGameVersion()).isAprilFools()) {
                                yield true;
                            }
                            yield false;
                        }
                        case 4 -> {
                            if (versionType == RemoteVersion.Type.OLD) {
                                yield true;
                            }
                            yield false;
                        }
                        default -> true;
                    };
                });
            }
            if (!StringUtils.isBlank(nameQuery = this.nameField.getText())) {
                if (nameQuery.startsWith("regex:")) {
                    try {
                        Pattern pattern = Pattern.compile(nameQuery.substring("regex:".length()));
                        versions = versions.filter(it -> pattern.matcher(it.getSelfVersion()).find());
                    }
                    catch (Throwable e) {
                        Logger.LOG.warning("Illegal regular expression: " + nameQuery, e);
                    }
                } else {
                    String lowerQueryString = nameQuery.toLowerCase(Locale.ROOT);
                    versions = versions.filter(it -> it.getSelfVersion().toLowerCase(Locale.ROOT).contains(lowerQueryString));
                }
            }
            this.list.getItems().setAll((Collection)versions.collect(Collectors.toList()));
            this.list.scrollTo(0);
        }
    }

    private static class RemoteVersionListCell
    extends ListCell<RemoteVersion> {
        private final VersionsPage control;
        private final TwoLineListItem twoLineListItem = new TwoLineListItem();
        private final ImageView imageView = new ImageView();
        private final StackPane pane = new StackPane();

        RemoteVersionListCell(VersionsPage control) {
            this.control = control;
            HBox hbox = new HBox(16.0);
            HBox.setHgrow((Node)this.twoLineListItem, (Priority)Priority.ALWAYS);
            hbox.setAlignment(Pos.CENTER);
            HBox actions = new HBox(8.0);
            actions.setAlignment(Pos.CENTER);
            if ("game".equals(control.libraryId)) {
                JFXButton wikiButton = FXUtils.newToggleButton4(SVG.GLOBE_BOOK);
                wikiButton.setOnAction(event -> this.onOpenWiki());
                FXUtils.installFastTooltip((Node)wikiButton, I18n.i18n("wiki.tooltip"));
                actions.getChildren().add((Object)wikiButton);
            }
            JFXButton actionButton = FXUtils.newToggleButton4(SVG.ARROW_FORWARD);
            actionButton.setOnAction(e -> this.onAction());
            actions.getChildren().add((Object)actionButton);
            hbox.getChildren().setAll((Object[])new Node[]{this.imageView, this.twoLineListItem, actions});
            this.pane.getStyleClass().add((Object)"md-list-cell");
            StackPane.setMargin((Node)hbox, (Insets)new Insets(10.0, 16.0, 10.0, 16.0));
            this.pane.getChildren().setAll((Object[])new Node[]{new RipplerContainer((Node)hbox)});
            FXUtils.onClicked((Node)this, this::onAction);
        }

        private void onAction() {
            RemoteVersion item = (RemoteVersion)this.getItem();
            if (item == null) {
                return;
            }
            this.control.navigation.getSettings().put(this.control.libraryId, item);
            this.control.callback.run();
        }

        private void onOpenWiki() {
            RemoteVersion item = (RemoteVersion)this.getItem();
            if (!(item instanceof GameRemoteVersion)) {
                return;
            }
            FXUtils.openLink(I18n.getWikiLink((GameRemoteVersion)item));
        }

        public void updateItem(RemoteVersion remoteVersion, boolean empty) {
            super.updateItem((Object)remoteVersion, empty);
            if (empty) {
                this.setGraphic(null);
                return;
            }
            this.setGraphic((Node)this.pane);
            this.twoLineListItem.setTitle(I18n.getDisplayVersion(remoteVersion));
            if (remoteVersion.getReleaseDate() != null) {
                this.twoLineListItem.setSubtitle(I18n.formatDateTime(remoteVersion.getReleaseDate()));
            } else {
                this.twoLineListItem.setSubtitle(null);
            }
            this.twoLineListItem.getTags().clear();
            if (remoteVersion instanceof GameRemoteVersion) {
                RemoteVersion.Type versionType = remoteVersion.getVersionType();
                GameVersionNumber gameVersion = GameVersionNumber.asGameVersion(remoteVersion.getGameVersion());
                switch (versionType) {
                    case RELEASE: {
                        this.twoLineListItem.addTag(I18n.i18n("version.game.release"));
                        this.imageView.setImage(VersionIconType.GRASS.getIcon());
                        break;
                    }
                    case SNAPSHOT: 
                    case PENDING: 
                    case UNOBFUSCATED: {
                        if (versionType == RemoteVersion.Type.SNAPSHOT && GameVersionNumber.asGameVersion(remoteVersion.getGameVersion()).isAprilFools()) {
                            this.twoLineListItem.addTag(I18n.i18n("version.game.april_fools"));
                            this.imageView.setImage(VersionIconType.APRIL_FOOLS.getIcon());
                            break;
                        }
                        this.twoLineListItem.addTag(I18n.i18n("version.game.snapshot"));
                        this.imageView.setImage(VersionIconType.COMMAND.getIcon());
                        break;
                    }
                    default: {
                        this.twoLineListItem.addTag(I18n.i18n("version.game.old"));
                        this.imageView.setImage(VersionIconType.CRAFT_TABLE.getIcon());
                    }
                }
                switch (NativePatcher.checkSupportedStatus(gameVersion, Platform.SYSTEM_PLATFORM, OperatingSystem.SYSTEM_VERSION)) {
                    case UNTESTED: {
                        this.twoLineListItem.addTagWarning(I18n.i18n("version.game.support_status.untested"));
                        break;
                    }
                    case UNSUPPORTED: {
                        this.twoLineListItem.addTagWarning(I18n.i18n("version.game.support_status.unsupported"));
                    }
                }
            } else {
                VersionIconType iconType = remoteVersion instanceof LiteLoaderRemoteVersion ? VersionIconType.CHICKEN : (remoteVersion instanceof OptiFineRemoteVersion ? VersionIconType.OPTIFINE : (remoteVersion instanceof ForgeRemoteVersion ? VersionIconType.FORGE : (remoteVersion instanceof CleanroomRemoteVersion ? VersionIconType.CLEANROOM : (remoteVersion instanceof NeoForgeRemoteVersion ? VersionIconType.NEO_FORGE : (remoteVersion instanceof LegacyFabricRemoteVersion || remoteVersion instanceof LegacyFabricAPIRemoteVersion ? VersionIconType.LEGACY_FABRIC : (remoteVersion instanceof FabricRemoteVersion || remoteVersion instanceof FabricAPIRemoteVersion ? VersionIconType.FABRIC : (remoteVersion instanceof QuiltRemoteVersion || remoteVersion instanceof QuiltAPIRemoteVersion ? VersionIconType.QUILT : VersionIconType.COMMAND)))))));
                this.imageView.setImage(iconType.getIcon());
                if (this.twoLineListItem.getSubtitle() == null) {
                    this.twoLineListItem.setSubtitle(remoteVersion.getGameVersion());
                } else {
                    this.twoLineListItem.addTag(remoteVersion.getGameVersion());
                }
            }
        }
    }

    private static enum VersionTypeFilter {
        ALL,
        RELEASE,
        SNAPSHOTS,
        APRIL_FOOLS,
        OLD;

    }
}

