/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.github.steveice10.opennbt.tag.builtin.ByteTag;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.DoubleTag;
import com.github.steveice10.opennbt.tag.builtin.FloatTag;
import com.github.steveice10.opennbt.tag.builtin.IntArrayTag;
import com.github.steveice10.opennbt.tag.builtin.IntTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.LongTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXTextField;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Consumer;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.ScrollPane;
import javafx.scene.effect.BoxBlur;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.game.World;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.DoubleValidator;
import org.jackhuang.hmcl.ui.construct.LinePane;
import org.jackhuang.hmcl.ui.construct.LineSelectButton;
import org.jackhuang.hmcl.ui.construct.LineTextPane;
import org.jackhuang.hmcl.ui.construct.LineToggleButton;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.NumberValidator;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.ui.versions.WorldManagePage;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;

public final class WorldInfoPage
extends SpinnerPane
implements WorldManagePage.WorldRefreshable {
    private final WorldManagePage worldManagePage;
    private boolean isReadOnly;
    private final World world;
    private CompoundTag levelDat;
    ImageView iconImageView = new ImageView();

    public WorldInfoPage(WorldManagePage worldManagePage) {
        this.worldManagePage = worldManagePage;
        this.world = worldManagePage.getWorld();
        this.refresh();
    }

    private CompoundTag loadWorldInfo() throws IOException {
        if (!Files.isDirectory(this.world.getFile(), new LinkOption[0])) {
            throw new IOException("Not a valid world directory");
        }
        return this.world.getLevelData();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void updateControls() {
        block28: {
            block27: {
                block26: {
                    dataTag = (CompoundTag)this.levelDat.get("Data");
                    scrollPane = new ScrollPane();
                    scrollPane.setFitToHeight(true);
                    scrollPane.setFitToWidth(true);
                    scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.ALWAYS);
                    this.setContent((Node)scrollPane);
                    rootPane = new VBox();
                    rootPane.setFillWidth(true);
                    scrollPane.setContent((Node)rootPane);
                    FXUtils.smoothScrolling(scrollPane);
                    rootPane.getStyleClass().add((Object)"card-list");
                    worldInfo = new ComponentList();
                    worldNamePane = new LinePane();
                    worldNamePane.setTitle(I18n.i18n("world.name"));
                    worldNameField = new JFXTextField();
                    this.setRightTextField((BorderPane)worldNamePane, worldNameField, 200);
                    var8_7 = dataTag.get("LevelName");
                    if (var8_7 instanceof StringTag) {
                        worldNameTag = (StringTag)var8_7;
                        worldName = new SimpleStringProperty(worldNameTag.getValue());
                        FXUtils.bindString(worldNameField, (Property<String>)worldName);
                        worldNameField.getProperties().put((Object)(WorldInfoPage.class.getName() + ".worldNameProperty"), (Object)worldName);
                        worldName.addListener((ChangeListener)LambdaMetafactory.metafactory(null, null, null, (Ljavafx/beans/value/ObservableValue;Ljava/lang/Object;Ljava/lang/Object;)V, lambda$updateControls$0(javafx.beans.value.ObservableValue java.lang.String java.lang.String ), (Ljavafx/beans/value/ObservableValue;Ljava/lang/String;Ljava/lang/String;)V)((WorldInfoPage)this));
                    } else {
                        worldNameField.setDisable(true);
                    }
                    gameVersionPane /* !! */  = new LineTextPane();
                    gameVersionPane /* !! */ .setTitle(I18n.i18n("world.info.game_version"));
                    gameVersionPane /* !! */ .setText(this.world.getGameVersion() == null ? "" : this.world.getGameVersion().toNormalizedString());
                    iconPane = new LinePane();
                    iconPane.setTitle(I18n.i18n("world.icon"));
                    FXUtils.limitSize(this.iconImageView, 32.0, 32.0);
                    this.iconImageView.setImage(this.world.getIcon() == null ? FXUtils.newBuiltinImage("/assets/img/unknown_server.png") : this.world.getIcon());
                    editIconButton = new JFXButton();
                    resetIconButton = new JFXButton();
                    editIconButton.setGraphic(SVG.EDIT.createIcon(20.0));
                    editIconButton.setDisable(this.isReadOnly);
                    editIconButton.setOnAction((EventHandler)LambdaMetafactory.metafactory(null, null, null, (Ljavafx/event/Event;)V, lambda$updateControls$1(javafx.event.ActionEvent ), (Ljavafx/event/ActionEvent;)V)((WorldInfoPage)this));
                    FXUtils.installFastTooltip((Node)editIconButton, I18n.i18n("button.edit"));
                    editIconButton.getStyleClass().add((Object)"toggle-icon4");
                    resetIconButton.setGraphic(SVG.RESTORE.createIcon(20.0));
                    resetIconButton.setDisable(this.isReadOnly);
                    resetIconButton.setOnAction((EventHandler)LambdaMetafactory.metafactory(null, null, null, (Ljavafx/event/Event;)V, lambda$updateControls$2(javafx.event.ActionEvent ), (Ljavafx/event/ActionEvent;)V)((WorldInfoPage)this));
                    FXUtils.installFastTooltip((Node)resetIconButton, I18n.i18n("button.reset"));
                    resetIconButton.getStyleClass().add((Object)"toggle-icon4");
                    hBox = new HBox(8.0);
                    hBox.setAlignment(Pos.CENTER_LEFT);
                    hBox.getChildren().addAll((Object[])new Node[]{this.iconImageView, editIconButton, resetIconButton});
                    iconPane.setRight((Node)hBox);
                    seedPane = new LinePane();
                    seedPane.setTitle(I18n.i18n("world.info.random_seed"));
                    visibility = new SimpleBooleanProperty();
                    visibilityButton = new StackPane();
                    visibilityButton.setCursor(Cursor.HAND);
                    visibilityButton.setAlignment(Pos.CENTER_RIGHT);
                    FXUtils.onClicked((Node)visibilityButton, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$updateControls$3(javafx.beans.property.SimpleBooleanProperty ), ()V)((SimpleBooleanProperty)visibility));
                    seedLabel = new Label();
                    FXUtils.copyOnDoubleClick((Labeled)seedLabel);
                    seedLabel.setAlignment(Pos.CENTER_RIGHT);
                    seedLabel.setText(this.world.getSeed() != null ? this.world.getSeed().toString() : "");
                    blur = new BoxBlur();
                    blur.setIterations(3);
                    FXUtils.onChangeAndOperate(visibility, (Consumer<Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$updateControls$4(javafx.scene.layout.StackPane javafx.scene.control.Label javafx.scene.effect.BoxBlur java.lang.Boolean ), (Ljava/lang/Boolean;)V)((StackPane)visibilityButton, (Label)seedLabel, (BoxBlur)blur));
                    right = new HBox(8.0);
                    right.setAlignment(Pos.CENTER_RIGHT);
                    BorderPane.setAlignment((Node)right, (Pos)Pos.CENTER_RIGHT);
                    right.getChildren().setAll((Object[])new Node[]{visibilityButton, seedLabel});
                    seedPane.setRight((Node)right);
                    worldSpawnPoint = new LineTextPane();
                    worldSpawnPoint.setTitle(I18n.i18n("world.info.spawn"));
                    var16_13 = dataTag.get("spawn");
                    if (!(var16_13 instanceof CompoundTag) || !((var16_13 = (spawnTag = (CompoundTag)var16_13).get("pos")) instanceof IntArrayTag)) break block26;
                    posTag = (IntArrayTag)var16_13;
                    var17_14 = spawnTag.get("dimension");
                    if (var17_14 instanceof StringTag) {
                        dimensionTag /* !! */  = (StringTag)var17_14;
                        v0 /* !! */  = dimensionTag /* !! */ ;
                    } else {
                        v0 /* !! */  = new StringTag("SpawnDimension", "minecraft:overworld");
                    }
                    value = Dimension.of(v0 /* !! */ ).formatPosition(posTag);
                    break block27;
                }
                dimensionTag /* !! */  = dataTag.get("SpawnX");
                if (!(dimensionTag /* !! */  instanceof IntTag)) ** GOTO lbl-1000
                intX /* !! */  = (IntTag)dimensionTag /* !! */ ;
                dimensionTag /* !! */  = dataTag.get("SpawnY");
                if (!(dimensionTag /* !! */  instanceof IntTag)) ** GOTO lbl-1000
                intY = (IntTag)dimensionTag /* !! */ ;
                dimensionTag /* !! */  = dataTag.get("SpawnZ");
                if (dimensionTag /* !! */  instanceof IntTag) {
                    intZ = (IntTag)dimensionTag /* !! */ ;
                    value = Dimension.OVERWORLD.formatPosition(intX /* !! */ .getValue(), intY.getValue(), intZ.getValue());
                } else lbl-1000:
                // 3 sources

                {
                    value = null;
                }
            }
            worldSpawnPoint.setText(value);
            lastPlayedPane /* !! */  = new LineTextPane();
            lastPlayedPane /* !! */ .setTitle(I18n.i18n("world.info.last_played"));
            lastPlayedPane /* !! */ .setText(I18n.formatDateTime(Instant.ofEpochMilli(this.world.getLastPlayed())));
            timePane = new LineTextPane();
            timePane.setTitle(I18n.i18n("world.info.time"));
            intX /* !! */  = dataTag.get("Time");
            if (intX /* !! */  instanceof LongTag) {
                timeTag = (LongTag)intX /* !! */ ;
                duration = Duration.ofSeconds(timeTag.getValue() / 20L);
                timePane.setText(I18n.i18n("world.info.time.format", new Object[]{duration.toDays(), duration.toHoursPart(), duration.toMinutesPart()}));
            }
            allowCheatsButton /* !! */  = new LineToggleButton();
            allowCheatsButton /* !! */ .setTitle(I18n.i18n("world.info.allow_cheats"));
            allowCheatsButton /* !! */ .setDisable(this.isReadOnly);
            this.bindTagAndToggleButton((Tag)dataTag.get("allowCommands"), allowCheatsButton /* !! */ );
            generateFeaturesButton = new LineToggleButton();
            generateFeaturesButton.setTitle(I18n.i18n("world.info.generate_features"));
            generateFeaturesButton.setDisable(this.isReadOnly);
            intZ = dataTag.get("WorldGenSettings");
            if (intZ instanceof CompoundTag) {
                worldGenSettings = (CompoundTag)intZ;
                this.bindTagAndToggleButton((Tag)worldGenSettings.get("generate_features"), generateFeaturesButton);
            } else {
                this.bindTagAndToggleButton((Tag)dataTag.get("MapFeatures"), generateFeaturesButton);
            }
            difficultyButton = new LineSelectButton<T>();
            difficultyButton.setTitle(I18n.i18n("world.info.difficulty"));
            difficultyButton.setDisable(this.worldManagePage.isReadOnly());
            difficultyButton.setItems(Difficulty.items);
            dimensionTag /* !! */  = dataTag.get("Difficulty");
            if (dimensionTag /* !! */  instanceof ByteTag) {
                difficultyTag = (ByteTag)dimensionTag /* !! */ ;
                difficulty /* !! */  = Difficulty.of(difficultyTag.getValue().byteValue());
                if (difficulty /* !! */  != null) {
                    difficultyButton.setValue(difficulty /* !! */ );
                    difficultyButton.valueProperty().addListener((ChangeListener)LambdaMetafactory.metafactory(null, null, null, (Ljavafx/beans/value/ObservableValue;Ljava/lang/Object;Ljava/lang/Object;)V, lambda$updateControls$5(com.github.steveice10.opennbt.tag.builtin.ByteTag javafx.beans.value.ObservableValue org.jackhuang.hmcl.ui.versions.WorldInfoPage$Difficulty org.jackhuang.hmcl.ui.versions.WorldInfoPage$Difficulty ), (Ljavafx/beans/value/ObservableValue;Lorg/jackhuang/hmcl/ui/versions/WorldInfoPage$Difficulty;Lorg/jackhuang/hmcl/ui/versions/WorldInfoPage$Difficulty;)V)((WorldInfoPage)this, (ByteTag)difficultyTag));
                } else {
                    difficultyButton.setDisable(true);
                }
            } else {
                difficultyButton.setDisable(true);
            }
            difficultyLockPane = new LineToggleButton();
            difficultyLockPane.setTitle(I18n.i18n("world.info.difficulty_lock"));
            difficultyLockPane.setDisable(this.isReadOnly);
            this.bindTagAndToggleButton((Tag)dataTag.get("DifficultyLocked"), difficultyLockPane);
            worldInfo.getContent().setAll((Object[])new Node[]{worldNamePane, gameVersionPane /* !! */ , iconPane, seedPane, worldSpawnPoint, lastPlayedPane /* !! */ , timePane, allowCheatsButton /* !! */ , generateFeaturesButton, difficultyButton, difficultyLockPane});
            rootPane.getChildren().addAll((Object[])new Node[]{ComponentList.createComponentListTitle(I18n.i18n("world.info")), worldInfo});
            gameVersionPane /* !! */  = dataTag.get("Player");
            if (!(gameVersionPane /* !! */  instanceof CompoundTag)) break block28;
            playerTag = (CompoundTag)gameVersionPane /* !! */ ;
            playerInfo = new ComponentList();
            locationPane = new LineTextPane();
            locationPane.setTitle(I18n.i18n("world.info.player.location"));
            dimension = Dimension.of(playerTag.get("Dimension"));
            if (dimension != null && (lastPlayedPane /* !! */  = playerTag.get("Pos")) instanceof ListTag) {
                posTag = (ListTag)lastPlayedPane /* !! */ ;
                locationPane.setText(dimension.formatPosition(posTag));
            }
            lastDeathLocationPane = new LineTextPane();
            lastDeathLocationPane.setTitle(I18n.i18n("world.info.player.last_death_location"));
            lastPlayedPane /* !! */  = playerTag.get("LastDeathLocation");
            if (lastPlayedPane /* !! */  instanceof CompoundTag && (dimension = Dimension.of((LastDeathLocationTag = (CompoundTag)lastPlayedPane /* !! */ ).get("dimension"))) != null && (allowCheatsButton /* !! */  = LastDeathLocationTag.get("pos")) instanceof IntArrayTag) {
                posTag = (IntArrayTag)allowCheatsButton /* !! */ ;
                lastDeathLocationPane.setText(dimension.formatPosition(posTag));
            }
            spawnPane = new LineTextPane();
            spawnPane.setTitle(I18n.i18n("world.info.player.spawn"));
            difficulty /* !! */  = playerTag.get("respawn");
            if (!(difficulty /* !! */  instanceof CompoundTag) || !((difficulty /* !! */  = (respawnTag = (CompoundTag)difficulty /* !! */ ).get("dimension")) instanceof StringTag)) ** GOTO lbl-1000
            dimensionTag = (StringTag)difficulty /* !! */ ;
            difficulty /* !! */  = respawnTag.get("pos");
            if (difficulty /* !! */  instanceof IntArrayTag && (intArrayTag = (IntArrayTag)difficulty /* !! */ ).length() >= 3) {
                spawnPane.setText(Dimension.of(dimensionTag).formatPosition(intArrayTag));
            } else if ((difficulty /* !! */  = playerTag.get("SpawnX")) instanceof IntTag) {
                intX /* !! */  = (IntTag)difficulty /* !! */ ;
                difficulty /* !! */  = playerTag.get("SpawnY");
                if (difficulty /* !! */  instanceof IntTag) {
                    intY = (IntTag)difficulty /* !! */ ;
                    difficulty /* !! */  = playerTag.get("SpawnZ");
                    if (difficulty /* !! */  instanceof IntTag) {
                        intZ = (IntTag)difficulty /* !! */ ;
                        var17_14 = playerTag.get("SpawnDimension");
                        if (var17_14 instanceof StringTag) {
                            dimensionTag /* !! */  = (StringTag)var17_14;
                            v1 = Dimension.of(dimensionTag /* !! */ );
                        } else {
                            v1 = Dimension.OVERWORLD;
                        }
                        spawnPane.setText(v1.formatPosition(intX /* !! */ .getValue(), intY.getValue(), intZ.getValue()));
                    }
                }
            }
            playerGameTypePane = new LineSelectButton<T>();
            playerGameTypePane.setTitle(I18n.i18n("world.info.player.game_type"));
            playerGameTypePane.setDisable(this.worldManagePage.isReadOnly());
            playerGameTypePane.setItems(GameType.items);
            intX /* !! */  = playerTag.get("playerGameType");
            if (!(intX /* !! */  instanceof IntTag)) ** GOTO lbl-1000
            playerGameTypeTag = intX /* !! */ ;
            intX /* !! */  = dataTag.get("hardcore");
            if (intX /* !! */  instanceof ByteTag) {
                hardcoreTag = (ByteTag)intX /* !! */ ;
                isHardcore = hardcoreTag.getValue() == 1;
                gameType = GameType.of(playerGameTypeTag.getValue(), isHardcore);
                if (gameType != null) {
                    playerGameTypePane.setValue(gameType);
                    playerGameTypePane.valueProperty().addListener((ChangeListener)LambdaMetafactory.metafactory(null, null, null, (Ljavafx/beans/value/ObservableValue;Ljava/lang/Object;Ljava/lang/Object;)V, lambda$updateControls$6(com.github.steveice10.opennbt.tag.builtin.IntTag com.github.steveice10.opennbt.tag.builtin.ByteTag javafx.beans.value.ObservableValue org.jackhuang.hmcl.ui.versions.WorldInfoPage$GameType org.jackhuang.hmcl.ui.versions.WorldInfoPage$GameType ), (Ljavafx/beans/value/ObservableValue;Lorg/jackhuang/hmcl/ui/versions/WorldInfoPage$GameType;Lorg/jackhuang/hmcl/ui/versions/WorldInfoPage$GameType;)V)((WorldInfoPage)this, (IntTag)playerGameTypeTag, (ByteTag)hardcoreTag));
                } else {
                    playerGameTypePane.setDisable(true);
                }
            } else lbl-1000:
            // 2 sources

            {
                playerGameTypePane.setDisable(true);
            }
            healthPane = new LinePane();
            healthPane.setTitle(I18n.i18n("world.info.player.health"));
            this.setRightTextField((BorderPane)healthPane, 50, (Tag)playerTag.get("Health"));
            foodLevelPane = new LinePane();
            foodLevelPane.setTitle(I18n.i18n("world.info.player.food_level"));
            this.setRightTextField((BorderPane)foodLevelPane, 50, (Tag)playerTag.get("foodLevel"));
            foodSaturationPane = new LinePane();
            foodSaturationPane.setTitle(I18n.i18n("world.info.player.food_saturation_level"));
            this.setRightTextField((BorderPane)foodSaturationPane, 50, (Tag)playerTag.get("foodSaturationLevel"));
            xpLevelPane = new LinePane();
            xpLevelPane.setTitle(I18n.i18n("world.info.player.xp_level"));
            this.setRightTextField((BorderPane)xpLevelPane, 50, (Tag)playerTag.get("XpLevel"));
            playerInfo.getContent().setAll((Object[])new Node[]{locationPane, lastDeathLocationPane, spawnPane, playerGameTypePane, healthPane, foodLevelPane, foodSaturationPane, xpLevelPane});
            rootPane.getChildren().addAll((Object[])new Node[]{ComponentList.createComponentListTitle(I18n.i18n("world.info.player")), playerInfo});
        }
    }

    private void setRightTextField(BorderPane borderPane, int perfWidth, Tag tag) {
        JFXTextField textField = new JFXTextField();
        this.setRightTextField(borderPane, textField, perfWidth);
        if (tag instanceof IntTag) {
            IntTag intTag = (IntTag)tag;
            this.bindTagAndTextField(intTag, textField);
        } else if (tag instanceof FloatTag) {
            FloatTag floatTag = (FloatTag)tag;
            this.bindTagAndTextField(floatTag, textField);
        } else {
            textField.setDisable(true);
        }
    }

    private void setRightTextField(BorderPane borderPane, JFXTextField textField, int perfWidth) {
        textField.setDisable(this.isReadOnly);
        textField.setPrefWidth(perfWidth);
        BorderPane.setAlignment((Node)textField, (Pos)Pos.CENTER_RIGHT);
        borderPane.setRight((Node)textField);
    }

    private void bindTagAndToggleButton(Tag tag, LineToggleButton toggleButton) {
        if (tag instanceof ByteTag) {
            ByteTag byteTag = (ByteTag)tag;
            byte value = byteTag.getValue();
            if (value == 0 || value == 1) {
                toggleButton.setSelected(value == 1);
                toggleButton.selectedProperty().addListener((o, oldValue, newValue) -> {
                    try {
                        byteTag.setValue((byte)(newValue != false ? 1 : 0));
                        this.saveLevelDat();
                    }
                    catch (Exception e) {
                        toggleButton.setSelected((boolean)oldValue);
                        Logger.LOG.warning("Exception happened when saving level.dat", e);
                    }
                });
            } else {
                toggleButton.setDisable(true);
            }
        } else {
            toggleButton.setDisable(true);
        }
    }

    private void bindTagAndTextField(IntTag intTag, JFXTextField jfxTextField) {
        jfxTextField.setText(intTag.getValue().toString());
        jfxTextField.textProperty().addListener((o, oldValue, newValue) -> {
            if (newValue != null) {
                try {
                    Integer integer = Lang.toIntOrNull(newValue);
                    if (integer != null) {
                        intTag.setValue(integer);
                        this.saveLevelDat();
                    }
                }
                catch (Exception e) {
                    jfxTextField.setText((String)oldValue);
                    Logger.LOG.warning("Exception happened when saving level.dat", e);
                }
            }
        });
        FXUtils.setValidateWhileTextChanged((Node)jfxTextField, true);
        jfxTextField.setValidators(new NumberValidator(I18n.i18n("input.number"), true));
    }

    private void bindTagAndTextField(FloatTag floatTag, JFXTextField jfxTextField) {
        jfxTextField.setText(new DecimalFormat("0.#").format(floatTag.getValue()));
        jfxTextField.textProperty().addListener((o, oldValue, newValue) -> {
            if (newValue != null) {
                try {
                    Float floatValue = Lang.toFloatOrNull(newValue);
                    if (floatValue != null) {
                        floatTag.setValue(floatValue.floatValue());
                        this.saveLevelDat();
                    }
                }
                catch (Exception e) {
                    jfxTextField.setText((String)oldValue);
                    Logger.LOG.warning("Exception happened when saving level.dat", e);
                }
            }
        });
        FXUtils.setValidateWhileTextChanged((Node)jfxTextField, true);
        jfxTextField.setValidators(new DoubleValidator(I18n.i18n("input.number"), true));
    }

    private void saveLevelDat() {
        Logger.LOG.info("Saving level.dat of world " + this.world.getWorldName());
        try {
            this.world.writeLevelDat(this.levelDat);
        }
        catch (IOException e) {
            Logger.LOG.warning("Failed to save level.dat of world " + this.world.getWorldName(), e);
        }
    }

    @Override
    public void refresh() {
        this.isReadOnly = this.worldManagePage.isReadOnly();
        this.setLoading(true);
        Task.supplyAsync(this::loadWorldInfo).whenComplete(Schedulers.javafx(), (result, exception) -> {
            if (exception == null) {
                this.levelDat = result;
                this.updateControls();
                this.setLoading(false);
            } else {
                Logger.LOG.warning("Failed to load level.dat", exception);
                this.setFailedReason(I18n.i18n("world.info.failed"));
            }
        }).start();
    }

    private void changeWorldIcon() {
        Image image;
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(I18n.i18n("world.icon.choose.title"));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18n.i18n("extension.png"), new String[]{"*.png"}));
        fileChooser.setInitialFileName("icon.png");
        Path iconPath = FileUtils.toPath(fileChooser.showOpenDialog((Window)Controllers.getStage()));
        if (iconPath == null) {
            return;
        }
        try {
            image = FXUtils.loadImage(iconPath);
        }
        catch (Exception e) {
            Logger.LOG.warning("Failed to load image", e);
            Controllers.dialog(I18n.i18n("world.icon.change.fail.load.text"), I18n.i18n("world.icon.change.fail.load.title"), MessageDialogPane.MessageType.ERROR);
            return;
        }
        if ((int)image.getWidth() == 64 && (int)image.getHeight() == 64) {
            Path output = this.world.getFile().resolve("icon.png");
            this.saveWorldIcon(iconPath, image, output);
        } else {
            Controllers.dialog(I18n.i18n("world.icon.change.fail.not_64x64.text", (int)image.getWidth(), (int)image.getHeight()), I18n.i18n("world.icon.change.fail.not_64x64.title"), MessageDialogPane.MessageType.ERROR);
        }
    }

    private void saveWorldIcon(Path sourcePath, Image image, Path targetPath) {
        Image oldImage = this.iconImageView.getImage();
        try {
            FileUtils.copyFile(sourcePath, targetPath);
            this.iconImageView.setImage(image);
            Controllers.showToast(I18n.i18n("world.icon.change.succeed.toast"));
        }
        catch (IOException e) {
            Logger.LOG.warning("Failed to save world icon " + e.getMessage());
            this.iconImageView.setImage(oldImage);
        }
    }

    private void clearWorldIcon() {
        Path output = this.world.getFile().resolve("icon.png");
        try {
            Files.deleteIfExists(output);
            this.iconImageView.setImage(FXUtils.newBuiltinImage("/assets/img/unknown_server.png"));
        }
        catch (IOException e) {
            Logger.LOG.warning("Failed to delete world icon " + e.getMessage());
        }
    }

    private /* synthetic */ void lambda$updateControls$6(IntTag playerGameTypeTag, ByteTag hardcoreTag, ObservableValue o, GameType oldValue, GameType newValue) {
        if (newValue != null) {
            if (newValue == GameType.HARDCORE) {
                playerGameTypeTag.setValue(0);
                hardcoreTag.setValue((byte)1);
            } else {
                playerGameTypeTag.setValue(newValue.ordinal());
                hardcoreTag.setValue((byte)0);
            }
            this.saveLevelDat();
        }
    }

    private /* synthetic */ void lambda$updateControls$5(ByteTag difficultyTag, ObservableValue o, Difficulty oldValue, Difficulty newValue) {
        if (newValue != null) {
            difficultyTag.setValue((byte)newValue.ordinal());
            this.saveLevelDat();
        }
    }

    private static /* synthetic */ void lambda$updateControls$4(StackPane visibilityButton, Label seedLabel, BoxBlur blur, Boolean isVisibility) {
        SVG icon = isVisibility != false ? SVG.VISIBILITY : SVG.VISIBILITY_OFF;
        visibilityButton.getChildren().setAll((Object[])new Node[]{icon.createIcon(12.0)});
        seedLabel.setEffect((Effect)(isVisibility != false ? null : blur));
    }

    private static /* synthetic */ void lambda$updateControls$3(SimpleBooleanProperty visibility) {
        visibility.set(!visibility.get());
    }

    private /* synthetic */ void lambda$updateControls$2(ActionEvent event) {
        this.clearWorldIcon();
    }

    private /* synthetic */ void lambda$updateControls$1(ActionEvent event) {
        Controllers.confirm(I18n.i18n("world.icon.change.tip"), I18n.i18n("world.icon.change"), MessageDialogPane.MessageType.INFO, this::changeWorldIcon, null);
    }

    private /* synthetic */ void lambda$updateControls$0(ObservableValue observable, String oldValue, String newValue) {
        if (StringUtils.isNotBlank(newValue)) {
            try {
                this.world.setWorldName(newValue);
                this.worldManagePage.setTitle(I18n.i18n("world.manage.title", StringUtils.parseColorEscapes(this.world.getWorldName())));
            }
            catch (Exception e) {
                Logger.LOG.warning("Failed to set world name", e);
            }
        }
    }

    private record Dimension(String name) {
        static final Dimension OVERWORLD = new Dimension(null);
        static final Dimension THE_NETHER = new Dimension(I18n.i18n("world.info.dimension.the_nether"));
        static final Dimension THE_END = new Dimension(I18n.i18n("world.info.dimension.the_end"));

        static Dimension of(Tag tag) {
            if (tag instanceof IntTag) {
                IntTag intTag = (IntTag)tag;
                return switch (intTag.getValue()) {
                    case 0 -> OVERWORLD;
                    case -1 -> THE_NETHER;
                    case 1 -> THE_END;
                    default -> null;
                };
            }
            if (tag instanceof StringTag) {
                String id;
                StringTag stringTag = (StringTag)tag;
                return switch (id = stringTag.getValue()) {
                    case "overworld", "minecraft:overworld" -> OVERWORLD;
                    case "the_nether", "minecraft:the_nether" -> THE_NETHER;
                    case "the_end", "minecraft:the_end" -> THE_END;
                    default -> new Dimension(id);
                };
            }
            return null;
        }

        String formatPosition(Tag tag) {
            ListTag listTag;
            if (tag instanceof ListTag && (listTag = (ListTag)tag).size() == 3) {
                Object x = listTag.get(0);
                Object y = listTag.get(1);
                Object z = listTag.get(2);
                if (x instanceof DoubleTag && y instanceof DoubleTag && z instanceof DoubleTag) {
                    return this == OVERWORLD ? String.format("(%.2f, %.2f, %.2f)", ((Tag)x).getValue(), ((Tag)y).getValue(), ((Tag)z).getValue()) : String.format("%s (%.2f, %.2f, %.2f)", this.name, ((Tag)x).getValue(), ((Tag)y).getValue(), ((Tag)z).getValue());
                }
                return null;
            }
            if (tag instanceof IntArrayTag) {
                IntArrayTag intArrayTag = (IntArrayTag)tag;
                int x = intArrayTag.getValue(0);
                int y = intArrayTag.getValue(1);
                int z = intArrayTag.getValue(2);
                return this == OVERWORLD ? String.format("(%d, %d, %d)", x, y, z) : String.format("%s (%d, %d, %d)", this.name, x, y, z);
            }
            return null;
        }

        String formatPosition(int x, int y, int z) {
            return this == OVERWORLD ? String.format("(%d, %d, %d)", x, y, z) : String.format("%s (%d, %d, %d)", this.name, x, y, z);
        }

        String formatPosition(double x, double y, double z) {
            return this == OVERWORLD ? String.format("(%.2f, %.2f, %.2f)", x, y, z) : String.format("%s (%.2f, %.2f, %.2f)", this.name, x, y, z);
        }
    }

    private static enum Difficulty {
        PEACEFUL,
        EASY,
        NORMAL,
        HARD;

        static final ObservableList<Difficulty> items;

        static Difficulty of(int d) {
            return d >= 0 && d < items.size() ? (Difficulty)((Object)items.get(d)) : null;
        }

        public String toString() {
            return I18n.i18n("world.info.difficulty." + this.name().toLowerCase(Locale.ROOT));
        }

        static {
            items = FXCollections.observableList(Arrays.asList(Difficulty.values()));
        }
    }

    private static enum GameType {
        SURVIVAL,
        CREATIVE,
        ADVENTURE,
        SPECTATOR,
        HARDCORE;

        static final ObservableList<GameType> items;

        static GameType of(int d, boolean hardcore) {
            if (hardcore && d == 0) {
                return HARDCORE;
            }
            return d >= 0 && d < 4 ? (GameType)((Object)items.get(d)) : null;
        }

        public String toString() {
            return I18n.i18n("world.info.player.game_type." + this.name().toLowerCase(Locale.ROOT));
        }

        static {
            items = FXCollections.observableList(Arrays.asList(GameType.values()));
        }
    }
}

